META
key;value
description;District PB in Warszawa, Ursynów
country;Poland
unit;Warszawa
district;Ursynów
subunit;Ursynów
instance;2024
num_projects;60
num_votes;5870
budget;6085628
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
1641;606223;3374;Więcej zieleni na Ursynowie;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.14570016788425;21.050957271030974
1634;198000;2747;Spójna sieć dróg rowerowych na Ursynowie;public transit and roads,environmental protection,public space,sport,urban greenery;children,seniors;1;52.136428517483125;21.069645881652836
1031;330680;2326;Zielone skwery na Ursynowie 2024 r.;environmental protection,public space,urban greenery;children,seniors;1;52.14321179721724;21.037631034851078
503;662685;2115;Bezpłatne wejściówki na baseny i siłownię - dla wszystkich mieszkańców Ursynowa;education,culture,sport;children,seniors;1;52.14453101834449;21.04493773906414
1534;224520;2064;Zielone ekrany dla Ursynowa - nasadzenia krzewów;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.16739472411206;21.03510189056397
1417;88370;1965;Pnącza na Ursynowie;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.13683340804859;21.061949616158675
1126;984140;1948;Poprawa estetyki i użyteczności ursynowskich parków i skwerów (Park Jana Pawła II, Park Przy Bażantarni, Park Lasek Brzozowy, Skwerek Złotówki, Olkówek);environmental protection,public space,urban greenery;children,seniors;1;52.1449673816762;21.048338006535648
1648;500000;1882;Nasadzenia roślinności wzdłuż ul. Płaskowickiej;public space,urban greenery;children,seniors;1;52.142943981521974;21.047272682189945
990;87900;1791;Ratujmy ursynowskie drzewa, usuńmy jemiołę zanim je zniszczy. Pielęgnujmy drzewa, które są i dają tlen, cień latem, tłumią hałas i oczyszczają powietrze. Uzupełnimy też nasadzenia na Zielonej Osi Ursynowa;education,environmental protection,public space,urban greenery;children,seniors;1;52.15173962805214;21.04169368743897
785;400000;1756;Łąki na przystankach (kontynuacja);public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.146543626940364;21.057732581939494
1455;18720;1740;Zieleń wzdłuż KEN - ochrona przed rozjeżdżaniem;public transit and roads,public space,urban greenery;children,seniors;1;52.13502061071639;21.061981978128337
1130;80000;1703;Kino pod chmurką - cykl 8 letnich projekcji;culture;seniors;1;;
315;41800;1683;Kwiaty i ozdobne antysmogowe krzewy dla Ursynowa - niczym mała Holandia - w drodze do szkoły - pracy - domu z myślą o wszystkich mieszkańcach;public space,urban greenery;seniors;1;;
970;50209;1681;Chronimy ptaki parków i skwerów Ursynowa – oczyszczenie skrzynek lęgowych ze starych gniazd;environmental protection;;1;52.16005951212208;21.025772094726566
1137;300000;1621;Bezpłatne zajęcia dla dzieci w ursynowskich domach kultury;culture;children;1;;
14;913400;1576;Lodowisko na Ursynowie (kontynuacja);sport;children,seniors;1;52.13032683297463;21.01920604705811
883;950000;1554;Plac zabaw dla dzieci niepełnosprawnych – być zauważonym;education,welfare,public space,urban greenery;children,seniors;0;52.16366627673409;21.02396965026856
1390;280622;1545;Bijące serce Ursynowa - defibrylatory AED w placówkach dzielnicowych;public transit and roads,environmental protection,public space;children,seniors;1;;
514;788600;1417;Wiedz, że nie jesteś sam! Wsparcie psychologiczne dla mieszkańców Ursynowa;education,welfare;children,seniors;0;52.14863361693207;21.04589939117432
309;127120;1383;Dywany kwiatowe z tulipanów dla Ursynowa /wieloletnie nasadzenia/;public space,urban greenery;;1;52.13905034387908;21.04783773509553
997;170000;1243;Eleganckie Śmietniki;public space;children,seniors;1;;
1513;178485;1145;15 aparatów AED z przełącznikiem pediatrycznym dla placówek oświatowych na Ursynowie.;education;children,seniors;0;;
56;30000;1141;Rockowe ursynowskie koncerty plenerowe;education,culture,public space;seniors;0;;
999;92000;1128;Mała zieleń - niech błyszczy!;public space;children,seniors;0;52.13967917622467;21.026496887207035
797;15400;1102;Chodnik zamiast przedeptu przy ulicy Belgradzkiej 3;public transit and roads,environmental protection,public space;children,seniors;1;52.1417312;21.0655055
1115;386750;1102;Puławska w kwiatach;public space,urban greenery;children,seniors;0;52.15519771921746;21.017724451917136
123;1182060;1086;Rowerowa Od-Nowa - edycja III ulica Belgradzka;public transit and roads,public space;children,seniors;0;52.13880889410751;21.05493345008385
26;332250;1085;Zazieleniamy Kabaty - nowe krzewy i rabaty bylinowe przy ul. Wąwozowej;environmental protection,public space,urban greenery;children,seniors;0;52.131169843652366;21.05804576459458
93;1173568;1063;Wymiana nawierzchni boiska piłkarskiego, bezpieczny plac zabaw i dodanie oświetlenia małego boiska przy SP nr 336 przy ul. Na Uboczu 9;education,sport;children,seniors;0;52.139537849999996;21.048886343490985
1190;60000;1056;Doświetlenie Ursynowa w nocy - Kabaty;public transit and roads,public space;children,seniors;0;52.13016876669679;21.06413841247559
678;1100500;1041;Sensoryczny plac zabaw Mandarynkowy Zakątek cztery pory roku;education,public space,sport,urban greenery;children;0;52.14537117714268;21.060560227124373
703;21900;1039;Zdrowoaktywni - regularne i bezpłatne treningi plenerowe dla mieszkańców Ursynowa 2024;sport;seniors;0;52.16490351646561;21.02384090423584
518;18000;1005;Ławki nad oczkiem wodnym Moczydło przy Lesie Kabackim;public space;children,seniors;0;52.13265083648009;21.041586399078373
1365;442000;981;Zielone przystanki na ulicy Puławskiej;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.12667054314398;21.018140736748194
1348;50000;977;Piłkarzyki plenerowe w ursynowskich parkach;public space,sport;children,seniors;0;52.1508061263805;21.045963764190677
1215;413700;975;Klasy 7-8: wsparcie psychologiczne uczniów, rodziców i nauczycieli;education,welfare;children;0;52.148659950431444;21.045727729797367
314;10000;898;Kreatywne strefy gier podwórkowych, jako idea wykorzystania znanych z dawnych czasów zabaw i gier planszowych w dużym formacie poprzez przeniesienie ich na chodniki i dzięki temu umożliwienie wspólnych zabaw na świeżym powietrzu przez cały rok;public space,sport;children;0;52.139706849999996;21.062969229443844
1097;120000;819;Potańcówki na Ursynowie;culture;children,seniors;0;;
840;1217000;789;Remont nawierzchni skrzyżowania ul. Wąwozowej z al. KEN;public transit and roads;children,seniors;0;52.1309630439112;21.066155433654785
1458;247500;727;Koła gimnastyczne, rurka pole dance i dodatkowe drążki dla dzieci na istniejących siłowniach plenerowych;public space,sport;children;0;52.15598187403367;21.033388632282666
636;577000;710;„Odlotowy plac zabaw” - modernizacja i rozbudowa placu zabaw dla dzieci i młodzieży przy Szkole Podstawowej z Oddziałami Integracyjnymi nr 318 w Warszawie;education,sport;children;0;52.15271388918717;21.046500205993656
1001;20600;675;Stres pokonać - zajęcia jak sobie radzić ze stresem w codziennym życiu, daj sobie pomóc;education,welfare;children,seniors;0;52.14905371668157;21.045985221862797
962;50000;668;Ursynowskie Murale - przewodnik internetowy;education,culture,public space,sport;children,seniors;0;;
1121;120000;647;Letnie koncerty muzyki młodzieżowej;culture;;0;;
637;327422;640;Wsparcie rozwoju dzieci w obszarze komunikacji językowej poprzez zastosowanie terapii słuchowej opracowanej przez A. Tomatisa;education,welfare;children;0;52.13999312531555;21.062400341033936
353;221500;639;Rowery towarowe dla Ursynowa;public transit and roads,environmental protection,public space,sport;children;0;52.14898020425051;21.045664704635154
811;29000;632;Joga na zdrowie;sport;;0;52.143155199999995;21.03929578662582
1174;505768;559;Bezpieczna, zielona i przyjazna Kłobucka;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.16548058161104;20.99216938018799
814;34850;497;Treningi piłkarskie dla dzieci i młodzieży;sport;children;0;52.15668775273525;21.027907061049053
312;2500;474;Funkcjonalne stojaki na deskorolki dla szkół wraz z zabezpieczeniem przed kradzieżą/młodzież spokojnie będzie mogła zostawić zabezpieczony sprzęt,tj.rowery pod wiatami;public space,sport;children;1;;
812;90750;461;Siłownia po szkole;sport;;0;52.143881564457075;21.040341854095463
1094;38300;459;Ursynów Zawsze w Formie - piknik sportowy;sport;children,seniors;0;52.164087468589685;21.023797988891605
823;60500;458;Dwa stoły do ping-ponga po drodze do lasu;sport;children,seniors;0;52.12856172770735;21.074953079223636
952;138400;390;trzyMAMY się razem ! - Bezpłatne 3-msc warsztaty dla mam (z małymi dziećmi) prowadzone przez specjalistów;education,welfare;;0;52.139652525;21.031982678809683
698;33220;365;Zapylacze w wielkim mieście – gra terenowa, warsztaty i przedstawienie teatralne dla rodzin z dziećmi;education,culture,environmental protection,public space,urban greenery;children,seniors;0;52.16384314489334;21.02377096191507
710;50000;360;Sąsiedzki ogród społeczny przy Kłobuckiej 14;education,culture,environmental protection,welfare,public space,sport,urban greenery;children,seniors;0;52.16666965;20.992911283651317
734;32510;322;Zajęcia MAMA FIT dla kobiet w ciąży i mam z dziećmi;education,culture,welfare,public space,sport;children;0;52.16666965;20.992911283651317
833;6700;277;Zdrowie i witalność dla każdego - Slow Jogging bieganie z uśmiechem :);education,sport;children,seniors;0;52.12619058072884;21.069459915161136
1103;40000;259;Sąsiedzkie karaoke;culture;children,seniors;0;;
1394;30000;195;Rodzinne warsztaty figurkowe łączą pokolenia;education,culture;children,seniors;0;;
VOTES
voter_id;vote;age;sex
18;1103,1097,309,990,1417,503,1130,970,1115,710,514,1001,1534,315;39;F
46;1137,1121,1634,123,990,314,93;44;M
54;1137,1121,1634,990,314,123,93;9;M
56;1137,1121,1634,990,123,93;6;M
59;999,26,309,315,1031,990,1648,1126,1455,1417,1137,1641,353;48;F
85;1126,1534,1648,997,797,962,1641,703,999,1634,1031,518,1417,1137,970;42;M
165;1121,514,1417,997,1130,962,309,315,1513,883,1126,1390,56,503;44;F
190;1513,1031,518,1190,814,990,1126,1455,514,1137,503,1641,314,636,637;43;F
197;315,309,26,1634,1031,1190,785,990,1126,1455,997,1130,797,1641,970;42;F
200;1390,1648,1534,1634,1031,503,1130,698,309,1121,823,14,1126,1348,962;48;M
222;999;38;F
240;999,312,1634,785,1365,1534,1126,1417,997,710,503,1174,962,314,1115;50;F
258;1031,785,1458,315,309,1121,883,1513,1126,1390,1417,56,503,1130,962;54;M
308;1031,1190,785,636,678,518,1648,1126,1390,840,997,797,1634,123,1641;49;F
391;1115,1641,997,1455,1126,1534,999,315,1031,1634;33;M
476;14,785,1121,1634,678,999,1534,1348,1641,962,1031,353,1115,883,1365;21;F
505;990,26,840,1001,514,1417,503,797,1641,962,952,698,970,1115,636;21;F
650;1097,1455,1130,315,1121,56,93;45;M
679;637;52;M
731;1121,1130,1137,1103,1097,1115;43;F
752;999,678,1634,1031,1190,14,1648,1126,1390,1455,840,503,797,1130,1641;47;F
753;999,678,1513,518,1215,123,1126,1390,840,997,797,1641,93,314,970;34;F
768;840,1455,1534,990,1365,1634,315,26,1174,1641,970;40;F
828;1634,315,309,1031,1126,883,1641,970;36;M
850;1634,315,1534,1648,1394,353,637,312,1121,1097,1215,1103,1137,1130,1115;44;F
873;678,1513,883,1190,785,1648,1390,1348,1455,514,1137,1458,1641,703,812;45;F
889;1513,785,1365,990,1534,1648,1390,1455,840,503,797,1641,952,970,1115;44;M
895;123,1126,1390,1455,840,514,1137,56,503,1130,797,734,1641,703,812;44;M
896;1634,309,1097,1215,123,1348,503,797,678;36;M
999;1121,1097,1103,1137,1130,1115;48;M
1027;1634,14,811,56,1130,1648,309;23;F
1033;1121,1097,1103,1137,1130,1115;21;M
1058;309,1634,518,1190,785,990,1534,1648,1126,1390,1455,840,514,1417,1641;66;F
1066;1121,1097,1103,1137,1130,1115;16;M
1081;503,1130,1641,703,970;36;F
1088;1121,1097,1103,1137,1130,1115;11;F
1144;990,353,309,1634,1121,1513,811,1534,1648,1390,1001,1417,997,56,503;48;F
1341;1648,1390,1455,997,1137,503,1641,314,812,970,353,636,1115,14,93;38;F
1391;26,315,1031,518,1215,1534,1648,1390,997,1641,93;82;F
1434;990,309,999,26,315,1634,1031,1190,785,123,1648,1455,840,797,1641;48;M
1440;1634,503,93;34;F
1452;14,797,1174,312,1634,1513,1031,518,123,1648,1126,1455,962,314,970;27;M
1464;1634,503,1641,93;35;M
1529;1390,840,797,1634;29;F
1551;1513,1634,93;9;F
1559;503,1634,93;9;F
1560;1390,814,1215,678,1513,883,1126,1001,514,1137,503,952,314,637,636;26;F
1588;678,999,309,315,1634,1031,785,990,1534,1648,1115;65;M
1609;1513,14,56,1394,503,698,1121,1097,1103,1137,1130,1115;43;F
1616;1634,93;4;M
1618;999,26,678,309,315,1634,883,1031,14,1534,1648,1126,1417,1641,636;43;F
1625;1634,814,1348,93;49;F
1749;636,353,812,1348,811,814,833,14,93;34;F
1758;1365,785,1190,1031,797,1174,1641,962,703,952,314,970,637,353,1115;71;F
1815;1455,997,1417,1137,1174,1641,970,26,1190,1215,990,840,797,93,637;45;F
1820;703,637,1094,1641,1458,503,1137,1417,514,1455,840,1126,785,1634,26;42;F
1849;56,93;36;M
1869;1634,93;60;F
1878;1121,56,1137,1097,14,1103,1394,1130;40;M
1899;1390,1115,1130,1137,1648,1534,1365,1190,312,1121,1126,1348,1394,56,1458;28;F
1910;678,1634,823,14,833,814,1348,503,1458,962,314,93;43;M
1911;698,962,1130,997,514,840,1348,1126,814,1417,1137,503,1641,314,93;31;F
1958;1121,312,1513,1394,1130,314,518,1190,703,93;39;F
1968;1634,315,309,26,1137,56,1394,503,1130,797,1458,734,962,703,93;6;M
2025;1634,93;60;M
2035;1190,1097,814,1348,797,93;18;M
2043;1648,1130,797,93,1115;18;F
2084;703,1130,503,56,1137,1348,1390,811,814,123,833,1097,1190,1513,1634;44;M
2091;514,503,1130,1458,734,1174,962,703,314,93;9;M
2162;503,1458,734,353,93;23;M
2186;1634,1031,1190,990,1534,1126,1390,1455,840,1417,997,503,797,1174,1641;64;F
2199;1634,1137,1641,962,314,637,883,1534,503;36;M
2206;1513,883,1215,1390;45;F
2236;1417,1137,56,503,1130,797,1458,734,1641,962,314,812,1094,970,353;42;F
2239;990,1534,1648,840,970,1115,1634,883,518,1190,14,1126,503,797,93;29;M
2243;785,1097,1103,1648,1348,1417,1137,56,503,1130,1641,970,1115,353,93;43;F
2268;1634,93;85;M
2301;883,315,309,999,1634,1031,123,1534,1648,1348,1417,503,1641,636,785;39;M
2313;312,678,315,1513,883,785,1365,1215,1390,1001,514,1137,56,314,970;37;F
2324;1031,1513,883,315,811,1215,14,309,1634,1001,514,1137,503,1130,703;38;F
2376;26,315,309,1634,785,1097,1648,1455,514,797,1641,703,812,970,1115;31;M
2379;999,1365,990,1534,1126,1455,514,997,1137,1458,1641,703,970,637;77;F
2421;814,26,823,518,1190,811,1137,503;44;F
2449;1031,312,1634,518,26,14,123,840,1458;39;M
2450;1417,710,1130,1174,1031,1648,26,1190,1455,514,1641,970;31;M
2602;312,678,315,1634,1115,1031,814,1126,1455,503,734,1641,703,314,93;31;M
2626;26,1634,1031,1126,1455,840,997,1641;34;F
2746;1137,797,1641,93,678,1634,990,1648,1001,1417,1458,703,314,970,353;31;F
2762;14,518,823,883,1121,1634,1190,1097,514,1137,503,1130,698,353,636;35;F
2774;1634,1121,1190,14,1103,1126,840,1001,56,503,1130,962,1094;18;M
2860;1648,637,812,1458,1130,1137,1390,1031,1190,1365,1126,1455,503,1115,1641;19;F
2934;970,999,315,990,1534,703,1130,503,514,1001,1126,811,14,1031,1634;26;F
2946;990,518,1031,309,315,883,1648,1126,1417,56,1641,698,93,1094,970;51;F
2952;811,997,962,314,93,812;46;F
3019;1513,1648,56,1130,962,93;40;F
3020;14,1130,883,785,1348,797,1641;41;F
3023;1126,1534,814,1097,785,999,1634,1031,1641;38;M
3027;1031,503,1641,26,315;30;F
3032;1513,883,1390,1641;30;F
3037;1534,999,990,997,970,26,1634,1190,785,811,1126,1455,1417,56,1641;55;M
3061;698,797,1001,1455,1390,1648,1215,1513,990,962,314,1115;42;M
3142;833,1001,1394,734,952,698,93;32;F
3146;1031,678,883,1190,514,1417,1534,840,997,710,314,503,1130,797,703;43;F
3184;997,514,1534,14,785,1031,309,1097,1103,1126,1348,1137,1130,1458,1094;36;F
3235;797,990,1648,1417,1137,999,26,315,1634,1031,1534,1126,1455,997,1641;43;M
3247;93;31;M
3289;1648,1458,962,970,315,1634,1031,14,1455,1417,56,1641,703,314,812;45;F
3305;1417,1130,970,637,353,1115,315,1121,883,14,1365,1097,1348,514,1137;37;F
3373;26,309,999,678,312,1634,883,823,785,14,1348,840,514,503,1641;46;M
3414;840,93,1513,678,999,26,883,1031,518,1190,1215,814,990,1648,1126;47;M
3424;315,1031,1365,990,1534,1648,1126,1455,840,1417,997,1641,970,1115;42;F
3430;703,785,1534,797,315,883,840,514,503,1130,1634,123,1126,997,962;46;M
3487;823,1031,1634,833,56,1130;40;F
3516;1390,1534,990,1215,883,315,309,999,1634,1513,1126,997,1137,1458,353;42;F
3532;1130,1174,314,1115,636,999,1634,1534,1390,1455,1417,997,1641,970,353;39;F
3538;812,14,1121,999,309,315,1634,1513,990,1126,1390,1348,503,797,1641;48;F
3591;997,26,309,315,1365,1126,1641,999,1031,785,990,1534,1648,1417,970;49;F
3661;1097,1103,814,1348,1137,503,1130,1641,93;42;F
3688;833,1097,1031,883,315,309,1634,14,1001,514,56,1130,1641,703,1115;52;F
3701;93;39;F
3778;123,1648,1126,1634,1031,990,1417,1137,1130,1458,1641;47;F
3800;785,309,1534,1648,1126,997,1115,93,1641,840,1455,1190,1031,1634,26;24;M
3817;678,1513,785,14,1215,814,1390,1137,56,503,637;39;F
3903;999,309,1634,1513,1031,785,990,1648,1390,503,1641;49;M
3916;93;8;F
3919;1417,997,503,309,1190,814,1126,1115,93,812,1641,1031,1121,315,1634;16;M
3920;1417,999,14,1390,514,503,1130,1641,703,637;65;F
3924;1348,1001,514,1137,56,503,1130,734,703,952,314,93,970,637,636;37;F
3926;1137,1031,315,309,1513,883,990,1534,1648,1390,1455,56,1130,1641,970;47;F
3944;1513,1174,1641,999,315,785,990,1534,1126,514,1417,1137,56,970,637;43;F
3968;93;8;F
4026;1126,1137,698,314,812,970,636,1513,14,514,1417,56,1130,1641,93;41;F
4062;999,315,990,1126,514,56,503,1130,703,970,1648,1455,1417,1641;50;F
4102;1190,1455,840,1641,1417,56,1130,970;38;F
4110;315,309,1190,123,1126,1455,840,514,1417,503,797,1641,93,970,1115;71;M
4133;785,1634,1031,990,1455,1417,1174,1115,1641,1648,1534,518,309,999,710;39;F
4145;1634,1031,123,1534,1648,1126,1455,840,1417,1130,797,1641,962,353,1115;50;M
4300;1455,1648,811,1190,1634,678,883,518,14,1097,814,1534,514,797,1641;51;F
4314;1455,1634,26,93,1641,840,1648,823;38;M
4356;14,1126,1458;26;M
4361;1648,1455,514,1641,962;61;F
4377;797,1641,703,123,1097,518,1031,999,970,1394,1648,1534,990,785,1634;19;F
4453;26,999,315,309,1031,785,1365,990,1534,1648,1455,1417,1641,970,1115;27;F
4495;1137,1130,14,1215,93;37;F
4503;1534,797,1641,26,123,1648,1115;75;M
4541;514,314,678,1634,883,1031,1097,1215,1103,1348,56,1130,1458,637,636;38;M
4658;1031,1534,1001,710,962,1174,797,1513,785,14,1417,56,1394,503,314;42;F
4687;1121,823,14,1097,1348,1137,56,1394,503,1130,698,314;42;M
4728;1634,990,970,883,1001,1641,93;39;F
4761;1634,883,1365,1215,1103,990,811,1390,1001,514,56,698,970,1641,503;26;F
4762;999,312,309,315,1031,518,1190,1365,123,1534,997,797,1641,962,93;35;F
4792;26,315,823,1190,785,990,1648,1455,1641,970;69;M
4818;14,1215,797,1458,314,93,636,637,678,1190,518,823;46;F
4820;678,309,315,1634,1513,785,1097,1103,990,1648,1390,1641,952,314,353;30;F
4836;518,1031,1121,315,1634,1190,1365,123,1534,1390,56,1130,503,1641,812;40;F
4970;1031,883,1513,678,309,56,636;31;F
4998;1215,1097,1190,823,678,26,883,1348,93,314;31;F
5084;1097,840,1174,999,26,309,823,1190,1126,1641,93,1513,1031,518,1390;39;F
5108;1137,1455,1648,811,990,1215,785,1031,883,1513,1634,315,999,703,812;41;F
5109;315,883,1455,1417,1641,703,952,970,518,1534,734;27;F
5177;678,1513,1097,123,1648,1126,997;42;M
5226;123,1215,1001,56,1641,1094,1634,1513,14;45;M
5272;840,1031,883,833,123,1103,1534,1648,1455,56,1130,1458,1641,703,314;44;M
5275;1641,997,840,1648,1031,26,1634,518,1190,785,123,1126,962,353;43;F
5292;312,315,1634,785,990,1126,514,997,1130,1641,962,703,970;35;F
5348;999,26,309,315,785,1365,1534,1455,840,1417,997,797,1641,314,1115;39;F
5414;314,812,636,883,123,1126,1348,514,1458,637,678,14,814,1137,503;36;F
5415;883,1174,123,56,1130,797,314,93;40;F
5449;93;33;M
5472;734,1641,703,970,312,883,518,1215,1348,1137,797,952,698,314,93;37;F
5523;1001,1390,1126,833,1097,1513,678,26,1190,1215,814,811,1348,840,1641;47;F
5576;999,309,1513,883,14,1215,811,1390,514,503,1634,1365,1126,1137,353;31;F
5612;1031,1634,14,1365,814,123,710,1137,503,1130,1174,1641,93,1115,353;31;M
5679;312,678,26,1634,518,1190;41;M
5731;514,1394,314,309,1513,14,1215,1390,1137,503,734,1641,703,952,636;37;F
5772;518,997,797,1641,1390,1634,1190,1455,840,1417,353,1174,1458,1126,1115;38;M
5774;1513,1634,678,883,1190,1215,814,1126,1390,514,1641,952,314,637,1115;37;F
5788;1137,56,1130,797,1458,636,814,1365,883,1121,315,785,14,1126,1348;36;F
5852;518;55;M
5875;1534,1648,1390,1417,997,1137,315,1513,785,514,710,56,503,1641,1174;35;F
5908;26,315,1634,123,840,997,56,797,1641,962;65;M
5925;1417,997,797,962,353,26,1634,1031,1190,123,990,840,1174,1641,970;52;M
5942;1634,1121,518,785,14,1103,1534,1348,1455,840,514,1417,503,1641,797;23;M
5950;990,785,1634,999,309,315,1031,14,1215,1648,1455,1417,503,1641,1115;44;F
5967;678;39;M
6024;1534,710,1641,1634,1174;33;M
6034;309,678;34;F
6042;883,1215,814,1137,503,93;43;F
6079;999,1031,1365,1534,1648,1417,1130,503,962,1115,1634;19;M
6104;999,883,1137,514,56,970,315,1513,990,1534,1126,1417,503,637,1174;12;F
6118;309,1121,883,14,1390,1001,997,1137,56,503,1130,1641,962,314,1115;49;M
6165;999,1126,678,26,309,315,1031,785,990,1455,840,1417,997,1641,970;54;F
6212;833,518,823,1031,883,1513,1634,1121,123,1648,1390,514,1137,503,56;45;M
6246;1641,785,1534,514,999,315,883,990,1126,1417,1137,56,503,970,637;7;F
6268;970,990,999,814,503,1417,734,1390,315,883,514,1001,309,1641,1534;27;F
6307;840,56,823,518,123,1634,14,1126,1348,1417,503,1130,797,962,93;22;M
6317;1513,785,1365,840,1126,1190,123,990,1455,1417,997,1641,315,1634,1390;25;F
6388;883,93,952,1641,1130,56,514,1121,678,785,1215,1137;34;F
6409;678,999,315,1634,1513,990,1001,1137,26,883,1031,1215,1534,514,1417;23;F
6415;999,1031,1190,1097,785,1103,1648,1455,840,1417,997,56,503,1130,1641;28;M
6484;970,785,1190,518,1513,999,312,26,315,1031,990,1648,1455,1130,1641;23;M
6534;503,1641,962,93,14,785,123,1126,840,1190,518,823,1031,1634,26;22;M
6561;678,990,1648,1641,970;40;F
6585;637;36;F
6695;14,1174,1121,1097,1103,1130,1115;48;F
6771;1348,840,1417,997,1641,962,698,1190,811,514,797,703,314,970,1115;52;F
6795;503,997,514,840,1455,1126,678,26,883,1031,1190,14,1137,1130,703;35;F
6819;503,997,785,1190,518,1031,1634,315,309,26,999,314,1094,812,970;32;M
6827;1031,883,678,309,1634,990,1534,1126,997;32;M
6833;1513,785,1365,1001,1417,734,952,883,710,1174;39;F
6843;1634,1031,518,833,1001,1137,503,1641,14,962;38;F
6855;1534,785,1031,1121,309,26,1634,518,1190,123,1648,1126,56,797,1641;33;M
6858;814,1348,353,1634,1031,1190,518,14,1137,56,503,1115;34;F
6903;962,970,353,1417,1126,1648,123,785,518,1031,1634,315,1458,1641,703;42;F
6916;1634,312,999,1031,785,123,1648,797,1641;47;F
6946;26,1031,823,123,990,1534,1648,1126,1455,1417,710,1137,56,1641,970;48;F
6968;14,1513,1634,678,1031,1534,1417,1641;38;F
6994;1126,999,997,883,833,814,812,811,636,503,123,678,93,1634;45;F
6998;1190,93,970,1130,840,1390,1513,1634;40;M
7040;970,1130,1390,1534,1103,1215,833,518,1031,1634,315,1097,990,514,1417;56;F
7112;1634,883,1390,812,353,636,678;49;F
7130;93;46;F
7142;93;42;F
7151;1634,14,503;71;F
7175;797,840,636,14,1137,503,962,1121,1097,1641,56,970,315,1130,703;39;F
7187;309,315,1031,518,785,990,1648,1534,1126,1455,1417,503,797,1641,970;65;M
7223;999,1190,123,678,26,315,1634,883,1031,990,1534,1648,1455,1641,93;14;M
7226;1513,785,1390,503,1417;20;M
7261;997,710,1174,970,1190,785,1365,1534,1648,1390,1455,56,797,1458,1641;21;F
7295;678,883,1534,1455,314,1121,1137,698,1458,970,814,1126;39;F
7305;1365,1115,999,309,315,1031,785,14,1534,1648,1390,1455,1417,997,1641;31;F
7337;811,997,503,1130,1458,1641,962,314,93,637,1215,123,1634,1513,883;45;F
7345;1121,56;26;M
7379;14;55;F
7438;14;47;M
7441;962,1137,883,1648,1126,840,514,56,637,698,1130,503,811,1097,1121;23;F
7450;1031,518,785,1534,1455,1641,962,312,999,315,990,1417,997,797,970;31;F
7454;26,1634,1031,1190,785,1365,123,990,1534,1648,1126,1455,1417,1641,93;35;M
7465;1115,999,14,1417,997,56,1394,503,1130,962;40;M
7528;1641,314,1094,970,997,1126,1534,123,1365,785,1190,1031,883,1634,315;43;F
7623;1215,518,678,1121,1513,883,14,1097,1103,1648,1390,1137,503,1130,1115;39;F
7666;999,315,1634,1190,1365,1534,1126,1455,997,1641,353,636,785,14,990;42;F
7689;14,990,514,1137,1641,314,970,637,309,1103,1390,1348,56,503,93;45;F
7695;309,1190,785,1455,56,1130,962,703,812,970;17;M
7716;1121,883,1215,1534,1648,1348,1455,1001,1417,1394,1130,1458,1641,962,970;44;F
7745;999,1097,1215,514,1130,637,315,1513,1390,1137,1394,703,93,1094,636;36;F
7771;797,1634,123;49;F
7786;26,823,1190,990,1126,1455,840,514,1417,56,1130,797,1641,93,970;45;M
7798;1365,811,1648,1390,514,56,503,797,1641,962,703,812,1094,637,353;37;M
7817;14,1365,1126,503;49;M
7885;710,1174,1641,999,833,811,1534,1417,1455,1634,123,970;51;F
7904;1513,883,990,1390,997,503,797,1458,93;15;F
7913;312,1417,962,970,1641,797,997,1648,123,999,678;29;M
7934;93;42;F
7964;309,1634,1417,1641,970;39;F
7997;309,315,1634,1031,785,1365,123,1648,514,1417,997,56,1130,797,1641;44;M
8028;1513,883;37;F
8029;309,1634,883,785,14,1126;55;F
8077;309,785,997,1641,970,1115,999,315,1634,1031,1365,1534,1417,710,1174;60;F
8109;1513,14,1348,797,314,1390,1031,93,1115;38;F
8110;314,636,518,797,93;40;F
8114;1215,1417,1641,1031,1634,1648,514,56,1174;45;F
8128;1641,997,1534,785,315,309,312,999,518,1365,990,1648,1455,1390,1417;46;M
8160;997,1130,1115,636,518,1348,840,56,797,1641,1190,1513,1634,123,93;37;M
8192;811,1534,1648,1126,1390,514,1137,56,503,1130,1641,703,698,637,636;43;F
8388;1365,990,1534,1348,710,353,1115,1634,1215,1390;43;F
8390;353,970,1648,26,1031,14,309,315,990;59;F
8419;1031,1417,1534,814,1121,1348,56,1130,1458,314,698,1094,883,1097,1641;34;F
8426;14,1215,123,1648,1126,1390,1348,1455,514,1417,1137,1130,1641,1634;37;F
8487;997,514,1001,1534,1215,678,999,315,14,636;43;F
8497;999,309,315,1634,1513,1031,1534,1390,1417,997,1137,1458,1641,14,636;49;M
8530;883,1390,514,93;43;F
8571;678;69;F
8598;1417,710,1137,56,1394,503,1130,797,734,1174,1641,962,698,353,1115;18;F
8599;1455,1390,1190,840,1534,797,1174,123,1417,1365,785,1634,1641,353;18;F
8610;1634,999,26,785,1513,1365,1534,1648,1390,1455,1417,797,1641,970,1115;28;M
8641;990,678;63;M
8649;1137,703,314,26,1031,823,518,785,833,1215,990,1390,1455,514,1130;41;F
8650;1137,997,990,883,1513,999,309,315,1031,1534,1126,1390,1455,1417,1641;57;F
8659;678,312,1121,1097,1137,503,1130,797,1094;33;F
8701;1126,1534,990,814,1190,1031,518,1634,123,353;47;M
8720;785,14,1390,710,56,503,1130,1174,962,703;60;F
8731;503,93;47;M
8763;999,26,309,315,1634,883,1190,990,1126,1455,56,503,1641,703,970;43;F
8777;1031,1513,999,309,315,785,1648,1455,840,514,1641,812,1190,1634,26;44;F
8811;93;45;F
8844;26,1634,785,1126,1390,1455;49;M
8889;14,814,1534,1648,1390,1455,314,315,1634,1417,997,797,1641,962,93;70;F
8919;1031,785,814,1455,1137,56,1641,962,314,636;43;M
8934;312,1121,1513,814,1648,1390,56,1130,93,812;46;F
8962;999,309,1634,315,1031,518,785,990,1534,1648,1455,1417,1641,970;36;M
8970;26,1634,1031,1190,785,1365,990,1534,1648,1455,840,997,797,1641,93;49;M
8976;123,1648,1417,1641;39;F
9001;990,811,1513,1137,1130,1641,812,970,678,785,1097,1215,514,56,503;40;F
9002;1130,93;50;F
9037;1634,883,14,814,1137,1458,93;40;F
9045;123,1190,1513,1634,990,1390,1455,514,1417,1458,1641,314,93,812,970;43;M
9083;990,1534,1455,1641,314,970,1115;35;F
9106;1121,999,678,14,814,811,1534,1126,997,1137,56,503,1130,698,1094;39;F
9159;309,785,1365,1126,999,315,1534,1648,1455,1031,990,1417,1641,970;62;F
9165;1097,1130,1121,93,503;14;M
9182;1634,315,1648,999,1031,785,990,1455,1417,997,1130,1641,962,703,970;29;M
9190;678,14,1097,514,1137,1130,952;27;F
9257;309,315,999,26,1031,1648,1534,840,1455,1417,1174,962,1641,970,1115;35;M
9289;26,315,1634,1031,1365,990,1534,1641,1115;38;F
9369;999,314,1641,1458,503,997,840,1126,990,785,1190,823,1031,1513,26;35;F
9396;1190,123,990,1534,1648,1390,1455,840,514,1417,56,1174,1641,952,970;37;M
9399;503,785,797,1455,1417,1348,1126,518,93,309,1031,1648;37;F
9483;315,26,999,312,678,309,1121,883,785,1215,1648,1348,514,1417,637;41;F
9492;840,997,637,999,309,1634,518,123,814,1534,1648,1126,1417,1641,636;33;M
9504;1634,1031,1417,1641;43;M
9507;1513,1390,56,503,1130,1641,970;57;M
9541;636,1513,785,123,1417,1137,93,1634,1031,990,1126,1390,1455,1641,970;29;F
9544;26,785,1365,1417,999,1634,1031,123,1534,1648,1126,1455,997,797,1641;42;M
9686;1190,785,990,1126,1455,840,636,1513,518,14,1215,1417,1394,1458,1641;41;F
9701;1348,1390,1648,1534,1190,1634,315,678,1513,883,518,14,1137,503,93;41;F
9706;315,1121,1097,811,1534,1348,962,1115,353,1634,1365,1648,1137,703,14;38;F
9717;999,26,883,518,1190,785,990,1126,1455,1641,970;34;M
9722;14,518,883,1634,999,309,1365,990,1534,1126,1390,1455,1174;34;M
9736;1365,14,309,1126,1534,1648,1390,1455,1417,1137,503,1641,93,812,636;50;F
9746;315,1634,883,518,1190,93,812;45;F
9756;785,1031,315,123,811,1534,1648,1126,1455,1417,503,797,1641,703,970;23;F
9814;999,315,1031,785,1534,1417,1130,1634,1513,990,1126,1390,1348,1641,970;36;M
9882;26,1634,518,1190,123,1648,1126,1455,1417,997,1641,840;34;M
9896;1513,1634,315,823,14,1103,1348,503,1130,1458,1641,703,93,1094,636;45;F
9945;93;39;F
9951;997,1534,1513,1215,814,1126,503;38;M
9990;1094,1641,710,1455,1031,1121,309;23;F
9991;833,514,1137,56,1094,823,1097,1103,811,1648,1348,1130,503,703,93;46;F
10014;1513,1215,1126,1390,999,315,309,1634,1031,990,970;48;F
10040;14;26;F
10047;1458,797,503,997,1365,14,1031,999,312,678;13;M
10058;312,1394,503,1130,1458,1094,1121,1215,1390,1001,1137,962,703,698,314;39;F
10066;1455,123,315,678,1513,883,518,1190,14,1648,1390,1348,1137,503,93;50;M
10151;1348,1455,840,1130,1641,952,1115,1634,1031,1097,1126,503,797,962,353;19;M
10172;1031,840,1126,1190,997,797,1641,26,518,1365,990,353,1634,123;61;M
10175;309,1121,1097,514,1417,314,1115,698,970,636,990,785,1031;38;F
10191;636,1634,883,1031,123,1534,990,1648,1641;52;M
10217;315,1031,1121,1097,1417,56,1130,970,990,518,1634,785,1641,999,1534;26;M
10227;678,26,785,1365,840,1417,1137,1641,93,812;30;M
10248;1031,26,999,1534,1648,1417,503,1130,1641,309,315,1634,518,823,1115;42;F
10293;1137,1174,636,1634,123,1455,1417,997,503,797,93,970;43;M
10317;999,309,315,883,1455,1417,997,503,1130,1634,1031,14,1534,1641,970;50;F
10322;1634,1513,883,518,1190,14,1534,1648,1390,1348,1001,1137,503,1458,93;9;F
10341;312,315,1348,1641,314,93,309,1634,1121,1190,990,1534,997,503,1126;54;F
10344;1634,26,999,309,1390,785,883,1513,678,315,1031,990,1534,1417,503;52;F
10377;315,514,56,1137,1458,812,678,309,883,785,1215,503,952,353,314;41;F
10413;1648,1174,970,636,999,883,518,1190,990,1126,962,1513,1390,797,93;35;M
10421;1103,833,785,1031,883,1121,315,309,678,14,1097,1137,1641,698,314;38;F
10444;1115,353,637,314,1417,990,1365,785,518,970,1634,883,710,1130,1174;34;F
10455;1137,56,678,1634,1513,1031,1097,1126,1348,514,503,1458,1641,314,637;35;F
10477;678,1634,1513,883,1190,518,14,1534,1648,1390,1348,1137,503,1458,93;9;M
10509;952,1130,1137,514,1534,1215,1365,883,315,999,678,1634,1097,503,1115;29;F
10578;26,1634,1031,785,1390,1417,797,970,1641;30;M
10589;1115,123,1634;56;M
10596;1121,14,833,1215,811;46;F
10658;811,1455,1137,734,703,637,312,1634,883,1126,997,1130,962,952,314;50;F
10667;123,883,315,1634,518,14,1365,1648,56,503,1130,797,1641,703,970;41;M
10726;1115,797,1534,315,309,785,1648,1417,970,999,26,1634,123,1455,1641;36;M
10735;1534,309,1031,518,123,1648,1348,1455,1130,797,1641,812;44;F
10763;1121,14,123,840,1417,797,952,637,315,823,990,1126,1348,56,1641;43;M
10777;1126,315,309,1634,1031,1190,123,990,1648,1455,503,1130,797,1641,970;31;F
10873;1634,315,1121,1513,823,785,14,1390,1455,997,56,1641,93,636,1115;52;M
10876;678,1190,999,315,1534,1126,1390,710,56;33;M
10891;1097,1390,840,962,1634,56,503,1130;47;F
10908;309,1126,1348,1137,1130,314;40;F
10948;309,999,26,1634,1031,990,1534,1126,1648,1455,840,1417,1641,353,1115;28;F
10967;514,1137,952,314,970,1634,518,990,1648,997,503,797,1458,1641,93;27;F
10970;312,309,315,314;58;F
10995;883,14,990,811,1126,514,503,1130,797,1641,703,952,1094,970,637;73;F
11179;811,1534,883,1130,503;61;F
11185;1137,1130,353,312,315,1513,833,811,1390,514,503,1641,703,93,970;49;F
11221;990,1634,1031,123;36;F
11243;883,785,1365,1097,814,990,1126,1390,1455,710,1137,1130,314,514,56;34;F
11290;1137,636,1417,797,1641,314,678,315,1513,883,1031,990,1534,1126,1455;32;F
11317;56;15;F
11431;1634,1031,785,1137,1641,970;39;M
11434;999,309,315,1634,1513,1190,990,1534,1390,1455,1417,997,503,797,1641;50;F
11500;970,503,814,678;45;M
11554;823,312,999,309,1634,1031,990,1534,1648,1455,1417,962,970,353;40;M
11582;1130,1534,814,123,14,883,315,1634,1126;43;F
11617;309,1513,814,1390,997,503,1094,883;35;F
11628;1641,315,503,1130;64;M
11676;93;43;F
11709;93;28;F
11770;1634,1648,26,518,1190,840;51;M
11840;1121,1634,26,309,315,883,1031,1455,1001,514,1130,1641,703,952,970;31;F
11880;1534,811,990,678,1634,883,785,1137,503,353;36;F
11885;990,26,309,1634,1031,1365,1534,1417,710,1130,1174,1641,703,1115,353;23;F
11904;1648,514,503,314,1534,312,1031,833,990,811,734,1641,703,952,970;34;F
11952;56,1641,353;36;M
11979;1648,1534,1513,1031,1190,785,26,1455,840,1641;41;M
12014;785,1634,997,636,999,309,315,1031,14,990,1534,1417,503,1641,970;60;F
12035;785,14,123,503,1174,637,1115,883,1513,1534,1648,1126,1641,93,636;47;M
12120;1174;33;F
12168;518,1126,1455,1417,56,1458,1641,970,353,26,785,990,1534,1648,1031;36;F
12175;514,797,1641,703,93,970,14,1634,1031,990,1648,1126,840,56,1130;29;F
12193;26,315,1190,1115;32;F
12198;636,14,1634,678,883,1031,123,1648,1534,1126,840,503,1458,1641,93;42;M
12290;1348,1634,1121,518,14,1103,1001,514,1417,997,56,503,1130,797,970;27;F
12308;309,1534,1130,1641,797;42;F
12311;999,1634,1031,14,1365,1648;57;M
12342;1115,315,309,1031,14,785,990,1534,1648,1126,1455,1417,997,1641,636;70;F
12389;315,1513,514,1417,1137,503,1130,1174,1641,952,812,637,353,636,1115;35;M
12405;1031,785,1365,1417,1534,1648,1126,1390,703,93,1190,840,503,797,1641;34;F
12423;93;44;F
12441;309,1634,1031,1215,123,990,1534,1648,1455,1001,514,503,1641,703,353;22;M
12476;309,999,1215,315,1634,1031,785,14,123,1534,1390,1001,710,1174,1641;30;F
12486;1513,1215,93;39;M
12487;1031,353,1641,1648,123,1634,1365;47;M
12509;56,1115,970,1641,1130,997,1417,514,1534,123,518,1513,1634,14,1174;30;M
12525;678,309,1390,1031,1190,840,1001,503,970,637,883,785,997,1137,1648;32;M
12563;970,1115,997,1534,990,1215,823,1031,1513,315,999,312,1634,14,1365;59;F
12572;314,1513,883,823,518,14,1215,1534,1648,1390,1455,1641,636,93,1634;43;M
12595;678,1190,840,797;33;F
12669;1126,840,997,797,93,636,353,14,1190,1634,312,123;46;F
12714;703,309,999,315,883,1031,785,833,1130,734,1641,952,636,1634,1115;29;F
12730;1513,678,1634,1031,123,1126,1390,514,1458,734,1174,952,636,970,1641;31;M
12742;999,315,1031,1534,1417,812,970;70;F
12746;678;38;F
12748;1534,1648,1455,840,314,970,678,26,1190,990,1126,1348,1417,1641,1031;49;F
12764;26,14,990,1126,56,314,970,518,1097,1455,1417,1130;49;M
12789;56,1126,518,1031,315,309,26,999,1190,990,1648,1390,1455,997,1641;29;M
12876;518,14,840,1417,1137,797,1641,962,703;44;F
12896;1634,1513,785,518,309,678,883,14,1215,1534,1648,1348,503,970,637;40;F
12900;315,1513,26,999,1634,1031,518,1190,785,1097,1126,1390,840,1001,1641;61;F
12920;811,1126,1390,1001,503,1130,1641,703,1115;39;F
12946;785,1534,840,1417,997,1137,26,1634,1031,1126,1455,1641;40;M
12950;1126,1455,1417,997,710,503,1130,797,812,970,999,1634,1031,1365,1641;18;M
12951;1126,1455,1417,797,1641,93,1094,678,1634,785,1097,1348,997,1137,1130;38;M
12974;840,1634,123;34;M
12985;883,518,1215,1390,1137,1458,678,1031,785,123,1648,1126,503,1130,93;42;M
12992;1137,1130,1641,698,678,309,1634,785,990,1648,1455,1417,997,503,314;56;F
13010;1534,1648,1417,1641,637,970,962,1130,1137,514,1390,1215,1513,1634,315;28;F
13013;678,26,883,1031,1190,785,1126,1455,1137;43;F
13108;1641,703,970,315,1634,1513,1190,785,123,990,1126,1390,1455,997,698;41;M
13142;833,93;46;F
13171;1394,309,1190,14,1097,990,811,1534,1648,1126,1455,514,1417,1137,797;20;F
13219;814,1534,1417,1394,1458,1641,1094,1634,1513,883,14,1390,1348,1137,1130;35;F
13265;999,785,1648,1174,1634,1031,1365,123,1534,1126,840,1417,797,1641,1115;34;M
13330;1534,1126,1455,997,1641,314,93,1634,1190,123;37;M
13389;1534,1390,1455,840,514,1115,1634,1031,518,785,14,1365,503,1130,1641;26;F
13487;883,1031,1634,315,309,26,999,1137,56,503,1130,1174,1641,970,353;43;F
13489;1365,1190,999,26,883,309,315,1031,990,1534,1455,1417,1641;28;F
13546;812,1094,970,309,312,315,1031,823,1215,1390,1348,1137,503,93,1458;39;F
13558;93;37;F
13574;93;38;F
13582;1190,1648,1390,56,1641,314,636,637,503,1137,997,1215,14,1513,93;39;F
13644;678,999,1031,833,1215,123,814,1137,503,797,93;36;F
13647;1390,1534,1115,1126,883,1634,26,1365,1417,56,14,309,999;44;M
13649;990,1534,1648,1348,1001,514,1137,56,503,1130,1458,637,314,93,812;7;M
13722;1641,883,123,997,797;32;M
13733;93;40;F
13757;1513,785,999,1634,312,1534,1126,1417,997,710,503,1174,962,314,1115;53;M
13760;1097,710,503,734,1417,1174,883,1031,990,1137,797,1641,812,637,970;25;F
13897;678,1634,123,990,1126,1417,56,1641;39;M
13907;1126,1365,785,1031,315,309,26,999,990,1648,1534,1417,1174,1641,1115;36;F
13914;999,26,315,1031,785,1365,123,990,1534,1648,1455,1417,1641,970,1115;31;F
13927;636,970,812,823,14,1215,514,93;36;F
13932;678,1634,123,314,637,636;35;F
13945;1634;37;F
13966;1215,797,312,678,1513,1390,514,1137,703,93;43;M
13970;1001,1215,309,315,1031,785,990,1534,1126,1455,1417,997,797,1641,970;67;F
13975;1031,26,1634,1121,518,1190,811,1648,840,56,503,1130,1641,703,1094;28;F
13997;26,1097,1215,1126,1455,1137,1130,703;31;F
14016;1641,1115,1417,1455,1648,1534,1365,1031,312,999,315,785,123,990,970;44;F
14019;833,1455,797,518,710,962,314,1458,1390,1174,1126,1031,14;47;M
14045;710,1458,1174,703,1094,1115,1455,1348,999,1634,1513,14,1365,123,1534;43;M
14046;814,1126,1348,840,1001,1137,503,1130,797,734,703,952,314,1094,1115;32;M
14116;1137,56,503,1130,93,812,1094,309,1634,883,1031,1126,1348,1001,514;35;M
14122;811,636,678,312,14,1215,990,1390,514,1137,503,1641,314,93,637;38;F
14135;812,1394,1417,14,312,678,883,1215,811,1390,1137,503,93,637,636;43;M
14192;952,698,970,315,1634,883,1215,990,1534,1348,514,1458,734,1641,314;37;F
14278;312,26,823,1126,997,314,1365,1115,1648,518,315,999,1634,1031,123;56;F
14376;14,1126,1001,514,1137,314,812,312,1634,1513,123,1648,1390,1641,93;42;F
14406;93;45;M
14414;999,678,309,315,1121,883,785,1215,1648,1417,503,1130,703,353,1115;71;F
14415;26,315,1634,1190,785,1365,1215,1126,1455,840,514,997,797,1641,970;27;M
14442;309,1634,883,1190,14,1215,514,503;25;F
14468;1215,1001,1137,514,56,503;40;M
14515;309,26,1634,1031,785,123,1126,1455,840,1137,1130,797,1174,1641,93;61;M
14518;26,1634,518,785,14,1126,840,797,1458,1641,93;41;F
14541;93;9;M
14590;785,1097,990,997,1417,970,1634,1513,883,1130,1641,703,698,1094,353;46;F
14592;1121,1215,1001,1417,56,503,1130,1641,962,970,637,636;53;F
14598;698,703,503,56,1137,1001,811,814,1215,1097,14;37;F
14603;93;7;M
14624;1031,1190,1097,1215,811,1126,1390,1001,514,997,1137,315,1634,503,698;41;F
14720;1031,1121,315,309,999,962,1417,1455,1534,814,1634,56,1130;48;M
14747;1641,883,309,26,999,315,1121,785,1365,1534,1648,1455,1417,56,1115;38;M
14766;1390,840,797,1130,1215,514,883,1513,309,123,1534,1137,503,1641,962;43;F
14832;1121,315,26,999,312,309,990,1534,1455,514,503,1641,93,1417,636;56;F
14846;883,1513,678;30;F
14880;785,315,1126,514,26,1634,1513,518,1648,1390,1455,1417,1641,970;42;F
14901;514,1455,518,1190,26,840;22;M
14940;990,14,785,1031,26,315,1513,1390,1648,1534,1417,1641,698,970,1115;43;F
14946;315,1455,1174,26,309,1126,503,812;54;F
14954;1031,997,1417,1126,315,678,1641,999,309,1634,518,1648,840,970,636;49;F
14999;636,883,1215,990,1001,514,710,637;32;F
15010;1190,1513,678,312,14,1137,797,1641,1348,1648,1031,883,1634,309,93;41;F
15052;1130,1513,1390,997,26,309,315,1031,1190,785,990,1417,1641,970,1455;60;F
15053;1634,883,518,514,952;32;F
15068;93;35;F
15075;1455,710,997,1417,1115,1534,990,1365,785,1031,315,309,999,1641,970;8;M
15107;678,26,1534,1455,1130,970;41;F
15125;999,26,1031,823,123,1103,811,1534,1348,840,56,503,1130,703,353;32;F
15146;1126,1001,514,503,315,309,26,1137,734,1641,952,636,93,883,518;42;F
15179;503,56,514,1348,1126,1648,811,123,1215,833,14,1121,1458,812,1094;40;F
15182;1648,1215,14,315,1634,990,1534,1126,1455,1417,1458,1641;38;F
15196;26,785,1215,503,1641,309,1634,1190,1648,840,997;70;M
15206;1130,1126,785,309,999,315,1634,1031,990,1534,1648,1455,1417,997,1641;46;F
15212;883,309,678,315,1031,1534,1417,56,1458,1641,1094,1126,698,314,93;38;F
15220;1641,997,1634;47;M
15236;518,1103,814,56,797,93;35;F
15244;883,1348,1417,1137,503,1130,703,952,698,314,1094,353,636,1634,56;35;F
15307;123,814,1126,1390,840,1001,514,997,1137,1641,637,636,797,1634,93;41;F
15310;970,997,840,1455,1126,990,1097,785,1190,309,26;73;M
15314;518,1031,309,26,1126,840,970,315,123,990,1648,1455,1417,797,1641;57;M
15336;698,1137,514,1348,811,814,123,1097,785,1190,883,1121,1634,678,26;40;F
15338;1455,1417,1394,1458,1174,1094,518,1365,1534,1648,734,1641,952,970,1115;40;M
15355;1137,1215,637,997,1031,990,1534,1641,970,1130;31;M
15359;93,1094,637,1513,1190,1648,1390,1348,514,1417,997,56,1130,797,1641;29;F
15367;999,1634,883,1031,1365,1648,1455,840,514,56,1130,1641,962,703,637;38;M
15382;1097,1215,1390,840,309,1103,514,503,1641,1634,26;42;F
15398;1634,1121,1031,823,14,1097,1215,1534,1455,1417,1458,1641,314,93,1115;39;F
15425;678,883,1215,814,1348,1001,514,503,962,952,698,314,93,812,637;39;F
15444;1115,1390,1365,990,1417,970,14;43;F
15458;123,1137,93,636,1634,1190,814,1001;52;M
15463;1390,1126,999,309,26,315,1365,1031,785,990,1534,1648,1641,970,1417;33;F
15490;1190,1215,1126,1458,93,314,636,637,1634,814,56,503,812,14,1137;38;F
15505;314,636,1417,309,518,315,1031,990,1648,1455,840,997,1641,678,1126;40;F
15519;93;44;F
15524;952,314,1115,678,26,1634,1121,1031,785,1648,1455,514,1137,503,1641;39;M
15529;309,14,1534,1390,797,678,698,1137,1130,1648,997,636,1641,93,1031;37;F
15555;1115,970,1641,997,1417,1390,1648,1365,1031,315,1634,309,678,312,785;34;M
15577;309,312,797,1394,1001,1455,1126,990,1634,999,315,518,1031,1130,703;54;F
15596;1458,678,999,315,1634,1031,785,1097,1648,1126,1455,1417,1137,1130,1641;32;F
15607;93;7;F
15647;518,123,1348,1455,1417,56,797;46;M
15651;678,14,1137,503,734,1641,93,637;42;F
15674;1534,1648,56,1130,1641,353,785;37;M
15702;312,999,883,1031,1097,811,1648,1126,1390,1455,1001,1417,997,503,1130;43;F
15756;503,797,93;38;M
15764;312,1215,1137,503,1641,93,1115;36;F
15802;93,840,1130;38;M
15806;999,26,1634,123,1641;43;M
15833;678,503,997,1126,1648,811,123,1031,309,315,1634,14,1097,1417,1641;61;F
15910;1215,1534,1365,1648,1390,1348,1455,514,1417,1137,1394,503,1130,1174,1641;19;F
15932;999,1534,797,1031,823,785,14,1648,1455,353,1641,123,1634,26;19;M
15940;315,678,1648,1634,1190,1455,883,1031,785,1534,1390,1417,797,1174,1641;23;F
15941;785,1390,1455,1417,997,970,999,309,1513,1031,1365,1534,1648,797,1641;29;M
15970;1513,14,1137,503,1130,797,26,353,1115,1534,1648,1390,1634,1174,1641;65;M
15982;123,1348,1390,514,1641,353,26,518,785,1534,1648,997,56,503,1130;38;F
16028;883,309,999,678,1634,1031,990,1126,1001,503,1130,797,1641,703,353;39;F
16066;1121,1031,785,1097,814,1455,997,93,812,1094,1126,1390;53;M
16082;1031,14,990,1534,1126,1455,1417,1137,56,503,1641,703,314,970;66;F
16091;1097,1634,678,1513,883,814,1390,1458,1641,314,636;35;F
16095;1348,123,1190,503,1634,823,93;42;M
16123;883,14,1097,1390,1137,503;39;F
16147;811,1137,734,952,637;46;F
16150;1031,785,123,1648,1641,1513,1390,1126,990,970,962,840,797,518,353;52;M
16179;1634,990,1126,997,503,1641,962,1115;18;F
16223;93;42;M
16227;814,1513,962,840,1190;40;M
16238;1348,840,1417,1137,1174,678,1634,1031,56,797,1641;28;F
16273;315,309,999,1634,1031,518,785,123,1648,1455,797,1641,962,970,1115;50;F
16275;1115,1031,14,814,56,503,1641,93,812;28;M
16299;1215,999,1348,785,1031,1634,315,309,26,503,1130,1641,812,1094,637;20;M
16320;814,811,1455,1001,710,56,797,812,833,1394,703;49;M
16341;970,1641,1126,1648,990,999,26,309,315,1031,1190,1097,1455,840,1417;62;M
16347;678,26,315,1634,14,1097,1534,1126,1137,503,1130,1641,970,353,1115;64;F
16393;1130,1174,962,970,999,997,1126,1641,353,1634,785,123,1534,1390,1115;27;M
16421;315,1031,518,785,990,1534,1648,1390,1455,1417,997,56,1641,314,970;54;F
16530;883,785,1215,1348,514,710,1137,503,1458,1174,314,93,637,353,636;41;F
16535;636,678,309,1634,883,1031,518,1190,785,1365,990,1534,1126,1455,797;41;F
16540;1634,123;44;M
16543;678;40;F
16568;1215,93;46;F
16574;1215,1417,970,503,1458,1641,93,309,518,785,14,1648,997,636,1634;70;F
16580;315,1634,1031,1190,123,1534,1126,1455,997,503,1130,1641,962;26;F
16586;1513,883,1365,1348,514,997,785,1031,990,1534,1126,1390,56,1641,970;51;F
16599;785,1190,1031,315,309,26,999,1634,1365,1455,514,797,1641,970,1115;39;F
16606;1126,883,678,503;42;F
16622;93;37;F
16659;678,1634,1648,1534,56,1130;32;F
16662;93;7;F
16674;93;4;F
16697;1365,1534,1455,997,503,999,315,1031,518,785,990,1126,797,1641,970;69;F
16705;1390,56,1130;32;F
16711;1190,1634,309,1031,518,785,1648,1126,1455,997,1417,797,1641;73;M
16751;797,1641,970,353,999,309,315,1634,1031,785,1365,990,1534,1126,1115;33;M
16754;999,26,309,315,1031,1190,1097,990,1648,1126,1455,840,1417,1641,970;55;F
16786;970,1634,1031,518,1190,785,1648,1126,1455,1417,997,797,1641;75;F
16805;309,999,1417,797,1115,26,1634,1031,518,1190,785,1365,1455,840,1641;30;F
16819;1513,883,1031,1190,1365,1534,1126,1390,1455,840,1417,997,970,353,1641;50;M
16841;678,1031,883,518,123,1126,840,1001,514,1137,1130,797,734,952,636;38;F
16868;312,26,315,309,1390,840,997,1130,1641,1115,999,1534,1126,703,970;34;M
16912;811,833,785,315,999,518,26,309,1031,990,1534,1648,1455,1641,970;67;F
16954;999,1513,1215,703,1094,1634,883,1097,1130,678,123,797,93,698,636;44;F
16960;1031,518,990,1648,1126,1348,1455,514,1417,1641,314,93,1094,970,353;43;M
16971;1455,1001,710,970,637,1534,1390,514,1641,990,518,883,1513,1634,26;33;F
16973;1634,123,1390;44;M
16974;1513,315,678,1097,1126,56,1458,1641,703,314,1634,14;38;M
16980;26,1634,1513,883,518,990,1534,1390,1455,1001,514,710,1641,970,637;61;F
17031;883,823,1534,990,1215,1031,1513,1634,123,1648,1390,503,1641,93,812;28;M
17038;999,678,312,309,315,1634,785,123,1455,1417,1394,797,1641,962,970;43;F
17110;93,698,1130,56,1348,1648,814,811,833,1097,785,518,823,1121,315;63;F
17139;1115,970,314,962,1641,514,1126,1648,1534,315,1634,14,1365,56,503;35;F
17149;1634,785,1534,1390,1641;47;M
17170;314,93,812,970,636,1115,312,309,1121,14,1365,56,503,1130,962;45;F
17212;1348,1534,503,93,1641,1417,1126,1648,990,123,14,518,1634,315,353;75;M
17239;883,1031,518,1190,814,1534,1001,56,1130,962,1641,997,990,1103,1097;48;F
17260;1137,970,1648,1634,26,1031,823,785,990,1534,1126,1455,1417,797,1641;49;F
17288;1115,999,315,1634,1031,1365,1648,1390,1417,997,1130,1641;23;M
17318;309,315,1634,123,811,1115;47;M
17376;1190,811,1137,1130,636,312,1634,123,734,962,952,353;36;M
17379;1031,785,1648,1126,1417,1641,703,93,970,353;38;M
17383;309,315,1031,785,1365,1534,1648,1126,1455,514,1417,997,1174,1641,1115;50;F
17468;1097,814,1031,678,309,315,811,1534,1001,1137,1130,734,1641,703,1094;39;F
17484;678,1097,814,1126,1348,840,997,812,14,1190,1634,883,1648,56,734;32;F
17491;636,353,93,1641,797,1417,840,1455,1126,1534,123,1031,1634,26,312;64;M
17493;93;48;M
17510;26,309,1634,1031,823,518,1190,833,123,1126,1390,1348,1455,1641;44;F
17517;678,883,1348,1641,962,812;46;M
17522;833,840,1417,1130,1641,93,353,518,1190,797,703,812,636;69;F
17524;999,952,1641,1130,56,1126,1103,883,1121,678,1097,1001,514,1137,636;40;F
17526;1031,785,123,811,1534,1126,1455,840,1001,1417,997,56,1130,797,1641;26;F
17558;785,1641,797,1417,1455,1031,990,1534,93;47;M
17574;309,26,999,315,1634,1031,518,1190,14,123,990,1648,1126,1348,797;29;F
17588;1115,999,26,309,315,1031,785,1365,990,1534,1648,1455,1417,710,1641;35;M
17607;1365,785,14,1455,1417,698,970,999,315,1634,1121,1031,1648,56,1641;48;F
17633;883,1215,312,1513,797,1458,1641,93;38;F
17669;1031,1534,1648,1417,797,1641,970;27;F
17681;1634,315,309,518,785,1215,990,1126,1001,1417,997,710,797,970,353;41;F
17783;883,1031,785,1648,1126,1455,1417,1137,1458,1641,314,93,970,637,636;38;M
17830;797,1641,1031,785,678,26,1634,1190,1097,990,1126,1417,56,1130,970;45;M
17866;315,309,999,1031,990,1534,1126,1455,1417,997,503,1130,1641,703,970;51;M
17875;1634,785,123,514,1641,703,26,353;46;F
17887;1031,315,678,883,1126,1137,503,1130,734,703,698,314,93,353,636;36;F
17909;883,314,1634,309,315,1031,518,785,833,990,1648,1417,1641,812,1094;67;F
17917;999,309,315,1121,1031,1455,997,1137,503,1641,1634,14,1648,1126,93;41;M
17972;883,1031,1513,518,1126,1390,840,1137,1130,797,1641,314,93,970,636;39;F
18027;999,785,797,26,309,315,1031,811,1534,1126,1455,840,997,503,1641;42;F
18038;1390,514,1137,1641,637;46;M
18053;1001,1394,1130,93,1634,883,14,1215,678,514,1137,1458,503,637,636;37;F
18084;970,1534,353,1031,1634,1641,123;51;F
18089;1190,1365,1634,123,1648,1126,1348,1455,840,1001,514,1417,997,797,1641;37;M
18141;990,503,678,26,883,785,14,1648,1126,1390,840,1137,1641,703,970;69;F
18154;309,315,1634,785,1365,1534,1648,1126,1455,840,1417,1137,1641,314,93;47;F
18156;312,26,1121,1513,823,1190,14,1097,1215,56,503,1130,703,314,637;44;F
18186;1634,309,1031,785,1365,123,1534,1648,1126,1455,1417,1641,353;31;M
18221;309,312,678,14,1097,814,811,1348,1417,1130,1641,703,698,93,970;40;F
18245;1094,637,678,883,1001,1458;29;F
18272;518,785,14,1215,1534,1648,1126,1455,840,514,1417,797,1458,1641,93;43;M
18273;883,785,14,1365,811,1648,1348,1417,997,1137,503,734,1641,952,1115;27;F
18279;1534,353,970,1031,1634,1641,123;76;F
18300;1648,1534,123,1215,1365,785,14,518,1031,883,26,678,312,93,636;10;F
18304;309,315,1634,1031,123,990,1534,1648,1126,1455,1417,1137,503,1130,1641;41;M
18333;518,14,1365,1215,1648,1126,1455,840,514,1417,797,1458,1641,93,636;6;F
18334;1534,353,970,1031,1634,1641,123;52;M
18336;997,314,823,26,312,1121,1190,785,14,1126,1390,1137,503,1458,353;33;F
18365;785,14,1365,1215,1648,1126,1390,1455,840,514,1417,797,1641,93,636;1;F
18427;1348,1417,997,503,797,314,93,823,814,1126,812,1094,353;12;F
18445;1534,1455,1417,503,637,1641,1365,785,883,309,1634,1031,14,833,703;43;M
18450;1115,1094,93,678,309,315,518,14,811,1126,1348,1137,797,962,314;42;F
18481;1641,309,26,678,315,990,1534,1126,1417,1137,698,314,93,970;43;M
18503;1115,315,1121,883,1215,1534,1126,1348,56,1130;35;F
18523;309,1031,785,14,990,997,1137,503,1130,1641,698,314,812,1094,970;9;F
18529;883,999,309,315,1634,1031,785,1365,990,1534,1648,1455,1417,1641,970;56;F
18533;1641;27;M
18563;315,1137,503,812;50;F
18587;315,1634,1641,1031,785,14,990,1534,1455,1001,514,1417,1137,1130,698;20;F
18659;970,1634,990,1534,1126,1455,1417,797,1641;38;M
18681;1137,1394,1641,952,698,970,637,636,678,883,1215,990,811,1001,710;21;F
18722;1215,14,1190,1031,315,312,883,1513,26,1634,785,811,1126,1455,840;40;F
18743;315,970,997,1455,1190,26,1634,1031,14,1534,1648,1126,1417,1137,1641;48;M
18763;503;32;M
18824;93;69;F
18830;503,1458,1641,703,812,1115,312,315,1634,123,814,1126,1417,797,93;70;M
18833;1031,1190,123,811,1115,636,93,840,1130,637,1634,1390,503;27;F
18838;1513,1215,1390,1137,734,93;35;F
18843;1634,503,840,1115;42;M
18915;93;45;F
18931;1097,14,518,1513,1634,315,309,999,678,823,1648,1458,1641,962,314;44;F
18935;999,309,1031,14,814,990,1534,1648,1390,1455,997,1137,56,1641,636;45;M
18982;1634,503,703;39;M
18994;678,309,1121,1634,1001,514,1137,503,1130,1458,1641,812,637,93;4;M
19014;503,1634,14;36;F
19030;990,814,1215,833,1097,14,1031,883,1513,1121,315,698,1130,997,1137;33;F
19044;785,1417,883,1648,997,56,1031,970,1365,1641,1534,990,1458,1126,999;44;M
19048;312,1534,823,1641,93,1115,14,1190,1031,883,514;29;F
19051;636,1634,1190,1365,123,1648,1390,1455,797,1174,93;40;M
19076;990,1648,1126,1417,997,1137,1458,1641,962,1115,636,678,315,1031,1634;41;F
19097;883,1215,93,636,1121,710,1137,503,1130,1634,1190,1390,840,1174,353;39;M
19152;309,315,1634,1534,1455,1417,1641,1031;44;F
19161;309,1031,990,1534,1648,997,1641,1115,315,1634,1417,14,123,1126,970;52;F
19181;1648,1126,1417,797,93,636,1137,970;44;M
19188;999,26,1634,1190,123,1126;41;M
19208;1031,1190,785,1365,990,811,1534,1648,1390,1455,1417,710,797,1174,1641;35;F
19251;1513,785,990,1455,710,1394,1130,797,1641,970;42;M
19279;999,1634,1365;39;M
19311;1130,997,1348,309,1031,14,1126,1634,123,1534,1648,1137,503,797,1641;40;M
19317;999,315,1634,1031,518,1190,14,1534,1648,1126,997,1417,1130,797,1641;53;F
19357;883,1455,997,1137,503,734,703,952,698,93,812,970,990,1634,123;10;M
19390;26,309,315,1190,990,1534,1126,1390,1455,840,997,1130,1641,970,1115;63;F
19405;93,999,26,315,1031,1190,785,1455,1417,1458,1641,962,812,314,970;28;F
19451;14,1390,1348,1126,678,1648,1641;41;M
19522;970,312,999,1634,1121,14,1365,1648,1417,1137,56,503,1130,1641,1115;48;F
19526;840,1648,1215,1365,14,315,999,1031,785,1126,1390,1417,56,1641,970;43;F
19532;1190,1365,123,1648,1126,840,970,1115,1634,518,990,997,56,797,1641;29;F
19567;1103,1001,710,1394,734,962,952,698,1121,1097,514,1130,503,56,883;40;M
19591;1534,1390,1455,1641,1115,1215,1126,997,698,970,353,518,1137,56,1130;42;F
19602;1348,1534,1103,785,990,123,1190,823,1634,312,315,1215,1648,1390,1417;40;F
19661;1031,785,1365,1534;39;F
19673;1190,1365,1648,1174,1641,883,636,315,1634,1513,1031,785,123,1126,1390;30;F
19694;315,1634,1031,990,1534,1648,1417,1137,503,1641,970;36;M
19697;785,1097,1648,1348,1455,840,1417,1137,56,797,1174,1641,962,698,314;55;F
19719;883,14,833,1215,514,1137,703,636,93;39;F
19727;814,1001,1513,1634,883,1031,1648,1390,514,1137,1130,93,1094,637,636;40;M
19741;1634,883,518,1190,14,1097,1648,840,503,1641;52;F
19772;1031,1390,1455,1417,734,970,1115,315,785,14,1534,1648,840,56,952;33;F
19801;1348,1126,990,123,785,823,1031,1634,309,312,962,1641,703,314,93;12;M
19805;1031,785,1417,1130,1094,315,1121,1534,1348,503,1641;18;M
19912;710,734,1641,1174;30;M
19941;1534,1417,309,1190,26,1215,1648,1126,1390,1455,997,797,1641,518;54;F
19972;1215,1190,518,883,1121,1634,999,678,312,962,698,637,636,14,503;43;F
20015;1031,315,518,1190,1348,997,710,503,1130,1174,1641,353,636,1634,14;32;F
20027;698,1634,315,26,1031,785,1365,990,1534,1648,1455,1417,1641,970,1115;40;M
20072;990,1534,1126,1417,1137,1130,1094,1115,1634,518,14,1648,1348,1455,1641;39;F
20079;93;19;F
20098;514,1137,503,1115,637,970,1390,1365,999,309,1513,1031,785,1534,1648;51;F
20130;518,1634,999,312,26,309,315,1031,785,1648,1126,1455,1417,503,1641;42;F
20136;883,823,785,14,1215,990,1534,1126,514,1137,703,1641,314,970;39;F
20157;26,1365,999,883,1534,1455,1417,1641,309,315,1031,785,1648,1126,503;38;F
20197;26,1031,518,1190,1097,1534,1648,1390,1455,514,997,56,503,797,1641;47;M
20203;1634,1190,1390,840,1455,636,93,734,514,1001,883,678,637,1513,1215;20;M
20225;1534,990,123,785,1031,1634,309,315,26,999,1417,997,797,962,1641;76;F
20234;26,883,823,518,785,514,1137,1130,1641,952;30;F
20247;309,1455,1417,1641,962,1115;41;F
20260;1634,14,1365,503,797,962,970,353;59;M
20282;312,1634,883,14,1097,503,314,1094,93;39;M
20292;678,1634,1190,1215,990,840,1001,514,1137,952,637,970;56;F
20317;1634,823,518,14,811,1648,1534,1348,710,1137,503,1458,703,314,812;51;M
20355;1634,1513,883,1031,785,14,1365,1648,1126,1348,1137,503,1458,1174,1641;34;F
20357;26,312,1513,14,1097,811,997,1130,734,1394,785,990,970,1121,962;58;M
20373;1417,314;36;M
20439;1365,970,999,26,309,315,1031,785,1534,1648,1390,1455,1417,1641,1115;37;F
20472;999,309,315,1031,785,990,1001,514,997,503,1130,1641,703,353;50;F
20522;1215,883,1634,315,26,309,1097,990,1126,1137,734;25;M
20603;309,1634,518,785,811,1126,1455,1417,503,1130,1641,703;29;M
20610;514,1215,990,840,1126,999,26,1031,785,14,1365,1534,1455,1641,1115;20;M
20621;123,814,1534,1455,1417,997,56,1130,1458,1641,1115,312,1634,14,1365;52;M
20726;1031,785,1001,1417,56,1130,1641,703,314,812,970,1648,1126,1137,1458;43;F
20745;503,353,1513,1031,518,1215,1534,1648,1390,997,1641;43;M
20810;883,1513,26,1190,1097,1390,840,503,1130,797,734,1641,962,703,952;33;F
20845;1513,1031,1190,1097,1534,1126,1390,1455,503,1130,797,734,1641,962,952;33;M
20919;14,1348,514,503,1130,636,637,1094,812,93,1641,710,1137,1174;37;F
20920;785,312,999,309,315,1031,1190,1534,1648,1126,1455,840,56,503,1641;68;M
20926;503,1641,703,952,698,314,93,812,637,1137,1126,990,814,1215,636;29;F
21034;883,1190,26,1126,1390,1455,840,1001,514,1417,797,734,1641,952,1115;34;F
21050;840;62;F
21060;1390,1126,811,1513,999,1094,1641,970,1130,997,1417,1001,990,1031,518;31;F
21093;999,309,315,1634,1513,990,1534,1648,1390,1417,997,1641,962,970,1115;16;M
21164;14,1126,1137,678,883,518,1390,997,797;22;F
21168;678,1513,883,1190,785,14,1215,814,1390,1001,503,1458,1641,962,1115;19;F
21209;812,1634,1121,1031,1365,1115,999,26,309,315,785,1534,1455,1417,1641;45;F
21340;1648,833,785,1031,1513,309,1634,883,1215,123,811,514,1137,797,970;44;F
21372;1031,1126,1390,1348,1001,514,1417,997,1137,1641,970,637,999,1455,797;69;F
21384;309,1534,1126,1634,990,970,637,312,14,1001,1137,1130,797,734,1641;56;M
21398;970,637,636,1031,785,1215,814,1534,1126,1348,1390,1417,1137,1641,952;32;M
21409;840,1126,970,1390,518,309,785,14,123,1534,1648,1417,1130,797,353;46;F
21450;1390,1126,1648,503,1641,636,1215;15;M
21496;1634,1121,1513,1031,1365,1348,1390,1137,56,503,1641,93,1094,1115,14;39;F
21507;1634,637,970,814,997,1115,503,1130,1137,1365,883,1031,518,14,56;59;F
21516;678,315,1634,883,1031,1190,785,1215,990,1455,997,1641,314,637,636;34;F
21538;315,1126,997,503;60;M
21563;997,1641,514,1648,1534,26,883,1031,785,990,1126,1455,56,797,970;40;M
21585;26,1648,1641,1115,1534;17;M
21588;312,678,1634,1534,1348,1001,514,1130,314,353;43;F
21593;1031,814,1126,1348,514,1137,636,503,1458,1641,952,93,812,1094,970;16;M
21629;678,315,1634,1031,14,123,1126,636;38;F
21663;1648,1390,503,1458,636;35;F
21771;1115;19;F
21783;503,1126,1648,785,1031,315,309,1641,1417,1455,1534,883,999,1365,26;42;M
21867;970,26,1634,785,123,1648,1126,1390,840,1417,797,1641;30;F
21870;990,56,503,93;41;F
21871;315,26,1031,518,1190,990,1126,1455,1641;44;F
21897;14,990,503,93;50;M
21905;999,309,315,1634,1513,1031,785,1365,990,1534,1648,1641,1455;24;M
21930;315,1634,518,1190,811,1001,503,1130;51;F
21938;785,814,990,811,1390,1348,14,1001,514,56,503,1641,952,93,637;8;M
21941;314,1130,56,1417,1190,1031,312,823,518,123,1641,26,1634,1648,1455;44;M
21943;1348,1390,1534,1097,518,1031,883,315,970,990,1634,1648,514,56,1130;24;F
21953;56,503,1417,1634,883,785,1365,970,315,1513,1031,990,1390,1641,636;22;F
21969;315,999,785,14,1365,1215,1417,1031,1534,1648,1390,997,1137,1641,93;40;M
21990;1634,1031,1534,1648,1390,1455,514,997,1641,970,1115;46;F
22003;314,698,703,1130,56,1137,1348,1215,14,823,1513,883,1121,636,1115;42;F
22027;883,785,1365,1417,710,1174,970,26,1634,1031,990,1534,1648,1455,1641;32;F
22039;999,309,1031,123,1390,1174,1641,353,26,1634,1365,1534,1648;25;F
22047;1390,1648,1534,811,990,814,1215,833,1097,1365,14,812,1348,514,1137;36;F
22066;309,883,1417,56,970,636,1031,315,26,1634,1190,1126,840,1137,1641;33;F
22077;1126,1031,26,1190,997,1641,315,518,1097,14,811,1534,514,503,1130;40;F
22088;1534,123,14,785,312,315,1115,309,1634,1365,1648,93,353,636;39;F
22094;1513,1121,1634,315,309,999,883,1031,518,14,1097,1137,1641,93,1115;44;F
22106;1115,1641,1031,518,1455,997,93;40;M
22108;698;48;M
22132;678,883,14,123,1390,811,1001,514,1137,1394,503,1130,797,1641,703;28;F
22173;999,26,315,1121,1031,785,1126,1641,1455;40;F
22208;637,636,698,797,1130,1137,814,811,123,1215,833,14,883,1634,678;43;F
22233;93;8;F
22249;93;6;F
22307;315,309,1634,1031,518,14,1365,814,1534,1648,1126,1348,1417,503,1641;43;F
22308;1648,1513,999,1634,1031,14,1365,1534,1126,1417,997,1137,503,1458,1641;40;M
22321;703,812,970,999,1031,518,14,990,514,1417,503,1641,314,93,353;34;F
22342;1121,1634,315,503,1137,811,814,1365,14;42;F
22387;1455,678,26,1634,811,1648,840,514,503,1130,1641,703,952,93,812;23;F
22389;14,312,678,999,309,315,823,518,785,1365,1534,1126,503,1641,970;36;F
22395;997,1137,636,1115,1215,785,883,1634,315,309,999,1648,1126,1458,1641;42;F
22399;883,823,14,1097,1215,814,1648,1348,1001,514,1137,503,703,952,314;37;F
22407;518,14,1534,1390,1348,1455,840,797,314,636,353,785,26,1190,1115;39;F
22423;678,811,123,1215,14,883,1634,1513,1097,1390,1137,56,503,314,637;36;F
22429;703,314,93,970,636,678,309,1634,1121,883,1190,1534,1126,1348,1455;38;F
22439;1130,1394,840,1455,1348,1126,990,814,315,26,1190,14,514,1137,56;40;F
22481;1001,1634,1190,997,833,1417,56,503,1130,734,1094,811,710,703,1174;36;F
22498;637,1094,1648,1215,14,1513,1031,883,1390,1137,503,1641,93;35;F
22511;1634,1513,1137,1130,734,703;28;F
22529;1634,883,637,678,1513,1390,514,1417,503,1641,703,952,314,1094,970;31;F
22531;1455,1137,314,93,812,1126,1031,999,636,309,678,785,1641,503,1534;30;F
22535;1634,518,1534,1390,1455,1001,1641,1115;26;F
22576;315,990,1455,840,997,1137,1394,797,1641,962,703,952,698,314,970;38;F
22612;14,1365,1126,1417,1641,93,1094,636,503,1455,785,1031,883,1513,1534;35;M
22636;1648,990,123,1215,14,1031,1513,1634,315,309,1390,1137,93;36;F
22658;1031,1215,833,1455,1137,503,797,962,1126;69;F
22701;1031,678,312,1634,1190,814,990,1126,1348,1137,1394,503,698,314,353;7;M
22735;811,1634,703,883,970,990,1455,1417,785,1031,678,123,1126,797,1641;37;F
22755;999,312,1534,1417,997,962,636,1634,1121,1031,823,785,1130,1641,970;46;M
22761;678,14,1097,1215,811,514,503,812,970,637;41;F
22776;1634,1031,1190,1365,1534,1648,1390,840,1455,1417,503,1458,1641;15;M
22779;678,1634,1513,883,1031,14,1648,1390,1348,1137,56,503,1130,1641,636;36;F
22783;309,315,1513,1031,785,1365,123,990,1534,1648,1455,1417,1641,952,1115;30;F
22797;1513,1130,1634,797;39;M
22903;1115,1417,1390,1634,999,785,1365,1534,1174,970;67;F
22925;315,1121,883,1031,1097,833,811,1390,1417,997,1137,56,503,1130,952;38;M
22941;1121,883,1513,823,14,811,1126,1390,1348,56,503,1130,703,812,1094;46;F
22962;1215;38;M
22980;1365,785,1634,1534,797,1174,26,1031,518,990,1648,1126,1455,1417,1641;37;M
22983;883,833,514,1417,1130,703;27;F
22996;1634,1126,353,1174,26,710,698,1031,990,1365,785,1534,1417,1641,970;29;F
23012;309,315,1634,1513,785,14,990,1126,1390,1417,56,1130,1458,1641,962;53;M
23016;26,309,1031,1190,785,14,1365,1097,990,1534,1648,1455,1417,1641,970;39;M
23019;309,315,785,1190,1365,990,1534,1648,1390,1455,1417,1641,962,970,1115;20;F
23024;703,970,1115,315,1634,785,990,514,710,56,503,1130,1174,1641,962;35;F
23029;1634,1031,1190,1097,833,1215,123,811,1534,1648,1001,514,56,503,1641;42;F
23037;997,1126,1534,785,1031,309,678,1513,637,703,1390,990,315,883;45;F
23038;999,315,1634,1031,1365,1215,1534,1126,1348,1417,997,1137,698,314,637;34;F
23044;1031,997,123,1634,518,811,990,1390,1001,514,56,797,734,1641;54;F
23058;1455,123,1097,785,1031,883,315,999,1634,14,1365,1534,1648,1130,1115;48;F
23086;315,1031,1365,1534,1648,1455,1417,710,1174,1641;33;F
23107;514,1455,1648,518,999,309,315,1031,785,1097,990,1534,997,56,1641;57;F
23109;636,503,997,1455,811,1215,1031,1634,309,678,1121,883,1126,1130,1641;40;F
23114;353,1094,314,1130,1390,1215,309,1121,1031,1648,1126,1137,503,1641,703;39;F
23124;315,1634,1031,785,990,1534,1648,1126;40;F
23187;1634,883,1031,1190,1365,1215,1103,1390,1417,962,1534,1648,1455,514,1641;28;F
23217;1137,990,1097,14,1190,823,999,312,883,833,811,703,353,503;28;F
23221;26,1634,1031,1190,1097,1534,1648,840,514,1417,56,503,1130,1641,703;39;F
23227;785,811,1094,1390,1634,309,833,1534,1126,1417,1130,1458,1641,703,636;54;F
23234;1215,14,1634,678,312,1121,1513,883,514,56,314;35;F
23310;518,14,1097,833,1215,814,811,1534,1126,1648,1390,514,1641,1137,56;50;M
23319;1417,56,503,1130,962;32;F
23381;1121,811,1534,1137,1130,1174,637,1115,883,14,1365,514,997,503,703;44;F
23386;636,353,637,314,1137,814,1215,785,1513,1634,315,26,14,990,1126;36;F
23388;990,123,315,678,883,1365,1390,1137,1641,734,1174,1115,1634,514,503;28;F
23428;990,814,1634,518,970,1534,1648,514,1130;46;F
23432;1455,1348,1126,883,1031,1634,315,309,14,1097,1534,1648,997,1130,1641;40;F
23466;26,1513,1190,1126,990,840,1458,1641,637;32;F
23476;1513,1634,312,1097,1215,990,1126,840,1001,637,883,785,14,514,1130;30;F
23510;1190,1648,1126,797,1641,1534,1103,1097,26,1513,1390,1348,785,123,1417;39;F
23566;1121,1031,823,1097,811,1648,1390,514,56,503,1458,962,970,353;58;F
23570;93;45;M
23622;1634,1390,514,1137,503;47;M
23628;315,1634,1365,123,1534,1648,1126,1390,1455,514,1417,997,503,797,1641;31;M
23692;990,811,1390,1348,962,698,312,1513,883,1215,1001,514,1137,503,970;40;F
23695;1190,785,123,1534,1648,1126,1348,1455,840,1417,503,1641,93,970,636;37;M
23701;970,26,1534,1648,1126,1455,1417,1458,1641;52;M
23708;1390,1455,1130,703,970,883,1097,990,1534,1648,840,514,1417,997,503;40;F
23726;1641,93,812,883,814,514,1137,503,797;40;F
23744;1641,970,1115,962,990,999,26,309,315,1031,833,811,1455,1417,703;46;F
23747;353,503,811,883,1031,1190,14,1215,814,990,1126,1348,1455,514,1137;37;F
23751;26,309,315,1634,883,1031,14,814,990,1534,1126,1455,1137,1641,970;43;M
23754;1513,883,785,1215,811,1534,1390,734,952;33;F
23760;1513;33;F
23781;14,1534;35;F
23873;1137,1115,678,1634,883,990,1534,1348,1417,997,734,1641,698,314,970;69;M
23887;1365,1634;39;M
23900;1634,785,14,1365,1215,514,1417,1137,1641,1115;25;M
23984;93;46;M
24023;814,503,703,314;46;F
24027;797,999,26,315,1031,785,1365,1648,1534,1455,840,997,1174,1641,1115;28;M
24035;785,1126,1455,1115;64;F
24057;1648,518,309,315,1634,1121,1513,1031,814,990,1534,1126,1390,1458,1641;40;F
24082;1458,1648,1137,1417,1641,1115,999,315,1634,1031,990,1534,698,314,970;63;M
24106;1534,1365,999,26,315,1513,1031,785,123,990,1648,1390,1417,797,1641;33;F
24107;1190,990,883,1365,1390,1455,997,514,1174,1641,1115,309,785,1215,1648;51;M
24118;997,797,970,26,309,315,999,1031,1365,990,1534,1648,1455,1417,1641;71;F
24121;1115,1648,26,1634,518,785,1365,123,1126,997,1031,990,970,1534,797;35;M
24154;1121,14,1097,1103,514,1641,56,503;25;F
24190;353,636,999,309,315,1634,1031,785,123,1534,1348,1455,1417,503,93;40;M
24197;93;8;F
24205;1390,503,93,1634,1513,1031,518,1190,833,123,814,1534,1455,1417,1641;44;M
24206;1634,518,1190,797,970;57;M
24245;309,315,1634,1121,1513,1031,518,814,990,1534,1648,1126,1390,1458,1641;11;F
24262;990,309,315,1634,1121,1513,1031,518,814,1534,1648,1126,1390,1458,1641;10;M
24285;309,315,1634,1121,1513,1031,518,814,990,1534,1648,1126,1390,1458,1641;40;M
24329;1390,997,56,1130,353,93,1634;42;M
24340;1634,883,1513,823,14,1215,1390,1348,514,1130,797,314,637,353,1115;27;F
24355;1513,315,1097,811,93,636,678,883,1390,514,1137,1130,703,314,637;36;F
24360;1115,1641,1455,1534,1365,14,785,1031,26,999,1126,840,990,1215,514;48;F
24361;1115,1641,1455,1534,1365,14,785,1031,26,999,1126,840,990,1215,514;18;F
24371;1634,1513,1031,123,997,1641,703,314,93,1097,1121,1126,1348,1130;48;M
24374;514,997,1094,1634,1031,123,990,1126,1390,840,1417,56,1130,1641,962;51;F
24399;970,93,1641,1458,1417,840,1348,1126,990,123,785,823,1031,678,1634;39;M
24422;26,1031,518,785,990,1534,1648,1126,1455,840,1417,997,1641,962,970;62;M
24444;703,1634,1031,518,785,1365,1648,1126,1417,997,56,503,1458,1641,812;16;M
24447;1534,1455,1417,997,703,309,518,785,14,811,503,1641,698,93,970;69;F
24451;353,812,1634,1513,785,123,1648,1390,503,797,1641;44;F
24478;962,1130,997,1455,1215,1097,14,1121,312,26,1634,1190,1126,840,952;30;F
24485;309,518,123,1534,1390,1348,1455,797,1641,703,93,812,970,353;47;M
24525;990,1390,1417,1137,1130,1174,1641,703,970,637,1115,14,1097,514,503;27;F
24535;1130,710,883,315,999,26,1634,1031,785,1365,990,1534,1455,1417,1641;31;F
24567;1215,123,1455,1641,1634,312,990,1534,1417,353;44;M
24572;315,1513,883,1641,970,636;39;M
24579;315,1634,1121,883,1190,1097,1215,1103,814,811,1137,503,314,637;39;F
24594;1137,1390,1513,14,1115;55;F
24598;785,999,309,1634,1513,1031,1365,990,1648,1390,1417,1137,503,1641,698;46;M
24696;678,1513,883,1031,1190,785,1390,1455,1137,1641;39;F
24719;990,1126,1001,514,1130,703,315,999,1634,1513,1365,1390,952,1115,14;25;F
24721;1121,1634,1215,1137,698,93,812;41;M
24729;678,1417,710,1137,1121,1513,1534,1126,1390,56,503,1130,1641,703,962;34;M
24741;353,518,883,1634,312,1513,14,990,514,1137,503,1641,962,952,636;45;F
24752;1458,314,1094,636,1634,785,1097,811,1348,1455,514,1137,1130,1641,812;45;F
24775;1094,883,840,997,26,1097,1455,314,1641,56,1130,503;26;F
24777;309,1634,14,123,1126,1348,840,503,1130,1641,962,93,1115;38;F
24780;14,734,703;25;F
24791;503,1130,812,1094;50;F
24793;26,1115,999,309,315,1031,785,1365,990,1534,1648,1455,1417,1641,970;49;F
24804;1634,990,1126,1455,1417,56,503,797,1641,962;46;F
24805;123,990,1534,1648,1390,840,1001,514,56,503,1130,1641,962,970,1115;39;F
24808;1390,710,1115,999,883,1097,1103,811,1648,514,503,1130,734,1641,703;28;F
24827;1190,814,1534,1126,1390,1348,1455,840,1417,997,56,1130,797,1641,93;27;M
24839;1648,1417,1215,833,1190,309,999,26,315,1634,1031,518,1455,710,1641;32;M
24865;1458,734,1094,970,812,56,1137,1001,1648,1215,1634,312;42;M
24879;26,309,1634,1031,785,1365,990,1534,1648,1126,1455,997,56,503,1641;57;M
24880;797,734,93;41;F
24898;1190,1534,1648,1390,1455,514,710,1137,797,1130,970,309,1513,1031,1001;33;F
24900;26,1365,970,1115,1641,1417,1455,1648,1534,990,785,1031,315,309,999;5;M
24906;785,999,518,1365,1534,1648,1417,797,1174,1641,93,1115,1634,1031,123;17;M
24911;678,1348,962,503,1394,123,823,518,840,1137,353,93;12;M
24914;1130,503,93;42;M
24927;999,315,990,1534,1458,312,1121,14,1126,1348,1455,503,1641,703,1094;15;F
24935;1190,1365,1215,990,1648,1534,840,1641,1115,1634,883,1390,1001,1137,503;47;F
24937;503,997,1417,514,1001,840,1455,1648,1534,123,785,1190,518,1634,26;58;M
24953;785,883,26,1513,1097,1534,1126,1390,1417,997,1137,797,734,1641,93;39;F
24955;1365,26,999,309,315,1031,785,990,1534,1648,1455,1417,1641,970,1115;8;M
24977;1417,1137,999,1534,1215,123,503,514,1641,883,26,1634,353,1126,518;22;F
24989;999,26,315,1634,785,123,1534,1126,1390,1455,1417,503,1137,797,970;42;F
25004;1417,797,353,636,970,703,1130,503,514,1126,315,999,710,1641,1174;34;F
25057;26,309,315,1634,1513,1031,518,1190,990,1534,1648,1390,1455,1417,1641;46;F
25104;883,315,999,26,518,1648,1126,1455,503,797,1641,1094;16;F
25107;1126,1001,1417,997,56,1458,93,314,1130,678,26,883,823,518,14;36;F
25121;1634,999,823,123,1648,1126,1455,997,710,797,1174,952,812,970,353;33;M
25163;883,797,999,1126,997,990,1031,785,1634,1513,1534,1390,1455,1417,1641;20;M
25170;309,1634,1121,14,1097,1455,1417,56,1130;54;M
25205;1115,1417,315,999,26,309,1031,883,785,1365,1534,1648,1126,1455,1641;69;F
25215;1648,999,309,315,1031,518,990,1126,1455,1417,997,1641;35;M
25256;1215,93,637,883;25;M
25262;999,315,1634,1031,1365,123,990,1534,1648,1126,1455,1417,797,1641,970;41;M
25286;1455,999,26,309,315,883,1031,785,1365,1534,1648,1126,1417,1641,1115;75;M
25310;1513,14,1215,990,1390;49;M
25317;309,999,315,1634,518,811,1648,1455,514,1001,1417,1641,703,1115;32;F
25323;1126,93,1634,1190,123,990,1348,1455,840,997,56,797,1458,1641,970;52;F
25332;990,811,1001,514,314,1634,785,997,1137,1130,1641,698,970;30;F
25387;1137,1348,1534,883,1513,1634,312,1031,785,1365,990,1126,1390,1417,1641;47;F
25402;1634,1126,999,309,315,1031,785,1365,1534,1648,1417,56,1130,1641,1094;33;M
25448;315,1513,785,814,1390,1455,997,1130,1641,703,314,812,93,637,636;75;F
25449;999,26,309,315,883,1190,785,833,811,514,1137,1130,1641,703,952;26;F
25452;93;1;F
25457;1417,1455,883,309,999,1634,1513,1031,785,14,990,1390,503,962,970;35;F
25483;1031,823,14,1348,514,1137,785,990,1534,1126,1455,1417,797,1641,314;54;F
25488;1455,990,785,1534,1121,1097,1417,1458,970,1130,1394,703,353,123,1648;30;M
25491;123,1417,93,1190,1648,1115,999,309,315,1634,1031,518,1534,1126,1455;55;F
25499;315,26,1534,1417,1031,785,503,309,1126,1455,997,970;68;F
25502;814,1641,93,812,970,1634,883,123,990,1126,1390,1348,1455,797,1458;44;F
25505;1097,14,785,1031,1121,315,811,1648,514,56,503,1130,1641,962,703;47;F
25519;26,1634,518,1190,14,1365,123,1648,1390,840,997,56,797,1641,93;56;M
25552;309,785,814,1115,812,93,1458,797,1417,840,1348,990,123,883,1634;43;M
25558;503,1130,703,314,812,637,636,1458,710,811,514,1137,1641,93,1115;42;F
25573;1417,997,710,1137,315,1634,1031,785,123,1534,1126,1641,962,970,353;44;F
25575;1634,26,1513,1031,823,1215,814,990,1417,1130,797,1641,952,1094,970;40;F
25582;1126,1458,1641,812,93,797,1455,1348,814,123,785,1031,883,1634,315;8;M
25592;999,990,309,315,1641,785,1031,26,1115,970,1648,1534,14,1455,833;18;F
25598;309,1126,26,518,1190,1534,1390,1417,1641;61;F
25629;999,315,785,1534,1648,1455,1417,503,1115,1641;53;F
25655;883,315,999,678,26,309,1634,1031,14,1648,1126,1455,1137,1641,636;54;M
25684;734,1641,93,503,1130,999,1634,1121,883,14,814,1455;15;M
25742;883,1513,1634,309,315,678,785,1365,1126,1390,698,314,1094,970,1115;51;F
25758;1215,1031,1121,1513,883,14,1390;43;F
25780;315,1634,1513,883,1031,785,1365,123,1534,1648,1390,1455,840,1417,1641;46;M
25789;1648,309,1031,518,1215,1641,1390,1513,93;23;F
25798;1417,997,1001,514,678,309,1031,1641,637,315,883,1215,990,1126,962;73;F
25807;997,823,14,1097,1103,1126,1348,1137,503,1130,703,314,1094,637,353;39;F
25816;14,1390,1458,1641,678,883,1137,703;46;F
25817;1126,1417,1137,1641,703,1115,1121,1097,56,1130;41;F
25834;1121,883,833,1534,1390,1348,503;47;F
25840;678,514,990,1126,1634,503;23;F
25842;1641,797,123,26,1031,1365,518,1634,1190,503,1417,1126,1455,840,785;28;M
25864;518;50;M
25897;1097;37;M
25908;312,1634,518,1190,123,56,797,962,93,636;41;M
25944;785,1365,1121,999,26,315,990,1534,1648,1455,1417,1130,1641,1634,1031;45;M
25978;637,514,1634,315,678,1513,883,833,811,1390,1001,1137,1130,703,1094;50;F
25984;1121,1634,309,1190,1097,123,811,1534,1648,1390,56,503,1130,314,353;63;F
25995;1634,785,1534,1648,1417,1641,970;47;M
25996;970,636,1137,797,703,1215,833,1190,26,1001,503,1641,314,812,1094;44;F
26073;309,997,797,1130,1094,26,1190,14,1215,840,1137,503,1641,970,636;12;F
26083;785,518,1513,1634,999,123,990,1648,1390,840,970;34;M
26090;26,883,14,514,1130,823,1137,56,314;51;F
26129;833,1215,840,1001,1417,1137,503,1130,797,1641,703,314,812,1094,636;6;F
26143;1097,1126,1348,503,93;8;M
26145;93,636,26,999,1634,1031,1365,990,1534,1648,1455,1417,503,1641,637;9;M
26148;1513,883,1215,93,970,637;38;M
26163;1215,840,1001,1137,503,1130,1458,797,1641,703,314,93,812,1094,636;42;M
26164;1348,1394,93;44;M
26174;814,503,703,812,636,1390,678,883;41;F
26192;1130,1641,970,1417,1348,823,1031,883,1634,309,999,1534,1126,1390,56;42;F
26194;1513,315,312,26,1634,1121,823,518,123,811,1390;52;F
26197;1634,1513,14,997,1137,314,637,353;39;F
26228;1634,93;45;M
26231;503,710,1190,1031,26;23;F
26301;1130,1126,1648,1534,123,1215,1031,309,999,315,1634,785,514;34;F
26302;1648,1458,1031,999,123,970,1641,1390,990,785,1126,1348,637,797,883;27;F
26321;1417,1130,314,93,1094,353,636,883,14,123,811,56,503,703,812;48;F
26329;678,1513,518,1365,1126,1390,1348,1137,1458,734,812,883,785,14,962;43;F
26342;314,970,1215,93;39;F
26350;93;9;F
26363;999,503,997,514,1534,1031,678,315,14,814,1348,1417,1137,1641;41;F
26377;93;9;F
26391;698,56,1215,312,678,1513,883;42;F
26397;14,1365,1130,314,812,315,1513,990,1390,1001,514,1137,56,503,703;27;F
26404;93;40;F
26405;997,797,314,93,353,636,840,1417,1137,703,678,312,734,1641,952;29;F
26451;1094,970,1130,503,1137,990,1513,1390,1031,14,1215,123,1648,1641,93;39;F
26455;1031,1365,123,1534,1648,1126,1348,1455,840,1417,503,797,1174,1641,93;45;M
26481;636;51;F
26487;1641,1417,514,1348,678,999,315,1031,14,814,1534,997,1137,503;7;M
26501;514,1121,26,309,518,1190,785,14,1215,1534,1001,1137,503,1641,703;72;F
26502;93;43;M
26507;678,309,518,785,1215,123,814,1648,1126,1417,1137,797,1641;37;F
26508;636,1634,797;37;M
26531;1390,518,1031,315,1634,999,123,990,1534,1648,1455,1417,997,1641,970;42;M
26538;840,309,1031,26,1126,785,1641,1634,518,353,999,1534,1648,1455,823;37;F
26546;678,312,309,883,823,14,1215,1137,1130,1094,970,636;43;F
26554;883,1190,1365,1137,503,797,1121,1215,1348,514,1458,812;16;F
26555;999,315,1634,1031,14,811,1648,1390,503,1641,703,970;43;F
26585;1001,698,812,636,1121,1513,14,1097,1390,840,514,56,1130,93,1094;24;M
26606;811,1534,1455,56,1130,1458,309,315,1031,990,1417,997,503,1641,703;43;F
26612;1215,93;41;F
26640;710,56,1174;10;F
26641;14,1458,314,1094,970,637,315,883,823,1215,1348,1137,1130,93,1513;43;F
26708;314,812,1094,970,312,1031,814,1390,514,503,1458,637,883,14,1137;36;F
26742;93;64;F
26743;814,997,1137,56,1130,785,990;38;M
26763;840,1031,309,1634,883,823,785,123,1648,1126,1348,1455,797,1458,93;14;M
26830;797,514,1001,1648,883,637;45;M
26845;698,812,637,1534,814,1097,1513,309,883,1190,833,1215,990,1001,514;56;F
26863;1001,1094,1121,785,1534,503,962,703,353;23;M
27009;1513,1215,1648,56,503,1458,1641,93;33;F
27063;26,990,1455,1417,1641,970,1648;70;M
27075;1534,1648,1126,1390,840,514,1417,997,1130,797,1174,1641,314,970,1115;31;F
27085;997,1648,1126,14,1634,814,503,636,812;45;M
27184;1513,518,1390,840,1641,962,698,637,1094,1634,1215,123,1648,812,93;45;M
27231;999,1365,1648,1126,1455,1130,1641,962,309,1634,1031,785,123;30;M
27254;315,785,14,1348,1455,1417,997,970;53;F
27269;93;68;M
27346;1215,1103,814,1348,1001,514,56,503,1458,1641,703,952,93,812,1094;17;F
27381;353;20;M
27391;315,1390,1417,1031,312,1641,14,1534,1648;37;M
27397;1121,1097,1001,353,514,1641,999,123,1417,1455,503,785,26,1126,1215;39;M
27408;315,309,999,785,14,990,811,503,1641,314,93,1094,970;74;F
27434;26,883,518,1190,14,1215,1455,840,1137,503,797,1641,93,637;49;M
27481;309,26,999,312,315,1190,785,1097,833,1215,1103,990,811,1417,703;42;F
27500;1097,1534,503,797,952,811,514,1137,1641,1634;56;F
27514;312,678,1634,1513,883,1031,1190,785,1648,1348,1001,514,1137,797,1641;36;M
27515;1215,990,1648,1455,514,1417,1458,734,1641,698,314,970,637,636,1115;59;M
27516;990,514,1417,56,1641,1121,1126,1137,678,315,1348,1455,503,1130,962;36;F
27559;1174,710,970,636,1513,315,811,1390,514,1137,503,1130,93,1126,990;37;F
27560;710,999,1115,1648,1455,1634,1365,990,1126,1641,970,1417,1534,1031,1174;39;M
27567;26,309,1121,883,1031,1641,952,970,637,1115,1634,785,1365,710,1174;30;F
27592;1634,93;43;M
27601;999,1190,1126,1417,997,797;37;F
27611;309,785,997,1458,315,1634,14,1365,811,1348,56,503,797,710,1174;26;F
27619;514,710,314,93,1634,1031,518,1097,990,1534,1648,503,1641,703,970;36;F
27626;1634,1513,883,1031,1126,1390,840,997,1417,1641,703,1094,970,1130,1394;39;F
27671;710,1174;27;F
27684;785,1513,309,999,1634,1031,1097,990,1534,1648,514,1130,734,1641,353;37;M
27690;1513,1390,1634;35;M
27693;999,1648,1126,1417,1641,93;37;F
27727;678,312,1513,785,1365,514,997,1634,823,1215,1390,1348,56,797,962;47;F
27729;999,1648,309,93,123,1455,1641,840,785,1190,26;38;M
27803;1126,678,1634,1513,883,1031,1534,1390,1417,710,1137,503,734,1174,1641;28;F
27823;309,1215,1534,1648,1641;46;M
27837;1115,997,1031,309,315,1174,1417,1641,970,1634,785,14,1097,990;66;F
27872;14;51;F
27886;814,1634,315,309,883,1031,514,1137,1641,952,1115;31;F
27889;1513,1097,14,1215,1390;57;M
27890;883,1513,1121,315,999,312,309,1031,823,1190,1348,1417,56,1130,1641;41;F
27905;1348,1417,93,636,1115,315,1634,785,990,1534,1648,997,1458,1641,970;39;F
27906;1097,14,823,309,678,123,1348,1455,997,1137,1130,797,1458,1641,970;41;F
27910;1215,1390,636,1513,883,1137,1641;34;M
27949;1634,823,814,811,1534,1455,514,1137,56,503,1641,962,703,812,1094;40;F
27963;883,1190,785,1215,1130,14,1097,1534,1348,514,1417,503,734,703,952;34;F
27972;1417,997,1534,1126;41;M
27999;309,1031,785,1534,1348,503,734,970,1634,14,1417,997,1130,1641;30;F
28014;999,1634,1365,814,1648,503,1458,1174,698;35;F
28060;514,1417,1137,315,785,14,1365,1126,1348,962;46;F
28062;999,1534,1126,1417,1174,1115,309,315,1031,785,1365,1455,514,1641,970;32;F
28067;1417,1648,123,785,678,1634,1031,1215,814,1126,514,56,797,1641,636;39;F
28111;1513,883,990,1126,1648,93;51;M
28145;26,315,1634,1031,518,1190,123,1534,1126,840,1417,997,503,797,93;24;M
28147;1348,1641,314,698,1130,56,1648,123,1215,1097,14,1190,883,1121,678;49;F
28186;970,797,1126,1648,1534,990,1215,14,1190,1031,26,309,1634,823,518;56;M
28188;315,1634,1031,833,1348,1001,514,1417,503,962,703,952,1094;28;F
28195;315,1534,814,1097,14,1031,309,883,1121,514,997,1137,503,703;76;F
28205;952,970,353,1126,990,1215,1097,785,1190,518,883,1513,1121,315,26;31;F
28223;1634,26,823,518,1190,1365,1648,1126,1348,840,1417,997,797,1641,93;26;M
28234;785,1390,1103,1097,1121,1634,1190,123,1534,1455,840,56,503,1130,1641;27;F
28259;1174;32;F
28316;1634,1031,785,123,1455,514,797,1641;30;F
28321;883,1513,315,1641,637,1458,1130,1455,309,1634,811,514,503,703,1115;25;F
28359;309,315,1634,1190,123,1648,1126,1348,1455,840,1417,997,797,1641,353;40;F
28398;315,309,999,1031,785,1126,1455,1001,952,314,1458,734,1174,703,698;25;M
28399;1634,678,1190,518,123,1648,1348,314,353;37;M
28436;1097,1215,990,1001,503,1641,703;43;F
28443;678,1513,883,518,1534,1455,840,93;37;F
28457;636,997,990,814,312,678,883,14,1215,514,1137,56,314,970,637;42;F
28472;1534,1455,1348,703,1641,1126,14,1031,26,1634,823,123,503,1130,962;27;F
28478;698,999,678,1115,970,1641,1417,1126,1534,1365,785,518,1031,315,309;69;F
28479;1641,997,1417,1126,1534,1365,785,1031,1634,315,309,26,999,1115,970;33;M
28495;990,840,56,1641,962;24;F
28512;26,1513,14,1097,1215,1126,1390,1348,1417,56,503,1130,1641,970,637;46;F
28515;26,1031,518,785,1365,1126,1001,503,703;29;M
28541;1137,93,1417,1348,1534,678,309,315,823,518,14,811,1126,797,1641;7;M
28560;312,26,309,518,1190,14,1648,1390,797,1641;38;M
28562;315,309,1126,1648,1534,123,14,785,1190,823,1031,1634,514,1094,353;43;M
28596;503,1641,637,353,678,315,1634,883,811,1534,1390,1348,514,1137,703;41;F
28598;785,14,1215,1103,1534,1455,514,1417,56,1394,503,1130,797,637,1115;15;F
28605;315,309,999,1031,1215,811,1648,1455,1417,56,503,1130,1641,970,636;47;F
28614;883,823,518,811,1648,1634,26,1455,514,1417,56,503,797,1641,970;54;F
28685;1126,1390,1455,1031,785,1365,1534,1417,997,710,1130,1634,999,1641,1174;56;F
28692;312,823,14,123,1126,1648,840,997,1137,503,797;70;F
28742;1634,823,1190,1534,1648,1126,1348,840,997,503,1130,797,314,1115,1641;28;M
28752;1513,797,703,314,970,636,1115,883,1031,990,1126,1390,1455,1417,1641;23;F
28762;315,1634,1031,785,1534;45;F
28773;315,1634,785,1097,123,990,1534,1648,1390,1455,1417,1130,797,1115,1641;32;F
28775;93;31;F
28776;26,999,1648,1455,840,797,1174,1641,1190,678,1634,883,1031,1365,1534;31;M
28780;353,1648,93,1634,814,1348;41;M
28784;1641,93,1417,1126,1648,1534,990,123,1031,1634,309,999,26,970,315;41;M
28816;1534;31;F
28827;1513,1121,1365,1097,1534,1648,1390,1348,1455,1417,997,1174,1641,1634,1126;46;F
28830;1513,315,309,26,1097,1103,990,1126,1455,840,1417,56,797,1641,970;39;F
28834;1174,1648,990,315,1031,785,1365,1417,1641,1534,1115;33;F
28906;1455,1534,26,1634,883,970,1641,636,1348,1648,990,123,14,785,1031;45;F
28909;1031,1634,123,1534;31;M
28917;315,1634,1121,883,785,1097,1215,990,1137,56,637,698,962,503,93;37;F
28918;123,990,1365,1634,883,1031,785,1115,26,315,1126,1455,514,1417,1641;11;M
28921;1348,315,26,1634,883,1031,785,14,123,990,1534,1648,1455,1641,970;8;M
28929;1121,315,26,999,309,1634,785,990,1126,1348,1455,997,1417,1641,1115;6;F
28931;26,1634,883,1031,785,14,123,990,1534,1648,1348,1455,1641,970,636;97;F
28935;14,315,883,999,678,840,797,26,1031,1190,1365,997,503;61;F
28936;785,1365,1348,636,990,1031,312,997,14,823,1634,123,1455;40;M
28941;797,1458,1390,1534,990,1513,315,999,1031,970,1417,785,1634,1641,962;39;M
29016;833,811,1458,883,1513,990,734,1174,312,1215,1390,1348,637,353,514;35;M
29020;315,1534,1648,1455,840,997,797,353,1641,999,785,1417,990,1190,1031;76;M
29049;678,703,823,990,1031,1534,315,518,314,56,970,1513,1215,1130,1137;29;M
29094;518,1534,503,1174,1641;29;F
29107;678,814,811,1001,514,56,734,1641,952,314,970;37;F
29109;1458,314,1534,1455,990,1190,1634,1031,123,1126,1137,503,797,1641,637;41;F
29115;1094,970,1031,1121,315,26,312,1190,785,833,814,1455,1417,997,1641;43;F
29118;312,1634,14,503,1130,797,1094,1115;42;F
29131;710,1174;29;F
29154;56,503,797,962,952,1094,1115,26,315,823,123,1648,1455,1641,636;38;M
29164;1390,1455,1417,503,797,734,1641,698,952,636,514,1137,678,1126,314;38;M
29165;1174;30;M
29180;970,703,56,514,1390,1648,811,990,785,883,1513,1634,315,309,999;45;F
29182;970,812,1641,1458,503,56,1534,123,1103,1097,785,14,1031,1634,26;17;F
29202;1634,1121,14,123,1126,1137,56,812,1094,997,503,1130,797,703,353;38;F
29228;314,1130,1215,1365,14,785,1190,518,1031,883,1513,1634,309,999,1115;39;F
29243;840,785,883,14,814,811,1348,309,123,1031,1641,1634,833,518,26;43;F
29248;1534,514,56,1641,703,637,1115;49;F
29263;1137,1130,1031,1634,1094,315,309,26,999,503,1641,703,698,314,93;44;M
29264;970,1641,1458,1001,1348,1390,1513,990,1137,56,1394,1094;42;M
29267;814,883,518,1190,123,1641,1634,14,1126,56,797,637,1417,1365,785;38;M
29282;997,970,636,26,309,1634,14,1097,1648,1126,1001,514,1137,1394,1641;38;F
29284;1534;40;F
29306;1513,315,309,999,678,1031,785,14,1097,1215,710,56,734,503,1174;27;F
29312;315,1513,1031,1365,811,990,1534,1648,1126,1390,636,637,93,314,1641;35;F
29315;1115,518,26,1031,315,309,1634,1190,785,990,1534,1648,1455,797,1641;40;M
29363;814,990,1094,1365,518,678,312,883,1031,1648,1458,93,637;39;F
29366;1031,1634,678,811,1534,1126,1001,514,1137,503,698,952,314,353,636;40;F
29384;1031,315,26,962,1641,1130,56,514,840,1455,1215,1097,1190,823,1121;31;F
29417;1031,883,678,312,1126,1534,14,1634,315,518,1458,1417,1390,1215,1513;47;F
29457;1365,1190,315,309,312,678,990,1390,970,637,883,1513,514,1634,503;24;F
29464;678,999,315,883,814,1126,1455,1417,1137,503,1641,314,812,637,636;36;F
29473;678,1190,14,833,1215,1126,1390,1455,840,1001,1417,1137,56,703,970;50;F
29483;1417,990,123,785,315,309,314,26,1634,823,1190,1097,840,1137,503;50;M
29538;1365,785,1031,1634,883,1190,14,1215,814,1348,514,1130,1641,703,952;41;F
29546;990,1137,1115,312,883,1365,814,1648,997,1458,503,314,93,1094,637;8;M
29615;309,1648,1634,797,785,1641,123,999,1348,1417,1126,314;39;M
29688;1190,823,1031,26,1634,785,123,990,1455,1417,997,797,1641,314,970;15;M
29701;823,1190,1455,840,997,797,1641,123,1365,1126,1348,1417,785,1634,518;23;M
29711;840,56,1513,883,823,1215,1390,1348,1394,797,1174;54;M
29726;1634,503,1534;52;F
29741;26,1634,518,1534,990,1348,1641;43;F
29761;353,1115,970,785,518,1031,833,123,811,1455,514,1417,503,1641,703;37;F
29765;1641,999,26,1031,1097,990,1534,1126,962,970,353,1634,1390,123,1455;33;M
29845;56;16;M
29854;315,1121,1190,1097,1534,797,999,1031,1455,997,1641,1130,503,840,1634;45;F
29870;883,678,315,785,1534,1634,1031,1215,123,990,1130,1458,1641,314,93;38;F
29910;1634,503,353;44;M
29984;1455,1365,26,999,309,315,1031,785,990,1534,1648,1417,1641,970,1115;45;F
30030;823,883,1513,14,1126,1390,1137,503,1130,734,1641,952,698,353,636;33;F
30056;1097,1103,1126;47;F
30113;315,26,999,309,1634,1031,1365,123,990,1534,1648,1417,1641,970,1115;41;M
30125;503,1130,970,353,703,514,1001,1534,811,123,833,1190,518,1031,26;49;F
30150;1121,1031,785,14,1126,997,1137,503,1130,1458,1641,970,1634,1513,636;42;F
30195;26,678,990,1126,1390,1417,997,1137,797,1190,1534,1455,1641,1513,503;36;M
30200;1634,1215,1513,514,503,1115,312,1031,1190,1126,1348,314,997,56,1641;42;F
30206;93,962,1126,1534,312,1634,1513,1190,123,1137,56,503,1130,797,1641;40;F
30213;1126,840,1394,1130,797,703,93,812,1094,353,1097,1103,1417,1137,503;45;F
30220;1634,823,123,990,1126,840,503,797,637;42;F
30227;678,26,315,1190,14,990,1534,1648,1390,1455,1417,56,503,797,1641;67;M
30291;1121,1031,785,1534,1648,1455,1417,56,503,1130,1641,314,812,970,93;45;F
30310;1130,315,1115,309,999,1031,1365,710,785,990,1648,503,1641,314,970;51;F
30330;785,1365,1455,514,970,1115,315,1634,1190,1534,1390,840,1417,1174,1641;26;F
30333;1001,14,678,999,315,883,1031,990,1455,840,514,1137,1174,1641,636;35;F
30434;952,678,26,309,1634,1513,883,1031,518,1190,990,1390,1455,636,1115;36;F
30436;1455,503,1137,990,123,1215,1365,1513,1634,785,1390,514,997,962,353;19;M
30446;997,1641,962;51;F
30498;315,1513,883,518,990,1001,1137,1394,503,1458,314;38;F
30504;1130,1458,962,1348,1417,503,1641,314,812,1121,518,14,56,703,1094;48;F
30508;997,1130,962,93,797,1648,823,518,123,1634;16;M
30513;999,1634,811,1648,962;27;M
30530;315,1634,1648,1126,1455,1417,797,840,56,503,1641,314,970,353,93;65;M
30551;812,678,1513,883,1390,1348,1137,636;35;F
30580;1513,518,1097,997,1137,797,1458,314,93,637,636,678,883,123,1126;39;F
30606;1126,970,1115,1390,1001,1215,990,1634,315,1641,1417,1455,1648,1031,1534;49;M
30628;26,309,1365,1648,1455,1417,1641,1634,315,1031,785,990,1534;28;F
30640;1190,1097,997,503,970,1031,518;59;F
30656;785,823,1513,315,309,1634,14,1534,514,1417,56,503,1130,703,353;46;F
30707;678,636,1455,1348,312,309,315,785,1648,1126,1417,1137,797,1641,314;37;F
30721;312,962,678,1634,1121,1097,1103,1390,997,1137,503,1130,812,970,353;62;F
30737;1634,309,999,315,785,1097,1103,1455,56,503,1130,797,1641,962,703;49;F
30747;26,518,1097,1455,997;64;M
30768;1121,1031,1137,636,312,1097,1130,1641;45;F
30773;1031,123;45;M
30790;26,312,1634,518,1190,14,1215,123,990,1534,1390,1455,840,997,1641;46;M
30810;26,309,315,1031,990,1534,1648,1126,1455,840,1417,997,797,1641,970;14;M
30825;1417,1458,503,315,678,1348,1137,1641,698,314,14,1534,1130,703,1094;37;F
30826;312,883,785,1365,814,1648,503,1458,93,1094,637,1115;7;F
30835;353,999,1031,1348,514,1634,14,1534,997,1137,1458,314,970,1641,703;41;M
30850;883,833,1126,1001,56,503,703,1634,1031,14,811,514,1137,1130,1174;43;F
30910;312,883,990,1417,1458,314,93,970,823,1097,1513,1634,518,1190,1348;41;F
30915;26,309,315,1031,990,1534,1648,1126,1455,840,1417,997,797,1641,970;49;F
30930;797,997,514,1455,1348,990,14,315,1634,883,1215,1534,1417,93,970;25;F
30946;26,1097,1103,814,1390,1348,840,1001,514,1137,1641,703,314,698,1094;37;M
30954;997,1634,14;36;F
30963;1634,811,1534;22;M
30993;1634,785,123,811,1648,1126,997,1137,503,797,1641,703,93;43;F
30999;1097,1215,1534,1648,1126,1390,1348,1455,1417,997,503,1130,797,1641,314;60;M
31007;997,637,1513,883,1215,1001,1137,698,1534,1390,514,503,1641,703,93;36;F
31049;1348,970,1190,785,1534,840,1634,1115,797,997,1417,1455,1365,1031,1641;22;M
31079;1130,1641,703,353,14,1390,56,503;47;F
31120;1390,1097,309,678,1634,883,1455,840,514,1417,1137,797,1641,952,970;43;F
31172;26,1031,1534,1126,1455,1641,1115;31;M
31177;785,883,315,1115,636,1458,1417,1348,814,309,678,1126,1137,503,1641;41;F
31223;14,1137;56;M
31260;1634,1534,1130;27;F
31263;1137,503,1174,1115,999,1634,883,1190,990,1126,1455,840,1641,962,93;51;M
31313;123,514,812,1634,309,678,1648,1126,1455,1417,1137,56,797,1458,1641;43;F
31428;1634,14,990,1534,1648,1137,93,970;45;M
31466;1215,1390,514,503,1130,970,1115,315,1634,1513,883,14,990,1348,1455;28;F
31475;1634,840,26,309,315,1031,785,990,1534,1648,1126,1455,1417,1641,970;40;M
31482;970,637,315,1634,1031,14,1097,1534,1348,1455,1137,503,1130,1458,1641;36;F
31497;514,883,1031,518,1215,990,811,1648,1390,1137,314,93,812,970,637;35;F
31538;990,1534,1648,1417,514,1137,503,1174,1641,703,970,636,1634,814,962;39;M
31548;1390,840,1137,314,1634,1031,990,1648,1348,1417,997,710,503,1174,1641;28;F
31552;309,1634,1513,1121,315,312,14,814,1348,710,1174,314,93,636,1115;43;F
31596;312,1121,1031,1097,123,1126,56,503,1130,962,1094,785,1390,1641,1174;37;F
31638;1365,14,785,1121,990,1513,315,309,883,1031,1390,1417,1174;51;F
31646;883,1031,518,1215,990,811,1648,1390,514,1137,314,93,812,970,637;4;M
31653;514,636,698,503,883,678,1115;45;F
31657;1534,1648,1126,840,514,1137,1458,1115,814,990,1455,503,1641,703,952;34;F
31662;883,1031,518,1215,990,811,1648,1390,514,1137,314,93,812,970,637;2;M
31672;123,1648,1634;46;M
31683;823,840,26,309,1634,518,123,1648,1126,1455,1417,997,797,1641,1115;51;M
31703;883,1031,518,1215,990,811,1648,1390,514,1137,314,93,812,970,637;34;M
31712;14,1097,503,962;62;M
31713;1126,1648,990,1365,1190,518,1031,315,309,26,1634,785,123,1534,503;42;M
31721;518,1534,1641,703;35;F
31763;710,734;24;F
31791;678,309,1634,1031,14,1097,990,1126,1390,997,1137,1458,314,636,883;34;F
31817;1031,503,1641,703,970,309,315,883,14,1097,1534,1126,1417,1130,314;33;F
31836;1513,1215,990,1126,1390,1455,1001,1417,997,1137,1394,1130,1641,952,970;31;F
31854;785,678,636,93,1137,1215,14,1190,1513,309,990,1648,503,703,970;67;F
31867;1641,1174,518,1534;39;F
31869;678;46;M
31875;1634,315,999,678,883,1031,123,811,1126,1137,56,1641,703,353,1115;35;F
31882;1634,1648;49;F
31935;1215,1190,1126,1390,1455,840,997,1137,56,797,1458,1641,970,812,637;66;F
31968;1121,637,1130,503;35;F
32001;883,678,1097,1215,990,1648,1001,514,1417,1137,1641,703,952,970,636;38;F
32034;26,315,309,1634,1513,1031,785,1365,833,1534,1390,840,1130,703,1115;33;F
32067;1130,970,315,1348,1458,1634,1031,823,785,123,990,1648,1417,503,1641;34;F
32075;1031,14,990,1648,1126,503,797,952,314,312,883,1174,1641,970,637;24;F
32076;309,315,883,1215,990,1534,1417,970;35;F
32085;1648,1634,797,1534,1455,1458,1031,1190,1126,1390,840,1137,1130,1641,812;41;M
32096;710,1174,814,1634,93;39;M
32122;1130,1126,1365,785,518,315,999,1634,883,990,1534,1648,1641,1115,1031;31;F
32137;312,14,1348,710,1137,503,1174,314,812;44;F
32149;1001,814,1513,312,883,698,314,14,1348,1458,962,1115,503,1094;10;M
32159;26,1031,518,1190,785,14,990,1534,1648,1126,1455,840,797,1641,970;68;F
32160;14,1365,1137,503;33;M
32167;970;43;F
32168;1365,1126,811,1417,997,503,1130,1641,703;32;F
32171;1215,1348,883,990,1534,1648,1390,1001,514,1137,1130,1641,703,952,970;46;F
32189;1215,312,678;44;F
32190;990,811,1126,56,999,1121,1031,1097,123,1648,514,1130,1641,962,353;36;F
32195;1648,1455,840,1001,514,1417,703,353,1641,797,1634,123,811,710,503;42;F
32201;883,1031,518,1365,990,1455,997,1458,636,353,1126,1534,785,1634,123;35;F
32205;1137,503,814,93;66;F
32229;1190,785,123,1126,1348,710,1130,678,1513,823,1215,1417,703,93,1094;41;F
32242;785,703,26,1190,811,1534,999,315,1031,990,1648,1417,1641,518,970;56;M
32243;309,999,315,1634,1513,1031,518,1215,123,1126,1390,514,1417,797,1641;42;F
32257;315,1215,990,811,1534,1648,1137,503,703,952;39;F
32293;514,56,503;21;F
32332;1634,710,503,1174,1641;42;M
32354;883,14,1097,833,1215,811,1394,1130,703,637;37;F
32367;999,309,785,1648,1126,1348,1417,997,1641,703,314,1094;34;F
32412;93;7;M
32422;710,1455,990,1365,678,999,1634,883,1031,1648,1534,1417,1641,952,353;22;M
32429;93;10;M
32451;678,309,883,1031,1126,1641;38;F
32473;93,990,814,1215,1365,14,785,1031,883,1634,309,26,999,710,1174;40;M
32476;823,1130,1348,14;30;M
32520;514,1103,1097,1174,710,1534,990,785,1031,1634,315,309,26,999;33;F
32530;26,1121,962,314,1634,123,56,503;40;M
32556;1174,1417,1455,1390,1126,1534,999,1121,785,123,990,56,1641,970,1634;54;M
32585;1365,833,1534,1648,1455,1001,514,1417,997,56,503,970,840,26,93;52;F
32601;1031,518,1190,14,123,990,1534,1390,997,1641,698,93,1094,970,353;39;M
32624;678,1348;46;M
32670;56,962,93,970,637,636,1348,1648,990,814,1215,883,1513,1634,678;50;F
32679;1513,315,309,999,678,785,1390,710,503,1130,734,1641,952,314,970;28;F
32700;883,1121,1513,315,309,1634,1190,514,503,1130,1174,703,952,1094,812;26;F
32703;1130,1641,962,814,1190,1513,26,56,1137,840,811,1121,1634,312,503;49;F
32714;1121,1634,315,678,999,970,353,1115,1458,1130,503,1394,56,1137,1534;35;F
32719;1641,962,314,812,637,353,636,1634,1513,883,1031,1390,997,1130,503;44;F
32741;1634,1513,1031,518,1190,1097;40;F
32788;970,698,1641,503,309,1634,1215,123,990,1534,1126,1115;36;M
32820;315,999,309,1534,785,1365,990,1648,1455,1417,997,710,1641,970,1115;52;F
32839;518,1190,1648,1348,1455,1417,997,56,797,1641,962;70;M
32851;93;37;M
32871;823,1097,123,1534,1648,1348,1455,514,1417,1130,1641,962,703,812,970;46;F
32876;312,26,315,1121,823,1190,785,1126,840,1137,56,503,1641,314,637;44;F
32900;26,1634,883,785,14,997,710,1174;41;F
32918;678,1513,14,1390,503,952,93,636,883,1126,710,1130,1174,703,637;31;F
32924;309,315,1634,1513,990,1534,1126,1390,1455,840,1130,1641,962,970,353;21;M
32926;1641,962,1455,1126,1648,1534,990,785,1031,1634,315,309,26,999,1115;50;M
32931;1365,1648,1458,1641,93,636,883,1031,1126,503,1634,123,840,710,1174;40;M
33000;678,1634,1513,883,1126,1641,636,1390,797;44;M
33129;14,1215,514,710,1137,1130,93,636,678,883,1648,1126,56,970,1455;38;M
33173;1094,812,1641,1130,997,514,1001,1390,1534,1215,1190,1031,1513,883,503;55;F
33188;1137,503,1130,93,1513,312,883,1215,1001,514,1458,703,314,1094,637;43;F
33194;1641,962,952;40;M
33198;952,1115,315,518,785,1365,1534,1458,93,636,1513,883,1390,514,1137;28;F
33235;785,1121,1634,883,518,1215,1126,1648,970,1115,1348,514,1417,1641,812;30;M
33279;309,811,1648,1126,1137,503,1641,703,812;45;F
33284;309,315,1031,785,1648,1130,1641;42;F
33354;93;47;F
33380;312,883,1115,1365,678;39;F
33403;1641,503,1137,1348,1534,814,1031,1634,14;39;F
33504;514,1390,1215,14,678,1634,1121,883,1097,814,503,970,93;10;M
33512;814,503,703,93;8;M
33515;315,1648,1641,1115,1534,1365,785,26;44;F
33519;883,1634,1121,1648,56,503,1130,812;42;F
33589;785,883,1390,1126,1534,26,1634,1031,518,123,990,1648,1455,1417,1641;67;M
33600;514,962,1097,1513,1390,997,1130,314,1094;41;F
33613;312,309,26,1390,840,1417,997,710,503,1130,797,970,1115,1641,353;43;M
33622;353,997,1137,1130,703,314,93,637,999,1634,1190,514,503,1641,1094;46;M
33623;997,1130,314,93,970,1641,1455,1648,1534,990,883,1634,315,678,636;41;M
33657;999,1648,1455,997,56,970,1641,840,1126,1534,990,123,1031,315,1634;48;M
33718;1130,1634,309,678,883,823,14,1097,1348,56,1458,703,93,314,1094;45;F
33768;93,812,637,636,1634,1513,1031,1190,1215,123,1648,1390,840,503,1641;47;F
33776;785,1126,1390,1115,999,1634,1031,990,1534,1648,1455,1417,997,1641,970;44;F
33785;710,1174,970;34;M
33796;678,1634,518,123,1648,1126,1348,797,1641;39;M
33814;26,309,315,1634,883,1031,785,1365,990,1534,1648,1455,1417,1641,970;30;F
33815;1215,814,990,1455,514,812,1513,1190,1534,1648,1390,1417,314,123,14;39;M
33845;1513,883,14,1097,1103,1390,1137,503,970;45;M
33861;1137,315,1648,1417,970,636,678,1634,123,1534,1126,797,1641,962,93;68;F
33889;309,1634,1390,883,315,970,1115,1641,999,26,990,1534,1648,1455,1417;38;F
33901;812,970,883,999,1634,1031,990,1534,1455,1348,1417,1641;39;M
33910;999,997,1458,962,56,840,1455,1126,14,1190,1121,1634,309,26,312;41;F
33914;26,1190,990,1390,1455,997,56,1641,962,1513,883,14,1215;45;M
33930;1126,1534,1215,1190,999,1634,1365,636,26,1513,1648,1390,1455,1417,1641;43;F
33938;1455,309,1634,1031,990,1534,1648,315,1126,1417,1641,970;67;F
33959;518,1031,1513,1121,1215,814,1097,26,1648,1126,514,1137,56,503,1641;41;F
33980;1126,999,26,309,315,1634,1031,518,1534,1648,1417,1641,970,1115;42;F
34042;14,1390,1137,503;47;M
34066;1648,315,636,812,698,997,814,999,312,503,1137,1348,1097,1121,1094;41;F
34078;823,1348;28;M
34088;997,1641,970,840,1390,1534,1648,123,1190,518,1031,1513,1634,26,309;57;M
34109;93;64;F
34127;1097,1103,1390,1348,840,503,1130,1641,314,1094,970,514,1137,797,734;39;F
34175;1031,14,814,1534,1348,1137,503,1130,734,1174,93,1094,636;36;F
34182;990,1126,1348,1455,1417,997,1137,703,797,734,1641,952,314,93,970;34;F
34227;314,93,1115,883,785,14,123,1215,990,1348,514,1130,952,637,1634;28;F
34249;970,812,93,952,703,1641,1130,56,1137,514,811,503,734,636,1115;33;F
34262;1130,997,1001,1103,833,883,1121,314,503,514,811,1097,14,1031,1634;38;F
34318;353,636,1115,1094,1641,734,1130,56,1137,1390,678,1634,785,14,1365;35;M
34324;1634;43;M
34364;814,1365,785,503,1348,514,1137,734,812,637,1130,962,703,952,314;21;M
34399;123,1097,14,1121,1634,315,26,999,309,811,1648,1534,1417,1130,353;43;F
34401;1097,123,1455,1130,703,1634,1121,1190,14,1648,1390,56,1458,962,93;40;F
34413;997,1417,1455,1126,123,1190,1634,1534,314,1031,518,840,1641,703,812;45;F
34435;883,785,999,970,26,1031,823,14,1365,990,1534,1455,1137;44;F
34447;1513,14,1390,1137,503,1458,314,93;8;M
34465;785,315,999,1634,1121,823,14,1365,1097,1215,1103,503,1130,1641,1094;13;M
34468;1001,1455,997,970,703,1641,1417,514,1648,990,1097,785,1031,883,1634;62;M
34485;636,1641,840,93,637;39;M
34516;1126,1348,1455,840,1001,514,997,1137,503,1641,1094,312,1634,1190,1458;22;F
34521;1534,123,785,518,309,1634,315,1417,997,710,797,1031,1126,1348,1174;47;F
34537;999,315,1634,309,1031,785,990,1455,1417,1641,970;30;F
34552;1641,56,1534,14,518,1031,1215,1390,1001,503,93,636,1513;46;M
34594;883,315,1634,1513,123,990,1534,1648,1390,1455,840,997,797,1458,1641;30;M
34601;997,797,1641,1190;49;M
34618;734,952,1126,698,314,1641,1513,883,1190,14,1137,503,93,636,678;34;F
34653;26,315,1031,1190,785,123,1365,1534,1648,1126,1455,840,1417,797,1641;24;M
34657;26,309,1513,883,1190,785,1215,1534,1648,1126,1390,1455,1417,1130,1641;40;F
34666;26,1513,1031,518,1534,1648,1390,1455,514,1417,710,503,1641;18;M
34669;93;48;M
34677;1031,1365,1648,1126,514,997,1417,1130,1634,785,123,797,1174,1641,353;39;M
34688;1455,1126,123,785,315,999,26,797,1648,1534,990,1190,1634,309,1641;50;F
34696;637;50;F
34710;1634,636,678,315,1348,883,123,1126,514,997,1137,503;67;F
34744;309,1417,1641,1634,1513,1190,1390,1455,26,14,1126,840,1137,1094,703;28;F
34806;315,309,999,678,312,1126,1390,1137,1513,14,514,710,503,1130,1174;37;F
34852;14,1097,1215,1348,997,503,812;41;M
34868;1634,312,678,883,518,1190,14,1215,1648,1455,1137,797,1641,93,636;72;F
34918;1348,1130,312,1121,518,1031,14,123,1126,1641,93,1634;42;F
34931;1115,970,1137,1534,1365,518,1634,999,1130;34;F
34955;1634,309,1534,503;37;F
34959;56,703,1094,1097,811,1534,503;48;F
34971;1634,315,26,1190,785,1215,1534,1648,1390,1455,514,1417,1137,1115,1641;54;F
34973;1126,315,1121,1031,1097,990,1534,1455,1417,997;36;F
35000;883;41;M
35076;1115,703,1174,1130,56,1121,1634,514,710;28;F
35099;1348,1417,56,1641,1115,309,315,1634,1513,785,123,1534,1648;44;F
35140;785,678,309,1634,1031,123,1648,1126,1455,840,1417,56,1130,1458,1641;45;F
35208;999,26,1031,823,518,1190,785,1097,1390,814,1137,56,503,797,1641;38;M
35224;1634,1130,997,990,999,315,785,1534,1648,1455,1417,56,1394,1641,698;39;M
35240;309,1121,823,518,1190,811,1348,997,1137,1130,1641,1094,26,1634,14;48;F
35283;990,1126,1348,970;40;M
35302;970,962,1641,503,56,1137,1390,1126,14,785,1634,999,309,315,314;71;F
35373;503,637;60;F
35410;312,315,734,1390,123,1215,1190,518,1031,883,1513,1634,999,678,93;31;F
35451;1534,1031,309,1513,883,518,14,1648,1390,1137,503,1641,314,93,637;9;F
35463;1390,1455,1121,1094,883,1031,1534,1001,514,1137,1641,703,1513,1215;47;M
35472;1215,710,312,1634,518,14,833,990,1648,1348,1130,797,1174;60;M
35526;1634,1121,1097,1103,1390,997,1137,503,1130,812,970,353;64;M
35533;14,1097,1390,503,93;36;F
35544;785,1365,1390,636,309,1513,997,1641,1174,1115;27;M
35574;811,1417,1137,314,309,785,1097,1126,1348,503,1130,1458,1641,703,698;35;F
35588;1513,797,503,1001,514,1455,1390,990,785,883,1634,1534,997,970,1215;45;F
35600;1097,1126,1390,1455,1417,1137,503,1130,797,1458,1641,1094,970,637;41;F
35606;1513,785,1215,1534,1126,1390,1455,840,1001,514,1641,1094,26,1634,1190;42;M
35644;1031,785,1534,1648,1417,997,710,797,970,636,1365,56,503,1641,1115;37;M
35654;1137,1641,314,883,1634,315,999,1513,518,785,1648,1126,1390,503,93;38;M
35674;840,1513,785,518,999,309,315,990,1648,1534,1455,1417,997,1641,970;75;F
35688;1634,999,990,833,315,309,1417,997,710,1458,1174,1641,970,1115,1365;43;F
35723;123,1634,26,1641,678,1513,518,785,1365,1097,1103,1534,1390,1458,1115;22;M
35747;93;39;F
35749;1648,1455,710,883,1031,1190,1534,1417,997,1641,952,314,970;34;F
35752;309,26,315,1031,1365,1641,518,785,1534,1648,1455,840,1417,797,698;51;F
35843;123,833,1190,1031,1634,315,999,1137,703,970,56,990,785,26,309;42;F
35858;312,26,1121,123,814,1130,1641,518,785,14,1348,1417,503,56,93;17;M
35862;315,678,1031,14,1648,1534,1126,1348,1137,1130,503,1641,636,314,637;36;F
35907;1648,1455,514,1417,1174,314,636,1634,1215,797,1458,1641,703,26,678;41;M
35918;314,26,1190,840,797,93,1094;33;F
35943;1634,14;43;F
35960;1097,1130,698,314,812,123,1534,1648,514,503,797,1641,952,636,93;40;F
35987;636,734,1634,1513,123,1390,1130,797;36;F
36015;1348,999,1634,1365,1534;36;M
36019;1513,990,1031,1455,518;22;M
36031;1365,1215,1417,997,797;49;F
36039;1126,1641,1634,999,26,1190,840,797,314,93,1094;6;M
36040;1513,1634,1390,309,678,312,1031,1348,999,1534,514,1137,797,1641,636;20;M
36046;518,1365,962,1190,26,514,1455;40;M
36047;26,962,1190,1215,1455,1115;76;F
36061;315,1513,1031,785,1365,990,1126,1534,1648,1390,1455,1417,1641,1174,1115;54;M
36064;999,26,1634,1190,1126,840,797,1641,314,93,1094;1;M
36088;785,883,315,1634,1513,1031,14,1390,1348,1137,503,734,1641,952,314;39;F
36094;997,1641,970,353,785,315,26,883,1190,1126,1348,503,734,962,952;28;F
36103;999,315,1031,14,990,1455,1417,309,518,785,1648,503,1641;74;F
36104;1121,1634,315,309,814,1390,1001,514,503,1130,970,353,1115,14,1137;40;F
36149;1534,814,1513,1648,1130,1094,1641,1348,1126,1215,1634,1031,1137,1458,637;41;F
36168;970,734,503,56,1137,1634,315,1215,990,1648,637,883,1390,797;72;F
36201;952,1458,1455,1126,1648,785,1031,26,1390,1641,123,1634,883,1215,514;25;F
36216;1641,123,678,26,1634,1513,518,785,1365,1097,1103,1534,1390,1458,1115;19;F
36219;93;11;F
36224;990,970,1031,26,999,1634,785,1365,123,1534,1648,1417,1130,797,1641;28;M
36228;1126,1115,1648,883,1634,315,1190,997,1137,1130,1641,962;43;F
36308;1115,637,1641,1137,1648,1534,1215,1365,785,1031,1634,315,309,999,14;37;F
36312;93;8;M
36320;999,14,698,970,1458,1417,312,315,1121,883,1190,1215,997,785,1348;40;F
36332;1534,1390,1455,1001,514,1417,997,1137,56,1641,962,703,970,637,1115;49;F
36356;123,814,1348,1417,1641,314,93,678,1634,883,1137,503,797,353,636;32;M
36363;26,1534,1455,1417,703,1641,1634;43;M
36374;1417,1455,1534,1365,1634,785,1031,999,315,833,990,503,1130,703,970;39;F
36568;309,785,123,1126,840,1137,1394,797,1641;39;F
36579;678,1648,1417,1001,1126,1215,883,1455,514,503,1641,952,698,93,637;27;F
36593;312,1534,883,1031,1215,990,1648,997,503,1641,93;70;F
36601;1641,797,123,1634;31;M
36609;1190,1115,315,883,1390,514,1031,1648,785,503,1130,1641,962,812,637;22;F
36618;1031,785,1215,1513,883,990,1390,1137,970,637;65;M
36628;1648,1137,797,970,93;37;M
36651;315,309,1634,1455,1417,1641;55;F
36657;678,1634,1031,123,811,1534,1455,1417,503,1130,1641,353;46;F
36669;1417,999,315,1390,997,1137,1641,970,637,1513;46;M
36671;1174,999,26,309,315,1634,1031,785,1365,1534,1648,1126,1390,1455,1417;33;M
36681;1126,797,678;39;M
36714;1458,315,1634,1121,883,1534,1648,1417,1137,56,503,1130,314,353,93;41;F
36721;518,1634,26,315,1031,1190,785,990,1534,1126,1390,1455,840,1641,970;46;F
36728;1031,123,811,1126,840,1130,315,1634,883,814,1348,1137,503;45;F
36741;785,823,883,315,26,518,1513,1190,990,1390,1648,1455,1417,56,970;45;F
36767;1390,514,997,1130,962,678,1634,883,785,123,811,1417,710,503,1174;51;F
36769;1634,883,1031,518,14,990,1534,1126,1390,1455,840,1137,503,797,1641;76;M
36776;990,1534,1648,1126,1390,1455,840,1417,997,797,1458,734,1641,314,353;69;F
36791;990,123,1097,999,309,315,883,785,1365,1103,811,1390,1455,1130,1641;27;F
36801;1031,1634,999,518,710,503;32;M
36815;999,309,1031,1215,785,1513,883,990,1390,1137,970,637;64;F
36837;1534,26,309,315,1634,1031,785,1365,123,811,1126,1455,56,1641,703;36;M
36842;1455,1534,1215,1097,1121,315,309,1031,990,1648,1126,1417,997,56,1641;67;F
36862;678,1634,883,518,123,1126,1137,1130;40;F
36869;1634,999,1031,1648,710,503,1174,1641;30;F
36906;823,518,970,1215,93,1031,26,1534,1390,797;50;F
36940;1534,1390,1641,970,1115,1634,503,703;17;M
37006;26,990,1534,1648,1455,840,1417,997,1137,503,797,1458,1174,1641,952;69;F
37049;1648,1417,1137,970,14,1115;41;M
37071;315,1115,970,710,1417,1455,1648,1365,999,26,1031,785,990,1534,1641;31;F
37102;309,1513,970,514,1001,1215,315,698,678,883,14,1130,314,637,636;38;F
37131;997,1365,990,1174,999,14;54;M
37192;1097,503,1130,1115;50;F
37262;1641,990,970;29;F
37303;1417,797,1641,636,698,93,637,678,1513,883,833,990,56,503;51;F
37335;26,309,315,312,1634,1121,1513,823,518,14,990,1390,1348,1137,503;39;F
37368;56,678,1634,1126,797;36;F
37398;312,26,1121,1513,823,14,990,1390,1137,1394,503,1641,314,970,637;12;M
37407;309,823,1115,1130,814,883,518,14,1365,1458;36;F
37411;503,797,636,1641,93,637,703,1137,1455,1126,1215,1190,883,1121,26;53;F
37418;636,1641,1137,514,315,678,1130,952,812,503;39;F
37435;1513,14,833,1534,1648,1001,514,734,1641,703,1634;32;F
37444;315,1121,1513,823,518,14,1390,1137,56,1394,503,1641,703,698,314;8;M
37450;14,1031,309,999,1458,962,353,312,785,1126,997,1137,503,1130,1641;35;F
37460;14,1348,1513,1417,1130,93,1641,314,883,1031,1126,514,1137,503,1458;40;F
37466;1115,1634,14,1130;63;F
37476;999,315,883,1031,990,1455,970;48;M
37491;678,1513,883,833,990,1126,1417,56,503,797,1641,698,93,637,636;11;F
37510;678,315,1634,1031,1190,1534,1417,797,1641;33;M
37524;636,637,93,698,1641,797,503,56,1417,1126,990,833,883,1513,678;8;F
37545;312,999,812,1137,1534,26,678,1031,823,1648,997,1130,503;35;F
37564;312,785,1365,1215,990,1648,1455,1417,997,797,1641,314;77;F
37596;93;36;M
37605;812,353,309,315,1634,123,1534,1126,1455,997,56,1130,1641,93,970;48;M
37613;93;10;F
37628;93;7;M
37642;883,1031,785,990,970,26,1634,123,1648,1455,840,1417,1641,703,353;71;F
37661;93;35;F
37752;1348,56,962,970;33;M
37756;962,503,514,678;40;F
37783;636;42;M
37827;309,999,315,1031,990,1534,1417,1641,970;46;F
37833;315,1634,1031,990,1534,1455,1417,503,1641,703;74;F
37867;1121,14,1103,1390,1001,514,710,1137,56,503,1130,1174,703,314,1094;26;M
37893;93,636,703,1458,514,1001,14,1190,883,823,1137,503,1130,314,1094;42;F
37901;312,1634,1513,883,823,833,123,811,1001,503,703,812,1115;39;M
37941;1634,785,14,353;44;F
37966;990,1534,1126,514,997,56,1130,1641,698,309,315,14,1097,503,703;48;F
37972;309,999,315,1634,14,1097,811,1534,1126,514,56,503,1130,1641,703;52;M
37987;123,1215,833,1097,14,1634,1121,811,1534,514,997,56,1130;47;F
37990;1031,1513,1634,315,309,26,883,1190,785,1126,1348,514,997,1130,314;63;F
37999;1115,812,1126,1348,1634,1031,518,1534,1641;33;M
38006;883;37;F
38009;1648,26,814,710,1394,314,970,1115,315,883,1031,785,990,1126,1641;11;F
38021;990,811,1648,1126,1348,1455,840,997,56,503,734,1641,698,93,970;40;M
38039;14,1097,1126,1137,698,636,1634,1390,1348,1641;42;F
38058;1215,814,811,1390,1001,514,1137,503,1130,1458,703,698,93,812,636;41;F
38075;970,999,1031,1097,1103,1417,26,315,785,990,1126,1455,840,56,1641;34;F
38092;315,1126,1390,1417,1137,1097,1534,785,14,1365,503,1130,1641,703,1115;65;F
38093;999,1534,26,315,1031,785,1365,990,1648,1126,1455,1417,1641,636;12;F
38116;503,1513,1215,1390,1348,997,1094,678,1634,785,1126,1137,797,1458,1641;45;F
38142;990,309,999,315,1634,883,1031,785,1534,1648,1390,1455,56,1130,1641;50;F
38170;1634,1097,123,1648,1455,1137,503,797,962,314,1094,353;34;M
38204;1634,1513,1215,1390,840,1641,703,93,353;31;M
38224;518,999,678,315,883,1031,14,1215,1648,1534,1137,1130,1641,952,698;32;F
38228;997,678,1634,1513,785,1215,1648,1126,1348,1137,503,797,1458,1641,1094;12;M
38236;999,678,315,1634,1513,1390,1348,1455,514,710,1130,962,1641,314,353;23;M
38240;1348,1648,883,1634,312,1513,1215,14,1365,1390,514,812,1094,1137,503;43;F
38249;1348,14;45;F
38271;1390,678,1634,1513,1031,1215,1126,1348,997,1137,503,797,1458,1641,1094;9;F
38282;999,26,315,1634,1031,518,1190,123,1534,1126,1455,840,1417,1641,962;29;F
38316;1648,1126,1001,514,1417,1174,93,637,636,1634,1215,123,1455,840,1641;47;M
38337;14;45;M
38389;678,1634,1031,1641,1534,14;48;M
38446;840,315,309,1534,1648,1126,797,1641;32;M
38479;518,1634,1513,710,56,1130,1174,314;34;F
38544;1634,1534,1648,1126,1455,514,1417,997,1137,503,1641,962,314,970,353;55;F
38549;14,123,814,990,1648,1137,1130,503,93;35;M
38553;637,518,1031,1513,1348,1417,1137,1458,314,678,26,514,503,797,1641;36;F
38557;785,1534,840,1174,1417,514,1455,1648,26,1031,990,1115,1641,812,970;20;M
38628;812,1094,636,1115,678,1634,1103,1534,1126,1348,1137,1130,797,1458,1641;39;F
38680;823,1031,883,315,309,999,26,1634,14,1417,1641,962;51;M
38686;678,999,14,1365,990,1534,1648,503,1641,698,812,93,970;43;M
38805;1513,883,1215,1390,1001,514,1137,56,1394,503,703,812,637,314,93;47;F
38854;1534,1001,1094,312,997,56,970,353,309,1634,990,514,710,503,1174;62;M
38858;1641,314,970,637,1031,1513,1634,315,1390,1455,840,503,1130,703,353;44;F
38864;315,1634,1130,703,698,970,811;43;F
38874;1648,1137,1130,315,309,14,1365,1097,1534,1417,56,503,1641,353,1115;42;M
38880;1455,1190,1348,1137,56,1634,1031,823,14,814,1126,503,1641,314,93;44;F
38895;26,315,823,785,1534,1348,1455,1417,56,1130,1641,698,314,1094;37;F
38907;1634,1031,14,1534,1641,503,797;71;F
38915;1648,1641,309,315,14,1365,1097,123,1417,997,56,503,1130,353,1115;12;F
38937;833,1634,26,999,1417,503,1130,1174,1641,970;27;F
38939;309,785,1365,14,1097,123,1648,1417,997,56,503,797,1641,353,1115;5;M
39013;1365,309,999,26,315,1031,1190,990,1534,1455,840,1417,1641,970,1115;47;F
39029;678,1215,514,503,637;44;F
39042;999,315,1634,1190,1648,840,26,1031,785,1455,1417,1641;56;M
39059;1137,797,970,636,990,1390,840,997;50;M
39087;1031,315,970,1115;48;M
39169;503;58;M
39193;637,1137,990,883,309,814,514,997,503,703,14;68;F
39239;309,970,1390,1417,997,999,315,1634,1513,1534;29;F
39250;1634,123;50;M
39254;1031,883,785,1365,1534,1648,1390,1455,1417,997,1641,698,970,999,1115;49;M
39255;1513,26,518,1190,785,1348,1455,840,1417,997,56,503,1641,93,637;42;F
39290;1648,1137,314,93;44;F
39294;312,883,518,1097,56,703;42;F
39309;503,1126,811,1097,14,1634,309,518;24;F
39347;309,785,1103,1534,1648,1455,1417,997,93;8;M
39363;999,1417,997,1137,797,93;3;M
39373;970,1115,999,26,309,315,1031,1365,785,990,1534,1648,1455,1417,1641;45;M
39380;1634,678;62;F
39397;678,14,93;37;F
39407;315,1513,1365,1215,1001,1417,1137,1641,314,1031,1534,1126;36;M
39414;678,1648,1137,1634,1455,883,315,309,123,1031,14,56,1130,1641,962;38;F
39419;1115,1634,1126,1641;34;F
39431;1174,952,811,1031,1634,315,309,14,1097,56,1130,703,314;31;F
39436;93;8;F
39462;1190,785,1455,1641,797,1634,123,1534,840,1417;48;M
39491;14,1365,833,811,1001,514,1137,503,1641,703,637,636;70;F
39526;503,1130,1641,1634,1190,1365,1097;28;F
39527;1513,1634,678,883,1126,1390,1348,1455,514,1417,1137,503,1641,698,93;42;F
39543;1097,1634;34;M
39585;678,883,1215,514,636,637;38;F
39609;309,1001,1417,997,1458,1641,962,1094,637,678,883,1534,1648,1137,1394;41;F
39611;314,1137,1001,840,1126,990,1097,785,1190,883,678,1031,1641,970;29;F
39630;1121,14,1097,1215,1103,811,1390,1137,503,1130,1641,962;68;F
39634;637;52;F
39648;997,840,785,315,26,999,1634,1031,1534,1455,1641;46;M
39663;997,990,999,309,1031,14,833,1534,1126,1348,1137,503,1130,703,314;42;F
39672;678,1513,883,514,710,785,14,1097,1215,1137,56,1394,637,353,636;39;F
39745;990,1634,678,1513,1031,833,811,1001,514,503,1130,1641,1094,353,1115;19;M
39815;1455,1648,1215,1534,1348,1641,970,353,1130,1417,1634,14,123,1390,56;45;M
39823;823,1455,840,1417,1641,1121,518,1097,1103,1648,1348,997,503,1094,353;9;M
39834;14,1097,1001,514,997,1130,503;53;F
39856;93;32;F
39869;93;47;F
39876;315,518,1031,990,1648,1130,1115,785,1365,1534,1455,840,1417,797,1641;52;F
39913;698,812,353;27;M
39933;93;48;M
39937;990,1365,785,26,1634,1031,1215,1534,1126,514,1417,503,1641,93,970;46;F
39944;309,315,1634,1513,883,785,1365,1215,1648,1390,514,710,1137,962,703;46;F
39945;1455,14,823,309,811,1001,962,314,1126,518,1031,990,997,970,883;57;F
39968;14,990,1348,503,93;8;F
39987;883,14,785,1215,123,514,503,93;73;F
39997;970,997,1126,1648,518,26,883,1031,1455;68;F
39998;1031,990,1534,1648,1455,1417,970,1641;90;F
40007;14,990,1348,503,93;11;M
40028;314,353,93;42;F
40038;1634,1001,962,785,309,999,26,315,1031,1190,1534,1126,1455,1417,1641;32;M
40043;1455,1115,314,503,1417,1534,315,1634,1031,811,514,710,1174,1641,703;20;F
40045;1031,1417,1641,970,1115,678,999,309,315,1634,14,1365,1097,710,1174;61;F
40053;309,1097,1130,315,1634,990,1126,970;41;M
40073;1215,14,1031,883,1634,309,312,1190,1097,1103,1137,503,703,314,970;74;F
40076;1126,997,56,1115,123,1455,1648,990,785,1634,1641,1534,1031,315,309;47;M
40081;1417,710,637,1634,883,785,1534,1648,514,1137,503,1458,1641,812,353;44;F
40130;811,1031,1634,503,999,1534,1126,703;48;F
40137;703,503,997,1455,1534,990,14,883,999;53;F
40154;797,1001,1126,990,1031,315,999,309,1634,123,1648,1417,1130,962,703;52;F
40165;309,14,1215,1137,1394,503,637,1121,1097,1130;41;F
40177;1634,1365,503,1031,14;43;M
40195;93;51;M
40203;26,1634,1648,1455,1417,710,1394,970,990,1641;37;F
40221;1031,990,1534,1455,840,1417,997,56,1130,1641,1115,1513,1634,309,1126;41;M
40252;1534,811,990,1215,833,1031,1513,999,678,1634,1097,1390,1137,1130,503;35;F
40263;518,1641,1031,1534,999,1634,785,14,1365,1121,1097,1103,1137,1130,1115;60;F
40278;1121,883,1031,518,997,1137,56,503,1130,1458,962,698,314,1094;39;F
40316;678,309,1121,518,1103,1534,514,1417,1130,703,314,1634;26;F
40337;1634,14,503,1094,1137,1215;39;F
40346;678,14,814,1126,503,1458,1641,314,1094,636;37;M
40367;1634,518,1534,1648,1455,1641,636,1137,312,1513,814,1390,840,503,93;50;M
40408;678,514,698,1126,883,1215,1137,503,636;45;F
40421;1648,1126,1455,1641,970,999,1031,1215,811,1137,503,703,1115,1634,1130;46;M
40424;123,1365,785,518,1031,1634,315,26,1126,1455,1417,997,797,970;33;M
40429;14,814,1348,314;30;F
40433;1390,814,123,1190,1634,1641,1513,883,1215,990,1534,514,997,503,797;12;F
40434;1103,990,1348,514,1417,997,1641,314,1115,678,785,14,56,962,970;23;F
40448;1215,814,990,514,997,797,1174,1641,1130,1137,1348,1390,785,1513,1634;38;M
40494;309,26,1641,1634,1455,1417,1190,1126,1031,999,997,990,785,797,123;57;M
40500;518,785,503,698,1094,1031,1215,1126,1001,997,1130,703,970;55;F
40511;678;36;M
40512;1634,1031,1215,1534,309,14,990,514,1417,1137,503,970,1641,1648;65;M
40527;1126,1137,56,503,1130,1174,1641,1115,1365,1390,1348,1417,93,353,14;46;M
40544;1634,1031,833,997,503,1534;45;F
40555;123,315,999,26,309,1634,1031,1190,785,1365,1126,1455,1417,1130,1641;42;F
40577;1390,1348,997,1121,883,785,1215,811,1001,514,1137,56,503,1641,703;48;F
40585;1031,1365,1634,123,990,1534,1648,503,1641;33;M
40609;26,883,1365,1455,812,1031,14,785,123,1648,312,309,315,1634,93;47;F
40634;315,999,26,1634,1031,14,1534,1126,1455,1417,1130,1641,703,698,314;47;F
40646;785,1634,883,1031,823,14,123,990,1534,1648,1126,1417,56,797,1641;51;F
40654;1641,1417,999,309,1648;33;M
40665;309,1031,785,1215,1534,1648,1348,1001,514,1137,503,1641,952,314,812;68;F
40721;997,703,970,315,309,812;13;F
40724;1634,1513,1031,1365,1417,1137,883,785,1534,1126,1648,1641,314,1115,514;34;F
40725;1365,1534,353,999,785,309,315,1634,1031,1215,990,1137,1641,314,970;43;F
40740;883,309,1634,315,999,26,312,123,1534,1648,1126,1455,1458,1641,93;7;M
40874;1634,1121,518,1190,123,1648,1126,797,1641;18;F
40887;1031;72;M
40906;315,1634,14,1348,1130,1190,1215,1001,514,997,1137,503,1458,1641,93;45;F
40916;514,1458,1641,678,1121,1513,123,1534,1648,1390,1455,1417,997,56,503;38;M
40924;678,315,1031,1365,1634,14,1097,811,833,1215,1417,503,703,698,1115;68;F
40927;1458,1641,952,314,970,637,353,636;24;F
40931;823,1390,997,93;49;M
40950;678,309,315,883,785,14,1534,1348,514,997,962,698,314,353,637;41;M
40991;1031,710,503,1174;36;F
40994;315,1634,14,1126,997,1417,1641,314;39;F
41014;1634,1031,14,997,56,503,1174;25;F
41047;962,637,1634,1031,1190,785,990,1126,1455,514,1417,997,1137,1641,970;25;M
41060;1115,309,312,1634,883,1513,823,518,1190,785,14,1215,1126,1390,514;32;F
41064;999,678,315,883,1031,518,1190,811,1534,1648,1126,1417,797,1641,970;42;F
41143;26,315,1634,1190,785,123,990,1126,1648,1455,840,1417,997,1641,970;48;F
41155;56,990,703,637,353,1634,315,1513,883,785,1215,1390,1001,514,503;33;F
41207;990,503,970,636,1634;59;F
41230;1121,883,1097,1215,1103,1137,1130,1115,703;44;F
41240;93,315,518,1534,1417,1458,636,1648,1634,999,883,1031,1126,1348,1641;48;F
41248;1126,1458,703,698,812,1094,678,1634,1137,503,637;38;F
41253;814,1648,636,637,93,1130,514,14,518,1031,312,503,1215,1634,1534;43;F
41283;514,1137,56,1130,314,503,814,1126,703,1094,698,883,1348,1458,353;33;F
41316;1126,26,1365,1115,1648,1348,1417,56,315,962,970,309,785,1641,703;32;F
41486;312,999,1634,518,1126,514,503;80;M
41539;990,1103,1097,785,1121,315,312,309,1215,1648,997,1137,56,1641,636;42;F
41548;514,1348,1390,1126,990,1031,823,883,1513,1215,1648,1137,93;38;F
41551;999,1130,514,1126,56,785,1458,1115,309,315,1031,1648,1137,1641,970;64;F
41595;785,518,1031,315,883,999,309,1634,811,1455,514,503,1641,703,970;47;F
41596;1513,814,1455,997,710,1641,518,811,1126,1417,56,1130,703;25;F
41605;1348,56,503,314,1126,518,1031,997,990,970,883,1115;20;M
41626;883,315,309,1031,518,785,990,811,1534,1648,514,1417,503,1641,970;27;F
41708;999,1513,1365,833,1126,1390,1001,1417,997,503,1641,952,637,353,1115;36;F
41734;970,840,990,123,14,1513,1634,315,312,93;40;F
41737;999,309,315,1031,785,1365,990,1534,1648,1126,1455,997,1417,1115,1641;44;M
41743;1031,1365,999,785,1534,1126,1455,1417,1130,1641,970,1190,14,990,503;73;F
41870;1455,952,636,678,1634,1121,1513,883,1215,1390,1001,1417,1137,1130,1115;65;F
41890;883,990,1417,1137,315,1031,1648,1126,997,503,797,1458,1641,93,1115;44;F
41910;1458,703,1094,14,315,1513,1190,1390,1394,1130,1641,952,812,1215,883;17;F
41925;1365,833,1534,1126,1390,997,503,1130,1174,1641,962,314,93,812,970;9;M
41932;999,26,1634,1190,990,1648,1126,1455,840,1417,797,1641,703,1094,970;31;M
41942;1458,1174,1115,970,1641,503,1417,1126,1648,1534,990,14,1031,315,26;14;F
41987;1648,518,503,703,309,315,1031,785,1097,811,1001,514,997,1130,1641;65;F
41991;1137,1641,703,970,353,678,309,883,1513,14,123,1648,1634,1097,315;41;M
42002;970,811,1031,1513,315,26,883,1634,1097,123,1126,840,503,1130,1641;33;F
42017;26;66;F
42027;1634,883,1031,1534,1417,1641,970;72;M
42041;990,999,309,315,14,514,997,1137,1641,1031,811,1126,797,703,970;41;F
42127;1174,1115,970,990,1648,1126,1390,1455,1417,997,1130,797,1641,93,123;21;M
42130;1534,785,1031,1121,315,309,698,1641,1137,1126,1648,990,1097,883,678;38;F
42146;1634,315,785,14,1365,811,1534,1126,1001,514,1137,503,1130,1458,703;31;F
42159;637,1417,514,1348,1390,1126,1648,312,1634,1513,14,1365,1137,503,1115;44;F
42201;312,1031,1458,962,314,353,636,1348,1137,883,1513,1634,123,1126,503;45;M
42213;1115,1215,814,1126,1455,514,1137,56,503,1130,1458,1641,698,314,636;40;F
42218;1634,883,1534,1137,970;66;F
42228;883,1513,785,1215,1390,840,1455,503,637,26,518,1190,514,56,1130;28;F
42230;14,1365,1215,1513,1634,990,1390,1137,503,1641,314,812,970,636,1115;40;F
42237;123,1215,1190,883,1634,309,678,811,1648,1390,1455,514,503,1130,703;53;F
42260;315,1097,1103,1126,678,1634,1121,1348,1137,56,1130,1458,1641,314,970;49;F
42271;814,1348,1137,503,636;33;F
42273;636;36;F
42294;14;68;M
42302;1031,999,309,1634,1365,990,1534,1648,1126,1455,1417,1137,1115,1641,1130;33;M
42312;1001,637,990,1215,883,1121,1513,811,1648,1390,514,503,1130,1641,703;27;F
42376;990,1534,1455,840,1417,797,1174,93,26,678,1513,883,1641,637,636;41;F
42380;970,309,1634,315,1121,1031,1365,14,1137,1394,503,1130,1458,314,1094;11;F
42439;1641,1130,56,1137,1121,1634,883,14,833,811,1001,514,503,1458,1094;41;F
42457;312,999,26,309,315,1634,1190,785,990,1534,1648,1455,797,1641,636;12;F
42482;14,1190,93,797,1130,997,1126,990,123,1215,1097,1031,883,1634,678;34;F
42533;1031,785,1215,814,990,1648,1126,1137,797,1458,1174,1641,970,93,636;40;M
42560;678;65;F
42570;1126,990,1348,514,503,1121,1031,785,1648,1390,997,56,1130,703,970;67;F
42577;1121,883,785,990,1031,14,1097,1126,1390,1348,503,1458,1174,1641,812;38;F
42626;678;62;F
42634;970,678,315,1634,1121,1215,990,1534,1648,514,1137,1130,1641,703,637;39;F
42636;678,785,1215,1001,514,503,1130,1641,962,314,812;41;F
42668;312,26,1634,1190,1455,1001,514,1417,710,1130,797,1641,703,314,970;47;M
42678;93,518,14;37;F
42679;1137,503,1458,1641,1094,1121,823,14,1103,1126,1390,1348,56,1130,703;41;F
42689;1031,1513,1634,1215,1126,1417,797,1458,1641;40;F
42692;1215,1390,997,1641,962,970,309,1634,1121,1031,123,990,1648,1455,797;66;M
42698;1641,1137,1215,883,678;69;F
42724;1417,1137,56,812,970,1121,823,518,785,990,1348,503,1130,734,1641;32;F
42737;811,514,637,503,1031,1097,833;39;F
42752;1126,309,1365,1190,883,312,14,1215,814,1137,503,1458,314,812,1094;45;F
42760;314,703,1458,1394,990,1634,315,785,811,514,1137,503,1641,636,1115;41;F
42772;309,999,1634,1513,883,1031,1534,1648,1126,1390,1348,1455,1417,997,1641;37;F
42783;315,1634,1121,1031,823,518,785,14,123,1648,1348,997,56,1130,1094;61;F
42798;678,1215,1648,1634,1121,883,1031,990,1455,514,1417,1137,503,1130,1641;54;M
42812;883,1031,1097,814,990,1534,1126,1348,1417,997,1137,1641,962,93,970;77;M
42814;315,1031,785,14,1215,1534,1126,1390,1137,503,1641,314,93,1094;39;F
42832;999,309,315,1031,785,1365,990,1534,1648,1126,1455,1417,997,1641,1115;73;M
42844;518,1513,1390,999,1097,997,309,315,883,1031,990,1534,1126,1641,970;64;F
42845;514,1001,503,314,636;63;F
42849;1121,883,1031,785,1215,514,1137,56,503,1130,734,1641,952,698,314;30;F
42860;883,123,814,514,997,710,1137,503,1458,1174,703,314,952,93,637;71;F
42886;678;84;M
42892;999,315,678,1634,1031,123,1126,1455,840,1417,997,1137,797,970,1641;43;M
42895;26,823,1190,1103,1126,1390,1348,1455,840,503,1130,1641,962,314,93;35;M
42899;797,26,315,883,1031,1190,785,1365,1534,1648,840,1641,93,637,1115;46;F
42917;14;73;M
42935;1365,14,1648,1390,1001,997,1174;43;F
42969;710,1174;32;M
42973;997,1130,1641,785,1513,1634,1215,990,1648,514,1137,952,314,970,1115;39;M
43003;1641,1390,314,678,1648,14,1126,56,952,1031,734,1634,962,93,123;32;M
43027;518,1215,1126,1394,734,952,314,636,883,1103,56,1130,1458,93,1094;33;F
43045;1394,812,678,1513,883,1348,814,1458,1137,1103,56,503,1130,93,1115;45;F
43057;678,1634,1513,883,123,814,1126,1390,1348,514,1137,503,1458,353,636;29;F
43065;962,636,93,514,1534,123,1215,823,1634,26;47;F
43075;952,970,1390,1215,1190,883,1513,1121,315,812,636;27;F
43077;1365;28;F
43107;1634,823,990,1455,514,56,503,1130,703,970;44;F
43116;26,1641,1126,1031,883,1513,785,14,1348,314,970,1137,56,503,1130;36;F
43128;814,1534,1126,1390,840,1417,997,56,503,1130,1458,1094,14,1137,1115;36;F
43161;14;74;M
43177;514,1137,1458,952,637,312,1634,1190,123,840,962,970,1390,314,353;24;F
43182;814,123,1031,1513,309,312,1634,14,1126,503,1130,703,1094;38;F
43191;637,970,1115,1174,1417,840,1390,1648,1534,1190,1634,315,26,999,1641;20;M
43198;309,999,1513,1031,990,1648,1390,1348,1001,1417,56,503,1641,698,93;45;M
43210;814,797,883,1634,999,26,1031,1190,1534,1648,1455,1417,1641,314,93;44;M
43221;990,1097,518,1031,315,999,312,1634,883,14,1365,1215,1137,797,970;54;F
43241;1534,123,1031,309,93,1641,503,514,1215,14,883,26,678,637,636;32;F
43288;999,1031,14,1365,1097,1215,990,1390,503,1115;73;F
43323;823,315,309,26,999,678,1634,1031,1534,1648,636,1417,1641,314,93;37;M
43348;1417,309,315,1031,990,1641,314,970;48;F
43377;1097,503,703,314,93,812,1094,14,990,1648,997;67;F
43415;1137,1094,636;42;F
43446;1115,26,93,814,1031,123,1648,514,1634,990,1641,1534,1126,999;33;M
43453;840,1137,1130,93,637,636,26,315,1634,518,123,1126,797,1641,703;35;F
43477;1390,840,970,26,309,315,1031,785,14,1534,1126,1417,997,1641,1130;13;F
43480;1130,1137,514,309,678,1121,1215,990,1126,1455,503,1458,314,637,353;44;F
43482;1137,703,962,1094,636;10;F
43500;1031,785,14,1365,1097,1534,1648,1348,1417,56,1137,1458,1641,314,353;43;F
43517;883,1137,962,1094,636;7;F
43526;1641,1534,1031,883,990,1648,997,503;42;F
43545;1458,833,636;45;M
43597;309,1634,883,1031,785,990,811,1001,514,997,503;27;F
43600;710,734;45;F
43611;309,1513,883,518,1190,1215,1534,1648,1126,1390,1455,840,1001,514;22;M
43614;1031,785,1390,514,503,1641;19;M
43634;1634,1121,883,785,14,1365,811,1534,1417,1394,1137,503,1130,1641,314;41;F
43649;999,309,26,1417,1634,1031,1190,785,1365,123,1534,1648,797,1641,1115;18;M
43651;1103,514,56,698;49;M
43668;1417,1455,1648,1534,1365,785,518,999,26,1634,1031,123,797,1641,1115;60;M
43669;883,1031,1121,990,1455,970,315,1641,514,1648,518,1634,26;50;M
43695;1137,1390,1648,1215,785,1634,315,883,1365,1534,1455,514,56,1641,952;31;F
43721;312,1634,883,14,814,1137,503,1130,636;39;F
43733;997,797,970,1115,1031,785,1365,1534,1648,1455,315,309,26,1417,1641;37;M
43744;1130,734,678,14,1097,1348,1417,1137,56,1641,703,698,314,1094,970;36;F
43763;1634,1365,990,503,1641,962,1115,315,14;40;F
43802;678,1115;37;F
43829;1634,785,14,1365,1115;45;M
43845;26,1031,1190,785,1534,1648,1126,1390,1455,1417,1174,703,1641,1115;53;F
43853;1513,883,14,1097,1390,1137,56,1130,1641,698;42;F
43883;999,26,1513,1365,1390,1648,840,1174,1641,93,990,123,1031,883,1634;38;M
43886;999,315,309,1634,1031,785,14,1534,1126,1455,1417,997,503,1641,1115;40;M
43890;990,811,1648,1390,1137,734,637,315,883,518,1001,514,503,703,952;38;F
43910;1634,1097,1103,1390,1455,1001,997,1394,503,1130,797,1641,962,703,952;24;F
43917;678;35;F
43923;26,1126,56,840,962,970,883,1190,1097,990,1534,1641,812,503,1130;51;F
43990;312,315,785,1097,1215,123,1103,1348,514,797,14,1641,962,1648,93;42;F
44041;785,1031,1121,1634,315,309,1513,514,1417,1137,56,1130,1641,314,636;49;F
44061;678;50;M
44073;999,309,315,1634,1031,785,1365,1648,1534,1417,56,1130,1174,1641,1115;53;M
44119;636,1031,309,1121,1513,883,1126,1348,1137,1458,1641,314,93;36;F
44123;678,1031,518,14,123,814,1648,1126,1348,514,997,1137,1634,883,703;33;F
44132;823,785,1126,1001,1137,1130,734,703,312,1121,1215,1348,514,56,962;46;M
44226;1031,123,814,812,26,1634,518,1190,1126,1455,840,56,1130,734,1641;32;F
44231;1513,123,1126,1348,1455,840,1137,56,503,1130,797,1641,314,93,1094;11;M
44324;123,997,703,1031,990,1534,1648,1126,1417,1641,26,309,315,1634,785;51;F
44342;1121,1097,1103,1137,1130,1115;46;F
44347;1634,990,1534,1417,1641;49;F
44358;1455,514,997,710,503,962,1641,952,93,314,812,970,1094,353,1115;14;M
44363;1215,785,309,999,26,315,1634,1031,990,1648,710,1174,1641,952,970;29;F
44365;678,309,315,518,14,811,1126,1417,1137,797,1641,962,314,1115,93;10;F
44419;997,1417,1126,1031,518,1001,514,503,1130,1641,703;39;F
44421;1215,1648,514,56,503,797,1641,93,812;47;F
44437;309,1634,785,123,990,1126,1390,1455,514,1417,56,1641,93,970,1115;25;F
44446;1215,814,314,637,312,26,1513,883,823,14,123,1390,840,1458,1641;38;F
44447;1648,1390,812,678,1634,833,1126,1417,997,1137,503,1641;45;F
44457;93;50;F
44469;26,797,997,999,309,1031,990,785,1648,1126,1455,1417,1641,703,970;73;F
44473;1097,1215,990,1648,1126,1455,1130,1641,1115,503,1417,840,518,1534,1174;28;M
44481;503,797,1641,812,93;35;M
44525;1513,315,26,518,1190,1648,1455,840,1417,1137,56,503,1641,93,970;65;M
44533;698;48;F
44552;1634,1365,14;41;F
44556;56,503,1130;45;F
44572;518,315,814,1130,1137,1215,833,14,785,883,1648,1348,1001,514,1417;45;F
44586;26,309,1634,1513,823,518,1190,1126,1348,840,997,1137,1641;40;F
44587;1513,1394;43;F
44602;678;45;F
44616;518,1190,1097,833,1455,514,1137,1130,1641,962,970;42;M
44631;14;32;M
44636;56,1390,123,1103,883,1513,1121,678,14,1097,1137,503,1458,1094,637;42;F
44639;952,734,503,1348,811,1215,1097,14,785,1190,883,312,678,823,518;47;F
44651;14,785,1190,1031,309,26,999,315,823,1348,1455,997,1130,1641,314;45;F
44670;1513,812,970,637,636;42;F
44675;1513,1394;13;M
44679;514,997,636,123,734,952,1115,1634,883,518,14,1365,1097,1137,503;60;F
44715;1513,1394;7;F
44734;1513,1394;82;F
44742;1634,1534,1417,970,1641,309,990,93,1031,1648;50;M
44744;883,785,1365,1215,990,1390,1455,1417,1137,503,1130,1641,952,970,1115;19;F
44762;1534,14,1513,1634,315,1137,1641,314,970,678,1348,503,703,353;46;F
44767;1390,990,1365,14,785,518,1031,1634,999,1417,1130,797,1641,962,970;43;F
44783;1130,312,785,1534,1648,1126,1001,1417,997,1641;48;F
44789;123,1365,518,1513,309,26,315,1634,1031,785,990,1390,840,1641,970;31;F
44835;123,1001,698,1641,1130,503,997,1455,1534,990,1103,833,785,1031,1634;39;F
44840;1458,1031,1648,812;40;M
44845;14,785,1190,1031,814,1348,514,997,710,1137,56,503,1174,1641,1634;38;F
44855;93,1115;37;M
44859;309,840,698,1115,26,1031,785,1365,990,1534,1648,1455,1174,1641,970;48;M
44862;309,315,1648,1126,997,1641,1634,1513,1190,14,814,1390,1137,503,314;72;F
44894;823,518,1190,785,14,990,1534,1648,1126,1455,514,503,1641,314,1115;21;F
44914;1634,1115,1121,883,1031,56,503,1130,1641;37;F
44921;678,1121,1513,518,14,1215,1390,514,1130,314;49;F
44924;1513,315,678,309,883,785,1097,811,1648,514,1417,710,503,1130,1641;25;F
44945;1513,1394;44;M
44971;1513,1394;40;F
44975;1126,1348,514,710,1130,970,636,1634,883,123,990,1534,1648,1641,93;40;F
44991;883,1031,1190,1097,1215,1103,1390,1001,514,1137,56,503,1130,962,314;20;F
45002;1634,93;35;M
45021;26,1634,1031,518,1190,1648,1534,1455,840,514,503,1641,703,970;52;F
45029;1641,312,1031,1534,1001,503,797,734,637,1513,1190,1215,1390,514,952;71;M
45037;703,999,315,1031,785,1365,990,1534,1648,1417,1130,1641,962,970,1115;41;F
45054;990,883,785,1215,811,1534,1648,1390,1001,514,1417,1137,1174,1641,1115;25;F
45062;883,811,637,309,315,785,1648,1001,514,1417,1641,698,970,1031,990;56;F
45064;1455,1001,990,14,1097,814,840,1137,503,797,703,812,970,353,636;46;F
45113;14,1348,1130,703,93;38;M
45114;1348,503,1130,797,93;34;M
45138;312,309,710,56,503,962,353,1121,1097,1103,990,1001,1137,1130,1115;44;F
45237;1455,1001,990,14,1097,814,840,1137,503,797,703,812,970,353,636;15;F
45246;811,514,56,503,703,1094,309,883,1097,990,1001;43;F
45260;1126,1455,970,353,1115,123,1031,1513,315,312,309,1634,883,1534,93;42;F
45275;14,1365,1215,814,990,1534,1648,1455,840,1417,1641,1031,1190,1126,1348;38;F
45288;26,1031,1190,14,1534,1648,1126,840,1641,812,1130,56,1121,503;48;M
45297;1513,14,833,56,1130,703,698,970,503,514,1215,1001;27;F
45304;353,93,1458,514,1001,14,678,1137,1394,503,698,314,636;37;F
45318;14;77;M
45325;1634,1126,1455,518,26;67;M
45337;637,309,999,1365,833,1215,811,514,1513,14,1390,1137,56,503,1130;46;F
45343;1190,785,14,1365,1215,1534,1455,1417,1137,1641,703,698,93,812,636;9;F
45347;785,990,1390,514,703,698,353;39;F
45373;315,14,883,1031,1097,811,1137,503,1458,703,314,812,1094,970,636;43;F
45374;312,309,1121,1097,1103,990,1001,710,1137,56,503,1130,962,353,1115;12;M
45377;990,14,1097,814,1001,1455,840,1137,503,797,703,812,970,353,636;9;M
45399;1417,353,636,309,315,1031,1097,1648,1390,1455,999,785,990,1458,1641;44;F
45420;1634,883,1031,1190,785,1097,1534,514,1417,56,1130,797,1641,703,314;32;F
45451;703,314,1094,1121,823,14,1097,1103,814,1348,56,503,1130,734,962;42;M
45479;785,1190,1031,1121,999,309,315,1634,811,997,503,1130,1641,703,970;74;F
45483;56,1130,353,1115,309,1455,1417,797,1641,1634,1031,123,1534,703,970;46;F
45506;26,883,1031,1648;27;F
45518;1455,1001,990,14,1097,814,840,1137,503,797,703,812,970,353,636;44;M
45533;1130,962,93,1634,1031,518,1365,14,123,1534,56,503,1641,636,1115;43;F
45540;315,1130,1137,1534,785,1031,883,1513,1634,678,93,1648,1417,1641,636;42;M
45543;1115;32;F
45551;1121,1634,315,309,26,999,312,1130,797,1641,962,93;41;F
45558;1641,812,123,518,1634,1121,1190,1455,1417,962,309,785,14,997,56;50;F
45581;518,999,26,309,315,883,1031,823,785,990,1534,1455,1417,1641,970;46;F
45599;14,883,1634,315,309,518,1097,1348,514,56,703,314,93;42;F
45616;514,1417,1137,1130,797,990,814,315,314,883,14,1648,1126,1641,93;42;M
45630;315,1634,883,1031,518,1534,93,1126,1348,1417,1458,314,636;46;M
45646;56,353,1390,1365,785,823,1031,315,1094,123,797,1634,1513,518,14;43;M
45669;1417,1455,1534,785,315,999,1648,1634;40;M
45685;315,309,26,312,999,1634,990,1348,1455,1417,1394,503,1641,962,970;32;M
45702;1001,353,123,1365,1641,962,1417,1534,785,1031,1455,970,315,26;25;F
45703;1513,1031,785,1534,1390,514,1417,997,1137,56,1130,1641,314,970,636;11;M
45712;883,1031,1365,785,1126,1390,1348,1001,514,56,503,1458,1641,962,353;35;F
45721;1534,1455,1417,1641,1115,999,309,1031,1190,990,1648,1126,840,997,970;37;M
45753;315,1513,883,1390,514,1417,997,1137,970,637,1126,990,1215,1634,93;28;M
45756;1097,1031,1121,315,999,26,309,785,14,1215,990,840,1417,997,1641;47;F
45764;997,1137,1097,1130,314,353,636,1634,883,518,123,990,1534,1417,1641;60;F
45769;123,1365,785,1190,823,315,312,1634,518,1348,1417,1174,962,93,812;46;F
45781;312,999,315,1634,1513,883,1031,14,1365,990,1126,1390,514,1137,1174;44;F
45782;1137,1126,1534,990,14,315,970,637,636,678,1634,1031,785,1648,1641;41;M
45813;678,26,1121,518,1190,1097,1126,840,56,1130,797,1641,703,93,970;60;M
45854;315,1348,785,1365,1126,1455,970,1115,26,1031,990,1534,1648,1417,1641;43;F
45874;1115,14;36;F
45879;315,1190,1126,1130,1115,678,999,1634,1513,997,14,1648,1455,1417,1641;39;F
45913;1634,1513,518,1215,123,797;35;M
45924;309,999,1115,970,962,1641,1417,997,1648,1534,123,1365,785,1031,1634;40;M
45926;1641,309,1634,1121,14,1365,1097,1103,1390,1130,1115;46;F
45972;1126,1648,1534,123,1634,1190,1365,1455,840,1137,797,1641,314;43;M
45987;999,1634,14,1365,56,503,1130;45;M
46003;1097,1634,14,1130;48;F
46021;678,883,1031,1137,1458,1641,698,353;32;F
46038;1190,1126,840,970,1115,312,1648,990,1641,812,703,1094,1097,1390,503;19;F
46115;1534,1190,1634,26,997,1648,1031,518,990,1455,840,1417,797,1641,970;73;M
46126;1137,1115;53;F
46151;315,309,999,1634,997,1031,1190,785,990,1534,1648,1126,1455,1417,1641;28;M
46175;309,315,1634,1031,785,14,1365,1648,1641,1115;43;M
46290;997,1130,1458,952,93,315,1634,1215,123,990,1648,1455,514,1137,1641;42;M
46309;678,123,703,1634,1513,883,1190,14,1390,514,1137,797;41;M
46313;26,1031,14,1365,990,1534,1648,1455,514,1417,56,503,1641,636,93;37;M
46314;1190,883,315,309,999,990,970,1641,1031,785,797,1534,1648,1455,1417;29;F
46315;93,1094,637,636,1455,1348,1534,990,678,26,315,1634,1031,1190,734;33;F
46320;785,1115,999,26,309,1031,990,1534,1648,1126,1455,840,1417,797,1641;73;M
46327;503,797,314,1634,1513,883,1001,14,1648,1126,1390,1348,1455,1137,93;42;F
46332;1634,14,1215,1137;41;F
46354;637;42;M
46393;123,1215,1031,1634,678,26,309,315,883,785,1126,514,1137,1458,1641;35;F
46419;785,1031,999,1513,1097,1126,1390,1348,1455,1001,1417,997,1137,1641,703;36;F
46424;636;36;F
46429;823,1031,1513,315,309,312,1634,518,14,514,503,1130,797,93,1115;45;M
46461;883,785,1365,1137;63;M
46465;1031,1634,315,678,1115;47;F
46510;1031,1365,1648,1455,1417,503,797,1641;32;M
46538;962,1215,883,1634;31;M
46546;833,1365,678,1634,883,1031,14,814,1648,1348,1137,56,503,1641,703;42;F
46561;1641,970,503,1126,1390,990,1215,785,883;60;F
46578;1130,314,636,1634,814,1137,503;34;F
46603;636;10;M
46608;1390,503,797,734;22;M
46615;636;5;F
46636;314,812,1365,14,814,1137,503,1641,703,1094,1115;41;F
46657;1174,1115,1126,999,26,309,315,1634,1031,785,1365,123,1534,840,1641;22;M
46682;1121,1513,1534,1390,1130,636;42;F
46717;309,26,1634,1031,785,1365,990,1534,1648,1126,1455,1417,1174,1641,1115;27;M
46741;26,1634,823,518,1190,123,1348,1417,1458,1115;55;M
46747;503,1534;46;F
46771;840,1455,814,883,1513,315,312,1031,785,1365,1215,503,734,1641,1534;42;F
46773;309,315,1031,785,1534,1455,1417,56,1641,970;33;M
46780;1126,518,1031,997,990,970,883;80;M
46844;1455,840,1417,997,797,1174,636,678,26,518,14,1137,1130,1641,314;33;F
46878;123,1634,518,1190,1126;19;M
46914;952,734,990,1648,1641,1137,883,518,1190,1215,123,1390,514,797,26;30;M
46918;314,636;40;F
46962;1634,883,833,514,1137,703,314,636;39;F
46978;678,999,26,309,315,1031,785,1365,990,1534,1648,1126,1417,1641,1115;29;F
46979;26,309,315,823,785,1365,1097,1534,1648,1455,840,1417,56,1130,962;47;F
46982;514,970,26,990,1126,1648,1417,997,315,1634,518,785,1641,353,1031;40;M
46988;883,636;8;M
47031;1031,1097,1390,1137,1130,1641,703;32;M
47085;883,678,312,1634,1121,1513,14,1097,1215,1390,503,1130,1174,970,637;31;F
47107;312,1648,1458,999,1031,1126,678,1634;35;M
47115;990,1190,93;41;F
47133;1001,840,1455,1390,1126,26,315,1634,883,1137,56,503,678;31;F
47166;1130,703,1513,1634,1001,999,26,1031,990,1534,1648,514,1417,1174,1641;42;F
47195;14,1648,636;41;M
47202;309,1634,1031,1648,1455,514,56,503,1130,1458,1174,1641,952,637,1115;31;F
47219;1634,1137,503,93;41;M
47232;1534,1126,503,1641,962;45;M
47262;1031,785,990,1348,1417,56,1458,970,315,14,1534,1126,1390,997,1641;29;F
47266;1365,990,1534,970,309,315,1031,1648,1126,1455,1001,514,1417,1174,1641;30;M
47274;1458,823,1097,990,1137;59;M
47277;636,637,93,314,1130,1137,1001,1390,1215,1097,883,312,1513,1634,678;44;F
47314;703;40;F
47332;1097,514,1137,56,503,1121,883,833;44;F
47342;1215,883,678,315,1634,811,1534,1648,1126,997,1137,703,698,1094;28;F
47360;1031,518,1365,1097,1126,997,503,970,962,703;55;F
47363;26,883,123,814,514,1641,93;36;M
47368;93,1115,1365,990,1534,1648,1126,1417,710,56,1174,1641,1634,1031,518;30;M
47377;785,678,1634,1031,14,1365,1534,1126,1137,56,503,1130,1174,1641,637;42;F
47379;503,1126,1534,518,1513,1121,315,309,999,1634,1031,14,1365,1648,1137;42;F
47396;1641,26,1634,1031,823,1190,14,123,1534,1348,1455,840,503,1115,93;9;M
47481;14,1365,1648,1126,1417,1137,56,503,1458,1641,1115;6;F
47503;309,315,1634,1513,883,1648,1126,1390,1455,514,997,1137,1641,93,1115;19;F
47538;315,309,678,1634,1365,990,1534,1126,1390,514,1137,14,1115;41;F
47551;814,1365,1634,309,1121,1513,1031,518,14,1126,1390,1417,1137,1641,1094;37;M
47560;1130,14;50;F
47586;1215,823,883,1634,315,26,1513,1190,1534,1390,840,514,1137,1641,636;34;F
47608;312,1137,1001,814,1103,1215,1097,14,518,1634,1121,883,1348,56,1130;39;F
47613;1641,1130,503,56,1348,1126,1031,999,678,309,315,1634,1417,710,1174;47;M
47634;811,1513,999,123,990,1534,1455,503,1130,812,1634,1190,1137,1641,703;68;F
47647;56,1137,1417,1455,1126,1648,814,833,1097,1031,883,1121,1634,315,1115;52;F
47648;990,1365,785,1031,315,26,999,1534,1648,970,1634,123,1417,1641,353;39;M
47656;1001,1417,997,93,1094,637,312,315,1634,1190,14,1137,503,1130,1641;47;F
47668;1130,1641,970,353,309,1031,518,14,1417,56,503,962,93,812,1094;33;F
47686;1634,811,997,503,1458,703;63;F
47709;990,1534,1126,1455,1130,797,1641,703,698,314,812,1094,970,637,678;44;F
47727;1365,883,1215,26,1513,1031,1190,123,1648,1126,1390,1348,1455,1417,1641;15;M
47731;1031,990,636;45;M
47802;1137,1455,1534,990,14,999,309,315,1634,1031,1365,1417,997,1130,56;44;F
47807;514,1126,883,312,1513,14,1215,814,1390,1001,997,1137,503,1458,314;40;F
47813;1534,1648,1390,1348,1455,1417,1458,93,678,26,883,1031,518,1126,1641;36;F
47850;26,315,309,678,1458,999,1031,1365,1648,1534,990,1417,1641,970,1115;38;F
47871;990,1126,1390,514,1417,56,503,1130,1458,734,1641,962,93,970,1115;24;F
47876;703,999,1103,797,962,26,518,1190,1097,1126,1001,514,56,1130,1641;67;F
47894;1348,1534,1215,1634,315,309,999,312,503,1641,26,1031,1190,1126,1417;42;M
47896;678,1634,1031,823,990,1534,1648,1126,1348,1455,1137,56,1458,1641;41;M
47897;1641,997,315,353,1115,309,999,1634,1031,123,1648,990,1534,970;44;M
47926;883,14,1534,1126,1348,1455,1641,952;40;M
47930;797,962,1641,56,1417,1455,1126,990,785,1190,518,1031,315,26,999;81;M
47993;1455,1634,1031,990,1534,1417,1137,1641,314,970;74;M
48000;990,1455,962,970,26,1634,1031,1190,1534,1126,840,1417,997,1641,1115;27;M
48007;1648,1126,1634,999,678;46;F
48012;1215,1126,1390,503,314,812,997,1130,1115,309,315,1031,1348,1458,1174;36;F
48017;353,123,518,315,26,1641,1634;18;M
48050;999,315,1634,1031,1190,785,990,1534,1126,1455,840,710,1641,962,970;29;F
48064;1137,1641,811,1031,999,26,309,315,1634,785,14,990,1126,1417,797;35;M
48075;1417,797,1174,1641,312,1634,123,1137,503,636;43;M
48080;785,999,1031,1365,990,1534,1648,1126,1455,1417,1130,1641,703,698,970;40;F
48105;1634,1031,833,1215,840,514,997,1641,703,952,637;47;F
48141;678,883,1190,785,1215,1648,1126,1348,840,514,1137,503,1130,1641,952;38;F
48158;997,1417,309,823,518,785,1348,1455,1458;44;M
48160;26,1634,1031,1190,14,123,1534,1648,1455,514,1417,1137,1641,314,637;44;M
48184;678,315,883,1097,1390,1455,1001,514,997,1641,970;48;F
48214;1641,1130,1137,514,1126,990,785,1031,315,309,678,312,1634,1348,93;40;F
48251;1190,1534,1455,514,1641;45;M
48347;315,312,1634,883,1031,1365,14,1215,1126,1534,811,503,1641,703,1115;46;F
48390;14,1365,1215,814,1001,514,1417,1137,1394,503,1641,812,1094,637,1115;42;F
48412;678,1634,1121,1190,14,123,1455,56,503,1130,93;47;F
48436;1634,1031,811,1534,1648,1126,1348,970,1115,14,123,1417,56,1641,703;41;F
48463;315,1634,1365,1534,1648,1641,703,970,1094;43;F
48479;518,1031,14,1534,1097,970,636;41;F
48491;812,811,814;46;M
48497;1390,1513,315,309,999,678,1634,14,811,1648,1126,734,1641,703,952;33;F
48502;1190,14,1365,1390,1115,997,1130;24;F
48508;93,636,1130,883,823,814,514,1137,56,637,1115,1513,14,1390,997;48;F
48514;518,823,1031,1513,1634,26,1126,1348,1130,952,93;30;M
48575;93;24;M
48677;1115,1534,1031,309,678,315,883,785,1365,990,962,970;41;F
48707;1641,785,518,1634,823,14,1365,123,1348,1417,353,1115;49;M
48718;1115,785,1190,1031,883,309,315,14,1365,1215,1534,503,1641,314,637;41;F
48725;26,315,999,309,518,785,123,1126,1455,840,1417,997,56,797,1641;44;M
48748;309,315,1634,1031,785,1365,990,1534,1648,1455,1417,1130,1641,970,1115;45;F
48750;1634,678,514,56,503,797,1641,962;27;F
48772;1365,814,1348,1001,1417,56,1394,1130,1458,1641,312,1634,1215,1137,14;44;F
48827;1648,1534,518,1634,785,14,1365,1097,1390,1455,1001,1641,952,93,636;31;F
48842;678,309,1634,1121,785,14,1365,1097,1534,1417,56,1130,93,353,1115;41;F
48847;999,309,1031,785,1648,514,1417,970,315,811,1126,1641,962,703,952;38;F
48870;734,1126,1648,1534,990,785,1121,1634,315,309,678,999,14,1365,56;36;M
48895;14;38;M
48921;999,26,1513,883,1031,518,990,1648,1126,1455,997,797,1641,312,1634;39;M
48983;93;15;M
49018;1365,1190,1031,883,1513,1394,1130,797,1641,962,970,637,315,14,990;22;F
49028;785,26,1190,14,1115;42;M
49045;734,1455,1534,785,999,1634,883,1390,1513,1115,990,1365,14,1031,315;28;M
49091;309,1031,823,1455,1094,797,1130,503,1137,1348,1126,123,1634,678;37;F
49171;315,1031,785,14,1365,123,1534,1648;47;F
49192;1094,636,1115,93,1641,503,1417,1126,1648,814,123,1365,14,1031,1634;44;M
49208;1115,970,93,952,734,1534,1365,785,1031,883,1513,309,1417,1641,962;39;F
49266;14,1097;50;M
49271;999,315,1031,518,990,1534,1126,1417,710,1641,970;71;M
49293;309,1634,823,518,14;43;M
49310;1390,785,1513,315,309,1634,883,518,14,1348,1137,503,1130,1458;69;F
49314;14,1534,1130,1458,1174,314,1094,636,1513,883,514,710,503,698,637;32;F
49357;1534,1648,999,26,315,883,1031,785,1641,1126,1390,1417,637,970,636;38;M
49482;678,309,1634,1031,518,785,14,990,1390,1137,503,1130,1458,353;77;M
49487;26,309,315,1031,1365,785,990,1534,1648,1455,1417,1174,1641,1115,970;45;M
49506;309,785,1097,710,503,1174,1641,703;32;F
49541;309,315,797,56,1126,123,1215,1031,1513,1634,990,1534,1648,1417,1641;50;M
49562;309,26,1634,315,1031,785,1365,990,1534,1648,1455,1417,1641,970;38;M
49563;970,1126,123,315,1634,1031,518,785,990,1390,1455,1417,997,56,1641;66;F
49575;999,309,315,1031,785,1365,990,1534,1648,1126,1390,1417,1641,314,970;71;F
49583;1634,1513,823,14,1365,1215,1126,1390,1348,514,1130;38;M
49601;710,734,1174,703;37;F
49631;309,1121,1365,1097,1126,1634,883,1190,14,1455,840,1137,1641,1031;36;F
49642;26,309,883,1031,518,1190,785,1126,1390,1455,1001,514,1417,1137,1641;32;M
49706;840,503,999,26,309,315,1190,785,811,1534,1648,1417,997,1641,962;32;M
49708;26,309,315,1634,1031,823,518,123,990,1534,1641;58;M
49772;503,518,734,703;31;F
49786;26,518,14,785,811,1534,1648,1455,1417,1137,503,1641,1634,123,636;41;F
49802;1031,785,518,883,1634,1097,990,1648,1455,1641;50;F
49807;14;32;F
49810;1641,312,1634,883,833,1215,814,1001,514,1137,56,503,1130,703,314;45;F
49856;1634,1641,1174;33;M
49869;1513,1031,997,1137,1130,503,1097,785,1390,797,734,637,883,1641,1634;52;F
49887;1126,1455,997,1458,1094,970,678,315,990,1534,1348,1417,1641,703,314;61;F
49937;1648,26,315,1031,990,1417,309,785,1365,1534,1126,1455,1641,970,1115;66;F
49941;990,1534,1648,1455,840,1641,970;75;M
49992;1390,514,710,1130,970,1634,785,1097,811,1534,1417,997,503,1641,703;36;M
49993;1126,1130,1641,1094,353,1634,1031,1534,1390;44;F
49996;514,990,309,315,1031,785,1365,1126,1417,503,703,1115,797,1641,970;31;F
50019;1513,1126,997,1641,703,970,315,1634,1190,785,123,1390,840,514,56;27;F
50027;990,1534,1648,1390,1137,637;45;F
50033;1513,823,518,785,833,990,811,1130,1641,962,952,698,314,970,353;48;F
50060;503,1648,785,1031,678,1115;65;F
50062;703,999,26,1190,123,1534,1648,1455,840,997,698,1634,1126,1390,1641;31;F
50111;309,518,1365,814,1348,503,797,1174,93,353,123,1634,1126,1455,1641;16;M
50129;1641,93,1094,636,678,1097,123,811,503,797,734,703,952;33;F
50187;26,833,823,883,1513,678,999,315,518,1455,514,314,637,353,1115;45;F
50191;999,785,990,1130,1634,1097,1103,1126,1641;33;F
50193;1513,883,1097,1390,840,309,1634,14,123,1031,1126,503,1641,703,636;65;F
50194;1634,1121,518,14,1137,503;71;F
50237;1190,990,1648,1390,1455,997,1641,703,970;62;F
50248;785,999,678,1513,883,1031,315,1634,1390,636,1648,1126,1137,1641,314;50;F
50284;734,970,637,678,1634,1513,990,1534,1390,1001,1417,1137,503,1641,703;39;M
50413;315,883,1031,833,990,811,1534,1126,56,1094;49;F
50439;883,1031,1001,1417,1641,703,1094;38;F
50457;1534,990,1031,1513,309,26,1634,518,1190,123,1455,840,797,1174,1641;46;M
50474;1634,1121,1031,1190,14,1097,514,1417,56,503,1130,1641,962,353,1115;25;M
50477;26,1417,840,811,1190,518,1121,514,1137,56,1130,797,1458,703,812;22;F
50504;1634,1031,1097,833,123,990,1390,997,503,797,1641,703,1115,970;53;F
50633;636,1417,56,797,314,518,1634,26,1097,123;52;F
50634;1455,1031,309,1190,26,315,1634,785,990,1648,1126,1390,840,1417,797;20;M
50636;823,93,1534,990,785,26,309,315,1634,1190,1455,840,997,1641,970;45;F
50654;1348,14,1121,315,678,503,1641,637;47;F
50733;1031,1365,1534,1455,1641;31;M
50782;999,26,309,315,1634,1031,518,785,123,1648,1126,840,1641,93,970;54;F
50812;997,1137,503,970,1126,1534,811,785,678,990,514,1417,56,1130,1641;28;F
50879;1126,514,997,636,678,309,883,785,1097,1534,1648,1137,1130,1641,1115;33;M
50894;1634,1513,883,1031,823,1190,785,1097,314,1126,1390,1641;24;F
50898;678,1634,123,1648,1126,1390,1455,1417,797,734,1174,1641,703,952,970;31;M
50942;93,353,1648,1534,1365,785,1031,883,1121,315,1115;50;F
50980;26,1634,123,1648,1126,1390,1455,840,710,797,734,1174,1641,952,970;31;F
50985;1648,1455,840,514,1417,1137,503,1130,734,1174,1641,952,93,812,636;30;F
51056;1097,1174;37;F
51066;514,1215,1634,123,823,1348,26,309,1031,785,990,1534,1648,1641,1115;65;M
51233;1641,93,970,637,514,1634,14,710,503,797,734,1174,952,1115,703;65;F
51251;1513,1634,1534,1126,1390,1348,1455,514,1137,1458,503,734,1641,703,353;38;F
51288;309,883,990,1390,503;73;F
51337;1390,1137,1115,999,883,1097,56,1130,1121,14,514,503,703,1174,1094;19;F
51368;678,315,883,1031,1215,990,1534,1648,1126,1390,514,797,1174,952,970;23;F
51379;1458,710,1365,785,1634,315,1031,1215,1534,1648,1455,514,1417,1641,1115;24;M
51418;1001,840,26,309,315,990,1455,999,1534,1634,785,1641;37;M
51451;710,1174,785,1031,990,1534,970,1126,1417;73;F
51467;1121,1513,883,1031,14,1097,1534,1390,1137,56,503,1130,1458,1174,1094;50;F
51474;999,26,315,309,1031,518,785,990,1534,1648,1417,56,703,1641,970;40;F
51485;309,26,999,1031,785,14,123,990,1534,1648,1126,1455,1417,503,1641;37;M
51554;1190,14,990,1648,1455,840,514,1137,503,797,1174,1641,812,970,1115;39;M
51573;315,1513,1031,1365,990,1648,1390,1348,503,797,1641,698,970,637,1115;35;M
51581;1513,1190,1390,1348,1455,840,797,1174,1094,636,1634,1534,1126,1641,1115;33;F
51582;883,1634,1458,1641,314,1094,970,636,1130,678,14,1348,514,1137,56;35;F
51621;1126,797,1417,1534,811,14,518,309,312,1634,997,503,353,952;37;M
51627;1390,883,1634,811,1513,1365,1215,1534,1648,1455,514,1417,1137,1130,1641;44;F
51631;14,811,1648,1534,970,1641,797,997,1455,1126,1031,315,309,1001;38;M
51662;1417,93,636,678,1634,1031,123,1648,1126,514,1137,314,637,1115;34;F
51663;1455,840,1001,514,997,999,26,309,315,1365,710,503,1174,1641,1115;32;F
51690;1001,503,1130,1641,962,703,970,514,811,1097;27;F
51716;883,1648,514,1417,1634,1031,14,1126,1348,1137,1394,1641,314,812,1115;39;F
51722;678,785,14,833,1417,503,1458,1094;48;F
51778;1634,14,1365,997,56,503,1130;50;F
51816;883,1115;25;F
51834;678,1513,785,14,1215,1001,514,997,1137,503,734,703,952,314,353;30;F
51844;797,1365,785,1417,353,1641,1174,840,1455,1390,1534,123,1190,1634;40;M
51886;785,1513,823,123,1126,797,1458,1641,314,1634,883,518,14,1390,1137;38;F
51921;1097,1417,1458,970,703,1641,797,56,997,1455,1126,1648,990,123,1634;69;F
51957;840,1001,514,1417,1137,314,970,883,518,1190,785,997,797,962,353;12;F
51982;315,1634,785,1365,514,710,1174,1115;39;F
51992;636,678,883,785,1097,514,997,503,1458,962;73;F
51995;1634,1121,1513,883,14,1126,1390,1348,56,1130,1174,962,703,952,314;33;F
52006;518,1137,314,1634,1097,503,1534;37;M
52050;1417,797,1215,811,1001,514,56,503,1130,1641,703,314,812,637,353;28;F
52079;1513,883,1190,785,990,1534,1648,1126,1390,1455,1417,1394,797,1641,1115;38;F
52087;1130,734,962,952,314,1137,1455,1348,1390,1126,14,883,1513,315,678;3;M
52105;309,315,1634,1031,785,14,1365,1534,1648,1390,1455,840,1641,970,1115;45;F
52124;1031,1534,1417,1641,93,636,785,1634,14,990;36;M
52139;1031,999,309,315,1634,1534,1455,56,503,1641;50;F
52160;93;10;M
52164;1641,26,990,1648,1390,999,309,315,1031,785,1365,1534,1417,970,1115;45;F
52165;93;7;M
52172;93;42;M
52207;1031,785,1190,1634,14,1365,1097,123,1534,1648,1126,997,56,797,1641;39;M
52216;883,312,1121,823,518,1190,990,1390,514,1115,56,1130,1641,962,698;18;F
52239;1455,1348,1126,1534,990,123,833,315,26,1634,1513,823,518,1648,56;49;M
52243;1126,26,1634,1031,990,1534,1648,1455,1417,997,797,1641,703,952,970;72;M
52257;883,785,1215,1648,1126,1390,1455,840,514,997,1137,56,503,1458,1641;31;M
52382;1534,1215,315,26,1190,990,1126,1001,840,1417,1137,1458,1641,1094,970;41;F
52390;14;44;M
52468;1031,990,1534,1348,1455,1417,1137,1634,883,970,1641,785,1365,1215,1648;35;F
52473;1417,997,797,1641,970,315,309,26,999,1634,1031,518,1365,1534,1115;28;M
52512;999,1031,1455,1115,1634,785,1365,1534,1648,1417,997,1641,970;44;M
52526;1648,1455,1641,1534,1031,883;46;M
52529;823,14,1137,503;31;F
52564;1126,1534,123,1215,1634,14;36;F
52571;999,309,315,1634,1031,1190,785,123,1534,1648,1455,1417,797,1641,1115;44;F
52578;678,315,883,1190,1097,1215,814,997,503,797,1641,314;38;F
52602;14;30;M
52626;1641,1130,1365,1513,312,1634,814,1534,1348,1137,503,1458,703,952,353;40;F
52644;1534,1641,1121,678,1190,1126,840,1455,503;45;F
52662;1137,56,503;51;M
52669;1190,315,1513,883,14,1390,1001,514,1137,503,1174,1641,314,637;28;F
52681;1031,785,811,1534,1648,1348,1455,514,1417,997,1130,1641,703,314,1094;41;M
52683;1130,797,353,1115,1126,1174,990,814,123,315,309,678,14,1365,1648;47;M
52719;1513,514,1115,1641,56,997,1390,315,1634,883,1031,990,1534,1126,1417;49;F
52729;14;45;F
52734;997,1130,503,93,1634,1031,14,1365,1097,1126,840,1417,1641,962,1115;20;F
52736;309,315,1634,883,1031,123,514,1648,1455,1417,503,1130,797,636,970;66;F
52744;710,518,353,56,1130,1031,1126,997,883;63;M
52775;883,1097,56,1641,1513,14,1365,1215,990,1648,1390,997,970,637,1115;44;F
52781;637,503,883,1513,14,1390,1137,1641;31;M
52820;1190,785,1365,123,990,1534,1648,1455,840,1417,503,797,1641,93,637;38;M
52821;1634,1031,123,1126,840,514,1137,56,503,797,1641,637,636,883,678;33;M
52873;1634,883,1031,785,1097,123,1534,1648,1126,503,1130,1458,1641,703,1115;53;F
52881;637,636,309,26,999,315,1031,1190,785,1365,1417,997,503,1641,1115;27;F
52893;353,1215,1634,970,999,1174,1534,710,1365;9;M
52931;999,26,309,315,518,785,1534,1648,1126,1348,1455,1417,503,1641,970;69;F
52938;952,883,1031,514;42;F
52970;990,811,1534,1648,1126,1390,1137,1417,56,1130,503,1641,703,812,970;47;F
53014;1130,797,970,503,997,833,785,518,309,26,315,1001,514,1417;62;F
53017;997,990,309,315,1534,1648,1390,1455,1001,514,503,1130,797,703;62;F
53046;1634,518,1648,503,797,1458,636;72;M
53054;1031,785,1097,123,990,1534,1648,1126,1455,1417,997,1130,797,1641,970;49;M
53085;309,678,26,315,1634,785,1097,990,1534,1455,1641;45;F
53105;312,518,503,1648,797,1458,636;71;F
53131;797,1130,703,314,812,970,353,1031,785,811,1126,1001,514,1641,637;46;F
53163;883,14,1390,514,1137,503,678;43;F
53169;1031,1190,785,1648,1455,1417,970;35;M
53178;678;11;M
53185;503,1365,1648,1417,309,315,1634,1031,785,811,1534,1126,1455,997,1641;20;F
53204;1121,1031,785,14,1215,814,1126,1348,1001,514,1137,503,1130,812,637;17;M
53222;1215,14,883,1121,678,637,353;6;F
53234;1417,56,1458,1115,970,698,1641,1174,1130,503,1031,315,26,1190,785;31;F
53247;785,814,811,1126,353,1031,1215,1001,514,1137,1130,1641,314,812,637;15;M
53263;93,309,1534,26,315,1121,1031,123,1455,518,1190,1097,990,1126,840;60;F
53287;123,1348,1455,997,1641,309,26,999,1634,1190,785,14,1390,503,1174;45;M
53311;1634,309,26,999,315,1417,1031,990,1648,1534,1126,1390,997,1641,1115;18;F
53312;678,309,315,1634,883,823,785,814,990,1348,970;7;M
53328;1365,997,1115,312,999,309,315,785,1534,1390,1417,797,1174,1641,970;70;F
53348;990,1534,1648,840,1455,1137,637,315,1634,883,1031,1215,514,1641,952;22;F
53352;1648,1641,1534,1417,1513,1390,1126,1031,970,883,797,785,636,309,26;44;F
53361;309,26,999,1190,785,1534,1648,1455,840,1417,1130,797,1174,1641,1115;57;M
53367;14,123,1648,309,1634,1513,1126,1390,1348,56,1031,1130,1641,703,812;47;F
53390;1390,1126,1648,785,1190,518,1031,883,1513,315,1534;24;M
53391;315,1634,1031,1126,26,785,1365,123,990,1534,1648,1417,1641,970,1115;40;F
53414;883,315,1031,990,1534,1126,1455,514,1417,1137,1641,698,812,970,636;70;F
53455;811,833,785,1031,1634,678,1190,997,503,1130,734,1641,962,703,1094;30;F
53487;999,1365,990,1648,1455,1417,997,315,1031,785,1534,1390,503,1641,703;63;F
53506;637,26,315,1031,785,990,1534,1126,1455,514,1417,1137,1641,812,970;76;M
53553;637,514,1001,785,883,315,26,1031,990,1534,1126,1455,1417,1137,970;34;F
53626;309,1634,1031,785,1365,1534,1348,1001,514,1417,503,1130,1641,703,970;39;F
53638;56,1130,999,26,1634,785,990,1126,1534,1648,1455,1417,1641,970,353;34;M
53659;814,56,503;46;F
53660;309,315,1634,14,1365,811,1534,1648,1126,1455,514,1417,503,1641,1115;21;F
53795;309,315,1634,1121,883,1031,823,518,1190,1365,14,1001,514,503,1641;48;F
53808;503,56,962;8;M
53879;785,1031,26,309,315,1634,1097,1648,1126,840,503,797,1174,1641,703;56;F
53896;1634,1031,14,1097,833,1103,811,1390,1348,1001,1417,1137,1130,1641,703;45;F
53898;1648,1126,962,514,353;45;F
53928;999,1634,1031,1648,1534,1455,1641;52;M
53938;518,1390,823,1513,1634,678,309,883,1190,990,1648,514,997,637,1115;67;F
53942;503,1534,314,1126,1634,883,1190,840,353,123,1348,1455,997;44;M
53949;1031,309,315,883,990,811,1648,1455,1417,1137,314,703,1641,797,503;67;F
54027;1126,1417,1458,1641,1115,1634,1513,1097,1103,1534,1390,997,710,1130,1174;47;F
54033;26,315,785,833,811,1455,1001,1417,997,1130,797,1641,703,698,1094;55;F
54045;26,309,1121,1031,1097,1648,1455,1417,56,1130,1641;43;F
54048;1390,997;27;F
54059;678,1126,1390,1365,315,26,1031,518,1455,1417,1641,1115;57;F
54060;14,1121,309,999,1455,997,1417,1130,797,1641,1648,1534,1215,1458,312;44;M
54157;833,315,1031,1455,1417,678,1534,990,1648,797,1634,1641,812;45;F
54164;1417,26,309,1634,123,1534,1126,1641;37;M
54176;999,309,1390,997,1458,1641,93,636,1634,990,811,1126,1417,1130,703;28;F
54183;1126,990,1031,309,315,1121,1513,1365,1097,1215,1103,1534,1455,1130,1115;19;F
54193;26,1634,1513,1031,785,1215,1534,1648,1126,1390,1455,1417,997,56,1641;43;F
54269;314,1458,1130,14;40;F
54292;812,1634,14,1001,514;43;F
54299;93,1641,1458,997,1417,840,990,14,309,678,1634,518,1190,1126,636;41;F
54308;883,518,999,26,309,1031,990,1534,1648,1455,1417,1641,314,970,1115;47;F
54311;14,990,1534,1390,1455,840,514,1137,503,1130,797,734,1641,703,93;76;F
54319;999,26,309,315,1190,785,990,1348,503,962,812,1115;21;M
54321;309,1513,990,797,970,1634,123;48;M
54343;785,1390,1001,503,1130,1458,1641,703,970,26,309,1455,514,840,997;22;F
54434;1458,56,1137,312,503,797,678;40;F
54450;1513,1641;24;M
54500;999,315,1634,1031,785,1648,514,1417,997,503,1130,1641;62;F
54501;678,999,315,1634,1031,518,785,1648,514,1417,997,56,503,1130,1641;38;M
54515;14,503;47;F
54536;1513,1534;31;F
54556;883;71;M
54564;309,1137,56,970,315,1121,1513,883,1097,1103,1390,1001,503,1130,703;46;F
54570;26,999,309,315,1634,1031,518,1365,990,1534,1417,503,1641,1115,970;60;F
54580;999,26,309,315,1634,1031,785,1365,123,990,1534,1648,1455,1417,1641;44;M
54581;1634,1031,1365,1648,1126,1390,840,1641,93,812,970,353,1115,1394,1513;33;M
54599;678,309,315,1121,14,1097,833,1103,811,1394,503,1130,1458,314,1094;18;F
54600;1634,123,1126,1348,503,797,1458,962,314,93;41;M
54603;1513,26,309,315,1634,1031,1190,785,1534,1126,1390,1455,840,1417,1641;34;F
54636;1215,1097,1190,1031,883,1513,1121,1634,315,309,678,636,970,1130,93;42;M
54681;1031,1126,1455,1001,1513,315,678,1534,1648,1390,1417,1137,1394,1641,636;37;F
54698;514,1174,1115,1417,1534,999,309,315,1031,1390,1455,503,734,1641,962;25;F
54701;1121,678,1534,1648,1390,1455,1137,56,1394,503,1130,734,636,1115,93;5;F
54703;1365,1031,1513,1634,1534,1648,1126,1390,1348,1455,1174,1641,353,1115,812;18;M
54714;518,14;61;M
54722;518,1031,883,309,999,678,1634,14,1365,1097,1137,503,1130,1641,93;35;F
54791;1634,315,1455,999,26,309,1031,785,1365,1534,1648,1417,1641,970,1115;23;M
54799;1174,990,315,1634,123,26,1031,1455,1534,785,1365,1648,1126,1417,1641;53;M
54829;1634,1641,123,990;42;F
54941;14,1365,1634,309,999,312,1641,952,314,93,636,678,785,1390,503;35;F
54984;1513,1174,785,1648,1031,990,1641,1365,1115,1534,1458,883,970,1126,999;38;F
54997;312,1634,1513,823,518,1190,1097,1126,1348,797,314;39;F
55010;1031,785,1365,990,1534,1648,1126,1455,1417,503,797,1174,1641,970,1115;17;F
55015;56,1130,1001,1455,123,518,883,1121,1190,1348,1634,823,26,703,314;47;F
55029;970,1417,1455,1534,823,1031,309,999,312,315,1634,1513,14,1390,1641;50;F
55056;315,1513,883,1031,814,811,1390,1001,514,1137,503,1641,703,952,637;39;F
55076;1513,1365,1390,1130,93,970,1115;23;M
55077;1390,1534,1126,26,1513,1190,1348,840,503,314;72;F
55119;309,315,678,883,1634,1031,823,518,123,990,710,1174,962,93,637;23;M
55120;312,823,1348,1417,314,1031;38;M
55133;1513,678,309,315,1634,833,990,1648,1390,1455,840,1137,797,703,970;66;F
55156;1190,1641,962,970,315,990,811,1534,1001,514,703;45;F
55170;315,1031,990,1126,1641,678,785,123,1534,1648,1390,1455,1417,997,797;47;M
55172;1126;44;F
55185;1458,123,833,1190,1031,1634,678,883,14,814,514,503,93,637,636;32;F
55191;26,1126,315,518,785,990,1534,1648,1390,1455,1417,997,797,1641,970;70;F
55195;1190,518,678,309,315,1634,1390,1348,883,1031,823,1115,1097,123,1126;74;F
55199;1094,26,1634,1121,785,1126,1137,678,883,840,56,503,698,314,637;46;F
55200;312,1634,1513,883,1215,814,1390,1001,514,1137,952,314,93,637,636;38;F
55204;309,678,26,315,883,1031,1534,785,1126,1417,970,1115;39;F
55239;1648,1365,518,1031,883,999,309,315,990,1534,1126,1641,952,970,1115;61;F
55242;1634,1031,123,1648,1126,840,1455,1641;42;M
55330;309,93,1031,1634,637,518,990,1348,1455;66;M
55340;990,1455,1417,1641,703,970,1115;85;M
55348;1634,1121,56,14;43;M
55349;997,883,1115;14;M
55391;1648,1641,997,1137,1458,703,812,123,1190,840,26,1634,990,1126,1390;34;M
55393;1190,14,1215,997,503,1130,1641,962,93,1094,1115;23;M
55395;93,1126,1417,1130,309,315,1648,1348,997,797,1641;22;F
55413;997,797,1174,812,637,1115,1534,1648,1455,1001,514,56,503,703,93;55;F
55433;823,1190,785,1097,14,1534,1348,1455,1641,703,1094,1115,518,56,503;43;F
55445;315,1031,785,990,1534,1648,1390,1455,997,56,503,1641,703,314,970;46;F
55477;812;18;F
55486;518,990,999,785,1534,1648,1126,1455,962,309,315,1031,1417,1641,970;53;F
55490;1130,797,962,698,970,353,1348,1103,883,678,309,1190,1097,1648,93;45;F
55556;312,999,315,1121,1031,785,1097,814,990,1390,1137,56,503,1458,1641;47;F
55557;1137,503,1458,1094,637;39;F
55599;503,1097;8;F
55633;1031,999,315,1634,823,518,1190,797,1641,1115,785,1417,997,962,970;45;F
55702;1121,1031,1190,785,123,1534,1648,1126,514,56,1130,797,1641,962,353;44;F
55732;883,315,309,26,999,785,1365,1534,1126,1455,514,1417,710,1174,1641;46;F
55737;1031,785,1365,990,1648,1390,1455,1417,1137,734,1174,1641,970,1534,1115;31;F
55741;990,503,970,883,14;68;F
55787;93,840,1634,14;61;F
55805;1365,1634,1190,123,990,1126,840,514,997,56,1130,797,1174,1641,970;35;M
55825;518,990,1648,997,503,1641;78;F
55838;999,315,1534,309,1634,1031,1190,1648,1417,503,1641,962,93,812,353;48;F
55880;1115,312,678,883,1031,785,990,514,710,997,1634,1365,123,1534,1174;26;M
55915;1634,1513,1126,1348,1458,883,1641,1115;47;F
55932;309,315,785,1648,1455,1417,1641,970;34;M
55983;14,1365,1137,503,1130;37;M
56011;1417,309,1031,785,990,1534,1455,797,703,970,1115,1641,514,1001,811;48;F
56024;14;45;M
56031;56,1648,1121,309,315,1634,518,785,1097,833,1137,1130,703,314,1094;52;F
56033;990,1417,1115,999,1031,518,14,1365;38;F
56034;1215,833,883,1634,518,123,1648,1126,1390,997,1137,1130,1641,703,353;51;F
56041;1137,514,823,883,14,703;67;F
56051;1190,785,990,811,1126,1001,56,698,970,636,1121,883,997,1130,93;37;F
56052;309,315,1634,1097,990,1455,514,503,703,314,970;53;F
56054;1534,1648,1126,840,1417,710,1174,1641,1115,353,970,1455,123,1634,785;37;M
56066;1121,1031,1097,814,1130,1458,962,314,1126,1348,1137,56,703;47;F
56085;1641,518,1648;33;M
56116;1137,997,1455,1031,315,309,1634,56,518,785,1097,1648,503,1130,314;68;M
56129;1390,1641,56,1513,315,309,1115,26,1190,14,1097,840;45;F
56131;814,1137,56,1130,970,637,514;43;F
56154;785,1031,1513,309,999,312,678,883,1126,1390,1417,1641,703,962,1115;45;F
56246;997,1534,1130,1641,962,1417,840,1390,1648,990,1190,1031,1634,309,26;48;M
56252;1634,1348,503,1458;49;M
56277;26,518,1190,14,840,997,1641,353;45;F
56290;1458,970,637,26,1190,785,1215,814,990,1534,1648,1417,1137,1174,1641;43;F
56291;1137,1130,1641,698,970,353,997,315,1634,123,1648,1390,503,1174,703;26;F
56295;14,1455,840,1001,93,970,353,1121,1215,1348,514,1417,1137,503,56;44;M
56301;999,26,309,315,1634,1031,785,990,1534,1417,1641,698,970,1115;43;F
56322;1634,1115;36;F
56362;26,309,1190,833,811,1648,1455,840,56,503,1130,1641,703;69;F
56418;990,353;36;F
56430;1634,26,883,1031,990,1534,1648,1455,1417,1641,970;46;M
56437;26,309,315,883,1031,1365,990,1534,1648,1126,1455,514,1417,1641,970;48;F
56438;514,56,734,698,1094,970,1115,1634,1126,1001,997,1641,503,1130,703;28;F
56460;1534,1458,1417,1130,1121,1103,1097,990,970,785,703,503,353,123,1648;30;F
56467;999,315,1634,1031,823,14,1534,1648,1126,1455,1417,503,1641,353,1115;53;F
56470;1126,26,999,309,315,1634,1031,785,1365,1534,1648,1455,1417,1641,1115;25;F
56480;678,1137,636;31;M
56484;26,315,1634,1513,1031,1190,990,840,997,1417,797,1641,970,637,353;21;M
56486;1365,315,309,1634;75;F
56490;123,1648,1001,514,698,1634,785,1534,1455,1417,1641;39;M
56493;990,814,518,883,1121,315,999,312,1130,1458,703,1031,840;39;F
56498;636;75;F
56503;26,309,1634,1031,785,990,1648,1126,1348,1455,514,997,797,1641,970;31;M
56518;1390,814,1215,518,883,1513,678,1121,514,503,1130,823,1190,14,840;56;F
56538;1126,1534,123,1031,883,315,309,1634,1648,1130,503;42;F
56575;970,1115,999,678,883,1031,990,1390,1394,1641,1513,1137,1130,797,93;38;M
56605;1513,315,1634,785,1097,833,123,811,1390,503,1130,1458,703,314,970;24;F
56620;1348,1137,1513,883,1031,518,1126,1390,840,1130,797,1641,314,93,1115;6;F
56621;678,883,1365,785,14;47;F
56622;1137,970,1513,883,1031,518,1126,1390,840,1130,797,1641,314,93,1115;4;M
56634;514,1417,503,1130,1641,637,997,1390,1126,1648,1031,678,309,14,1137;47;F
56636;1031,785,1365,990,811,1534,1126,1455,1001,514,1417,997,56,503,1641;30;F
56679;970,999,1365,990,1417,56,315,1634,1121,785,14,1126,997,1641,703;49;F
56703;514,997,710,797,999,315,883,26,990,1455,840,1641,962,1115;38;F
56704;1097,123,990,1417,997,1137,1130,797,698,1115,636,970,1094,962,1641;68;F
56768;678,999,26,309,315,1634,1031,785,1365,123,990,1534,1648,1455,970;35;M
56824;1417,997,503,1641,785,1365,990,1126,1130,970,1115,811,514,56,703;37;F
56826;315,1031,1215,814,990,1534,1648,1126,1455,1001,514,503,1130,1641,970;83;M
56834;999,26,309,315,1634,1031,518,785,123,990,1534,1648,1126,1455,797;54;M
56835;1126,1455,703,1417,123,1634,1137,1641,970,1097,1390,503,797,1513,678;71;F
56851;999,315,1634,1031,785,1534,1648,1126,1348,1455,514,1417,962,1641,353;43;F
56860;883,1190,14,1215,1455,1417,997,56,503,1130,1641,703,952,93,970;30;M
56877;315,1513,785,14,833,811,514,883,56,503,1130,734,952,1094,637;31;F
56879;1458,1126,14,1174,1348,1031,1390;69;M
56888;503,1174;29;M
56926;315,309,26,999,1634,883,518,1365,1534,1648,1126,514,1417,997,1641;27;F
56933;999,1031,990,811,1648,1455,703,1115,315,1634,1534,1126,997,1417,1641;58;F
56945;518,123,1648,1534,970,999,785,1641,1634,678,1126;37;M
56947;1126,1455,703,1097,1390,1417,1137,503,797,1641,970,123,1513,1634,678;68;M
56979;315,309,1031,785,14,990,1534,1348,1455,1417,997,1641,812,970,1115;12;M
56980;1455,1648,312,999,14,1365,1534,1417,1394,1130,797,1641,812,970,678;37;M
56997;990,1534,1648,1126,1390,1455,840,1417,997,797,1458,1641,93,637,1115;31;F
57012;518,1190,785,990,1534,1126,1455,840,514,1417,997,797,1641,703,970;83;F
57042;999,1634,14,1365,1215;37;M
57070;811,1094,1458,503,14;43;F
57071;678,14,1390,840,1137,1641,93,353,637,952,734,710,1001;51;M
57094;309,518,785,123,997,1394,315,1031,990,1534,1348,1137,1641,314,1634;42;F
57124;1215,637,811,1137,1130,1641,698,1094,1121,1097,990,56,503,703,970;53;F
57147;1641;41;M
57157;315,26,970,1365,309,999,1115,1641,1417,1455,1534,990,785,1031,1634;21;M
57164;315,1634,1031,785,990,811,1534,1648,1455,1417,56,503,1641,962,970;34;F
57179;1130,1534,1190,1097,785,1103,1390,1417,56,703,1458,1641;37;F
57189;1513,990,1390,514,1394,503,797,1641,962,703,952,93,812,970,353;18;M
57214;1455,1126,1215,1513,1634,678,14,1137,962,314,56,93,636;46;F
57243;1634,883,1215,1137,962,678,1513,14,1126,314,56,93,636;8;M
57320;518,1097,1215,990,797,1634,123,1648,1126,997,1137,1130,1641,703,970;70;M
57339;1137,883,999,1634,1513,1031,518,1365,990,1648,1390,840,1174,1641,93;88;M
57387;26,315,1634,1031,785,14,1365,123,1534,1648,1455,840,1417,1174,1641;25;M
57395;710,1215,1126,312,883,518,1097,990,1455,1137,637,636,353,678,1634;39;M
57396;1513,990,1215,514,26,999,1648,518,636,678,883,353,1634,1126,637;38;F
57420;503,123,1634;15;F
57473;1126,1534,990,678,1190,999,1513,785,1365,833,636,1115,883,1031,1174;34;F
57477;883,1215,1648,1455,1137,1174,1641,503,514,1534,785,315,1634,1513,1365;37;M
57478;1174,1534,1458,1641,1126,710,1215,990,812,999,26,315,1634,883,1031;28;M
57497;312,1634,814,1137;39;F
57508;1103,123,811,970,997,314,1513,1390,1348,710,56,1130,503,1174,962;42;F
57515;14,1365,1648,1130,1641,1115;45;M
57522;1121,1097,990,1126,1348,637;38;M
57544;1390,1648,883,26,1634,1513,1190,1215,1417,997,1137,797;28;M
57551;814,1390,1137,503,1513,1031,518,14;46;M
57565;1634,1513,883,518,823,14,811,1390,514,1137,1130,952,314,970,636;51;F
57585;811,814,1634,309,312,823,14,1365,1097,1215,1348,997,1137,970,1115;44;F
57594;1634,1137,503,1641,14,1115;32;F
57602;678,315,1634,1031,823,14,1534,1648,1417,1137,56,1394,1458,1641,636;45;M
57603;970,990,1137,93,636,312,678,883,814,1534,56,1458,703,637,1130;57;F
57610;823,309,1190,26,1634,1031,785,1534,1648,1126,1455,1641;22;M
57621;1031,315,999,309,1097,990,1126,514,1417,1137,1458,1641,703,1094,353;28;F
57640;1634,309,997,1390,990,883,1126,514,503,1130,1641,812,1094,970,637;22;F
57671;1634,353,1534,883,1513,315,999,1031,518,785,1417,56,503,1130,1641;39;F
57714;1634,123,990,1534,1648,1126,1417,997,56,1130,797,1641,812,970,1115;46;F
57743;1115,56,990,1097,1634;27;F
57788;990,518,678,1513,883,1031,1137,123,1126,1390,840,797,1458,93,636;45;F
57797;1634,823,518,123,314;31;M
57801;883;36;F
57810;970,1634,1513,883,123,1390,514,56;31;F
57822;1215,1648,1126,1390,1001,514,1137,1130,703,314,93,1115;32;F
57838;1390;26;F
57845;678,883,14,1137,797;76;F
57893;1417,1641,990,785,823,1634,26,309,315,1121,1190,56,1130;61;F
57911;678,1513,883,814,990,1390,514,1137,637,636,93;6;M
57919;1534,1365,785,518,1634,1417,1115,999,309,315,990,1001,514,997,1031;37;M
57933;883,309,1648,970,637,1115,999,315,1031,785,990,1534,514,503,1641;32;F
57944;678;59;F
57963;1534,814,123,833,315,518,785,811,1455,840,1641,703,93,26,1190;50;F
57970;1365,1115,812,503,514,123,785,309,26,1634,1031,1534,1648,1641,353;43;F
57981;999,26,315,1634,1031,1190,785,990,1534,1648,840,1417,503,1641,970;48;F
57982;353,309,1365,785,123,990,1648,1174,1115,1634,1031,518,1126,797,1641;45;M
57985;1094,636,1634,883,785,14,1097,990,1534,1417,997,56,1458,1641,970;71;F
57999;990,785,309,26,1126,1417,1115,970,1455,1534,1031,678,1634,1648,1641;32;F
58050;1534;31;M
58055;14;37;M
58068;315,1513,1031,1455,678,840,514,1417,1137,797,734,1641,952,698,637;31;F
58090;26,883,1190,1534,840,503,1130,1641,962,314;38;F
58102;315,26,1634,1031,1648,1455,1417,514,56,503,1641,962,952,970,1115;30;F
58104;990,1126,1417,1137,734,1641,703,952,698,314,1115,999,1634,883,1031;38;F
58116;315,1215,309,785,811,1458,952,636,883,14,1648,514,503,1641,637;51;F
58118;1634,1031,785,1534,840,1417,970,26,823,518,990,1648,1455,797,1641;67;F
58136;1126,823,883,1348,1103,1097,1121,309,503,1130,797,1641,962,1094,1115;33;F
58139;1365,1031,999,1634,785,990,1534,1455,1417,56,503,1130,1641,962,970;33;F
58149;1126,1455,840,1641,26,1031,1190,1215;47;F
58160;1031,1634,999,1115,93,797,1130,840,1534,14,997,1648,123,1190,678;35;M
58167;952,1641,734,503,1137,990,1215,785,1031,883,1513,315,309,26,678;3;M
58189;1417,26,999,309,315,1634,1031,518,785,1534,1648,1126,1130,1641,962;45;F
58206;312,678,1634,883,785,123,1365,811,1001,1137,503,1458,314,970,637;37;F
58223;1634,797;31;F
58266;1534,785,518,1031,1634,309,315,1455,1417,56,503,1130,1458,1641,970;45;M
58268;1641,883,1215,1534,1126,1634,1348,1458,636,1648;46;F
58427;309,883,1390,1348,1001,514,997,797,1641,636,353,1634,14,123,503;42;F
58457;1365,997,1115,1641,1417,1126,1648,1534,990,123,785,1031,1634,309,26;57;M
58467;1513,1121,26,315,1634,1031,518,785,14,123,1534,1648,1455,1130,1641;29;F
58473;353,636,1115,1348,999,309,1190,14,833,811,1137,1458,1641,703,314;38;F
58503;1031,1648,1094,503,1458,1641,703,123,1634;38;M
58506;1126,883,1513,999,309,518,785,811,1390,56,315,703,314,970,353;45;F
58543;823,833,123,1126,1390,840,997,1458,93,518,14,1648,56,503,812;53;F
58547;1137,514,1126,811,123,833,1365,883,1513,1121,1634,315,1094,970,637;8;M
58592;797,785,1190,883,1513,309,970,1648,1215,1126,1534,990,1634,315,26;39;M
58618;1634,1121,1031,785,811,1648,1001,514,1417,997,503,1130,1641,962,703;48;F
58622;503,1130,703,698,1137,514,814,1097,1103,990,1641,678,314,93,1094;39;F
58623;312,1031,518,785,990,1534,1390,1348,1417,997,1458,1641,314,970,315;54;M
58652;1190,353,1390,1215,1513,1634,14,123,1001,514,503,1458;29;M
58658;1190,785,990,1534,1126,1390,1455,840,514,1417,997,797,1641,962,970;28;M
58700;93,1115,314,1641,1130,797,1348,1417,14,1634,1031,823,785,315;21;M
58724;840,1534,785,1031,315,309,999,1634,1390,997,503,1130,797,962,353;46;M
58820;314,1641,1130,997,1534,678,1634,518,1215,811,1001,503;66;F
58826;1513,883,1031,823,518,1190,1648,1390,1348,1137,1641,962,314,93,636;35;M
58888;1455,1417,710,56,1394,1130,1174,93,970,1031,518,1534,503,1641,636;39;M
58941;315,1634,1031,14,1215,990,1534,840,514,1137,503,797,1641,93,970;70;F
58944;123,1348,1455,56,797,1115;45;M
58947;1031,1513,1634,309,26,315,1190,1534,1648,1455,840,1417,797,1641,93;46;F
58961;883,1097,26,309,1031,785,1641;33;F
58972;312;43;M
58992;503,1130,353,1126,678;41;M
58994;1215,814,997,56,503,1174,1641;65;F
58998;1534,1648,1126,1390,1348,1455,840,1417,997,1137,1130,797,1641,970,1115;46;F
59012;1031,14,833,1215,1390,1001,997,1641,1097,503,1130,1174,703,93,1094;36;F
59020;999,314,1130,56,1348,123,1634;29;M
59055;1634,883,518,710,1174,1115;34;M
59077;312,1513,1215,1390,1458,703,314,637;43;M
59079;840,309,26,1121,1031,1126,1634,518,1190,123,56,503,1130,1641,1115;62;M
59101;812,315,309,14,1215,123,1534,997,503,1130,797,1641,962,93,1115;40;M
59113;1115,999,26,315,1031,1097,1648,1417;43;M
59163;678,312,823,1190,14,811,1126,1348,1137,56,1130,797,1458,962,314;44;F
59190;1031,990,811,1534,1648,1455,514,1417,1641,970;35;M
59225;811,26,315,1031,1534,1648,1455,1417,710,1641,970,1115;66;F
59265;1137,1458,309,312,1634,1121,883,823,785,123,1001,514,503,703,93;40;F
59348;315,1121,883,1031,518,14,1097,990,1534,1648,56,503,797,703,1094;69;F
59391;1115,1513,1634,1121,990,1534,1126,1390,1417,997,1137,1458,1641,703,970;37;F
59463;309,315,1031,518,785,990,1534,1126,1348,1455,56,503,1641,970,1137;39;F
59477;312,1031,1126,1174,999,1634,883,518,990,1534,1455,997,970;34;M
59494;1031,1190,1455,1417,997,1130,1641;53;F
59504;1001,999,1458,703,1121,1513,518,811,1126,1390,514,1394,1137,56,503;38;F
59534;997,1417,1634,315,309,883,785,1648,1641,812;42;F
59571;315,1534,1648,997,503,999,1455;45;M
59590;990,315,1455,518,785,1365,811,1648,1417,56,503,1130,1641,970,1115;49;F
59666;353,970,1641,1417,883,1634,312,1190,14,123,990,840,997,503,1130;27;F
59672;970,1215,785,26,312,811,1455,1130;43;M
59695;1031,1390,514,1417,797,1634,883,518,1365,811,56,1130,1174,1641,1115;27;F
59701;637,312,1348,1641,93,636,678,1513,14,1390,1137,503,1130,314,812;42;M
59710;678;35;F
59713;678;39;F
59717;309,315,1031,785,1365,990,1648,93;74;F
59721;1097,990,1001,514;11;M
59725;698,678,312,315,883,1097,123,1648,1126,503,314,812,1094,1641,1634;18;F
59733;999,970,1641,1417,1455,1390,1126,990,785,1190,1031,315;58;F
59752;823,785,1365,1215,1648,1126,1390,1348,1417,710,56,1458,1174,1641,1115;42;F
59762;636,999,1634,1513,883,1215,1534,1648,1390,1348,1417,1137,1130,1641,812;42;F
59763;1534,503;38;F
59774;1634,123,1534,1458;27;F
59780;1513,1190,26,990,1534,1390,840,997,1137,1130,503,1641,703,970;54;M
59800;1115,999,26,1455,309,315,785,1365,970,1031,990,1534,1648,1417,1641;35;F
59822;1648,1634,26,315,1190,833,123,990,1534,1126,1417,1130,797,314,970;70;M
59833;797,14,1097,811,1001,514,503,1130,703,1641,315,1031,123,1534,1648;46;F
59852;26,309,315,1031,785,1365,123,990,1648,1455,1641,1534,999,1634;29;M
59872;1534,811,1215,814,1001,56;44;F
59875;1215,814,997,56;54;M
59881;1641,1634;55;M
59888;1513,1031,14,636,1130,503;25;F
59909;785,1348,26,309,315,990,1648,1126,1534,1031,1634,1455,1417,1137,1641;60;M
59919;1417,1115,999,309,990,811,1534,514,997,703,970,1634,1031,503,1641;51;F
59950;514,734,962,814,1190,518,678,1121,1513,883,1215,1137,56,637,1390;32;M
59961;1115,990,1097,518,823,1031,1121,1634,315,309,26,999,312;21;M
59984;1097,811,1348,514,1137,1130,1641,703,636,353,883,14,56,503,637;41;F
59992;999,811,1648,1348,1001,514,703,990,833,309,315,1641,1097,1031,1121;44;M
60018;1634,315,309,999,1137,1458,1641,970,883,1031,518,1215,1534,1001,514;29;M
60021;14;52;M
60023;312,1634,518,1648,1348,703,314,812,1094;70;M
60057;1513,1115,312,678,309,315,997,1641,93;36;M
60059;1174,26,999,309,315,785,990,1534,1648,1390,1455,1417,1641,970,1115;39;F
60080;997,514,1390,56,1534,123,14,518,1031,883,1121,315,1634;44;M
60086;1634,1513,1031,1365,1190,1534,1648,1126,1390,1455,840,1417,997,1641,93;71;F
60088;999,1513,1097,1534,1348,636,678,1634,1031,1137,990,1126,997,970,883;36;F
60099;999,883,14,990,1390,309,315,514,1417,1137,56,503,1130,970,1115;42;F
60102;309,1121,1190,840,514,56,1130,1458,1641,14,811,997,503,962,703;41;F
60104;1137,833,514,503,698,637;38;F
60160;999,315,1126,1348,997,703,314,990,514,1417,1641,970,1031,1137,1458;48;F
60162;1634,309,999,315,1513,1031,785,1648,1126,997,797,1641,314,636,93;45;F
60175;1121,14,1455,636,970,1094,1126,314,1390,811,814,1634,93,1394,1458;41;F
60180;1365,1215,999,1513,1097,1103,56,503,1130,14,1115,637,1094,1121,1137;41;F
60202;785,1634,315,518,14,1455,1417,1137,314,970;42;F
60217;1031,823,518,1190,785,814,1648,1126,1348,1455,997,503,1641,962,353;38;M
60230;999,1115,1031,353,785,797,518,315,309,123,56,1130,1417,1648,1634;38;M
60236;1417,93,970,309,1031,990,1534,1390,1455,997,503,797,1634,123,1641;37;F
60268;1390,1417,1394,636,1634,883,518,14,1097,990,710,1130,1641,703,970;31;F
60313;1634,1513,14,1390,1137,503,1115;71;F
60353;1190,518,883,1634,315,309,26,1365,1137,503,1174;37;F
60437;1031,1534,1094,970,315,1348,703,353,1641,1130,1137,1417,990,785,26;45;F
60559;999,315,1513,1031,785,1648,1126,997,797,1641,314,636,93,309,1634;7;F
60575;840,1130,962,503,1648,123,823;49;M
60590;1634,309,315,518,1001,1394,999,990,997,1648,1455,1417,797,1641,970;54;F
60593;1031,1634,315,309,833,990,1648,1455,514,997,56,503,797,1641,970;43;F
60599;1648,1534,1115,970,1641,990,785,1031,309;43;F
60609;123,1417,1137,1130,797,703,970,999,1634,1031,14,990,1126,503,1641;46;F
60612;1634,14;46;F
60627;999,309,315,1634,1513,1031,785,1648,1126,997,797,1641,314,93,636;8;M
60682;1115,636,314,990,883,999,26,309,1634,1031,1648,1534,1455,1641,970;37;F
60688;636;40;M
60695;1001,353,785,636,1031,518,999,698,1458,990,1641,1348,1126,1094,703;43;F
60725;785,1190,309,678,503,797,1641,93,353,636,1634,1031,518,840,1130;28;F
60729;514,1130,970,353,315,1534,1215,1513,1634,1031,785,1126,997,503,1641;32;F
60730;970,353,1215,1634,14,1455,1126,1031,1513,785,1390,997,503,1130,1641;33;M
60774;678,315,1121,1513,1190,1097,811,1390,514,1137,797,703,314,812;43;F
60869;1455,1190,1130,997,883,812,703,514,1641,503,1031,1417,26,1634,14;43;F
60872;1190,14,1097,123,1126,840,1001,514,1137,56,503,1130,797,1458,1641;44;F
60879;999,26,309,1031,785,990,1648,1126,1455,1417,997,797,1641,703,970;73;M
60975;1634,1121,823,14,1097,1390,1348,1137,56,503,1130,1458,734,1641,970;19;M
61046;636,1634,1121,518,1190,14,811,1137,56,503,1130,1641,962,698,812;44;M
61055;1190,999,1634,1365,1534,840,514,1174,1641,970,353,1115,1513,1215,990;44;F
61070;1126,1031,997,990,970,883;28;F
61102;840,1094,26,309,315,1031,1190,785,14,1365,1126,1417,503,1130,1641;17;F
61130;999,1634,883,1513,1215,1534,1648,1390,1348,1417,1137,1130,1641,812,636;12;M
61157;1001,840,678,1634,1513,883,1190,14,1215,814,1534,1390,514,1137,503;34;F
61182;1031,518;71;F
61185;833,1534,1648,1455,1417,1458,1641,314,970,1115,1634,785,14,710,1174;44;F
61190;952,1365,123,840,14,1348,314,315,1031,1534,1634,785,990,970,26;44;F
61204;970,833,1126;27;M
61228;518,1455,703,970;33;F
61265;1513,1365,1648,997,970,1634,518,797,56;37;M
61304;1513,14,833,811,1534,1126,1390,514,1417,1458,1641,703,314,93,970;43;F
61307;514,678,26,1634,1513,883,1031,1190,785,1365,1215,1390,1641,698,637;19;M
61321;1634,1031,785,14,1365,1215,1534,1126,514,1137,1417,56,503,1641,1115;43;F
61330;1126,999,309,1648,1534,970,1455,1641,990,315,26,1031,1190;47;M
61374;14,1115;61;M
61379;636,1121,1634,999,315,1031,518,990,1648,1126,503,797,1641,93,353;38;M
61389;1001,1417,309,315,1031,1097,997,1634,518,1103,56,503,1130,1641,703;41;M
61425;56,503,1641,962,703,1115;27;F
61430;999,1648;51;F
61459;1174,1455,785,1121,1634,503,1641,698,962,734,1394,1137,1390,1534,1190;73;F
61496;1126,990,123,1121,315,26,999,1634,1031,785,14,1534,1417,56,1641;48;F
61540;823,14,814,811,1348,1137,503,1130,703,314,812;41;F
61600;678;40;M
61610;999,1190,1126,1115,503,514,1455,1534,883,315,518;30;F
61658;703,637,678,1634,883,518,785,1097,990,1648,734,314,1094,353,636;32;F
61787;785,14,1365,1534,1390,970,1115;49;F
61844;14,785,1031,883,1648,1115,703,1513,1634,678,514,503,1130,952,637;25;F
61878;962,698,1534,1634,678,952,1215,514,883,503,1365,999,710,734,1174;33;F
61905;1190,518,1634,999,1115,997,840,1455,1126,1648,785,1031,315,309,26;29;M
61916;1031,518,1215,990,1126,1390,1455,1001,514,56,1130,797,1641,703,970;34;F
61921;309,999,26,1121,823,1190,785,814,1126,1455,840,1417,56,1130,1641;43;F
61960;1390,1417,56,797,703,970,309,1031,518,990,1648,1126,1455,503,1641;66;F
61961;1634,678,1031,785,1648,1126,1137,1641;32;M
62034;678;49;F
62112;1097,1634,1641;33;F
62158;678;13;M
62204;1348,811,812,309,26,315,1365,1534,1648,1455,1417,1115,1641,1126,1634;16;F
62268;14,1031,883,309,678,1634,518,990,1126,1137,1130,1641,314,970,636;39;M
62322;990,1534,1648,1455,1001,514,997,1137,503,1130,734,1641,952,314,637;37;F
62331;1634,1031,14,1365,990,811,1126,1417,56,1130,1641,703,1094,970,1115;36;F
62453;1417,503,93,1455,1634,999,1031,518,1390,1130,1174,1641,952;31;F
62462;883,26,678,1634,1513,840,1137,797,1458,93,1094;45;F
62512;56,1130,1458,309,315,1031,785,1534,1648,1348,1417,1137,1641,812,970;48;M
62525;785,990,514,1417,997,734,309,1534,1001,1137,503,1458,1641,703,970;55;F
62530;883,1215,811,1126,1390,997,1137,503,1130,734,1641,962,703,970,636;41;F
62558;883,1215,990,1390,514,1137,56,1394,503,1130,1458,1641,703,314,93;10;M
62576;1137,840,1455,1348,1126,1534,123,1215,785,1190,518,883,1513,26,678;5;F
62607;514,1215,636,1634,1137,1641;38;F
62634;1190,1215,123,1126,1390,1348,1455,840,1137,797,1458,703,93,812,1094;13;F
62636;678,811,1390,1001,514,997,1137,1394,503,1130,734,1641,636,952,970;9;F
62648;1634,123,1126,797;22;M
62650;1365,883,1634,1121,1513,990,1534,1648,1126,1390,1455,56,1641,962,970;42;M
62666;1513,1190,1215,123,1126,1348,1455,840,1137,797,1458,1641,93,812,1094;5;F
62670;14,833,814,1137,56,734,962,314,1094,503;41;F
62675;26,1634,883,1031,123,1348,840,1641,353;37;F
62680;123,797,1031,1634,1641;50;M
62727;1634,678,1417;49;F
62728;1394,797,1130,1115,970,1094,1455,1001,514,1417,997,734,637,812,636;11;M
62742;785,1097,990,1455,503,698,1094,309,1031,1126,1417,997,1130,1641,970;74;M
62752;1634,503,353;31;M
62772;883,814,811,1348,514,710,1137,56,503,1130,734,1174;36;F
62778;1097,1215,1390,514,1137,1458,1641,698,314,93,970,636,637,883,1115;38;F
62783;309,503,1031,1097,1455,1641,353,1190,315,1513,1390,1126,990,123,1634;42;F
62792;1390,503,1458,970,999,990,1097,1365,14,785,1031,1634,811,1641,1115;28;F
62794;678,315,1031,785,1534,1126,1417,1641,1458;31;M
62800;26,1513,883,1031,1215,990,811,1648,1390,1001,514,1137,503,1641,703;52;F
62877;1130,1417,678;12;M
62895;710,734,1174;37;F
62929;1634,1121,1097,1390,56,503,1130;20;M
62935;811,514,1417,962,14,1648,1455,315,503,1641,703;48;M
62969;312,1390,883,1031,1190,785,123,990,1648,1455,514,997,1137,797,1641;42;F
63012;999,785,1365,1534,1455,1130,1641,93;77;M
63069;678,1513,883,14,1215,814,990,1390,1001,514,1137,503,812,1094,637;30;F
63103;315,812,314,1094,1641,1417,514,1348,353,1634,1031,823,14,1130,962;51;F
63143;315,1115,123,1215,518,1190,999,26,1634,1534,1648,1455,1417,797,1641;52;F
63191;785,970,678,309,315,1634,1031,1534,1126,123,990,1648,1348,1417,1641;45;M
63202;1513,1031,14,1097,833,1215,811,1390,503,703;17;F
63223;1641,970,1417,1126,811,833,1097,785,1190,518,1513,315,309,26,678;22;F
63225;518,1215,990,1534,1648,1126,1455,997,1641,314,93,970;49;F
63229;785,990,1130,1417,840,883,26,1634,1031,518,123,1648,56,503,1641;41;F
63247;1534,710,1641,962,1115,1634,518,123,1648,1390,1174;67;M
63261;1215,1001,503,315,1534,1390,1417,1513,514,1634,1031,1641,883,785,1648;38;F
63297;93,698,883,678,990,503;61;F
63312;26,1634,14,1097,840,1417,997,56,503;41;M
63340;1513,1634,999,1121,883,823,1190,814,1126,1390,840,1001,514,1137,703;51;F
63367;1130,962,1094,1115,990,678,1455,1417,1348,637,797,1031,123,785,1641;20;M
63372;999,518,514,1634,123,1126,1390,1094,14,1097,833,811,503,1130,703;40;F
63387;1103,814,1534,1348,997,1394,1641,93,636,1115,678,883,1126,503,314;28;F
63419;309,26,999,315,1634,1031,785,990,1534,1455,1417,1641,970,353,1115;44;F
63425;785,883,309,315,1365,1097,1215,14,1137,1130;46;F
63433;1031,1634,1137,503,1641,353;39;M
63465;26,315,1634,1513,1031,518,785,1097,833,123,811,1126,1390,1455,840;56;F
63515;93;35;M
63527;703,698,997,1417,1455,1365,883,1634,1390,1031,1348,1174,14,1126,1458;43;M
63532;840,1001,26,1634,1031,1215,1390,1455,514,997,503,1641,962,93,1115;19;M
63537;678,1513,883,1215,1390,1130,952,93,56;31;F
63541;1534,1126,997,1641,1455,1130,962,309,883,1097,1103,811,56,503,703;48;F
63547;678;36;M
63565;1534,1390,1455,1417,1137,56,1458,1174,703,952,314,812,1094,970,637;23;F
63574;999,1031,518,785,1126,1348,1417,997,1137,503,1458,1641,970;9;M
63581;93,970,636,785,883,1634,678,1513,990,1648,1126,1390,797,1641,637;69;F
63591;814,1348,997,1137,970,56,811,1390,514,703,353,503,1130,823,1634;25;M
63624;814,518,1031,309,678,315,1634,883,1190,14,1097,56,503,1641,1115;70;M
63672;1130,678,14,811,1348,1137,56;31;M
63675;1648,1455,1130,990,56,797,785,1365,1534,840;35;M
63679;514,14,1513,678,883,1215,1137;34;F
63683;999,1121,1215,514,1417,56,309,315,1031,518,1534,1648,1455,1130,1641;49;F
63688;26,678,999,1417,1001,840,1348,1534,990,315,883,14,514,997,1641;62;F
63734;1634,14,814,1348,503,1458,962,93,1094;34;F
63764;1126,1455,309,315,1634,1365,123,1348,840,503,1130,962,703,1094,1115;33;F
63767;1365,1417,1174,970,1634,1031,1190,1534,1126,1348,1455,1641;39;M
63773;1126,1455,1417,1137,56,1130,1641,1115,309,1634,1031,518,1097,123,503;71;F
63803;1126,1394,883,1215,1513,123,518,814,1390,514,1137,703,314,93,1094;37;F
63890;710,1455,1648,1103,1097,1190,1031,309,1634,1121,14,833,1534,56,1130;33;F
63892;678;35;F
63916;785,1031,1513,518,1390,997,1417,56,1130,970;67;F
63919;970,999,26,315,1634,1031,785,123,990,1534,1648,1126,1455,1417,1641;47;F
63929;1648,123,785,1190,315,990,1534,1455,1417,1641,970,26,1634,1031,518;28;F
63947;514,1137,734,952,1126,1641,703,636,678,883,518,1097,1648,1390;27;M
63948;26,1031,518,785,1126,1455,840,997,1417,797,1641,962,698,970,637;37;M
63949;1417,1641,970,1455,1126,1648,1534,123,315,309,26,1634,1031,823,518;33;M
63957;678,1648,797,1641;37;F
63958;1190,990,1534,1641,93,309,1634,1031,518,785,123,1648,1126,1455,1417;30;F
63966;636,353,1103,1126,1001,514,970,678,883,14,1097,990,1137,1130,703;48;F
64012;1634,785,814,1534,1648,1126,1455,1417,797,1641;48;F
64018;1648,1115,1455,1534,1417,970;69;F
64077;503,698,353,315,309,678,518,785,14,1097,997,1130,797,1641,636;63;F
64112;999,1513,1641,353,309,823,785,14,1097,990,811,1455,56,1130,703;51;F
64132;1001,514,1137,698,636,1130,962,970,637,840,1126,14,883,1513,56;43;F
64137;678,1634,14,1534,514,1137,56,503,1130,703,698;41;F
64138;1634,1513,1534,56,797,1641,962,812,1031,14,1126,1390,1348,1458,1174;44;M
64139;312,678,1513,883,1190,811,1390,1001,514,1137,637;43;F
64154;1130,703,637,678,883,518,1097,1215,1534,1648,1126,1390,1417,997,1641;27;F
64167;315,1634,883,14,814,1390,1455,1137,637,1121,1513,1215,1534,514,503;25;M
64180;1641,1634,990,1534,1648,503;51;M
64259;1634,1513,1215,1126,1390,1348,314;39;F
64298;1031,1365,814,1103,990,1534,1458,1174,1641,93,637,636,785,1215,1648;40;F
64299;1634,1534,1648,1390,1348,1417,1130,1094,353,1031,14,1365,503,734,1641;28;F
64336;990,840,26,1634,518,123,1648,1126,1534,1455,1417,503,797,1641,353;72;M
64344;309,1121,883,785,14,1126,1348,1137,56,1394,503,1641,314,812,970;44;M
64347;315,1115,1130,997,814,309,1031,14,1534,1648,1390,1417,797,1641,970;56;M
64365;1648,997,797,1115,999,26,309,1634,1031,1190,785,1126,1455,840,1641;35;M
64380;678,1634,1126,814,315,999,1031,1641;35;F
64388;883,1390,1648,1641,503,1137,1126,785,1190,1031,1513,1634,309,999,93;27;M
64403;1031,14;74;F
64423;1534,1094,314,1641,503,514,1126,1215,1097,1634,14,1648,1348,1137,698;34;F
64457;678,315,1634,1031,1215,1534,1001,56,1641,1115;16;F
64469;26,1513,1190,1365,990,1534,1648,1390,1348,1455,1417,997,503,797,1641;15;M
64478;883,503,703,14,353;35;F
64484;315,309,1031,823,785,1126,1417,1130,1641,962,314,93,1634,1348,353;29;M
64485;1634,999,636,93,314,1641,1458,503,1137,514,1348,1126,1215,312,678;41;F
64502;678,1031,1097,811,1417,997,1137,56,1130,1094,703,952,698,314,636;42;F
64513;1215,1097,1634,678;53;M
64582;678,990,1648,1455,514,1417,1641,970;38;F
64603;999,309,26,315,1634,1121,1031,785,1190,14,1126,1455,56,1641,970;54;F
64620;14,797,1126,1648,1534,123,518,1031,1634,678;42;F
64632;1513,1634,315,883,1215,990,811,1390,1394,1130,999,1641,970,56,503;15;F
64648;698,1513,1031,785,1137,1458,637,883,14,1215,1390,1001,514,703,952;39;F
64673;797,840,1390,1634;30;M
64711;514,1215,14,678;51;F
64740;1641,1174,962,703,314,970,315,999,1121,1031,1534;45;M
64781;14,1137,56,1115;45;F
64814;312,518,1390,56,797,1513;45;M
64821;785,1215,990,1390,1348,1455,997,309,1634,514,710,503,1130,1174,1641;34;F
64831;703,314,26,1215,1137;38;F
64854;1365,1001,990,1031,999,883,1634,1513,1215,514,56,503,1130,1641,970;41;F
64857;1137,503,1513,518,123,1390,840,514,1641,93,678,14,833,814,797;42;M
64862;1390,1001,1137,734,703,952,637,1634,14,1097,1215,514,56,503,1130;27;F
64881;1534,990,785,1031,1634,315,26,999,1365,1648,1455,1417,1641,703,1115;41;F
64888;1121,990,1394,812,312,14,1365,1348,503,1130,1458,1641,703,970,1115;44;F
64905;1648,990,1031,883,315,309,678,1126,997,503,797,1641,962,970,636;69;F
64910;1648,990,1365,315,309,999,26,1031,785,1534,710,503,962,1641,1115;64;F
64945;1417,997,1130,1641,314,309,1031,514;47;F
64972;970,997,1417,1455,1348,1097,785,999,1634,883,1031,518,26,1534,1641;50;F
64988;812,1648,123,1215,1634,1094,637,698,962,1641,840,1390,518,1513,93;43;F
64998;1634,1031,123,990,1534,1648,1126,1641;23;M
65023;840,1390,1513,1634,123,503,1641,93;38;F
65037;883,823,1190,14,1097,1103,990,1348,514,997,1137,1174,970,1126,1115;41;M
65043;814,1031,999,309,315,518,990,1126,1648,1348,1417,314,970,637,1115;56;M
65052;999,1534,1126,353;56;F
65084;1513,1534,315,999,309,1634,811,1390,514,503,1130,962,703;60;F
65085;1215,883,518,785,990,1390,514,1137,1130,797,703,698,314,970,636;70;F
65090;1031,1534,1648,1417,997,503,1130,1174,1115,514,797,1641,970;40;M
65095;26,1634,823,123,990,1126,1417,1137,503,1641,703,970;50;M
65098;999,26,315,1634,1031,785,123,990,1534,1126,1648,1455,1417,997,1641;50;M
65102;1390,514,710,503,1458,1641,812,883,1031,14,990,1534,1648,1137,970;67;M
65117;1513,1534,514,312,1634,1031,14,1215,814,990,1126,1390,1455,1001,1137;71;M
65193;315,1634,1031,823,785,123,1648,1390,1348,1455,514,1417,1130,1641,703;46;F
65203;312,990,840,1001,514,970,26,1634,1031,785,1534,1648,1455,1417,1641;34;F
65215;1031,1365,1534,1137,636,1115,1634,1513,1390,710,503,1174;41;M
65239;14,1648,1641,883,970;54;M
65325;1097,811,997,1137,1130,962;39;M
65326;883,1031,785,56,1130,14,1137,503,1458,314;35;F
65336;26,315,1634,990,1534,1648,1417,503,1130,797,1458,1641,962,314,970;44;F
65341;1215,833,678,26,309,315,883,823,518,785,1190,1126,1390,1455,840;46;F
65376;678;36;F
65385;123,514,56,26,315,1634,1031,823,518,833,1126,1534,1648,1455,1641;49;F
65389;309,1513,518,785,1390,1001,514,1417,1130,962;51;F
65398;309,1513,26,1126;46;F
65412;1215,823,1031,883,1513,26,1634,785,14,1126,1390,1137,503,1130,1641;39;F
65426;734,503,1001,1215,1513,315,678,1634,883,814,811,514,1137,952,314;28;F
65437;1031,1634,315,309,26,518,1190,785,990,1455,840,56,797,1641,970;46;M
65449;678,1634,1031,785,1365,1648,1455,514,1417,1137,503,734,1641,952;30;F
65524;999,1634,883,1031,785,1648,1390,1137,503,1130,1641,637;37;F
65583;883,1513,309,678;50;F
65605;1215,1534,1648,1417,997,1137,56,1130,698,637,797,314,1641,678,1126;44;F
65616;1455,997,970,814,703,1641,503,1031,309,123,314,315,785,1634;47;M
65634;1634,123,797;31;M
65678;678,1137,56,503;49;F
65685;1390,1215,1190,1137,1130,814,812,514,518,503,962,1513,678,1634,14;46;M
65702;1390,1348,1455,840,1417,1137,56,503,1130,797,1641,703,698,1094,970;38;F
65718;514,1137,962,703,698,952,314,812,1094,1130,518,823,312,678,1121;38;F
65722;997,1417,514,1390,1648,1534,1215,518,1031,883,1634,315,309,1126,678;34;M
65752;1648,1455,1126,997,703,1534,990,518,1031,315,1417;65;F
65774;315,1455,1001,1641,1115,999,309,1634,785,1365,990,1390,514,1417,970;27;F
65795;785,1215,1137,1390,1534,1190,883,1513,26,1455,1365,840,514,1417,1641;29;F
65811;518,26,309,1634,785,1648,1348,797,93,1390,315,1031,823,314,123;38;F
65826;811,1648,785,14,1365,503,1130,703;59;F
65842;1137,1641,952,970,1126,990,785,883,309,1348,123,1215,1031,1634,678;39;F
65851;1634,785,123,811,1390,1455,514,56,503,1130,1458,703,314,1094,812;43;F
65902;678;9;F
65927;1115,1130,1390,811,990,1215,14,1190,518,823,1513,1634,315,309,1648;36;M
65934;678;8;F
65937;1031,14,1390,1348,514,56,503,1130,1458;30;M
65943;678;4;F
65959;309,1634,1031,990,1126,997,970,1513,883;47;M
65981;1097,1103,1115,1130,1513,14,814,1390,1137,503,314,1094;41;M
65992;1001,1390,1126,1215,14,1513;41;F
66018;312,678,1634,883,823,518,1190,14,1001,514,1137,1130,703,314,970;37;F
66035;636,812,14,678,999,315,1031,1390,997,970,1634,1513,883,990,1126;3;F
66047;999,1031,1190,785,1365,1126,1348,797,518,93,1641,1458,883,636;48;M
66053;514,811,678;43;F
66069;997,1365,1215,123,1348,514,1634,883,14,1534,1648,1126,1137,1641,1458;44;M
66092;1115,999,26,315,1634,518,1190,1215,123,1534,1648,1455,1417,797,1641;53;M
66119;990,811,503,999,1190,997,26,309,315,1031,785,1126,1641,970,1455;50;F
66150;514,811,678;10;F
66173;823,1513,678,1634,1031,1534,1390,1348,1417,56,1130,1641,812,93,353;46;F
66178;678,1001,1137,503,1130;8;F
66179;785,518,1031,26,315,1513,990,1534,1390,1455,1417,1641,637,1115,970;84;F
66181;1641,999,1031,1365,1390,1417,1130,1115,309,315,1634,1534,997,710,1174;29;M
66193;1634,1513,518,1190;37;M
66207;1390,1648,123,1215,1190,518,883,1513,1634,26,678,703,93,812,1094;17;M
66239;1534,1103,1097,1190,823,518,883,312,14,814,811,56,1130,797,812;43;F
66242;1513,1031,1190,1417,637,309,785,1365,990,1534,1648,1174,1641,970,1115;67;F
66323;1634,1513,990,1390,1137,1130,734;37;M
66327;883,1634,26,678,823,14,1126;41;F
66360;1417,56,1130,797,962,970,353,999,26,1634,785,1126,1455,997,1641;47;M
66504;1094,1031,1417,503,1458,703,315,309,1121,785,1126,1348,997,56,1641;44;F
66505;678,999,1031,1534,1648,1126,1455,1641,636;37;M
66553;1121,1634,833,811,1126,1001,514,1417,56,503,1130,1641,703,637,353;61;F
66605;1190,312,1513,93,637,1641,1137,1455,1534,814,1215,1365,785,883,636;39;F
66609;970,1417,1455,1648,1534,1215,833,14,785,1031,1634,315,309,999,698;48;M
66632;503,14;65;F
66639;1417,1634,518,1190,1215,1534,1641;42;M
66646;518,93;31;M
66746;314,1641,1130,503,56,710,1417,1348,1534,990,785,1634,26,312,1031;35;M
66763;840,883,1634,26,678,823,14,1097,1648,1348,1130,1641,703,93,637;52;F
66835;1641,503,1190,1634,14;64;M
66903;990,814,833,883,811,703;29;F
67005;1137,503,1458,1641,314,970,636;43;F
67026;812,353,814,93;46;M
67040;1455,1126,999,997,970,814,1534,518,1641,503,1031,309,1417,785,1634;82;F
67091;309,1031,518,1190,785,1365,811,1534,1648,1126,1455,840,1417,1641,703;55;F
67246;785,811,698,514,990,1634,315,999,14,1365,1648,56,503,1641,970;51;F
67265;93;67;M
67268;970,833,309,1641,1031,123,518,1348,1417,1455,1126,840,785,26,1634;52;M
67295;710,734;21;F
67328;26,1031,518,1190,1455,1417,997,503,797,1641,353,1115;44;M
67331;1534,312,814,1348,56,1130;41;M
67355;1634,14,123;68;M
67360;952,703,1458,1137,811,503,678;37;F
67400;14;35;F
67401;14,514,1137,636,1174,503;42;F
67407;315,1031,990,1648,1126,1417,1641,970,698,1634,823,1348,314,1094,636;42;M
67424;14;36;M
67429;999,678,312,26,1121,883,1031,1190,1097,1215,1001,514,1417,56,1130;36;F
67474;678,1634,1121,883,1031,1103,814,990,811,1390,1348,514,1137,797,1458;38;F
67500;997,309,833,1215,703,315,1634,990,56,518,14,1390,970;66;F
67507;962,1130,56,1121;36;M
67531;1417,997,503,1641,518,56,1130,93,1634,123;35;M
67652;1031,1513,678,1634,814,811,1534,1390,1348,514,1137,1458,1641,703,314;1;M
67686;785,883,999,309,26,1031,1365,990,1534,1648,514,1417,503,1641,970;28;F
67705;1348,1130,315,1634,785,14,1365,990,1534,1648,1455,514,56,1641,970;16;M
67748;1641,1130,1648,1534,123,785,1190,1031,678,312,1634,883,997,797,636;35;F
67774;1417,997,1641,812,970,353,1115,1634,1348;36;M
67821;1634,785,1648,1534,1130,970,990,123,1390,1455,1417,997,56,797,1641;55;M
67846;312,26,315,1513,823,518,1190,1390,840,1137,503,797,1641,93,970;47;M
67896;1455,309,1634,1031,518,785,14,1365,990,1534,1648,1417,503,1641,1115;18;F
67898;1097,1458,997,883,812,811,1094,703,636,503,1394,314,678,93;67;F
67914;1641,970,309,785,1534,1126,1390,1417,1130,93,1634,1031,518,1455,797;65;F
67915;1137,1097,997,970,1094,703,518,1641,503,962,1031,314,315,56,14;67;F
67952;1455,1130,1126,1097,990,1641,503,309,315,1417,14;85;F
67962;1417,997,56,503,797,1115,999,1634,1513,785,1648,1390,1130,1641;40;F
67976;1348,710,970,785,1190,1634,1513,123,990,1126,1390,840,997,797,1641;38;M
67987;1390,123,990,1534,1648,1348,1417,1641,970;24;M
68001;1190,123,1126,636,1137,785,883,678,14,1390,840,514,503,1458,1641;74;M
68004;883,1394,678;66;F
68044;26,1634,1031,1190,14,990,1534,1126,1455,840,56,1641;55;M
68048;883,1394,678;36;M
68072;883,1394,678;42;F
68073;1634,678,309,883,1190,1097,1648,1126,1390,1137,503,1641,962,314,636;32;F
68098;1648,1455,797,1174,353,123,1634;29;M
68141;1190,1215,123,1648,840,1634,26,678,970,637;42;M
68142;1031,1190,1365,797,1174,1641,1115,1634,1513,14,1126,1137,503,1130,952;36;F
68270;26,1097,1390,1455,962,833,990,811,1126;49;F
68289;883,1394,678;5;M
68309;1648,1130,1126,1001,970,823,990,1641,962,1031,1394,1513,315,1417,14;73;F
68343;1126,1390,503,797,93;43;F
68344;1455,1390,1215,1458,997,970,883,636,990,503,309,314,93,1417,1634;72;F
68362;1390,1190,970,840,990,962,1031,56,785,26;72;F
68435;1513,1121,1115,970,314,703,1458,1137,1126,1534,814,14,990;32;F
68443;1115,1390,1513,883,1031,14,1365,1097;37;F
68463;1513,883,1390,314,93;34;F
68499;1190,1365,1534,1417,970,315,1634,1648,1126,1455,840,997,710,1130,1174;50;F
68542;14;41;F
68580;734,1174,1641,812,1115,1634,883,1031,1215,514,56,503,703,952,637;27;F
68589;314,1115,1455,1534,1215,1031,1121,26,678,1634,883,1190,710,1137,1174;38;F
68596;999,518,1190,1115,990,1534,26,309,315,1031,1648,1126,1455,1417,1641;33;F
68610;26,315,785,1365,833,811,1534,1390,514,1417,503,1641,703,698,970;23;F
68684;970,314,1641,1417,1455,1390,1534,990,1513,315;63;F
68705;1458,962,990,1534,1417,997,1137,797,1455,1648,518,1031,1513,315,1390;48;F
68712;514,1137,1130,1031,123,1348,1417,999,1513,1648,503,962,1534,1126,1641;33;F
68745;999,315,1031,785,990,1534,1417,1641,970,353;77;F
68788;1634,1097,1455,840,514,1417,503,1130,1094;15;M
68827;309,1634,1031,1190,785,14,1097,833,123,811,514,1417,997,1641,703;62;F
68829;93,970,636,678,1634,1513,883,518,785,14,1365,1097,1215,1390,1417;40;F
68837;703,1094,637,636,514,1215,1365,1031,309,999,1458,1137,1634,1190,14;69;F
68862;636,970,1634,14,514;51;F
68902;309,315,1390,1001,514,503,1130,797,1641,952;24;F
68911;309,1031,823,518,785,990,1534,1648,1126,1455,1417,997,503,797,1458;20;M
68955;315,1634,1031,785,1365,123,990,1534,1648,1126,1455,1417,997,1641,970;37;M
68990;703,353,1121,823,123,811,1126,1348,1094,1634,14,56,503,1130,1458;52;M
68998;962,1455,1126,123,14,518,1031,309,999,1634,1534,1648,1417,1641;31;M
69036;93;43;M
69068;883,1031,1455,514,962,678,999,785,990,1126,1001,1137,703,970,637;66;F
69071;123,93;40;F
69075;1215,1126,1455,1417,1001,1534,785,1031,315,999,990,1137,1641,812,970;36;M
69078;1648,123,1215,1031,503,1094,315,1634,14,1348;43;M
69097;678,1648;59;F
69138;26,1190,56,503,1641;27;M
69179;883,1031,823,315,1121,309,14,1534,1648,1348,514,997,56,1130,1641;36;F
69201;1348,698,314,970,353,999,1094,1634,14,1097,1126,56,1130,1458,703;38;F
69232;1417,1137,698,1115,636,970,312,883,1031,785,1215,1455,514,503,1641;13;F
69255;1190,999,26,315,1121,1031,14,1648,678,1126,1417,1137,1641,314,93;41;F
69258;315,309,1031,1190,1215,123,990,1001,1513,514,1534,1648,1390,1417,1641;57;F
69274;1634,840,1641,93;30;M
69286;309,1634,1513,1031,785,1648,1534,1126,1390,1455,514,997,503,1130,797;21;M
69295;309,315,1031,1190,785,1534,1648,1126,1455,840,1417,997,1130,1641,970;51;F
69313;93;68;F
69331;999,56,797,1174,1641,93,970,353,1115,1031,785,1365,1648,1455,1126;31;F
69340;1417,1130,503,1634,1513,1031,123,1534,1648,1390,514,56,1641,93,970;64;M
69373;678,883,123,1031,1634,309,999,785,990,1534,1648,1126,1348,1641,970;5;M
69394;1126,1390,1130,703,997,56,503,962,970;36;F
69419;999,1031,785,990,1365,1534,1648,1455,1417,1137,1130,1641,970;44;M
69428;1648,1455,1534,26,999,518,1031,315,990,1126,997,503,1641,703,970;73;F
69436;1513,1031,1648,1126,1390,1137,503,1458,1641,962,703,698,314,93,636;35;M
69450;1137,1174,970,1115,315,1634,883,1031,14,990,1648,1126,1455,1417,1641;43;F
69453;26,1031,1634,503;40;M
69457;503,1641,14,962;70;F
69460;1365,1115,1455,990,26,785,1648,1126,309,315,1031,1534,1417,997,1641;35;M
69467;315,1513,1031,1215,1534,1126,1390,1348,1641,314;9;M
69475;1031,785,1365,14,1115,1534,1648,1126,1417,710,997,1137,1174,1641,970;8;F
69485;1634,1641,1031,785,1534,1648,1458;32;M
69494;309,1634,1513,1215,1126,1390,1348,1641,314;6;F
69504;1130,734,678,518,785,14,1534,1648,1126,1390,1001,1417,797,1458,1641;39;F
69505;1634,785,999,1126,1641;24;M
69508;1031,785,14,1534,1648,1126,1390,1455,1417,997,1137,1174,1641,970,1115;74;F
69598;1031,1001,1126,315,678,1634,883,990,811,1648,514,997,503,1130,703;66;F
69622;1641;79;M
69627;123,315,1534,1348,840,997,93,637,678,1648,1455,1417,797,1641,314;42;M
69632;26,1031,1190,785,990,1534,1126,1455,840,1417,797,1641,314,970;72;M
69637;503,1130,797,812,678,14,1126,1390,1001,514,1137;31;F
69649;1634,1031,1190,123,814,503,1641;39;M
69651;315,1031,785,1365,990,1534,1648,1455,1001,514,503,1641;21;F
69655;514,1001,997,952,962,970,314,93,812,1455,1115,1641,823,14,1348;14;M
69681;312,514,1001,56,314,970,1634,1031,123,811,1534,1648,1417,997,1641;46;F
69696;1365,1174,703,1097,123,962,14,840,997,1130,93,1634,797,353,1348;29;M
69698;1115,1215,999,1534,1455,1001,1417,1641,970,1634,1031,785,1365,990,514;35;F
69717;1126,1648,14,1513,309,883,1190,814,1137,1641,636,26,1634,840,637;36;F
69731;1031,990,1534,123,315,518,1634,26,1455,1417,710,1130,56,698,314;34;F
69745;883,1031,1190,1365,1648,1348,514,1130,797,1641,314,1097,1103,1417,503;29;F
69773;678,883,1031,1190,1126,1634,1513,1648,1390,1137,503,1641,93,637,636;37;F
69778;1215,1094,637,698,962,1641,840,1390,309,315,1634,1513,518,1648,93;13;F
69780;26,1634,823,1031,518,14,123,1126,1455,797,1458,1641;40;M
69789;1648,997,123,1215,1634,1094,637,698,962,1641,840,1390,518,1513,93;10;M
69817;999,26,1634,823,1417,785,962,314,93,1094,970;46;M
69826;823,1031,1634,315,999,309,1190,14,1130,26,1455,840,1001,514,1641;52;F
69854;315,309,26,999,1417,56,503,1641,962,703,952,698,812,970,636;32;M
69863;883,1097,811,1348,1137,503,1458,1641,703,1094;45;F
69873;315,14,1534,1137,1641;69;F
69874;14,309,997,678,1513,883,1031,1365,1215,990,56,503,1641,314,637;22;M
69890;1097,990,1534,1126,1648,1455,840,997,503,56,1641,703,1094,1130,970;38;M
69901;14,1097,811,1390,1001,56,503,1641,962,703,698,812,1094,637,353;30;F
69930;1031,518,785,1097,990,1534,1648,1348,1417,997,1458,1641,962,970,1115;16;M
69938;785,1534,999,1031,1648,1455,1115;72;F
69955;1390,1001,514,1137,503,1130,962,703;40;F
69956;678,1121,1031,1097,814,314,637;40;F
69961;312,1215,1103,514,56,503,1130,797,812,970,637,353,636;32;F
69981;1115,636,26,883,1031,518,1190,123,1001,710,56,962,1641,314,353;32;M
69992;814,811,56,503,1115,1634,518,14,1130;43;F
70014;1031,26,1190,14,1097,1126,1455,840,797,1094,636,678,883,1394,637;40;F
70024;1348,698,636,1215,883,678,1097,814,1137,503,1641,314;34;F
70032;999,1513,883,1031,785,1365,990,1534,1648,1455,1417,1130,1641,1115,1634;47;M
70074;883,1126,1455,123,315,309,999,1634,1031,785,14,1648,1390,1417,1641;73;M
70103;785,1455,1513,1390,1365,518,353,1115,1634;16;M
70109;1348,1417,1458,1641;48;M
70114;678,1121,1031,1097,814,514,1137,314,637;7;F
70131;1031,883,315,999,990,1534,1126,514,1417,1390,1137,734,1641,952,314;33;F
70135;1001,840,811,1103,1097,14,1190,518,823,678,1130,56,1137,1348,1126;38;F
70138;811,1121,56,1130;61;M
70148;990,1097,123,814,811,1126,514,56,503,1130,797,1458,1094,812,637;38;F
70164;315,785,14,514,1417,997,56,503,1641;64;F
70179;678,1121,1031,1097,814,1137,314,637;3;M
70255;1641,962,93,1094,637,1115,1634,1121,518,1130,1174,970,514,710,56;62;M
70282;1513,1634,315,678,312,14,1648,1455,514,1137,503,1641,314,93,812;37;F
70284;1031,1534,1348,1137,1130,952,970,636,309,315,1634,518,1097,1641,962;35;F
70294;1365,997,56,1634,1513,1137,883,14,514;42;F
70317;1348,1417,1458,1641;48;F
70321;1348,1417,1458,1641;9;M
70331;703;29;F
70337;1634,1458,14;44;M
70343;1190,970,123,990,1648,1126,1417,797,1365,999,1534,1031,1348,1641,785;44;F
70371;1348,1417,1458,1641;13;M
70385;883,999,1634,1365,123,1455,1417,1641;50;M
70399;997,514,1001,1126,1215,814,14,1121,833,883,1097,1634,999,312,1094;48;M
70408;962,970,315,1634,833,990,811,1534,56,1130,703;36;F
70443;823,883,309,315,1634,1031,811,1648,1417,997,1130,1641,962,703,353;39;F
70472;637,314,1137,514,814,1097,1031,1121,678;40;M
70507;93,1648,1126,503,1641;46;M
70524;990,840,56,1394,797,314,1094,636,315,1634,814,1348,734,703,93;33;M
70539;883,1365,1648,1126,1001,1417,1641,315,1634,14,514,1137,503,1115,637;31;F
70581;1634,1130,93,970,1094,962,636,123;38;M
70593;990,1641,999,315,785,1534,1455,970;74;F
70601;315,1634,1031,785,1097,1215,123,514,797,970,1115;41;F
70645;678,1097,1365,123,56,1174,703,1094,636;37;F
70647;883,93,636,678,1513,1190,1390,1137,1641,962;40;F
70655;1094,1458,637,1121,1634,518,123,840,1130,734,312,814,1126,1137,56;38;F
70662;1417,309,999,314,637,1115,814,123,785,518,14,710,1130,1174,1641;62;F
70695;1455,797,1641,1365,1190,1031,315,309,999,785,840,1417,997,26,1634;51;M
70715;26,315,1634,1031,785,1365,1534,1648,1417,1641;35;F
70722;1001,840,1348,1390,814,883,1634,1513,1215,514,1137,314;37;F
70738;14,814,1348,503;37;F
70755;93;39;M
70765;123,990,1648,1126,1455,1417,997,1137,1394,797,1458,1641,703,1094,353;35;M
70780;678,312,1215,1648,1513,833,814,1390,1348,1137,1458,314,637,812,636;37;F
70798;93;37;F
70834;678,883,518,1390,514,997,952,93,314,812,315,1634,1513,1137,503;33;F
70839;1648,1417,703,962,1641,1458,1130,503,1137,514,1348,814,785,1031,93;44;F
70843;999,678,26,315,1634,1031,1190,785,14,990,1648,1455,1417,1641,698;40;F
70847;840,1190,26,1031,785,1365,1534,1126,1455,1417,1641;20;F
70848;518,1097,123,14,1634,1121,990,1648,1390,997,503,1458,1641,93,970;20;M
70859;26,883,1190,1097,1215,814,990,514,1137,970,637;61;F
70865;1365,990,1417,1130,123,309,1031,785,14,1534,1648,1126,1641,703,1115;47;F
70869;962,710,1648,990,1365,785,1031,1634,698,1390,1417,1130,1641,703,314;60;F
70870;1634,883,823,518,14,1126,840,93;43;M
70883;1455,1137,1130,734,314,637,636,678,1215,1534,1390,797,962,710,1174;35;M
70886;315,883,1031,518,1190,123,1534,1126,1455,514,997,503,1458,1641,1634;32;F
70917;93;8;F
70926;1031,14,814,514,997,710,1174,1115;38;F
70940;1031,1390,814,1097,823,1513,1121,1365,1348,997,1137,1130,314,1634,14;39;F
70944;678,312,1634,1121,518,123,814,1126,1137,56,1130,1458,734,1094,637;39;M
70955;93;5;M
70963;1634,814,833,1130,703;44;F
70971;1513,123,1390,93;40;M
70975;883,14,811,514,503,1130;45;F
70985;1137,1130,734,703,1094,637,1648,1126,952,636,1390,1458,1641,698,314;39;F
70994;14,1097,123,1126,1130,1094,636;33;F
71000;1634,1115;34;M
71002;312,1634,1121,518,123,814,1126,1348,1137,797,1130,1458,734,1094,637;9;M
71024;970,1215,1365,1190,1031,315,785,1534,1648,1126,1001,514,1417,1137,1641;43;M
71026;1215,1390,1001,514,962,93,637,678,353,636,1634,883,123,1348,1458;39;F
71031;312,1634,1121,518,123,814,1126,840,1137,56,797,1458,93,1094,637;5;M
71048;811,1137,503,703,637;44;F
71055;1130,1634,1348,1455,1458,1641,636;40;M
71059;1534,1634,999,678,315,1513,883,518,1648,1126,1390,1137,1130,1641,637;44;F
71074;1634,309,785,123,1126,840,514,997,1417,1137,56,1130,1174,1641,93;36;M
71076;703,312,1634,1121,123,814,1126,840,1137,56,1130,797,1458,1094,637;3;M
71083;93,1634,315,309,1097,1103,1648,1390,1348,1455,56,503,1130,1641,314;19;M
71089;312,678,1513,833,1215,814,1648,1390,1348,1137,1458,314,812,637,636;8;F
71108;312,678,1513,833,1215,814,1648,1390,1348,1137,1458,314,812,637,636;6;M
71125;315,1031,1190,785,1365,1215,1534,1648,1126,1001,514,1417,1137,1641,970;9;M
71143;703,1115,785,503,1137,997,812,1455,1348,1534,1215,1190,823,1031,1634;38;M
71158;93;10;M
71178;93;7;F
71180;26,883,518,14,1097,990,1348,1455,56,1130,970,637;61;M
71194;814,1534,1390,1121,56,1130,1094,970,883,14,1097,1126,1348,1458,698;36;F
71208;26,1634,883,785,123,990,1648,1534,1390,1348,1455,1417,1641,962,970;40;F
71257;1031,1126,1390,1455,1417,503,1130,1641,703;36;F
71267;678,1097,990,1648,1137,56,1130,797,1174,1641;42;M
71274;637,1641,1648,785,678,1634,1513,883,1031,1534,1126,1390,710,1137,1174;37;F
71286;315,999,785,990,1455,1417,1458,1641,970,26,1634,883,1031,1534,1126;71;M
71302;26,309,315,1031,518,785,1648,1126,1455,1417,1641,962,970;70;F
71329;990,1648,1126,840,797,710,1174;36;F
71348;315,309,26,999,990,811,1534,1126,1390,514,1417,1641,703,970,353;39;F
71367;1634,14,1365,990,1648,1417,503,1115;80;M
71376;1534,1648,1126,1001,637,353,1137,514,1634,785,1215,123,811,1641,703;46;F
71381;1648,1458,1641,970,353,314,703,797,1126,990,883,1513,1634,678;71;F
71418;999,636,93,797,1417,1534,1215,14,1031,1634,678,1648,1126,1137,1641;33;F
71424;999,1634,1126,1648,503,1455,1390,309,315,1031,785,1417,990,1534,1641;64;M
71432;1634,1126,1348,1130,1641;39;M
71438;637;34;F
71457;637,503,1137;45;F
71468;1121,1031,14,1097,833,1534,997,1417,1137,56,503,734,1641,703,952;27;F
71477;309,1031,785,1126,1455,1417,1641,962;45;F
71479;1031,999,309,315,1097,990,811,1001,1137,503,1130,1641,703,812,970;45;F
71501;678,315,1634,1534,1648,503,1641;45;M
71507;1417,1455,26,1634,1031,823,518,1190,14,1126,1348,56,1641,970;53;M
71513;990,997,797,1641;34;F
71524;1648,1455,1417,997,710,797,1174,970,1115,26,1031,1534,1126,1641,1634;25;F
71528;1634,518,14,990,1648,1348,1417,997,962;45;F
71534;1634,1215,123,1534,1126,1390,1348,503,1417,1001,514,1137,1130,952,970;29;M
71574;1534,1126,1455,56,970,1634,1031,1417,1641;49;M
71577;1130,970,990,785,1031,1097;42;M
71614;678,518,1190,1001,514,1137,503,314;37;F
71622;56,503,1130,1641,962,1634,518,1097;33;M
71647;1634,1190,811,1126,503,1641,703;43;F
71649;1634,514,1137,503,814,1126,1115;52;F
71650;1634,1513,1126,1390,514,812;34;M
71651;1634,1121,883,1097,123,1103,1126,1137,56,503,1130,703,698,314,1094;69;F
71654;1417,1648,1534,990,123,1365,883,1031,1513,1634,1126,1390,503,1641,703;33;F
71660;1534,1365,309,26,315,1634,1031,823,785,1648,1455,1137,1641,636,1115;47;F
71667;1394,1137,1001,1455,1126,990,14,1031,1634,678,883,514,503,1641,314;57;F
71672;26,1634,785,833,1534,1648,1455,1001,1417,1130,797,703,812,970,353;64;M
71674;26,315,1634,1031,518,1190,785,123,1126,1455,840;40;F
71675;1634,1513,1031,785,14,1365,514,1137,56,1130;35;M
71704;970,990,1103,1097,785,518,823,1031,1513,1121,1634,1094,812,1130,1137;46;F
71705;14;53;M
71713;999,309,315,1513,811,1534,1455,698,637,514,883,1648,1130,1641,703;51;F
71718;1634,26,678,1190,123,1648,1126,1348,1455,840,997,1130,797,703,970;44;F
71727;312,1190,1215,1126,797,1390,1513,1634,999,970,990,1641,1115,1534,883;28;F
71734;1648,1534,1215,883,1513,812,1094,990,1103,1097,518,823,1121,1634,999;73;F
71735;883,14,811,514,1137,56,503,1458,703,812;46;F
71738;312,1094,93,1458,1513,1121,678,14,1097,1348,1137,56,503,636,314;41;F
71741;315,678,1031,785,990,1534,1648,1001,1417,1137,503,1130,1641,703,314;61;F
71746;823,123,814,1126,1348,1455,840,1137,56,503,703,698,1094,636,1115;41;F
71749;312,962,698,970,637,636,315,883,785,1190,14,1390,503,1130,797;46;F
71752;1031,1365,990,1534,1455,1417,1137,785,315,26,1174,1641,703,970,1115;20;M
71753;962,1094,1121,814,812,636;32;M
71754;309,14,814,990,1534,1648,1126,1390,1417,1137,503,1130,1641,93,970;71;M
71767;1513,315,1634,14,1097,1534,1126,1390,1417,56,503,1130,1641,962,314;49;M
71774;309,1634,1031,785,1097,123,1103,1534,1648,514,1417,503,797,1641,1115;51;F
71776;26,309,1634,518,1190,1417,997,503,1130,1458,1641,962,93;25;F
71783;26,315,1634,1513,1031,518,1190,1641,997,503,1455,823,785,990,1126;33;F
71800;833,518,823,1121,1634,1513,1215,1390,1001,514,503,1130,1641,703,1094;46;F
71803;999,785,123,997,503,1130,1641,1031,518,1648,1126;47;M
71807;1634,1031,1174,1641,14;49;M
71828;1031,1190,1126,26,1634,123;50;M
71837;1634,123,797;33;M
71865;312,309,315,1634,883,785,1534,1648,1417,997,1641,314,93,970;40;F
71866;1634,14,1534,1455,1417,1641;30;M
71893;312,309,1634,14,1534,56,503,1130,1641,703,1115;42;F
71903;309,1031,785,1648,1641,703,999,1634,1365,1390,503;44;F
71936;1641,353,503,514,1455,123,1031,1634,26,93;74;M
71947;14,785,1190,1534,1648,1126,1455,514,1417,997,56,1641,962,353,1115;31;M
71949;503,1534,26,999,309,315,1634,1121,1031,785,1648,1417,56,1641,703;47;F
71986;1031,1365,1634,518,1455,997,1641,353;46;M
71997;883,823,990,1348,1458,703,93,503,314,812,315,14,1215,814,1137;68;M
72004;26,1513,1031,518,1190,785,990,1534,1648,1390,1455,1417,997,1641,962;42;F
72054;1348,123,833,785,1031,1634,823,503,1126,1534,26;61;M
72058;833,785,1031,315,309,999,312,1634,1534,1390,1455,1417,1137,503,1641;34;F
72073;1455,1417,797,1634,518,840,1641;24;F
72078;314,840,1648,518,1031,1634,1513,785,123,1390,997,56,1130,1641,93;40;F
72099;309,315,823,1215,990,1648,997,514;71;F
72100;1097,312,1121,1513,883,823,1001,56,1130,698;49;F
72106;1455,1390,1130,1121,1126,1094,710,1641,503,1174,56;37;F
72111;312,678,1115;55;M
72120;1648,1001,703,990,514,1641,797,56;75;F
72124;962,1458,797,1417,1390,1648,1097,518,785,1513,678;47;F
72140;814,811,1534,503,1458,734,1121,1097,1103,1137,1130,1115,314,698,93;50;F
72141;840,26,1390;35;M
72143;883,678;69;F
72152;1137,1126,814,1634,309,678,1513,811,1390,503,734,703;28;F
72159;883,1394,678;74;M
72166;678,1190,1390,1130,970,1634,1513,1031,1097,811,1648,1137,1641,703,637;36;F
72171;636,1121,1031,1513,883,14,1097,990,1001,514,56,1130,1641,970,637;47;F
72186;703,678,1215,1534,1455,56,797;46;F
72194;883,1394,678;43;M
72206;1115,637,1174,710,315;33;F
72216;1634,1001,514,1137;30;F
72229;1215,1190,678,312,1634,1513,883,1365,1534,1648,1348,1641,952,93,637;35;F
72238;1137,1031,312,678,1634,1513,123,1130;35;M
72246;1634,1097,1126,1455,1001,56,1641,952,93,637;32;M
72259;309,26,999,678,1115;65;M
72277;26,999,678,315,1634,883,823,1534,1126,1137,503,1130,1458,637,1641;45;F
72296;315,1634,1121,1031,1534,1417,997,56,1130,1641;52;F
72302;56,1130,1190,26;35;F
72304;970,1115,1365,1534,1648,26,315,1031,785,1417,503,1641;35;F
72330;1121,1031,678,1634,1097,990,1648,1348,514,997,503,1130,1641,636;40;F
72382;1130,1121,1126,1103,1097,1458,970,883,990,514,518,1641,315,56,14;64;M
72389;26,1121,1215,1126,1455,1137,703,637,93,1641,636,797,503,883,1190;53;M
72405;1641;29;M
72431;1130,56,514,1455,1126,1097,1190,883,1121;16;F
72487;1634,1190,123,811,1534,1648,1126,1455,840,1417,997,503,797,1641,1115;54;F
72528;1365,990,1534,1648,1126,1390,1455,514,710,56,503,1130,797,1641,970;33;M
72534;315,1031,1365,1648,1534,1417,1137,14,883;46;F
72545;703,123,312,999,26,315,1634,1031,823,1190,1390,1455,503,797,1641;13;M
72547;678,93,636;59;F
72567;811,1390,1455,1417,56,353,1634,1031,823,1534,1348,503,1130,1641,703;29;F
72569;518,1634,315,309,26,999,1031,1534,1126,56,1130,797,734,1641;27;M
72571;999,1121,1031,518,123,1648,1126,1137,1130,1641,93,309,56,1634,353;42;M
72578;1417,1130,970,636,123,678,1634,997,56,353,1641,518,14,999,1365;34;M
72592;1634,1390,56,503,812;48;M
72601;503,999,309,315,883,785,1648,1126,1455,1130,797,1641,698,970,1115;69;F
72613;93;30;M
72623;999,883,1634,26,315,1031,518,1534,1390,1455,840,1417,997,1641,703;32;M
72630;26,309,315,1031,785,1365,990,1534,1648,1455,1417,710,1174,1641,93;42;M
72686;309,315,26,1031,1097,698,970,990,1534,1648,1126,1417,56,1641,93;33;M
72705;678,315,1634,1513,883,1190,1215,1103,990,811,514,1137,703,314,637;46;F
72742;812,962,734,503,840,1348,1534,811,1121,1097,814,1103,1137,1130,1115;14;M
72746;312,785,1365,1126,1348,962,1115,999,1634,1031,1648,1417,1137,1641,970;45;F
72747;1648,1455,1137,1126,840,1534,990,1641,797,1031,309,315,93,1417,1365;73;F
72752;1215,990,1455,314,1115,315,26,999,1634,1031,1534,514,1417,997,1641;31;F
72762;1513,14,1215,1534,1126,1390,514,997,1137,503,1130,1641,636;31;F
72765;636,353,314,952,734,1137,1126,1215,823,883,678,1634,1031,518,1348;37;F
72772;315,309,999,26,1634,883,1031,785,1126,1390,514,1641,962,970,1094;39;F
72780;1190,814,990,1534,1648,1126,1390,1455,840,514,1417,1641,314,93,970;36;F
72785;1130,1121,1097,970,1094,703,823,514,518,503,1348,93,56,1417,1634;65;F
72803;1130,1121,1097,970,811,703,503,309,315,56;78;F
72825;309,785,14,1126,1455,1137,503;61;F
72828;1455,1390,1137,1121,1126,970,990,1031,309,315,56,1417,785;71;F
72835;823,1215,1001;46;M
72845;1634,123,93,14;43;M
72865;1190,1455,710,970,1115,26,990,1126,1390,1417,1130,797,1641,962,353;32;M
72866;883,1394,678;47;M
72880;26,1534,1126,1455,1641,970;72;M
72898;883,1394,678;41;M
72931;1648,1455,1137,1001,811,703,1534,990,514,503,1031,309,315,678,14;89;F
72934;999,26,309,315,1634,1031,785,1215,990,1126,1455,997,1137,970,353;48;F
72943;678,1641,883,1634,785,1365,14,123,990,1534,1648,1126,1455,1417,353;35;M
72950;93;48;M
72972;637;53;F
72984;1115;55;M
73007;1126,1390,1348,1001,1417,314,637,883,1215,514,1137,503,1130,703,93;44;F
73008;14,1190;63;F
73011;999,1634,1121,1031,1190,14;87;F
73026;1126,1455,1417,1115,999,26,309,1634,1190,785,1648,514,797,1641,970;28;F
73033;999,1417,1130,1115,1031,1534,503,990,1634,123,1648,1126,56,797,1641;30;M
73039;997,797,703,314,812,636,93,1137,1648,1215,883,1513,315,309,678;39;F
73049;93;9;M
73052;814,56,1130,1641,1097,1215,703;47;F
73083;1455,1137,1130,1121,1097,999,997,636,1534,990,518,1641,503,1031,309;75;F
73098;703,698,314,93,812,1094,637,312,678,1121,1097,1103,1137,1130,1115;47;F
73114;1455,1097,309,14;77;F
73136;1513,840,1137,970,518,93;39;M
73146;1648,1126,883,26,678,309,315,1513,1215,1390,1417,1137,93,812,636;14;M
73154;315,309,26,1634,1513,883,1365,1534,1648,1390,1417,1458,962,1641,952;27;F
73160;1130,1126,1103,1097,970,833,812,1094,703,990,1641,309,314;70;F
73173;93,1634,1121,883,123,814,990,1641,314,1031,1126,1137,56,1130,636;47;F
73189;1648,1137,1126,970,840,1534,990,514,1641,1031,309,952,93,1417,785;75;M
73204;503;76;M
73217;678;36;M
73239;1115,1417,1648,1031,26,811,503,1641,970;34;F
73262;1648,999,309,26,1634,1031,785,1365,1455,1417,997,56,1130,1641,1115;33;M
73263;1641,970,312,26,1513,883,1190,14,1126,1390,1455,840,962,703,1094;42;F
73265;999,309,1634,823,1365,1137,1458,952,14;41;F
73317;1390,1348,1455,1001,514,1417,503,1130,962,315,1634,990,56,1641,970;44;F
73320;1190,997,970,1534,990,503,962,1031,312,785,14;74;F
73327;785,1365,1390,1534,797,1417,1031,315,999,309,990,1648,997,1641,970;45;F
73328;710,1394,503,698,314,1094,636,970;31;F
73341;997,999,1634,1031,1190,785,1348,315,970,1417,1455,990,1534,1126,1641;58;F
73342;123,997,1534,26,1417,1031,970,785,1365,990,1115,309,1634,1648,1641;40;M
73364;678,999,1634,883,1031,1534,1126,1455,56,997;55;M
73411;514,785,1634,883,1031,823,1365,123,1648,1417,56,503,1130,797,1641;63;F
73414;1365,883,999,315,1634,309,1031,785,14,1534,1390,1137,1641,970,353;67;F
73423;1455,1126,997,970,883,636,990,1641,503,1031,309,315,1417,785,14;86;M
73430;997,1031,883,1513,1121,1115,1634,518,1190,1097,1534,1126,1390,962,1641;28;F
73432;14,1534,1126,1455,840,1417,1137,56,1641,785,1190,1031,1121,1634,26;46;M
73441;309,1634,785,990,1534,1648,1126,514,1417,503,797,1458,1641,314,970;34;F
73457;1648,1455,1126,999,970,1534,990,1641,503,1031,309,123,315,1365,1634;59;M
73468;93,1641,962,503,997,14,785,883,1634,315,309,678,814,1348,56;41;M
73472;514,1137,1641,703,698,1115,823,14,1365,990,503,1130,812,970;33;F
73482;1455,1390,1126,999,997,970,636,1641,503,962,309,314,315,1417,1634;69;F
73487;1031,1634,315,999,309,518,785,1365,1126,1417,997,56,503,1641,970;46;M
73504;1634,1513,883,785,1365,1097,811,1534,1126,1390,1001,710,1137,1174,703;40;F
73510;1455,1641,962,952,970,26,999,309,315,1513,1031,785,990,1390,797;69;M
73526;1455,1390,1126,999,997,970,636,1641,503,962,309,314,315,1417,1634;68;F
73585;785,1641,812,14,990,1390,1348,1137,56,503,1130;46;F
73590;999,1634,1513,883,1215,1534,1648,1390,1348,1417,1137,1130,1641,812,636;5;F
73608;883;48;F
73634;797,1417,997,1641,970,1648,1534,990,785,1190,1031,883,315,309,26;76;F
73658;1634,315,309,999,26,1121,1455,1641,703,1094,353;39;F
73663;1137,1641,703,93,353,514,1001,811,1097,315,56,698,314,636,1534;38;F
73713;883,1031,518,990,997,970;48;F
73747;1634,1031,785,1648,1417,1641;29;M
73773;1634,14,503;69;M
73781;883,1634,518,1190,1215,814,1126,1648,1455,997,1137,503,1130,1641,93;21;M
73804;14,812,1634,823,518,814,1130,1348;44;M
73862;56,1103,1121,1115;27;F
73863;1215,14,883,1634,312,678,1190,814,1137,734,952,93,812,637,636;28;F
73870;678,999,315,1634,883,14,1215,990,514,637,312,1174,1641;30;F
73941;637,970,314,1641,1137,990,785,312,1634,1513,883,1190,1097,1390,1130;18;F
73949;26,1634,518,785,123,990,1534,1648,1126,1390,840,93,797,997,1455;26;M
73976;1031,1190,785,1365,1534,1348,997,1174,26,1648,1126,1455,1641,14,840;41;M
74004;14,123,1634,1103,1348,56,503,1130,703;42;M
74006;315,785,1648,514,1137,970,1513,883,811,1390,1455,997,93;64;F
74017;315,1648,636,1031,785,1417,997,1641,93,970,309,14,990,1126,797;73;M
74033;1365,823,883,1031,1634,678,518,1190,1648,1348,1455,840,503,1458,1641;32;M
74056;314,637,636,997,1031,1513,785,14,1126,1390,1455,840,1137,503,797;74;F
74059;1641,315,1534,1455,1634,1190,1126,970,990,1417,997,1348,785,1031,999;36;F
74076;93;32;M
74081;309,353,970,1641,1137,1634,1031,14;71;M
74125;26,315,1634,1031,1190,1534,1648,1126,840,1641,678,883,56,503,636;30;F
74142;678,309,315,883,1455,797,1031,990,1534,1648,1417,1641,999,970,503;53;M
74155;1634,14,811,503,1641,962,1115;71;F
74164;1174,797,1126,990,1031,1634,26,785,1365,1534,1417,1641,698,970;43;F
74170;990,1455,1417,1137,1031,315,309,999,678,785,1534,1126,503,952,970;38;F
74190;26,315,1634,1190,990,1534,1455,840,1417,1641;75;M
74216;883,999,1634,1031,785,990,1648,1126,1455,1417,997,503,1641,698,93;9;M
74227;1121,785,814,811,997,797,1001,514,1394,734,952,698,314,883,703;28;F
74228;1174,1634,1641,1534;32;M
74239;999,678,315,1097,990,811,1534,1417,1137,1458,734,1641,703,952,314;35;F
74301;315,1634,1031,1365,814,990,1648,1137,56,503,1115;34;F
74345;309,315,1031,1365,1534,1417,710,797,1115,785,1097,1455,1130,26,1215;23;M
74364;1174,1115,1126,990,1365,1031,999,26,315,1634,785,1534,1648,1455,1641;28;F
74366;1641;45;F
74386;636,314,698,56,315,1097,811,1001,514,353,93,703,1641,1137,1534;43;M
74395;1634,1534;35;M
74406;833,1348,1001,503,1634,14,1390,514,1137,1394,1130,1174,1641,314,637;39;F
74410;883,999,26,315,1031,785,990,1648,1126,1390,1455,840,1417,997,970;64;F
74436;785,14,1365,1215,990,1126,1390,1417,1641,962,314,353;38;F
74466;785,990,1126,812,637,1115,1458,703,314,1365,1534,1648,1455,1641,1634;41;F
74472;1634,1215,990,1648,1390,1001,1417,1137,970,1115,26,1455,56,1641;62;M
74481;1634,883,518,1190,123,1001,514,1417,997,710,56,503,797,1641,1174;50;F
74487;1121,883,710,734;50;F
74547;970,703,1641,990,315,999,26,1031,518,1534,1126,1455,1417,997,797;48;F
74617;315,1634,1031,785,811,1534,1648,1390,1348,1417,56,503,1130,1641;45;F
74630;883,678,1121,518,14,785,514,1137,503,1130,703,698,314,353,636;32;F
74646;678,1634,14,1001,514,1137,503,637;30;F
74662;1365;50;M
74667;1126,1641,970;40;F
74670;312,309,883,1130,1641,636;41;F
74682;1641,970,1634,1365,1103,785,14,1097,833,990,811,503,1130,703,1094;25;F
74713;26,1365,1513,1634,1031,123,1534,1648,1390,1417,1641,970,353,636,1115;39;M
74739;26,823,1031,1190,518,785,14,1365,1534,1648,1455,840,1417,1641,93;37;M
74766;999,1634,883,1031,785,990,1648,1126,1455,1417,997,503,1641,698,93;12;M
74771;1001,1534,1513,514,1031,1634,785,1215,811,1648,1390,1417,1130,1641,970;30;F
74779;785,1634,1648,1455,1001,514,1417,997,1394,503,1641,703,314,970,1115;35;F
74819;1641,883,315,1513,1031,1634,990,1534,1137,503,698,314,678,14,1097;39;F
74842;883,1513,811,1390,1458,703;34;F
74917;518,785,990,1390,1417,26,315,1634,883,1031,1648,1126,1455,1641,970;54;M
74942;309,315,1031,785,990,1534,1390,503,1130,1641,703,970;48;F
74962;1417,1031,999,26,309,315,990,1634,14;46;F
75005;698,1130,518,1634,1121,14;41;F
75029;1137,514,1126,1215,883,812,1094,637,678,315,1634,1513,1031,14,636;41;F
75031;123,990,1648,840,1634,503,797,1641;22;F
75048;999,309,1031,1190,785,123,990,1648,997,26,1634,1390,1455,840,1417;52;M
75055;999,1634,883,1031,785,990,1648,1126,1455,1417,997,503,952,698,93;43;F
75106;970,1130,1641,1115,315,1634,1031,823,785,1365,990,1534,1648,1126,1348;17;F
75118;1121,518,14,1137,56,503,1130;69;F
75134;312,1634,518,14,56,503,1130;14;M
75158;1190,518,823,1031,883,1513,1121,1634,315,309,26,999,312,797,1115;31;M
75189;1634,823,703;37;F
75212;1190,999,309,315,1634,883,1031,1365,1097,1534,1648,1137,1641,970,1115;30;F
75213;1130,1348,1390,990,823,14,797,1641,703,314,812;39;M
75237;1190,1648,997,503,797,1641,353,309,1634,883,785,14,1103,1417,56;30;F
75239;1190,1390,1126,1115,970,93,1641,678,1634,1513,1031,785,123,990,1648;45;F
75273;1031,1190,990,1455,840,309,312,1534,1126,997,56,503,1130,785,1648;27;F
75291;637,56,514,1001,1190,883,1513,678,1534;32;M
75308;514,1455,1648,1534,811,1215,14,1031,1121,315,990,1126,56,703,1130;30;F
75310;1634,314,823,678,503,1130,636,1115;33;F
75319;678,309,1634,785,14,1534,1390,1130,1417,56,1174,1641,703,353,1115;27;F
75345;1121,1031,14,1126,1348,56,503,1130,797,1641,1094;18;F
75406;309,1031,1190,1455,1130,1641;25;F
75407;823,1121,26,678,1130,970,314,14,1215,811,1348,1455,56,703,1458;31;F
75409;26,309,315,1031,518,785,1126,1455,1417,1137,1641;38;F
75437;503,970,997,1390,990,26,315,1031,785,1365,1534,1648,1455,1641,1115;20;F
75447;1634,1031,518,811,1534,1648,503,1641;28;F
75484;1634,1365,1390,503,1130,797,1641,1174;31;F
75495;970,999,309,1513,1348,1455,1417,797,1115,1031,1534,1641,314,93,990;30;M
75503;1365,990,1648,1126,840,997,1031,518,785,1348,678,1458,1641,970;39;F
75553;315,1634,1121,1513,883,1031,823,1190,785,123,990,1390,514,997,503;34;F
75560;1455,1390,1534,123,518,309,315,1190,14,1097,1215,990,1126,797,970;57;F
75565;309,93,812,636,1634,14,123,710,1137,503,1130,1174,1641,962,314;40;F
75589;1137,1641,698,503,1001,1215,833,309,315,883,990,1348,514,952,970;27;F
75600;123,1103,814,1648,1348,1455,1417,1458,1641,698,314,1094,678,823,1097;38;F
75625;1031,309,999,1190,1365,1534,1648,1126,1455,1417,710,797,970,1115,1641;62;F
75638;814,1097,999,1094,970,14,785,315,309,1634,1126,1534,1031;36;M
75650;26,678,883,1031,785,14,990,1534,1417,1137,56,1130,1174,1641,1115;59;F
75671;309,518,785,1365,26,315,1031,1534,1648,1390,1417,503,1641,970,1115;51;F
75673;970,353,315,1513,14,514,1190,785,1390,1348,997,1417,1121,56,503;44;F
75688;56,1130,1458,1641,962,698,970,636,678,1513,883,1534,1648,1390,637;37;F
75697;93,1115;34;F
75712;309,999,1031,14,990,1126,997,503,703,1174,1641;24;F
75742;1115,309,315,518,1215,990,1648,840,1137,514,703,314,353;47;F
75756;1390,315,1031,785,990,1534,1648,1126,1417,797,1458,1174,1641,962,970;46;M
75777;1103,1097,1121,1130,1137,990,1031,1634,883,14,1215,1001,514,997,503;30;F
75792;309,315,1031,14,1097,990,811,1634,1365,785,1534,1648,1417,1641,1115;31;F
75805;1634,1031,14,518,990,1534,1126,1417,1641,970,785,1455,797,962,353;70;M
75843;1641,997,1534,990,14,1190,518,999,309,315,1455,1130,962,314,970;42;F
75844;1641,1348,1648,26,823,1215,1417,123,785,840,1190,1634;44;M
75871;503,1130,797,1641;25;M
75875;1634,1031,1365,1648,1641,1534;25;M
75908;1365,1348,1455,1130,1641;25;M
75971;785,14,1534,1455,1130,503,797,1641,353,1137,1417,883,315,1634,1126;37;M
75994;678,1190,814,514,1417,1137,1130,1458,962,703,1094,637,1634,883,1348;19;F
76009;1121,14,1103,1648,1137,503,703,93,1094,353;67;F
76025;883,315,1634,1513,1031,785,1215,990,1534,1648,1126,1390,1455,1641,812;47;F
76028;1390,26,1365,1534,710,353,797,1417,990,1634,970,1097,1641,785,1031;25;F
76054;1458,970,1634,883;54;F
76055;26,1031,518,1190,14,1348,1455,1417,56,1641,970;52;F
76072;14,1534,1648,1455,1417,56,1130,1174,93,1634,123,990,797,1641,353;29;M
76121;123,1137,503,1115,312,999,309,1634,1513,785,14,1365,1130,1641,353;51;F
76123;1513,1190,990,1390,56,503,1130;26;M
76147;1634,1365,1130,14,1001,514,56,1641,1115;18;F
76170;1513,883,1215,1001,514,503,962,637;6;M
76193;1641,797,56,997,1126,1648,1534,123,1097,1365,14,1634,1190,785,1031;17;M
76205;1126,1001,503,797,314,518,1097,1103,811,514,997,56,1130,1641,703;31;F
76225;1097,1365,1641,797,56,997,1126,1648,1534,123,14,1634,1190,785,1031;18;M
76228;797,1641,56,997,1126,1648,1534,123,1097,1365,14,1634,1190,785,1031;16;M
76234;315,309,26,999,678,811,1001,1417,1137,503,1641,703,952,637,636;40;F
76238;1121,1215,1348,1130,1458,999,1126,1390;42;M
76239;678,315,785,990,1001,514,1417,1137,503,1641,952,698,314,637,636;6;F
76256;997,678,1121,1126,56,503,1130,703;21;M
76263;56;17;M
76335;514,1137,503,1458,1641,93;37;F
76346;123,1130,1641,698,314,1094;29;M
76351;1513,123,1634,785,1365,990,1534,1348,1455,1417,997,1641,353,1115,962;22;M
76354;312,1634,1513,883,14,1390,1137,56,503,1130,1458,314,970;40;F
76361;970,1634,1031,123,1648,1348,56,1641;32;M
76371;811,840,514,1137,503,797,703,812,823,518,1348,997,1458,962,1094;32;F
76376;26,309,1634,823,14,1417,1641,962,970,353;17;M
76390;518,1215,814,1137,797,637,93;38;F
76406;315,1130,353,1634,883,990,797,1641,970;29;F
76425;990,14,315,1634,1031,1097,811,1001,710,56,1130,1458,703,314,353;45;M
76438;1097,1215,123,636,812,1641,997,1417,1001,1455,309,1634,518,1126,1115;49;F
76474;1534,1417,1641,637;34;F
76475;315,1031,1190,785,1365,1215,1534,1648,1126,1001,514,1417,1137,1641,970;11;M
76485;1121,883,14,1097,1103,1130,1641,952,314;26;F
76493;26,309,1634,823,14,1455,1417,1641,962;85;M
76514;26,309,315,1031,518,785,1365,1534,1648,1390,1417,503,1641,970,1115;51;F
76530;1126,1534,990,14,315,999,1648,1455,1417,1641;49;F
76537;785,970,312,999,1634,1513,1365,123,14,503,1137,1130,1641,353,1115;82;F
76554;1634,1390,514,503,1641,1174,710;30;F
76559;1031,811,1417,1130,1641,1115,14,1365,1215,814,1001,514,1137,56,503;42;F
76600;970,999,14,823,309,1634,990,1641;83;F
76620;637,1634,1031,1190,1097,1215,1103,1534,514,1417,503,1130,1641,952,353;26;F
76641;1190,26,1534,14,1103,1455,1130,797,1174,1390,56,1641,353,1634,123;23;M
76642;1634,1031,785,1417,1137,1641;39;F
76653;970,312,999,1634,1513,785,1365,123,14,503,1137,1130,1641,353,1115;15;F
76684;309,26,1126,1348,840,1417,56;46;M
76709;26,999,315,1190,785,1534,1648,1390,1455,514,1417,997,1137,797,1115;41;F
76728;314,26,1031,518,1534,1126,698,93,636,678,883,14,814,1137,1130;44;F
76738;315,1634,1137,1130,93;47;F
76739;678,1513,883,1031,518,123,990,1126,1390,840,1137,797,1458,93,636;11;F
76741;312,999,1634,1513,785,14,1365,123,1417,1137,503,1130,1641,353,1115;13;M
76772;1417,312,999,1634,1513,785,14,1365,123,1137,503,1130,1641,353,1115;10;M
76776;678,1513,883,1031,518,123,990,1126,1390,840,1137,797,1458,93,636;9;F
76799;1190,840,797,1641,93,353;41;F
76802;315,26,678,309,1121,883,1031,833,811,1648,1001,1137,1130,123,503;69;F
76814;353,970,518,1031,26,1634,785,123,797,1641;73;F
76825;1031,883,1634,315,14,1215,990,1417,1001,514,1137,503,1641,970,637;48;F
76830;678,1513,883,1031,518,123,990,1126,1390,840,1137,797,1458,93,636;5;F
76856;26,309,1634,1031,823,785,990,1648,1534,1126,1348,1417,997,797,1641;40;M
76875;678,1513,883,1031,518,123,990,1126,1390,840,1137,797,1458,93,636;47;M
76884;1365,1031,315,999,353,970,1641,514,1390,1534,990,123,883,1513,1634;53;M
76964;1634,1513,883,123,990,1137,56,503,93,353;69;M
76977;999,309,1126,1348,1634,785,1534,1417,1641;41;F
76989;1001,678,1215,637,1534,1634,1115,1641,1458,1455,990,1031,999,1417,710;28;M
77028;678,1215,990,1534,93,636;61;M
77058;1417,309,315,883,785,997,1641,1126,1534,1031,999,26;48;M
77063;1641,797,962,1417,1455,1126,1648,990,1190,1031,1634;24;M
77076;1641,636,990,883,823,518,785,1365,1215,1534,1348,314,703,1115,999;43;F
77095;1455,797,1097,1417,309,1641,999,1031,990,1648,1390,970;37;F
77112;1121,315,678,1634,823,1103,811,1348,514,1137,1130,952,14,1097,1115;63;F
77140;883,1001,503,1455,990,1648,1634;67;M
77185;309,785,123,990,1534,1648,1126,1390,1348,1417,997,1130,1641,314,970;47;F
77198;833,56,1394,503,1641,1094,1121,1130,1634,883,1126,1115,14,1097,703;48;M
77215;1634,1121,883,14,1097,833,1126,56,1394,503,1130,1641,703,1094,1115;46;F
77221;1190,990,811,1534,1648,1126,1455,840,1417,997,503,797,1641,970,1115;32;F
77264;314,1641,26,1634,883,823,14,1348;38;F
77265;1455,840,1001,1417,997,710,797,1641,962,1115,1513,1031,1190,1390,1130;34;M
77266;997,1641,1115,518,14,1097,990,1534,1126,1348,1130,703;47;F
77291;93;74;M
77299;26,999,309,315,990,1534,1648,1390,1455,56,503,1130,1174,1641;39;M
77300;315,883,1031,1365,1215,503,1634,123;48;M
77308;312,1634,1031,823,1648,1126,1348,1137,56,503,1641,1115;42;M
77328;823,518,1097,811,1348,56,1394,1130,734,703,314;30;F
77336;734,637,1190,1137,678,883,1390,797,952,1115;27;F
77363;785,1455,1417,14,1190,999,1634,1031,1534,1126,997,503,797,1641,93;14;M
77379;1390,1174,1634,1121,1031,785,1365,123,1534,1648,1455,56,962,1641,1115;53;F
77388;503,797,970,353,1634,883,785,14,1365,990,1648,1130,1641,962,1115;62;M
77426;1458,970,785,518,883,840,309,315,1634,1031,123,1648,503,797,1641;58;F
77435;26,309,1634,1031,785,1190,833,811,1534,1348,1417,56,503,1641,703;38;F
77442;26,1031,1126,1455,840,503,797,1641,703;44;M
77461;1513,883,1097,1126,1390,514,1417,1137,962,952,314,970;34;F
77479;26,315,1634,1031,1190,785,990,811,1534,1455,840,1417,56,503,1641;36;F
77502;1634,1001,314,503,1137,1455,990,814,1097,315,970;73;M
77527;1458,1130,997,1455,1648,123,1634,1121,823,1190,1126,1348,1137,56,1115;39;F
77537;883,1126,93,636,678,1634,123,797;39;M
77539;1031,1137,1641,698,503,1534,990,1634,315,14,1126,1455,514,1417,1130;35;F
77580;1648,1348,1455,1001,1417,1137,503,1130,1458,1641,314,93,1094,970,637;46;M
77588;1130,970,1634,315,1121,1513,785,1365,1648,1455,56,1174,1641,962,1115;53;M
77590;503,1534,1103,1097,309,315,1634,785,1031,14,1126,1390,1348,1458,1174;32;F
77598;26,315,1634,1031,518,123,1534,1648,1126,1348,1455,1417,1174,1641,353;40;M
77599;1103,1455,1417,997,1137,56,1641,314,1031,14,1126,1390,1348,1458,1174;53;M
77608;14,1097,1103,1126,1348,1417,997,503,1130,797,1174,1641,314,812,678;48;F
77631;93;40;M
77659;312,315,1634,1513,785,1215,990,1534,1648,514,1417,997,1641,637,883;40;F
77670;93;7;M
77686;823,14,1097,840,1130,26,309,1634,518,1190,123,1126,1348,56,1641;43;F
77721;990,1215,1513,315,678,999,883,56,1130,997,1634,1121,1031,1190,1097;14;F
77728;93;1;M
77729;1031,1190,123,811,1648,1126,1455,514,1137,503,1130,734,1641,703,952;26;F
77731;93,883,678,1634,797,314,636;13;F
77751;1103,703,678,1121,14,1097,1215,814,990,811,1137,56,503,1458,1641;38;F
77795;678,1634,883,123,990,797,93;10;M
77809;1534,1648,1455,1001,514,1417,1137,503,1130,1458,1641,698,970,637,1115;52;F
77833;1534,1648,1417,997,785,1097,1103,1126,56,503,1130,962,703,1634,1641;73;F
77845;1634,14,1365,1215,123,1534,1648,1126,1455,710,1137,503,797,1174,1115;71;M
77852;518,1634,123,990,1001,1417,1458;37;M
77882;1031,1534,997,503,797,314,353,990,840,1641,636,93,1190,518,26;72;M
77886;833,14,883,1121,1513,823,1190,1097,811,1390,1417,56,503,1130,970;48;F
77897;315,309,999,14,123,990,1534,1348,1417,1130,797,1641,314,970,636;7;M
77916;1115,1634,503;20;F
77918;1001,503,1130,970,514,1390,1126,1513,1031,811,1648,952,1137,93,637;38;F
77921;1126,1001,514,1417,997,710,1137,56,970,1130,1641,314,637,1121,883;27;F
77927;315,1190,990,1130,1641,1115,883;22;F
77941;1031,990,1534,1648,1455,1417,1641,970;44;F
77962;312,678,1121,883,1031,823,1190,14,1097,814,990,1455,503,997,1137;11;F
77964;26,883,1130,123,1634,315,678,1126,997,797,1641,314,636,93,970;37;F
77974;970,353,1115,93,315,1634,1513,1190,14,990,1648,1126,1390,1455,514;20;F
77976;1126,1534,518,315,999,1031,312,785,1648,1001,514,1641,970,353;44;F
77987;1001,1417,56,962,812,315,1031,1534,503,703,1634,1648,514,1130,1641;47;F
77991;814,1641,1634,1513,1534;32;M
77994;883,309,1634,1031,1648,1534;41;M
78020;678,309,1031,1190,14,1097,990,1534,1648,1126,1455,997,1174,1641,314;66;F
78021;678,26,1190,14;56;F
78025;970,1534,1648,1190,883,315,123,1031,1634,26,1390,1417,797,1641,314;33;M
78046;503,970,26,315,823,1215,1001,1641;52;F
78077;56,503,734,309,14,840;57;M
78083;811,1534,1648,1348,1455,840,997,1641,314,26,1634,518,833;44;F
78088;1534,990,1634,26,123,56,503,1130,353,315,1348,840,703,93,637;49;F
78089;26,315,518,1190,785,123,990,1534,1648,1455,840,997,797,1641,93;50;F
78100;1190,883,999,309,315,1513,14,1215,990,1126,1455,1001,514,1641,970;45;F
78125;1458,678,1121,883,14,1097,1215,814,990,811,1001,1137,56,503,703;5;F
78150;812,970,353,962,1130,56,1137,1348,1215,785,823,883,1634,26,312;45;F
78171;1348,1513,14,990,1390,1641,314,93,970,353;49;M
78188;1365,26,315,883,1031,1190,785,1648,1534,840,797,1641,93,637,1115;14;F
78205;26,1190,785,840,503,797,1641,962,636,970;51;M
78231;678,26,315,1634,883,123,1126,997,1130,797,1641,314,93,970,636;7;M
78252;1634,1513,1365,1215,1390,1001,514,1641,962;25;F
78259;811,1534,1648,1455,997,797,1641,703;38;M
78262;997,1417,990,123,999,1634,1215,811,1126,1455;36;F
78286;1121,883,1190,1097,1103,811,1390,1001,997,503,1130,1458,1641,703,1115;20;F
78290;678,26,315,1634,883,123,1126,997,1130,797,1641,314,93,970,636;1;F
78311;1390,514,785,797;31;F
78318;26,315,518,1190,785,123,990,1534,1648,1455,840,997,797,1641,93;54;M
78323;514,1365,14,785,1190,1513,999,1634,1031,823,518,1534,1126,1390,1455;45;F
78350;312,678,1513,883,1215,814,952,353;33;F
78399;1634,1031,1365,1174;54;F
78407;1648,1641,1534,1455,1417,1390,1031,997,990,840,26;34;M
78410;814,1648,1126,1348,1455,1417,997,56,503,1130,1458,962,703,314,1094;10;M
78411;1190,1121,1634,1534,1648,1390,1348,1455,840,1137,503,797,1641,962,1115;50;F
78417;26,315,518,1190,785,123,990,1534,1648,1455,840,997,797,1641,93;76;F
78418;1126,1115,1634,785,1365,1455,1641;18;M
78443;1634,785,123,1126,797;41;F
78464;26,315,883,1031,1190,785,1365,1534,1648,840,797,1641,93,637,1115;15;F
78477;833,1215,1001,514,1137,56,503,1130,636;41;F
78479;990,123,785,518,1031,999,26,1634,1455,840,1417,503,797,1641,353;28;M
78499;503,14;45;F
78506;1513,1348,514,503,962,637;27;M
78531;123,314,1641,797,1137,1634;42;M
78533;999,26,1634,1031,518,1534,1126,1455,1417,970,309,315,990,1648,1641;49;F
78546;56,785,1390,1126,123,1190,1513;42;M
78553;1455,1641;46;F
78564;312,883,812,1121,1190,14,1097,1215,1103,840,1001,514,503,1130,797;13;F
78567;312,1634,14,1103,1390,1348,514,1417,997,1641,314;29;M
78577;637,123,1130,990,1648,1455,1634,1365,785,1534,1417,1641,970,678,503;11;M
78585;1190,1534,1455,1634,123,797,353;42;M
78626;1634,1513,883,823,518,1190,14,1097,814,1126,1390,840,93,812,1094;45;M
78627;999,1634,1031,990,1534,1648,1455,1417,1130,1641;50;M
78640;797,999,970,1115,1648,1126,309,1031,123,990,1534,1417,997,1641,93;43;F
78654;1458,734,952,970,812,314,312,1121,883,518,1103,997,503;12;F
78664;309,1634,1648,1130,1641;51;F
78749;1634,518,93,997,840,1348,990,123;37;M
78767;1513,990,1458,999,678,315,883,1634,1031,1534,1648,1455,1417,797,1641;50;F
78774;840,1126,883,312,1115,353,1390,1365,1031,1513,315,1634,785,1348;47;M
78779;1137,1417,1126,1648,1534,518,1031,1634,309,1641,1115;62;M
78821;678;49;M
78889;309,999,1634,883,1031,785,1365,1534,1126,1455,997,1417,1641,962,1115;24;F
78920;1115,503,1137,1634,309,678,315,1513,883,1190,990,1390,840,797,1458;16;F
78952;1126,840,997,970,797,1390,123,1641,962,26,1513,1634,785,1417,56;45;F
78956;1634,14,514,56,703,1648,1390,503,353;49;F
79067;1365,785,315,309,1634,883,1031,518,1097,811,1126,1137,56,503,1641;39;M
79088;785,1190,1031,309,678,315,1634,1365,1534,1348,1417,997,1137,1641,93;18;F
79108;1634,883,1513,1137,703,785,1390,503,1130,514,314,962;43;F
79116;1094,1121,309,999,312,1634,1031,814,1348,1455,997,503,1130,1641,636;43;M
79118;14;15;F
79133;14;15;F
79142;1634,1121,514,1365,14;44;F
79202;1121,1513,1031,315,1634,14,785,123,814,990,1126,1390,514,56,1641;49;M
79207;1634,1031,785,1365,123,1648,1126,1001,514,997,1417,710,503,1174,1641;35;M
79223;1190,785,14,814,811,1534,1648,1348,1137,56,503,1641,93,812;41;F
79230;710,1365,1190,1390,353,797,840,1455,785,1634,123,1534,1417,1174,1641;42;M
79249;999,309,315,1115,14;50;F
79259;314,970,1121,315,312,1513,1031,785,1534,1390,56,503,1130,1641,962;47;M
79264;1634,1097,14,1137,56;44;M
79308;314,1641,1130,503,514,1348,1103,1215,518,823,1031,1513,1121,315,999;23;F
79325;93;50;M
79330;999,1641,703,353,1648,503;28;F
79413;1215,883,309,1513,1097,1648,1641;41;F
79419;1031,1634,811,1390,514,1001,997,710,1174,1641,962,952,314,93,1115;24;M
79421;1031,785,1365,1215,990,1534,1648,1126,1348,514,1458,1641,93,637,636;10;M
79430;883,1215,1126,1455,1001,514,1417,1137,503,797,1641,703,93,812,636;41;F
79432;14,883,1634,315,309,999,636,1641,1137,1417,840,503,26,678,1115;39;F
79433;1417,314,678,309,315,1634,1031,518,1097,1126,1137,503,1130,1458,1641;39;F
79437;1513,26,999,1634,1031,823,811,1648,1348,1455,503,1130,1641,970,1115;21;F
79466;123,990,1103,1001,1417,997,1130,734,1513,1648,1390,514,1137,1641,952;23;F
79467;637,678,315,1648,514,503;49;F
79474;1641,1458,1417,514,1126,1648,1534,990,1215,1365,785,1031,1634,315,26;6;M
79479;93;42;F
79482;1417,1634,1031,123,997,315,26,785,1534,1648,1126,1455,840,1130,1641;22;F
79487;26,999,309,315,1634,1031,785,990,1534,1648,1455,1417,1641,970,1115;37;M
79493;990,1190,840,1174,26,315,1031,785,1365,1534,1648,1126,1455,1417,1641;17;F
79540;1190,990,840,1215,514;32;M
79576;997,1031,1190,312,1634,1513,123,1534,1126,1390,1455,840,1417,797,1641;38;M
79580;999,1121,1031,1190,1126,1390,1455,1001,1417,997,56,503,1130,1641,1115;23;F
79584;315,1031,1215,1348,1390,637,1513,1137,1130,514,636,1634,314,1458,883;23;M
79591;1534;58;F
79628;999,315,1634,883,1190,785,1215,990,1648,514,1417,997,1641,952,314;26;M
79657;26,315,1031,1648,1534,1417,970,1641,710,785,999,14,990,1115,1365;38;F
79664;883,14,1097,833,56,1394,1130,1641,703,1094,1115,1121,1126,840,503;14;M
79679;1121,1190,1097,833,1215,1137,962,823,518,1126,840,1001,514,503,1130;18;F
79699;883,1137,636,1641,637,312,315,1634,1513,14,123,1648,1126,1390,1458;45;F
79731;309,999,312,315,1634,1031,833,1534,1417,503,1458,1641,678;54;F
79733;1534,814,1031,1121,26,678,309,315,883,518,14,1001,514,1137,503;38;F
79734;315,1031,518,785,14,1097,1648,1348,1137,503,1458,1641,952,812,970;32;M
79743;1417,637,1137,514,1455,1390,1534,990,785,1031,883,1634,315,1641,970;54;F
79758;315,1634,1121,1190,14,1097,814,811,1348,1455,797,1458,703,314,93;49;M
79779;1390,1348,514,997,1137,56,1130,797,1458,734,1641,962,314,812,970;34;M
79821;1365,14,883,999,678,1634,1031,785,1126,1417,1458,970,1115,1137,1641;40;F
79835;1641,1534,123,1634;33;M
79844;1634,1513,14,123,1534,1648,1390,840,710,1137,797,1174,698,314,93;33;M
79956;26,312,1534,990,123,1215,14,518,883,1513,999,678,1634,1648,797;36;F
79988;999,309,1031,990,1648,1641,970;46;F
79989;883,1534,1126,1137,1130,734,703,952,970,353;35;F
80014;1513,315,309,999,1031,785,1365,990,1534,1648,1390,1455,1417,1641,970;31;F
80016;1031,1417,1641;26;M
80083;1634,14,1534,1348,1417,710,1137,56,503,1174,1641,703,970,353;39;F
80114;26,999,309,315,1031,518,785,1534,1648,1126,1455,840,1417,1174,1641;30;M
80128;883,1097,1390,514,56,503,1130,952,637,1115;32;F
80130;1137,56,503,703,314,636,1641,698,1634,14,1215,814,514,1130,1174;45;M
80143;1641,1634,1031,785,1648,1455,56;47;M
80150;1097,1001,1390,990,1215,1513,309,315,1348,314;42;F
80171;14,1097,1215,814,811,1390,514,1137,56,1394,503,1130,734,637,636;38;F
80180;1534,811,1031,315,309,1634;25;F
80213;315,1121,1513,1031,518,785,814,503,812,678,883,1390,1348,1137,314;7;F
80221;1534,1390,1417,1130,1121,883,1190,1348,1137,56,503,1641,703,812,1094;46;F
80234;952,1137,1130,962,1390,999,883,518,1534,1648,1126,514,1417,797,1641;37;F
80235;514,503,56,1641,1130,1126,1103,1097,1094,999,353,811,785,703,123;42;F
80236;1121,1031,1126,1097,503,14;74;F
80267;1126,1001,1137,93,812,970,312,1121,883,14,1215,56,503,637,636;43;F
80292;1094,1634,1097,1215,1137,1130,1641,703;40;F
80387;1390,514,678,1031,811,1534,1648,1137,503,1130,1641,703,952,314,637;30;F
80413;785,1348,1455,1130,314,970,636,1126,678,309,1634,518,1648,797,1641;64;F
80419;14;42;F
80452;1126,1634,1031,123,990,1534,1455,797,353;26;M
80453;1126,990,1215,1031,1634,315,312,518,1534,997,710,1174,1641,970;30;M
80457;14,710;30;F
80477;1634,1513,1190,14,123,1534,1390,997,1130,1641;30;M
80491;1215,1103,814,1348,1641,314,93,636;12;M
80511;353,1115,314,503,1634,14;37;F
80533;1121,56,1513,883,1031,518,1534,1126,1390,503,1130,1641,703,1094,353;40;F
80541;678,1215,93;10;F
80552;56;16;M
80600;1097,1215,1001,14,990,514,1137,503,1641,703,698,812,637,636,1534;44;M
80602;814,123,823,883,1121,999,309,1634,1097,1001,514,1137,503,1641,703;45;F
80610;1648,1126,1458,840,703,1534,514,1641,1031,1394,314,315,93,1417,14;66;F
80647;785,14,1365,710,1137,1174;29;M
80649;518,26,970,1115,1031,785,1648,1126,1455,1001,514,56,503,1174,1641;33;F
80658;823,518,785,814,811,1648,1348,1130,698,93;68;M
80676;970,812,703,797,503,997,1348,1390,1190,518,1634;19;M
80678;1126,999,315,1031,1534,1455,1417,997,1641,353,1634,1648,1348,1001,514;37;M
80682;14;42;M
80685;1137,1121,1126,503,1348,1634,14;74;F
80717;1121,1097,1001,883,811,703,503,1513,314,315,56;70;F
80722;1348,710,56,1174;30;F
80745;833,814,1534,315,678,514,1137,503,1458,1641,952,970,785,1031,26;37;F
80750;1390,514,997,710,56,1130,1174,1365,1641,1634,1031,1534,1417,1115,999;31;M
80753;1648,1390,1126,999,970,883,636,1534,990,1641,1031,315,1417,785,26;72;F
80809;1130,970,811,703,514,503,962,123,315,785,1634;72;F
80819;883,518,698,1634,1031,785,123,990,1534,1648,1126,1455,1417,1641,970;51;F
80825;1641,1115;48;M
80835;1137,678,1634,785,123,999,1417,26,1190,1126,1390,1455,840,797,1641;37;M
80848;1455,1190,1001,997,811,703,514,1641,503,1417,14;72;F
80869;678,1126,123,785,1634,952,1137,1121,883,1215,637,636,1390,503,514;22;M
80876;1513,1215,1390,1455,514,1130,1641;44;M
80895;1190,1097,997,812,811,703,514,503,797,315,56;68;F
80900;999,26,315,1031,785,1365,990,1534,1648,1455,1417,997,1641,703;68;F
80904;1121,1455,514,1130,1641,962;23;F
80913;970,823,312,315,1097,811,1001,637,812,1137,1417,514,833,1215,678;45;F
80914;811,1634,309,840,1417,997,56,503,1458,1641,703,353,1115,710,1174;44;F
80920;315,1001,1137,1641,636,1115,309,1634,1031,518,785,123,1648,1126,353;33;M
80921;1001,1641,503,1031,1348,314,14;11;F
80924;1365,1031,315,990,1458,698,1115,970,1634,1513,518,14,1390,1137,56;62;F
80943;1190,1121,797,1634,1031,678,123,1641,962,970,93;40;M
80961;1215,990,1648,1126,1348,1001,514,1417,56,1458,970,678,123,1641,93;40;F
81029;999,997,1137,1130,636,637,514,1001,1390,1126,1215,833,315,678,312;44;M
81044;785,698,1365,1455,1115,1513,1390,1648,1031,990,1641,970,1417,1634,1534;29;F
81050;93;4;M
81058;1648,1455,1215,1137,1121,1126,514,503,1031,1348,14;49;F
81080;1648,1097,999,997,1534,1641,503,1031,309,315,353;79;F
81122;1648,1097,999,997,1534,1641,503,1031,309,315,353;78;M
81145;1190,1130,997,812,703,990,503,797,315,56;71;M
81153;1634,883,785,1215,811,1648,1390,514,1137,503,1641,314,812,637,1115;18;F
81165;14,1115;63;F
81166;1137,1097,1001,990,514,503;63;M
81189;823,14,1097,123,1348,1455,840,1417,797,1458,1641;35;M
81216;1534,1126,1390,1130,1094,1634,26,1190,14,1455,840,1137,503,797,1641;59;F
81221;883,315,785,990,637,970,1115,999,309,1031,1534,1648,1455,1417,1641;35;F
81227;1097,997,1417,703,312,678,1215,1126,1001,514,1137,1641,812,970,637;12;M
81245;1534,1126,997,26,1031,518,123,514,503,797,1641,703,812,1115,970;35;M
81263;814,1390,1417,56,962,812,14,1534,1648,1126,1348,1137,503,1458,1641;35;F
81271;1634,1121,823,518,1190,785,123,1390,1348,840,1001,514,1417,56,1130;53;F
81302;833,990,811,1390,56,703;35;F
81307;952,1648,1094,1115,1365,883,1513,1634,785,811,56,1130,503,962,703;31;F
81352;93;13;M
81359;797,1641,812,636,637,1137,514,1126,1648,1215,1513,309,999,678,312;10;M
81399;999,315,1365,997,1641,309,1634,1031,785,1534,1648,1126,1455,1417,1130;37;F
81402;1365,678,1455,698,883,1031,1534,1648,1417,1137,503,970,1641,514,785;23;F
81415;1394,1001,514,1348,1634,678,814,883,503;44;M
81461;56,503,1130,1641,703,93;44;F
81473;678;37;F
81476;315,1121,883,1103,990,1126,1390,56,503,1641,1455;13;F
81477;1634,823,123,1455,353,518,93,26;36;M
81490;1365,1031,678,999,1513,990,1534,1648,1390,1455,1417,1130,1641,970,1115;57;F
81496;1641,962,703,314,636,637,93;36;M
81509;514,309,315,883,1031,518,1215,990,1648,1126,997,1137,1458,1641,93;70;F
81520;678,1634,883,123,1130,797,734,314;28;F
81544;26,1634,1031,1365,1215,123,1534,514,1130,734,1174,962,703,952,1094;51;M
81555;710,734;26;F
81584;26,315,883,1097,811,1534,1648,840,514,56,503,1130,703,1115;47;F
81601;999,315,1634,1031,518,990,1534,1648,1348,1455,1417,56,503,797,1641;41;M
81612;678,1126,797,1137,314;38;F
81613;1634,1121,1097,1103,1534,1455,503,56,1130,797,1641,314,1115;28;M
81631;123,514,997,1130,678,1513,1190,14,1215,1001,1137,56,797,1641,637;42;F
81637;309,1534,710,1641,1417,1126,1648,811,990,1103,1097,14,1031,315,999;30;F
81665;814,785,678,309,1634,883,14,353,990,1534,1648,997,1115,503,1641;30;F
81667;1097,14,999,678,990,1390,1348,997,1137,56,503,1641;48;M
81681;315,309,883,1215,1534,1390,1455,1001,514,1137,1641,962,703,637,952;43;F
81714;883,785,990,1390,1126,1348,1417,56,1130,1458,703,26,1634,970,503;28;M
81758;93;40;F
81771;840,1648,990,123,518,883,309,999,1634,1031,1126,514,1130,1641;27;M
81813;1365,1031,1348,309;34;M
81821;123,14,1190,1634;38;M
81822;1513,1121,1634,309,999,1534,698,1094,636,678,14,1097,1137,56,797;37;M
81869;678,1634,1031,14,1394,314,1126,637,93,1115;42;F
81871;1137,1455,1126,1648,1534,1365,785,1031,309,315,1634,990,710,1174,1641;31;F
81880;26,1190,785,1097,1215,123,990,1126,1455,840,1001,514,1417,997,1641;40;F
81884;26,785,1097,1215,123,990,1648,1126,1455,840,1001,514,1417,1641,970;11;M
81896;1348,503,1130;47;M
81914;26,999,312,309,315,1513,1190,785,1534,1648,1390,1455,1417,797,1641;52;F
81944;999,990,1534,1417,970;48;F
81947;1126,1534,990,1215,1365,785,1031,883,1121,1634,315,312,999,1390,1513;32;F
81955;1115,1634,14,123,1648,1137,1641,93;10;M
81958;1174,1641,785,14,1534,1126,1417,710,734;29;M
81961;312,999,309,315,14,1365,1215,990,1348,1455,997,1137,56,503,1534;43;F
82006;785,1365,309,1634,1031,14,123,1648,1455,997,503,1137,1641,93,1115;8;F
82029;1126,1648,14,883,1634,309,26,1513,785,1365,990,1534,1390,1641,970;45;F
82050;1634,518,14,123,1534,56,503,1130,1641,703,93,812;48;F
82056;970,1115,999,1031,785,1365,990,1648,1126,997,1137,1641,952,698,56;36;F
82073;1031,518,785,1534,1126,1417,1641;22;M
82079;315,1634,1513,883,14,1215,1103,1390,1348,514,503,1458,812;44;F
82085;1031,1534,1390,1417,1137,503,1641,970,1634,710,1174;40;M
82094;1513,315,309,999,503,1130,1458,1641,962,703,56,1390,990,1190,1634;30;F
82114;1641,314,785,93,636,1115,309,1126,997,698,970,1513,883,710,1174;45;F
82120;312,678,636,1513,997,1390,1215,883,1031,309,315,1634,514,503,1641;47;F
82139;315,1634,26,999,990,1455,840,637,1115,309,123,1534,1126,1417,1641;34;F
82148;883,678,1513,14,1390,637,93;39;F
82188;797,962,1534,990,1190,1031,315,309,26,999,1634,123,840,1130,1641;28;F
82196;1190,990,962,970,1634,1648,997,1641;61;M
82203;1458,883,1137;38;M
82207;1458,503,1137,1417,514,1534,990,814,833,785,883,1634,315,309,26;35;M
82218;1103,1348,1001,1417,56,1394,503,1641,703,970,1634,1031,514,997,1137;50;M
82226;710,1130,1641,26,309,315,1513,1190,14,1365,1534,1390,797,1174,970;27;F
82228;997,503,1458,93,309,678,315,1634,990,1126,636,1137,1394,1641,970;46;F
82240;1634,1126,514,1417,1641,970,1455,1648,1534,990,123,883,1031,518,698;50;M
82269;636,990,1215,518,1031,26,309,883,1648,840,1417,1137,503,1641,703;58;F
82291;999,636,1115,503,883,315,678,1031,1365,785,1641,123,1215,1190,1634;26;F
82340;309,315,1634,1031,785,1365,990,1534,1648,1455,1417,56,1130,1641,970;30;F
82352;970,1641,1174,840,990,123,1190,1031,1634,26,353,962,797,997,1417;56;F
82401;814,1215,833,1097,312,1121,823,14,1348,503;19;F
82486;797,1534,1648,1641,1126;39;M
82529;1634,999,315,785,990,1648,1001,514,1417,1641;68;M
82552;814,811,1001,1137,56,1130,637,353,312,315,1121,883,14,1097,514;46;F
82555;1634,518,1648,1455;79;M
82568;315,309,26,999,1634,1031,1190,123,1126,1455,1417,997,797,1458,1641;28;M
82580;1641,312,1634,1513,1534,1126,1390,1455,840,514,1137,734,952,314,970;35;F
82594;309,518,123,1648,503,26,315,1634,1190,14,1126,1455,840,997,1641;71;M
82622;1215,833,14,785,518,1031,1634,315,309,999,1365,1648,514,503,1641;31;F
82624;315,883,1190,1648,637,999,1390,1455,1641,1031,997,1126,840,970,26;52;F
82636;1190,990,56,1130,93,970,315,883,14,1097,1348,514,503,797;36;F
82640;1097,1455,1001,1394,797,1641,1031,785,990,1534,1390,514,997,503,883;60;F
82647;1215,678,1121,883,1190,14,990,811,1648,1455,1137,56,1641,636,1115;41;F
82660;315,1031,1348,1534,1634,1190,1137,1130,962,1094,1455,1513,1390,1126,1641;32;M
82668;734,997,1648,1126,990,785,309,1634,1031,1534,1390,1417,1458,1641,970;42;F
82690;999,1634,1031,14,1126,1455,56,1641,1115,1094;11;F
82725;315,1634,1031,1190,1097,123,1534,1455,1417,1130,797,1641,703,1126,503;27;F
82731;1130,503,840,1534,123,833,1097,1190,518,1031,1634,315,309,26,999;60;F
82736;1215,1031,1634,883,56,1130,734,962,678,1126,514,1137,503,1641,636;34;F
82741;1634,883,1031,1365,990,1534,1648,1126,1455,840,1417,710,1137,1641,636;38;F
82755;1455,990,315,785,1417,1641,970;75;F
82771;1097,785,315,1534,1126,1455,514,997,56,503,1130,797,1174,703,970;56;F
82776;309,315,999,785,1365,833,990,1534,1126,1417,503,1641,703,93,353;49;M
82783;26,1634,518,1190,123,1103,1534,1126,1455,840,56,797,1174,1641,1115;32;M
82823;999,309,1115,1641,1417,1001,1455,1534,811,1648;18;F
82858;1130,1417,1126,1648,1534,123,1121,999,309,1031,785,1390,56,1458,1641;16;F
82882;1215,1190,1031,1634,309,678,883,14,1417,1137,503,797,1641,1115,314;36;F
82884;1513,315,26,785,833,814,1534,1001,514,1137,503,1458,698,314,1094;65;F
82901;823,26,93,309,1031,1455,840,678,1126,1641,123,999,637,314,797;20;M
82972;823,56,962,703,970,1115,1634,14,785,1137,503;63;F
82980;999,26,315,1031,785,1365,1215,990,1126,1417,797,1641,970;42;M
82997;1126,1390,1001,514,1417,1137,503,1130,1458,1641,353,1115,315,1634,14;40;F
83001;883,315,999,309,785,14,1365,811,1001,514,56,503,962,1094,970;50;F
83011;514,1001,1103,883,1121,315,309,518,14,1097,1365,997,503,1130,314;24;F
83055;1390,1126,1215,1097,1190,883,1634,309,312,1513,1348,503,962,952,93;22;M
83092;999,309,518,785,1031,1634,26,962,990,1534,1648,1455,1417,1641,970;54;M
83097;883,123,814,1137,1394,797,314,93,812,637,636,678;43;M
83110;1031,990,1534,1455,1417,997,1641,962,999,315,1130,1390,514,1215;70;F
83131;1130,970,990,812,883,999,315,1458,1648,1126,1455,123,353,1641,1634;28;M
83150;1634,312,678,1121,785,1097,814,997,56,503,797,1641,353;12;M
83173;1417,997,710,1174,1641,1115,312,309,1634,1513,990,1390,797;30;M
83204;785,123,1534,1390,514,970,1641,1130,503,1365,1634,14;78;M
83213;1534,1648,123,1103,785,14,1365,823,883,309,678,312,1115,1458;41;F
83233;797;42;M
83246;1634,1348,503,93,1115;24;M
83252;315,1513,883,1365,833,814,990,1534,514,1137,503,1458,636,785,26;3;F
83287;883,1348,1126;48;M
83320;93;19;M
83372;811,1115,353,962,56,710,1001,1534,123,1365,518,1031,1634,309,999;35;M
83375;637,1458,503,1137,514,1534,814,1215,833,1365,14,1190,315,309,26;90;F
83387;814,1390,1001,514,1137,503,1130,1458,734,962,1641,703,952,970,637;22;F
83398;1455,1115,1417,1031,999,518,14,1365,1534,1648,710,1137,797,1174,970;34;F
83410;1513,518,14,1390,1137,503,1174;67;F
83416;14;46;F
83439;785,678,999,26,309,315,1031,990,1534,1648,1455,1417,1174,1641,1115;37;F
83462;1455,503,1115;38;F
83498;1365,1190,1634,1513,1031,814,1390,1130,797,1641,703,314,93,812,1094;31;M
83519;990,678,315,26,785,833,814,1534,514,1137,503,1458,703,952,812;60;F
83526;315,1634,1001,1417,997,56,503;28;M
83551;315,26,1634,883,1031,1190,990,1534,1648,1126,1455,1458,1641,962,636;64;F
83554;14;70;F
83569;518,1365,1097,1126,514,503,1641;16;M
83570;678,1190,123,1534,1455,1137,56,503,1130,797,1641,703,314,93,636;36;F
83596;1534,1641,1137,503,514,814,833,785,1634,315,26,678,1458,970,353;90;M
83639;1121,1097,1103,1137,1130,1115;45;F
83662;1121,1390,797,314,883,1513,14,1137,1458,93;11;F
83670;823,811,1390,1458,703,314,698,14,1001;59;F
83748;1417,710,1534,1365,1634,315,1121,1215,990,514,56,503,1130,1641,812;16;F
83762;1534,1390,1455,1417,1137,1458,1174,1641,14,1215,123,990,1648,1126,997;72;M
83782;1634,123,1126,797,1641;26;M
83786;1390,1215,1190,785;42;M
83830;1103,1348,1001,997,1137,503,93,1121,1190,1097,840,514,56,1130,797;49;M
83855;309,703,314,970;27;F
83857;1390,1417,997,999,315,1031,833,1455,503,1634,990,1534,1641,703,970;66;F
83922;1121,14,123,811,503,1130,734,1641,703,952,93,1094,970,637,636;35;F
83949;1641,970;32;F
83961;999,1634,1121,1513,883,1190,785,1097,1215,123,1126,1390,1455,514,797;35;F
83969;93,312,999,1513,823,785,833,1215,1031,1348,1455,1641,703,1634,883;35;F
84009;1130,1121,1634,309,823,518,785,14,1215,1097,1390,514,56,503,1641;67;F
84014;1634,518,1190,14,990,1126,1455,840,1001,514,1417,997,1137,56,1130;40;F
84061;1648,1390,797,970,1126,1417,503,315,785,1634,823,123,1455,1641,353;51;F
84062;14,1115;72;M
84086;811,1534,1126,1390,503,1130,1641,703,812,637,1634,883,785,990,1648;46;F
84087;1215,883,1634,123;41;F
84098;503,703,314,1094,353,1137,1215,1513,1634,312,1174;28;M
84114;309,1031,785,1126,1348,1455,840,1417,56,1130,1458,1641,962,970,636;20;M
84144;1115,636,314,883,1031,785,797,1641,312,678,1634,14,1648,1137,503;36;F
84160;1634,883,1031,785,123,990,811,1534,1648,1417,503,1641,970,353,1115;33;F
84199;1634,883,1031,785,1455,1417,997,1137,503,1641,970,353;72;F
84212;797,698,970,678,1634,518,123,1648,1126,1348,1455,1130,1641,314,636;64;M
84233;1348,1126,1648,1534,990,814,123,1365,14,785,1031,883,1634,678,312;37;F
84256;710,1174;35;M
84258;1121,785,14,1534,1126,1390,1417,56,703,309,1031,990,1130,1641,970;44;F
84266;1513,1031,1534,1455,734,952,353,309,1634,990,1126,1390,1137,970,637;50;M
84329;309,518,1126,1417,970,840,990,315,999,26,1634,1031,1190,1534,1641;60;F
84350;785,1513,315,1634,990,1390,1417,1394,1458,1174,1641,962,703,952,970;26;F
84411;1031,26,1513,1190,990,1534,1648,1455,840,1417,503,1641,970;52;F
84437;811;65;F
84458;1534,503,1174;42;M
84465;26,309,1634,1031,1190,785,1365,123,1534,1126,1455,1417,997,1641,962;30;M
84468;1634,1390,734,1641;55;F
84469;1641,1417,997,1455,1534,990,785;48;F
84482;26,315,785,1534,1648,1115,309,1634,1031,1365,1641;25;F
84502;823,1031,309,26,1634,518,1190,14,123,1126,1455,1417,797,1641,93;42;M
84529;812,1513,1130,1634,14,833,814,811,997,1137,56,503,1641,314,93;41;F
84547;812,990,1648,1390,840,1417,797,1634,999,93,970,1534,1458,785,1641;27;M
84555;883,1031,518,1190,1365,123,1126,1390,1455,840,1417,1137,503,1641,314;69;F
84668;1115,1126,518,1634,14,1534,1348,1130;45;M
84671;1455,1417,503,1458,678,309,315,883,518,14,990,1126,56,314,970;71;F
84711;999,26,309,315,1031,785,1365,990,1534,1648,1455,1417,1641;43;F
84712;678,309,1130,1031,1097,990,514,1137,997,1174,1115,314;63;F
84718;970;23;F
84773;1648,1455,962,1641;34;F
84799;1534,1648,1126,1390,1455,1001,514,1417,997,1137,797,1641,314,353,1115;28;F
84806;309,315,1031,785,1534,1648,1417,997,503,1641,703,1634,14,123,1126;64;F
84849;999,26,309,315,1634,1031,785,1365,123,990,1534,1648,1126,1455,1641;46;M
84850;1348,1417,970;23;M
84877;811,999,315,1031,1190,785,14,1534,1455,1417,1641,353,1115,56,503;50;F
84921;315,309,999,1417,1634,1031,14,1365,990,1348,1115,1641;19;M
85013;999,315,1121,1031,1534,1648,1417,56,1641,970,1348,1458;43;M
85032;785,123,1126,1641,999,833,1097,1215,811,1390,514,56,503,1130,703;37;F
85036;999,26,309,315,1031,990,1648,1126,1455,997,503,1641,703,698,970;38;F
85074;1534,1365,785,312,1634,1126,1390;48;M
85131;1641,1126,1534,990,1455,1417,970,315,1348,785,1190,1031,1634,999,997;26;F
85142;990,883,1121,1513,14,1215,1390,840,514,1137,797,1458,314,93,636;40;F
85165;999,315,1634,883,1031,1215,1648,1390,514,1417,1458,1641,962,703,952;20;F
85167;883,1190,999,315,1031,1634,990,1534,1417,710,1458,1174,1641,698,970;31;F
85182;1174,970,1455,1365,999,14,1534,514,1417,1115,1031,309,1126,503,1641;25;F
85195;1365,1097,1103,990,1390,997,56,503,1641,962;19;F
85197;315,678,312,1031,785,14,811,1126,1001,1137,503,1458,1641,703,314;39;F
85249;315,1031,1190,785,1365,990,1534,1126,1455,1417,1394,1130,1641,698,970;18;F
85263;1513,14,797,93;38;F
85266;315,1031,785,14,1365,1534,1126,1455,514,1417,503,1130,1641,703,1115;34;F
85274;1513,1031,1190,1365,1534,1126,1390,1455,840,1417,997,1130,1641,962,1115;33;M
85305;1390,315,518,840,514,703;71;F
85308;315,309,811,1648,1390,1001,514,997,1137,1394,503,1641,703,698,353;76;F
85317;1634,1534,1390;40;F
85346;785,1455,1137,503,1534,1634,309,26,315,1648,1417,56,1130,1641,93;17;F
85353;678,1513,883,1031,1097,1390,1348,514,503,1458,1641,703,353;43;F
85357;1634,1121,823,1190,785,123,1126,514,56,503,1130,1641,962,93,1094;28;M
85393;678,26,315,1634,1513,883,1031,823,14,785,1215,1534,1641,1126,1390;21;M
85398;1190,1031,1634,26,1215,1001,514,1137,503,1130,734,1641,703,952,1115;35;F
85414;1641,812,637,636,315,1121,883,14,1648,1348,514,1137,56,503,1115;45;F
85429;678,312,1634,883,990,1455,970,1115;33;F
85452;999,309,315,1634,1031,1097,1534,1126,1001,514,1417,1641;29;M
85455;1190,1455,1641,1126;30;M
85456;990,1534,1648,1455,840,997,1137,503,1130,1641,952,314,970,637,636;72;F
85471;1648;26;M
85475;883,1634,1031,785,123,990,1648,1455,1417,56,797,1641,698,970,1126;30;M
85491;785,315,309,1455,999,710,514,1115,1031,1365,1534,1648,1417,1641;40;F
85495;990,1215,1190,1031,503,514,1001,1126,1534,811,1097,1634,315,309,1130;32;F
85496;698;32;M
85502;1390,637,1121,1513,883,14,1215,840,514,1137,797,1458,314,93,636;42;M
85544;811,814,1634,518,1190,1534,840,1641,1031,14,1126,1390,1348,1458,1174;48;M
85545;678,26,518,1190,1126,1455,840,997,1130;33;F
85568;514,1648,1534,1190,883,678,785,14,1215,123,1137,93,1121,1634,503;46;M
85579;1031,1634,26,1513,1126,1390,1348,1417,503,1641;43;M
85582;1190,999,309,1648,785,518,1031,315,1417,997,56,503,797,1641,962;70;F
85583;1115,1417,1126,1648,1534,990,315,1031,26,1455,1174,1641,703;28;F
85597;1634,1121,1137,1130,1513,785,14,1365,1115;50;M
85603;1641,1031,14,518,999,1365,1417,1115;33;M
85658;1634,840,1455,514,1417,997,710,1137,1130,797,1174,1641,962,970,1115;27;F
85661;999,1634,518,14,1365,1534,1648,1417,56,1130,1174,1641,962,353,1115;38;F
85669;26,883,518,990,1648,1455,1641,970;62;F
85699;1634,1031,785,833,990,811,1126,1455,840,1417,710,503,1130,1174,1641;18;F
85712;883,315,26,678,1031,1190,1534,1648,1390,1455,1417,997,503,797,1641;31;F
85714;1513,678,315,1634,883,518,1097,811,1417,514,710,503,1130,797,703;29;F
85745;1174,14,1215,1648,710,1137,503,734,1641,1115;41;F
85748;1634,1534,1390,1417,1513,1031,1348,503,1641;43;F
85778;514,56,698,503,314,1094,883,1001,734,1634,1031,1455,1097,962,637;32;M
85818;26,1641,518,997,999,1126,797,703;73;M
85831;315,1121,1031,1190,785,14,1097,1103,1348,840,56,503,797,1458,812;17;F
85834;637,970,636,1121,514,1137,503,1130,1458,990,1215,14,823,1031,1634;42;F
85845;999,1031,785,1365,833,811,1001,1417,710,503,1174,1641,703,353,1115;37;F
85857;1417,1641,999,26,309,1031,785,1365,123,990,1534,1648,1126,1455,970;27;M
85859;518,1215,814,970,1634,883,1031,990,1534,1348,1417,1641,703;40;M
85906;1641,1115,999,26,309,315,1031,518,785,1365,1534,1648,1126,1455,1417;41;M
85950;309,1097,1534,1126,1390,1130,797,1458,1641,353;70;M
85957;990,1534,1648,1126,1455,1417,1641,970,833,811,1390,1001,514,503,703;42;F
85965;14,1097,1103,1390,1137,503,1130;46;M
85991;1455,797,1641,93,840,1126,123,14,1190,518,823,1031,1634,315,26;12;F
86020;1534,1126,26,1031,823,518,1190,14,123,1648,1455,840,797,1641,93;6;M
86031;1641,636,1455,315,997,1130;73;F
86034;1634,1513,883,514,710,1137,1174,1641;27;F
86040;309,315,999,1634,1031,1190,785,123,990,1648,1126,1455,1417,1130,1641;41;M
86080;999,309,315,1031,785,1365,1534,1648,1126,1455,1115;67;F
86115;1130,637,1115,970,1641,1137,1534,1513,309,678,883,1215,990,1648,1390;68;F
86166;785,1348,26,1634,883,1190,1215,123,1534,1455,1137,1130,1641,703,353;41;F
86182;970,999,309,315,1031,990,1534,1126,1641;51;F
86183;1634,1534,1390,1417,1513,1031,1348,503,1641;11;F
86194;1394,1130,698,970,999,315,883,518,1190,990;51;F
86217;14,309,1097,1130,797,1458,1641,962,353;72;F
86223;1121,1348,1455,1365,14,785,1190,823,1031,1634,315,1641,93,1115;15;M
86225;1634,1121,1215,503,1130,1094,1534;47;M
86234;1137,1115,1126,1634,1513,785,1390,514,1417,997,56,1130,1641,962,970;30;F
86257;1365,636,970,997,840,1348,990,999,1634,1031,1534,1648,1455,1417,1641;29;M
86270;1455,840,997,1130,970,678,1634,1031,123,1126,1390,1417,56,1115,1641;33;M
86276;811,990,1513,1348,514,710,503,970;46;F
86277;1634,1126,1390,1348,1417,503,1641;15;M
86278;1390,1126,823,315,1031,999,1634,1513,14,123,990,1534,1455,503,1641;40;M
86290;970,1641,503,997,1126,1534,990,1215,785,1190,1031,1634,315,309,26;69;F
86357;1417,883,315,309,678,1513,785,1215,1390,1348,503,703,952,314,637;22;F
86361;785,1121,315,309,1634,1190,14,833,123,811,56,503,1130,797,703;47;F
86390;678,1634,814,1126,997,503,797,1458,734,1641,952,698,314,93,636;31;F
86392;1455,840,997,1137,56,314,312,1634,823,1190,1348,503,962,93,1115;54;F
86400;1115,353,970,1641,503,1648,1534,990,811,785,14,1031,315,309,26;27;F
86410;1126,1348,840,1417,1641,1634,823,14,811,1001,514,997,56,1130,703;57;F
86411;1417,1126,997,785,503;36;F
86426;999,309,315,1031,785,1365,990,1648,710,503,1130,1641,314,970,1115;55;M
86437;309,999,312,1634,518,990,1348,1417,1130,1641,962,703,698,314,970;69;F
86445;93,678,1348,1455,840,1137,1641,315,1634,883,1031,1126,514,503,637;27;M
86473;123,1534,1115,353,970,962,1641,1390,1648,990,1215,785,1031,1513,1634;43;M
86489;315,309,999,14,503,1641,1417,1130,514,703,1126,1001,1534,883,1634;32;F
86529;710,1174;34;F
86543;883,990,314,312,1103,1390,1137,1115;26;F
86558;833,1126,503,703;75;F
86570;1031,14,1365,1534,1648,1001,514,997,1417,503,999,883,315,785,93;18;M
86589;1126,1390,1455,1001,514,1417,997,1137,56,1130,797,1641,962,698,970;50;F
86590;710,1174;36;M
86602;999,309,315,1031,785,1365,990,1648,710,503,1130,1641,314,970,1115;25;M
86608;1130,970,309,315,1634,883,1534,1648,1641;49;F
86609;883,1648,514,503,1130,1641,637;36;M
86655;840,1417,997,1174,698,1641,1190,1365,26,1031,1534,990,1648,1126,970;49;F
86673;518,840,1417,56,1394,1130,1641,698,93;35;F
86676;93;39;F
86680;840,514,797,1174,1641,952,93,812,637,353,1115,823,1190,1634,123;32;F
86693;315,26,312,1031,785,123,990,1534,1648,1126,1417,797,1458,1641,970;44;F
86696;353,797;22;M
86726;990,833,1190,518,1031,315,309,785,1097,811,1648,503,93,1094,970;71;F
86749;883,1031,1648,1348,56,1394,1513,1634,14,1137,1130,1641,1094,636;39;F
86750;123,514,1115,1641,1130,1417,1348,1455,1390,990,1365,1513,315,1634,309;47;M
86809;1137,710,503,1174;37;M
86823;315,1634,1097,811,1417,997,56,1130,1641,703;54;F
86828;56,1121,1137,312,26,309,315,883,823,1190,785,1365,1126;41;M
86866;833,1365,1097,1190,518,823,1513,315,999,678,312,14,814,970,637;44;F
86905;710,1174;37;F
86932;970,503,1137,997,1417,514,1001,1390,1648,1534,990,1215,1031,1634,315;37;M
86937;26,309,315,518,1190,785,1365,123,990,1126,1455,840,1641,962,1115;41;F
86949;14,637,315,1634,883,1534,503,1031,1126,1001,514,56,1130,1641,703;61;F
86964;518,785,14,833,811,1534,1648,1126,1390,56,1130,1641,962,883,1634;33;F
86967;315,823,785,1215,1455,1417,1641,314;34;M
87029;1648,1390,1458,990,123,1190,1031,1634,26,1126,1455,840,997,797,1641;39;M
87050;312,1031,1458,970,1534,1365,999,710,734,1126,1174;34;F
87056;1365,962,93,518,1190,823,883,26,678,1513,1126,1634,123,1390,1641;17;M
87060;1130;20;M
87080;14,1215,514,952,1097,1137,698,785,1365,1534,1390,797,1513,1634;21;F
87107;811,1001,812,883,1215,1130,514;44;F
87127;1174,734;29;F
87138;1001,1137,56,1394,503,1130,1458,703,952,314,93,812,1094,637,353;51;F
87150;1534,14,1031,315,1634,1513,883,990,1390,514,710,1394,1174,1641,970;40;F
87158;14;38;M
87165;970,353,1115,14,785,26,315,1031,990,1648,1534,1455,1417,1137,1641;38;M
87204;1634,1031,1137,503,970,353;39;F
87213;1634,785,1365,990,1534,1126,514,1417,503,1641;26;F
87287;514,1455,1390,1534,990,785,1031,1634,710,1130,1174;32;F
87307;1534,123,785,315,999,309,1634,1513,1031,990,1648,1390,1417,997,1641;34;M
87326;1348,1417,1458,1513,1390,990,1641,970,883,1130,1031,123,1634,14,833;38;M
87349;514,997,710,999,309,315,1031,785,833,1215,1126,1455,1417,1137,1641;36;F
87421;315,1031,785,970,1534,1126,1458,952,1641;39;F
87425;14,999,1215,514,1417,997,503,1641,314,353;26;M
87437;636,1634,309,315,883,1031,123,990,1648,1417,734,1641,952,314,678;32;F
87484;315,1126,1001,514,123,1115,999,952,1137,637,518,1634,14;36;M
87515;312,1215,811,1648,514,1137,812,970;46;F
87526;1137,1130,970,797,698,1634,314,353,1534,990,315,883,785,1348,514;13;F
87544;1634,1031,785,1365,990,1534,1126,1390,1348,1455,514,1137,1458,637,503;46;F
87570;1121,883,1031,1215,814,1534,1126,1001,56,14,1648,514,1137,503,93;46;M
87578;990,840,1115,26,1634,1641,353;56;F
87587;678,309,315,883,1031,785,811,1534,1417,1137,1458,1641,703,314,970;70;F
87604;883,785,1103,990,1417,1641,636,1031,1215,1648,1126,514,1001,962,952;53;M
87628;315,883,14,123,1126,1390,1001,514,503,1458,1641,703,970,1094,812;50;F
87633;14,734,952;33;F
87641;514,637,999,785,1348,997,797,314,1137,315,883,1215,990,1126,1641;75;M
87655;678,1215,1103,1001,514,56,503,1458,703,952,1121;27;F
87664;833,14,883,1513,315,26,1121,1634,734,1641,811,1648,1455,1031,1390;70;F
87669;312,678,309,883,785,990,56,1641,314,970;44;F
87673;56,1031,315,309,26,999,1634,123,1126,840,1641;55;M
87681;518,1455,797;50;F
87685;785,678,123,1390,997,314,312,823,1641,883,1031,1634,1126,1348,56;18;F
87715;1634,1513,1031,1126,514,26,309,883,1190,123,990,1648,1390,840,1641;44;F
87745;636;45;F
87761;703,353,309,26,1634,1121,518,1190,1097,1126,840,56,503,1130,314;45;F
87763;785,123,1390,1348,997,1458,1641,703,314,312,678,883,823,1634,1126;50;F
87784;353,823,314,812,1513,1190,123,1126,1390,797,1130,1634,14,1348,1458;14;M
87787;315,1031,1365,1534,999,997,1641,26,309,990,1648,1455,1417,797,970;72;F
87798;1121,1513,1097,1534,698,518,785,14,1365,1390,1130;49;F
87806;823,785,514,56,503,1130,883,1031,1365,1115;31;F
87813;1031,1513,1215,811,1648,1126,1390,503,1641,93;65;F
87836;312,678,309,883,785,990,56,1641,314,970;13;F
87851;1031,309,999,833,1534,1634,315,698,1641,1458,785,990,1648,710,1174;63;F
87866;312,678,309,883,785,990,56,1641,314,970;7;F
87874;1634,1513,14,811,1390,1455,1001,514,997,503,1130,962,703,952,353;33;F
87904;14,970;47;F
87921;1534,1648,1126,1390,1455,1417,503,797,734,703,1641,962,952,1115,93;32;M
87972;678,309,1031,1534,1390,503,1634,883,518,14,1641,93;30;F
87973;1115,1641,840,1455,1126,1648,1534,123,1365,1190,518,1031,999;38;M
87989;309,315,1634,1513,883,1215,1390,1348,1001,514,797,1458,962,93,636;5;M
87991;26,518,1190,785,1455,840,1137,503,797,1641;44;F
87992;1634,1534;37;M
88002;514,1390,811,1103,1215,14,1031,883,1513,309,999,503,1641,703,1634;25;F
88006;812,1215,1513,1534,1648,56,1130,1137,14,503,1365;41;M
88018;678,883,1190,123,990,710,1458,637,797,1174,93,1513,14,1390;30;M
88022;1215,123,811,1648,1126,1455,1001,514,1417,1137,503,797,1641,703,637;14;M
88045;1634,518,14,811,1648,503,1641,703,1115;35;F
88050;1121,883,1031,1365,1534,1137,56,1130,1641,314,970;36;F
88071;1115,970,1641,1190,315,883,1365,990,1534,1417,1634,1031,785,1648,962;37;F
88077;811,990,1103,309,1513,1031,785,1097,1648,1390,1455,997,1394,1130,1641;47;F
88078;1094,314,952,703,734,503,1137,1001,1455,814,123,1215,518,883,1634;46;M
88082;1513,1390,1455,1641,999,503,883,1031,518,1097,1534,1648,1126,997,93;67;F
88113;883,785,14,1097,814,1534,1390,1417,710,56,503,1130,1641,962,1174;42;F
88137;1126,990,814,518,1513,1190,14,1215,1390,1348,1455,840,514,503,797;15;F
88140;309,1031,990,1126,1634,823,1097,123,1648,997,56,1130,797,1641,314;34;F
88161;93,1115;37;M
88182;678;40;F
88183;26,1634,990,1031,785,1365,123,1534,1455,840,514,1417,1130,797,1641;36;F
88191;678,309,315,1513,1031,990,1534,1126,1390,1455,840,997,1417,1641,970;33;M
88250;309,315,1031,1215,1534,1648,1390,1455,514,1417,503,1641,962,678,883;20;F
88288;1390,970,1641,997,1126,1648,1534,1097,14,1031,1513,1634,315,309,999;35;F
88293;883,1634,814,1348,1001,314,1458,1121;49;M
88320;518,990,309,26,315,1031,785,1534,1648,1126,1417,1641,962,314,970;73;F
88321;823,1121,315,309,26,999,1634,1534,1648,1455,1417,1641,812;49;M
88327;312,26,999,123,1215,1097,1365,1190,1634,1455,1417,503,1130,1641,703;37;F
88333;14;11;M
88338;1001,514,503,1130,703,309,315,797;54;F
88347;1130,315,1634,1121,990,811,1648,997,56,703,314,970,353,14,1031;63;M
88349;883,1390,1634,1513,1097,1215,123,503,1130,734,1641,952;34;M
88372;811,1097,1190,1121,1634,518;29;F
88402;811,514,56,315,14,1215,1137,503,1130,353;40;F
88434;14;9;F
88449;309,315,1634,785,1365,990,1534,1648,1115,970;47;F
88453;703,812,353,636,1031,1190,1215,814,1534,1648,1390,514,1137,503,1641;36;F
88494;309,315,1513,1031,1534,1390,1348,1641,314,970;27;F
88517;518,14,990,811,1390,1001,1417,56,503,1641,962,698,812,970,1115;45;F
88566;1126,1648,1534,833,14,1137,812,970,1115;50;F
88578;785,1190,309,883,1126,1115;41;F
88583;1634,1126;36;M
88607;811,1534,1348,1001,56,962,1121,1097,514,1417,503,1130,1641,703,970;37;F
88643;514,1215,14,1634,636,678,811,1348,997,503,1130,797,734,703,952;70;F
88714;999,1513,1365,833,1126,1390,1001,1417,997,503,1641,952,637,353,1115;72;F
88719;1390,1001,1417,997,1458,1641,703,353,1634,14,1215,1348,514,1137,503;39;F
88733;514,1137,56,703,314,1094,637,636,1634,1097,710,503,1458,734,1174;26;F
88738;309,999,315,883,1190,990,811,1126,1390,514,997,734,1641,962,970;72;F
88790;312,518,503,1130,1126,14,823;13;M
88812;1534,1031,1634,315,309,962,703,990,811,1126,1390,997,1001,56,503;50;F
88832;309,1390,1348,1001,1417,1031,315,1513,56,1215,811,514,1137,503,1641;43;M
88842;999,26,315,309,1190,785,990,1534,1648,1126,1455,1417,997,1641,970;50;M
88852;997,1417,785,315,1641,970,1001,1031,999,503,514,1390,1126,1215,1634;19;M
88860;1348,315,1634,1455,1417,1137,503,797,678,309,1031,14,123,1641,353;47;M
88878;990,1417,1641,1634;45;M
88887;1126,999,26,309,315,1031,518,990,1534,1648,1455,1417,1641,698,970;15;F
88888;14,990,997,56,1094,637,1634,1215,814,811,1648,1348,1137,1458,93;39;F
88900;811,14,990,997,56,1094,637,1634,1215,814,1648,1348,1137,1458,93;42;M
88913;314,353,636,999,678,309,1031,785,14,1348,1417,1137,1130,1458,637;39;F
88915;503,703,314,812,970,678,1534,1648,1390,1001,514,1417,1130,1641,637;34;F
89006;678,315,1513,883,14,1215,814,1390,514,1137,503,1458,812,637,636;40;F
89016;1634,1513,1365,1097,1103,1534,1390,1417,1130,1641;54;F
89041;1126,785,1031,309,315,1634,1455,1417,1115,1641,1534;52;F
89065;812,353,1121,1513,1097,962,1094,1103,1348,56,503,1130;44;M
89082;1001,812,833,312,1513,518,1097,811,1390,503,797,703,314,353,636;69;F
89096;1513,883,518,1390,970,637;67;F
89156;990,1648,678,1634,1031,14,1215,814,997,1137,56,1458,93,1094,637;7;F
89157;823,518,1348,797,678,636;39;F
89164;315,309,1634,990,785,1648,1417,1641,970;73;M
89180;840,309,26,1455,1417,1641;49;M
89191;1137,1394,1417,1455,1097,785,1634,315,309,999,1031,1648,503,1130,1641;38;F
89250;990,1534,1417,710,797,970,999,309,1031,785,1455,1174,1641,1634,1365;29;M
89263;1031,1513,1215,1137,518,823,883,1001,514,1634,785,123,1534,1455,1417;30;M
89274;1534,797,26,123,990,1634,1390,1455,1001,514,503,1641,637,970,353;32;M
89275;1031,1648,1126,1417,997,962,999,518,1103,1390,1001,514,1130,1641,503;30;F
89288;678,1634,14,1215,814,990,1648,1348,997,1137,56,1458,93,1094,637;5;M
89289;637,1130,503,1137,1417,1215,309,315,785,1365,1001,1031,1126,514,1641;35;F
89291;1126,1417,1458,1174,970,1115,1365,883,1634,678,1137,698,637,353,636;36;F
89304;26,1115;62;M
89324;734,812,1634,1513,1390;35;F
89336;315,1390,1455,840,1130,970,26,518,1190,785,1001,514,503,1641,93;48;F
89342;814,123,883,1634,312,1121,518,514,1137,56,503,1130,1458,314,93;29;F
89368;703,797,1648,123,1190,518,883,1634,814,1390,1348,1137,56,503,637;42;M
89418;990,811,1390,1417,997,710,503,1641,970,1634,14,1365,1174,1115;22;F
89454;14,1126;43;M
89474;1348,1137,503,1130,637,1648,123,1365,999,312,309,1634,883,14,1115;37;F
89476;1390,1130,1174,353;40;M
89477;1031,309,26,315,883,1121,1190,1365,1534,1455,514,1417,56,1130,1641;43;F
89495;1634,1513,1215,123,1103,1648,1390,1455,1417,797,1174,1641,812,970,353;29;F
89496;785,1365,990,1534,1126,1417,1641,353,962,1458,1348,312,503,812,14;16;M
89513;997,999,315,1097,1534,1648,1455,1417,1130,309,1641,1031,785,990,970;44;F
89528;710,503,1634,1174,353;28;F
89544;309,1634,1031,315,518,785,123,1648,1126,1348,1455,997,1130,1641,636;33;M
89549;1121,1634,999,309,315,785,14,1365,990,1534,56,314,1115,970;48;F
89572;312,1513,518,1097,833,811,1390,1001,503,797,703,314,812,353,636;71;M
89590;1634,1121,1190,1097,990,1126,1455,1417,1137,56,1130,734,703,698,970;38;F
89593;1513,312,26,1121,823,1190,14,1215,56,503,1130,1115;44;F
89600;1190,990,26;66;M
89613;678,315,1634,883,1031,785,123,990,1648,1126,1417,734,1641,952,970;32;M
89635;1455,1130,1094,1115,312,309,1634,1121,1365,1390,1417,1137,1458,1641,812;14;F
89651;1534,1103,999,1097,1348,1137,1458,1634,883,1031,785,990,1648,1641,1126;39;M
89663;678,883,1215,1648,1455,1001,514,1417,1137,797,952,314,637,353,1115;51;F
89674;1031,312,823,123,1648,1137,637,1634,883,518,14,833,703,970,353;64;F
89702;315,1634,1103,1121,1031,990,1348,1137,56,503,1130;41;F
89715;315,309,26,999,678,1634,883,785,14,1365,990,1417,1458,1641,1115;4;M
89769;1634,1513,518,785,123,1126,997,1394,797,962,698,812,970,1390,14;16;F
89774;1634,26,1513,123,1348,1390,970,823,518,785,14,797;47;F
89785;970,990,1534;55;F
89791;1365,883,503,990,785,1031,1634,315,1126,1455,1417,997,797,1641,970;75;F
89796;1121,503,56;15;M
89835;353,314,1641,1130,1137,997,1001,1390,1648,1534,1031,883,1513,315,1115;70;F
89838;1648,93,14,1534,1126;68;M
89903;26,1031,1190,14,1534,1648,1126,1455,840,997,503,1130,797,1641,1115;22;F
89914;56;16;M
89920;315,1634,1121,883,785,14,1365,1097,1648,1126,1417,997,1137,56,503;38;F
89923;123,1190,518,1634;47;M
89925;1121,1190,1417,997,503,1130,1641;19;M
89930;883,14,1001,314,1634,990,514;21;F
89931;1417,503,93,678,1634,883,14,1534,1648,1348,1137,797,1641,636,1115;41;F
89934;962,734,56,997,514,1390,883,1513,1634,1215,1001,503,952;29;F
89947;1126,1417,1458,1641,1121,1097,833,1103,1348,1390,503,1130,703,1094,970;17;F
89960;1641,315,26,1634,1513,883,823,1190,990,840,514,1458,93,637,353;44;F
89965;312,678,309,883,785,990,56,1641,314,970;43;M
89998;1001,698,514,997,1137,734,952,970,1641,990,1031,315,1634,883,703;32;F
90008;883,785,1097,1455,997,637,1115,1634,1215,814,14,1365,1137,1458,1174;45;F
90054;14,814,1126,1455,840,1417,1137,503,797,1641,703,636,93,970,1115;43;F
90066;314,962,1641,1458,1130,514,315,312,1634,14,1348,1001,997,1137,503;44;F
90069;1634,1513,811,1534,1390,1001,514,1137,503,1130,734,1641,703,952;32;F
90128;999,990,1648,1348,1130,1641,970,353,1634,123;42;F
90144;1634,883,14,123,1534,1648,1390,1137,503,1130,797,1641,93,1094,636;9;F
90158;26,315,518,123,990,1534,56,1634,883,1031,785,1417,1174,1641,970;43;F
90168;811,14,1190,823,883,1121,1634,1130,734,703,962,952,314,970,637;22;F
90214;952,1126,1634,503,123,1115,1534,1031,990,999,636,785,1365,1641;27;F
90253;823,518,970,811,26,315,1634,1031,785,1648,1126,1417,1641,1513,833;43;F
90260;26,315,1031,785,1126,514,997,1394,1641,962;26;F
90282;312,26,1634,1031,823,1190,1648,1390,1455,514,93,636,1115,1126;34;F
90341;990,678,1634,1513,883,14,1215,123,1648,1130,797,1641,93,1094,636;6;F
90378;1130,678,315,1031,518,1097,990,1455,1001,56,503,1641,703,637,636;70;F
90390;999,1634,883,1031,1215,123,811,514,1137,503,1641,703,812,637,353;49;M
90445;785,26,1634,1031,518,1190,123,1534,1648,1126,1455,840,997,503,1641;37;M
90487;814,1390,1130,314,93,636,503,1137,1348,1126,1097,14,883,1634,678;44;M
90503;26,309,1031,518,14,1190,1103,990,1534,1648,1455,840,797,1641,970;37;M
90510;999,315,990,1534,1648,1455,710,1641,962,970;60;F
90520;93;7;F
90543;93;5;F
90552;309,1513,1365,1534,514,56,503,962,703,970,353,1634,1031,123,1390;30;M
90621;1001,514,734,952,315,1031,1190,997,1634,785,1365,1534;19;F
90654;1513,1121,315,1634,1365,1648,1390,514,1137,503,1641,1115;38;F
90671;1634;50;M
90692;1137,56,1394,314,312,1634,1513,1390,1417,1458,1641,962,698,1094,970;53;M
90704;990,1126,1137,1641,314,812,1634,811,710,56,503,1130,1174,703,1094;17;F
90749;1634,1121,1031,1348,1130,1115,1365,503;50;F
90752;26,315,1513,1031,823,518,1190,840,1534,990,1126,1390,1348,1641,314;42;F
90754;883,1190,14,1126,1390,503,1641,952;29;F
90755;840,514,1137,1174,353,703,1634,123,814,1534;39;M
90772;26,785,1534,1455,1001,710,811,1126,503,1115,315,883,1648,1390,1641;31;F
90815;999,518,785,1390,1115,1641,840,1455,1126,26,309,1190,1534,315,883;46;F
90848;1513,309,315,1031,785,1648,1455,997,1390,1126,1534,999,970,990,1641;39;M
90862;997,503,1641,698,636,678,883,14,814,1534,840,1137,1130,314,93;44;M
90892;811,503;23;F
90896;1513,1417,1031,315,785,1648,1455,997,999,990,1534,1126,1390,1641,970;38;F
90934;1648,1455,1137,503,1458,1641,812,637;66;F
90945;1634,1031,785,1365,990,1534,1648,1126,1455,1417,1115,997,1641,703,970;40;F
90992;678,999,1634,1513,883,1215,990,1121,14,1390,1001,514,1137,56,503;45;M
91009;970,637,636,678,823,990,812,1348,1031,785,1390,1513,883,1215,93;41;F
91047;999,26,883,823,518,1190,785,1126,1455,840,1417,56,503,1130,1641;42;M
91067;1634,1648,1390,1417,997,1130,734,1534,970,785,1126,1641,990,1031;39;F
91093;678,1634,710,1130,1174;32;M
91099;1215,1031,309,123,1534,514,970,1634,883,990,1417,710,1174,1641,952;25;F
91107;678,503;32;F
91120;883,518,997,797,1458,970,637,636,1190,1215,123,990,840,56,812;45;F
91129;811,990,14,1634,823,518,785,1648,1390,503,1130,797,1641,703,970;32;F
91152;734,703,314,952,1130,514,1001,811,1103,1097,14,309,1634,315,503;56;F
91184;814,1103,1534,1126,1390,1348,514,1137,503,1130,1458,1641,970,812,93;64;F
91188;123,785,797,678;40;F
91215;1634,1513,123,1534,1126,1390,1455,1001,1417,997,503,797,1641,962,970;68;F
91219;883,1190,1365,952,314,678,1634,1513,14,1390,710,503,734,1174,1115;31;F
91224;1215,14,823,1031,883,1121,1634,309,93;38;M
91231;990,315,785,1455,997,1130,970,1115,999,309,1634,1031,1126,503,1641;26;M
91236;1365,785,1031,315,999,1634,1534,1126,1455,1641;57;M
91240;1174,962,970,1115,999,309,315,1031,785,990,1534,1648,1455,997,1641;42;M
91250;314,970,312,309,1634,883,1031,823,518,1097,123,997,56,503,797;54;F
91275;1634,503,797,999,315,1534,710,1130,1174;62;F
91294;883,1031,1390,811,1001,1137,1130,797,1458,734,1641,952,1094,637,1174;39;F
91326;312,1513,309,1031,785,1365,1390,14,1097,811,1648,997;42;F
91328;1641,315,1634,1031,1648;36;M
91336;636,14,785,1390,514,997,1513,518,1365,1097,990,56,503,1641,1031;55;M
91355;1121,1390,1001,514,678,999,1634,1513,883,14,990,1137,56,503;7;F
91357;811,1126,514,1417,1137,1394,703,883,518,14,56,1130,797,962,637;47;F
91358;1534,1348,1130,1641,353;37;M
91380;1190,14,1348,503,1130,314,812,1094,93;47;F
91419;1534,1031,315,309;56;F
91462;883,1031,1190,1390,1455,840,1417,997,1137,503,1130,1641,314,698,678;41;F
91470;678,703,1458,1634,1031,518,785,14,1365,990,1126,1417,997,1641,970;72;M
91521;1365,785,1031,1115,734,1394,56,514,1001,1126,990,811,1641,952,970;27;F
91542;518,503,823,315,999,1417,997,1031,123,1534,1648,1455,1634,1641,353;52;M
91556;970,678,1634,14;62;M
91570;518,785,14,1365,1534,1648,1126,1348,1455,840,1417,997,503,1641,1115;28;M
91596;1455,840;41;M
91599;26,1634,1190,814,1390,840,514,1137,1130,703;44;F
91605;1031,518,14,814,811,1648,1126,840,514,1137,503,797,734,703,93;40;F
91639;1634,26,999,315,1121,14,1097,1103,1534,1348,503,1130,962,812,1115;21;F
91672;1031,315,26,1634,123,990,1534,1648,1455,1417,1641,970;32;F
91678;1094,1641,1130,1417,514,1648,1534,1097,1190,823,883,1634,518,14,1137;39;F
91682;315,1190,785,14,840,503,1130,797,962,1641,703;70;F
91719;883,785,1215,814,990,1126,1455,1001,1417,997,1137,797,1641,962,703;77;F
91732;1634,1513,883,1190,14,1365,123,353;41;F
91754;1534,1417,1634,785,123,1455;27;F
91816;1534,1417,503,1115,353,970,1458,785,883,1634;35;F
91862;999,26,1634,1031,1190,785,1365,1534,1648,1126,840,997,1417,1641,1115;26;M
91866;999,1031,785;45;M
91875;999,1513,785,1390,970,990,1365,1534,1126,1031,1634,1115,1417,1458,1641;51;M
91897;970,1634,1031,990,811,1648,1001,514,1417,503,1641,703,952,353,93;27;F
91950;678,833,514,56,503,1130,734,952,703;31;F
91964;14,1648,1137,503,1130,1641,698,636,1115,1634,1031,785,1365,1126,1458;44;F
91990;1390,1115,970,1641,1417,840,1455,1534,309,1634,1031,785,1365,990,1126;30;M
92035;1031,883,518,1190,1215,811,1534,1648,1126,1390,514,503,1130,797,1641;27;M
92047;1534,1648,1417,970,353,1115,678,1513,1190,1365,990,1126,1348,1390,1641;33;M
92058;14,1121,1634,309,1097,1394,1130,1458,703,698,812,1094,1115,315,970;57;M
92061;503,811,518,1455,962,1534,990,883,514,1417,1174,1634,123;33;M
92075;840,1458,637,883,1634,678,312,314,797,997,1126,1190,518,823,1031;48;M
92086;1121,1031,518,14,814,811,1648,1126,840,1137,503,797,703,637,93;9;M
92088;678,1115;66;F
92102;1534,1458,1641,309,315,1634,883,823,503;33;M
92109;952,1094,1115,353,637,1365,1121,1513,14,1097,1137,503,1641,710,1174;43;F
92114;353,1417,1455,1648,14,823,312,1634,1031,518,990,1534,1348,1458,1641;20;M
92127;1115;40;M
92167;997,309,1634,1190,1365,123,990,1126,1455,840,1130,797,1641,970,636;70;F
92180;1174,1641,952,637,710,514,1001,1215;37;F
92186;93;47;M
92195;315,309,999,26,1031,518,1190,785,1534,1648,1126,1455,840,1417,1641;33;M
92200;26,1121,1031,14,814,1648,1126,840,514,1137,503,1641,703,93,637;7;F
92202;1031,990,1534,1648,503,1641,970;39;F
92215;312,678,315,1121,785,1365,1534,1417,1137,56,503,797,1641,962,314;39;F
92259;1417,514,1455,1365,970;47;M
92265;1130,1641,952,353;21;M
92277;811,990,1126,1001,1215,1458,1641,997,1130,812,1121,1513,14,1390,1137;39;F
92312;1348,997,1137,56,503,1641,1094,970,353,518,14,1097,1126,1130,93;41;M
92333;811,1458,315,997,823,1348,514,56,503,314,812,353,1513,1130,636;46;F
92453;1634,503,1455,970;29;F
92479;823,1534,1348,503,1641,312,1634,1126,1417;39;M
92495;1641,309,26,785,1455,997;34;M
92509;1534,1417,1641;27;M
92513;1174;39;M
92538;1455,1417,812,970,637,312,678,1634,1513,1190,1215,1126,1390,1458,1641;20;F
92554;1121,823,353,1115,14,1137,1130;44;F
92559;1031,1215,1137,315,1513,883,785,990,1534,1126,1390,1417,1641,952,353;44;F
92566;1534,1174;34;M
92567;1634,1031,14,1455,503,1641;23;M
92569;309,315,1634,1031,823,785,1365,123,1648,1126,1348,997,1130;26;M
92576;1031,1097,990,1348,1641,353,1634,1390,1001,514,14,123,56,503,1130;30;F
92589;1648,1455,1130,698,1365,26,309,1031,785,1534,1126,1417,1641,970,518;36;F
92609;990;29;F
92631;883,1121,315,309,999,678,1634,823,1215,123,1126,1348,1417,1458,1641;49;F
92637;883,1097,1215,1001,514,1137,56,503,1130,734,1641,703,952,812,637;33;F
92641;14,1126,1094,636,1634,123,814,1648,1137,503,1641,812;39;M
92647;678,1634,1215,1513,518,1190,14,1126,1534,1390,1137,1458,1174,93,637;42;F
92685;123,990,1534,1648,1348,1417,1641,93,970,315,1513,1031,785,1390,797;33;F
92689;1648,315,309,26,990,14,797,970;75;F
92695;814,833,312,1513,14,990,1348,636;8;M
92710;518,1031,26,309,315,1634,1121,14,1455,840,1417,503,1130,1641,812;18;F
92716;1634,1190,1215,990,1137,503,1130,1641,314,1534,1126,1348;44;F
92721;1455,1348,1648,1215,883,315,1634,1031,1190,1365,1534,1126,840,710,1174;32;M
92751;999,1031,518,1190,785,997,1534,1641,1126,26,123,1634;39;M
92791;309,315,883,785,1648,1390,1417;59;F
92794;785;43;F
92795;353,703,1137,990,518,14,503;63;F
92797;1094,353,710,26,1115,703,1130,1394,811,990,1031;32;F
92810;309,883,1097,990,514,1130,703;36;F
92812;1634,1513,1031,14,814,1390,503,1641,93,636;42;M
92826;1534,1365,1641,703,999,315,309,990,1648,1390,514,503,1130,970,353;46;F
92842;785,1634,1417,797,1641;37;M
92866;503,312,309,883,1534,997,785,14,990,1648,840,514,1417,698,970;61;F
92875;1534,1348,710,1174;38;M
92916;678,309,1534,1455,1417,999,1390,997,1641;33;F
92933;309,1634,1031,785,1365,123,1648,1455,1641,1534;30;M
92964;312,1513,1365,1097,1215,990,1534,1455,710,1137,1394,962,314,1094,970;36;F
92973;315,309,26,1634,1031,1190,785,14,1097,1534,1126,1455,1130,1641,703;47;F
92987;734,678,315,1513,883,1031,1648,1390,1001,997,1137,1641,636,314,952;29;F
93005;678,315,883,785,123,990,997,1137,1641,962,314,93,970,353,636;47;F
93016;123,1634;58;M
93024;814,990,1534,1126,1455,797,970,1190,1513,1390,840,997,503,1130,93;14;M
93049;1097,678,1648,1348;40;M
93084;503,1001,518,823,1634,1641,636;13;M
93085;703,1130,503,1137,514,1001,1455,1126,1648,811,814,14,1190,883,1121;43;F
93101;1137,1641,93,353,636,1115,309,785,1390,1455,1513,14,1648,503,1130;51;M
93122;997,1513,14,1365,1126,1648,1641,1115,1121,1348,1455,503,1130,797,1094;15;F
93126;1121,1031,1190,14,1103,811,1648,1126,1455,1001,514,1137,503,1130,703;10;M
93173;1455,1641;41;M
93174;636,312,678,1121,785,814,1455,1130,1174,1641,710,698,811,503,14;45;F
93195;14,1097,1534,1390,1455,514,1394,503,1130,797,1458,1641,703,314,1115;31;F
93197;309,518,14,990,1390,1455,1417,997,56,503,1641,812,970;71;F
93200;823,314,1648,785,678;32;F
93228;1513,1634,883,1390,503,703,970,1115;26;F
93229;678,14,1097,1215,56,703,952;41;F
93243;14,1097,833,1126,1390,1001,514,1417,56,503,1130,1458,1641,703,1094;32;F
93281;678,514,883,314,637,636,1130,503,1137,1513;33;F
93287;309,315,1031,785,1455,1417,1641;69;F
93294;1137,840,503,1641,353,1634,883,1215,1126,514,710,1130,1174,703,314;33;F
93313;1365,123,990,1390,1417,56,962,1031,1534,503;46;M
93317;1130,1115,1126,970,883,703,698,637,1534,1641,312,309,315,678,56;70;F
93320;962,636;48;M
93322;990,785,1031,26,999,1641,503,840,811,823,353,1634,123,1126,1455;51;F
93330;1634;26;F
93369;1121,812,1115,1097,1634,1513,14,1365,1648,1390,1417,56,503,1130,1641;18;M
93392;1641,1634,1534,1417,1126,997,999,990;64;M
93400;1634,1215,990,1648,1390,514,503;25;F
93414;823,785,14,1126,1348,1455,1417,1174,353,1115,518,1365,990,1648,1641;45;F
93437;811,1534,1126,1001,514,1417,997,1137,1130,1641,703,1115,353,123,1634;29;F
93455;1365,1174,999,1115;27;M
93458;999,309,315,883,1365,990,1126,1001,514,997,1641,970,1634,503;36;M
93461;1458,999,309,315,1126,990,1534,997,1641,1634,883,1031,1417,962,970;72;M
93477;1121,1097,1103,1348,1417,962,1130;47;F
93478;1130,1126,999,811,703,1534,990,518,1641,797,1031,315,785;75;F
93501;309,1121,1513,1190,1534,997,353,14,840,503,1130;23;M
93531;710,1634,1174;8;M
93536;1137,970,637,636,990,514,503,315,678,14;70;F
93563;637,1634,1174;37;M
93566;1634,123,1648,1641;34;M
93589;814,309,315,1031,123,1137,1215,1641,56,812,970,26,1634,514,1130;29;M
93597;1513,883,14,1390,514,1137,503,1130,314,637,636;5;M
93648;312,26,309,315,1634,1031,14,814,840,514,1137,503,1641,703,93;40;M
93679;315,309,26,999,1031,785,990,1534,1455,1417,1641,970;40;F
93692;309,1634,1031,14,1115;54;M
93695;1121,883,14,1097,1215,1103,514,710,1137,1174,703,314,1094,637,636;37;F
93699;315,1634,1390,56,1174;30;F
93711;1390,997,1634,14;70;F
93714;785,1001,14,1513,1634,315,812,637,678,883,997,1641,1215,353,1458;25;F
93721;637,1634,1174,710;7;F
93727;1455,1417,1137,812,1458,1031,315,309,312,1634,503,1130,1641,93,636;68;F
93743;514,811,1137,999,315,1634,883,1031,785,833,1648,1458,1641,314,636;43;F
93746;1634,1534,1455,514,503,1641;40;M
93780;1031,1365,1215,123,990,1648,1126,1390,1137,1174,353,26,883,1534,1641;32;M
93803;14,1121,1097,1103,1137,1130,1115;14;M
93813;1534,636,1455,518,1513,1634;41;M
93822;678,1031,1534,1648,1455,1417,1641;42;M
93828;1634,883,123,990,503,1130,962;47;F
93840;1634,678,14,1126,503,1641,970;46;F
93846;14,1365,1417,1137,797,314,970;38;F
93868;1648,1455,1115,970,840,1534,990,518,1641,1031,309,315,1365,785,26;60;F
93886;14,1121,1097,1103,1137,1130,1115;9;F
93897;1031,785,1534,1648,1455,1417,1641;48;F
93902;1634,1174,637;36;F
93912;1190,93;33;F
93931;1455,1390,1137,999,997,970,883,990,518,1641,503,1031,315,1634,14;74;F
93934;14,1103,814,811,1137,1394,503,1130,1641,703,314,93,812,970,1115;45;F
93942;315,840,797,970,309,1648,1115,1641,1126,26,503;21;F
93944;1031,14,1126,1390,1458,1174;39;M
94020;1121,1513,1634,678,883,1215,811,1390,1126,1001,514,1137,503,1130,962;44;M
94041;999,309,315,990,1648;34;F
94088;698;59;M
94128;1534,1455,1348,514,997,1394,1174,962,314,812,1031,785,309,1648,518;42;M
94141;503,797,1641;20;F
94146;353,962,1137,1648,1534,518,1031,309,315,1634,1365,1417,997,1641,1115;49;M
94158;1513,823,518,1348,840,1390,1130,353,14,1190,1634,123,1126,503,797;14;M
94206;123,93;50;F
94213;999,1365;33;M
94229;883,823,518,785,990,1126,1455,1137,1394,1130,1458,1641,962,314,1094;48;F
94236;990,1455,997,309,678,1634,1365,1534,1648,1417,1641,93,812,1115;42;F
94242;999,309,315,1634,883,1031,990,1534,1126,1417,997,1458,1641,962,970;72;F
94246;1634,123;14;M
94298;1031,14,1390,1174;74;F
94312;1121,883,1390,1001,514,1137,503,1130,1641,703,952,812,1094,970,637;13;F
94341;26,315,1031,1190,1215,990,1534,1648,840,514,1417,1394,1641,970,1115;30;M
94342;678,1634,1031,14,990,811,1126,997,1137,503,1130,1458,1641,703,970;34;F
94411;990,1513,26,315,999,1634,1031,785,1190,1534,1648,1455,1417,1130,1641;35;M
94412;990,710,1417,315,26,1137,1130,883,1031,14,1390,1458,1641,1174,703;27;F
94418;1634,823,1365,1115,14,990,1348,1417,1641,314,970;37;F
94443;785,1097,997,56,1130,1115;38;M
94469;315,1634,14,1215,1348,1001,514,997,1137,503,1458,314;80;M
94474;1634,123;52;F
94488;970,503,710,1215,883,315,26,1648,1534,1121,1097,1103,1137,1130,1115;52;F
94501;1121,1097,1103,1137,1130,1115;56;F
94514;1031,518,1365,833,990,811,1126,1390,1417,997,503,1641,703,314,970;34;M
94544;1094,1115;52;F
94576;1190,1513,1634,309,999,26,883,1031,990,1534,1126,1348,1130,1641,970;30;F
94586;990,1097,883,1121,14,1215,514,503,1130,734,1641,93,812,1094,637;41;M
94645;1634,1513,1097,811,56,952,637,1130,883,123,1390,1348,1137,314,636;52;F
94653;812,797,1130,710,514,1001,1390,1215,312,1634,14,123,1137,503,703;38;F
94699;1137,1121,1126,883,1534,1641,962,1031,952,93,56,1634,14;79;M
94752;1215,1130,1126,1097,1458,1001,703,990,514,518,1641,503,123,315,1634;70;M
94763;14,1137,56,503,1130,703,970;45;F
94838;1130,1121,1126,1103,1097,1458,997,883,814,990,1641,1513,309,1417,14;69;F
94844;1417,26,1534,1648,1126,1031,1455,1641;74;M
94882;56,678,503;56;F
94924;997,970,1365,123,678,883,1031,785,1534,1648,1455,840,1417,797,1641;38;M
94925;883,1634,1031,518,785,990,1648,1126,1455,503,1417,952,1641,970,636;41;M
94938;1634,883,1031,785,1455,1417,997,1137,503,1641,970,353;78;M
94941;1130,636,1121,14,1103,1390,1348,840,1001,1458,314,514,56,503,962;40;F
94950;962,56,1390,1126,811,1031,1513,315,309,26,1634,1455,840,503,1641;57;F
94956;1031,785,1365,123,1115,999,26,1634,1190,518,1455,14,990,1126,1641;69;F
94961;1365,990,1534,1648,1390,1348,1455,1001,514,1417,997,56,503,1130,797;54;F
94976;814,840,26,1513,883,997,1137,503,1130,797,734,952,812,1190,785;40;F
94977;883,1534,1126,1390,1455,1001,1417,997,1130,734,698,314,1094,970,637;38;F
94982;678,883,823,518,1097,1215,1103,1390,1348,514,1137,1130,797,952,93;35;M
94989;1648,1390,1137,970,883,1094,703,636,1534,1641,503,1513,123,315,1634;53;F
95023;1190,518,309,999,26,315,1634,1031,997,840,1455,1390,1126,1648,123;32;F
95048;1648,1390,1190,883,1534,1641;71;F
95070;314,970,678,1513,814,1130,1458,312,883,823,14,1390,1348,1137,734;40;F
95098;1455,1130,1097,999,997,970,1534,990,1641,1031,309,315,56,1417,785;78;F
95108;883,1190,1215,990,1390,1001,514,1137,503,1458,1641,952,698,970,637;32;F
95110;309,315,1031,785,1365,990,1534,1648,1455,1417,503,1174,1641,970;34;M
95124;1001,1455,1121,1031,518,1215,811,997,1130,1634,1390,514,1641,703,1094;29;F
95132;1215,1121,1455,797,1130,1641,812,1094,703,1634,833,811;48;M
95135;637,1094,952,1130,1137,1001,1348,814,833,785,1190,883,1513,1634,678;67;F
95139;785,1215,1103,1455,1001,514,56,503;25;F
95142;1137,970,637,1174,1641,312,1348,1001,514,314,353,883,14,1215,814;34;F
95154;309,999,26,1634,1513,1190,1215,1390,1001,514,1641,962,970,1115,353;35;F
95197;1534,785,1641,636,698,1394,56,1390,14,1121,1513,353,503,1130,962;22;F
95204;514,503,797,637;32;F
95210;1115,1094;25;F
95216;999,315,1634,1031,518,785,1365,990,1455,514,1417,1174,1641,1115,970;31;F
95225;636,637,970,314,952,703,734,1137,514,1215,1097,883,1513,1121,1634;32;F
95236;1534;35;F
95255;678,1121,1031,1126,1348,1455,1417,1137,503,1130,1641,703,314,636,1115;38;M
95287;1648,1455,999,990,1641,503,797,1031,312,309,123,315,1417,1634;70;M
95299;309,1634,1121,56,503;52;M
95312;309,1634,1031,1534;31;M
95318;999,315,1534,785,1634,1031,1648,1455,1417,1641;76;F
95332;56,710,312,1215,503,1641,812,309,1121,1097,814,1390,1137,1130,703;44;F
95368;503,1534,1648,1126,1390,1455,514,997,1130,1641,962,703,314,970,14;78;M
95384;312,1121,14,1103,1137,503,1458;16;F
95404;14,312,999,1513,990,1390,514,970,1126,814,1215,1634,1121,123,997;47;F
95435;990,1534,1390,1455,840,1417,56,503,1130,1641,952,93,812,970,1115;54;F
95452;840,678,514,999,990,1534,1417,1641,1455,123,1365,26,1634,1031,785;35;F
95461;1031,1534,1648,1455,997,797,1641,970,1115,1634,1126,1417,503,962,353;59;M
95501;823,1513,1634,315,26,1648,1126,1641,314,93,970;37;M
95528;518;65;M
95564;883,1031,518,14,1365,1215,1103,811,1094;51;F
95591;999,309,315,1031,990,1365,1115,1534,710,56,1174;45;M
95602;1634,14,990,1534,1126,1390;53;M
95621;990,1634,315,309,1513,1031,814,1648,1390,1137,56,1394,503,1641,637;35;F
95657;1390,1001,514,785,1534,1648,1455,1417,970,999,26,315,1031,1641,990;33;M
95659;1190,1097,1215,1126,1390,1348,1001,514,1137,503,1130,797,1174,1641,1115;20;F
95673;1455,1390,1137,999,970,1534,1641,503,1031,1513,309,315,1417,785,14;76;F
95717;636,970,734,503,883,14,1097,123,1130;27;F
95737;1534,999,1417,26,309,315,1031,1641,514,797,1115,1634,123,1648,353;31;M
95749;999,26,1634,883,1031,1190,1534,1126,1348,1417,514,1137,1130,1641,703;31;F
95763;123,93;73;F
95767;1390,1137,1001,883,734,637,636,1641,1513,952,678,93;36;F
95770;312,309,1121,14,1097,1215,1103,990,1137,56,503,1130,1458;49;F
95772;353,1115,26,999,315,1634,1031,785,1365,990,1534,1648,1417,1641,970;48;F
95806;785,1641,990,970,1365,999,1031,26,833,1390,678,1417,797,637,1534;33;F
95819;833,990,734,1094,698,503,811,26,785,840,1130;31;M
95849;833,1513,514,1417,503,312,840,1001,1634,1031,1190,123,1390,1455,1641;38;M
95860;1390,1137,1001,883,637,636,1641,1031,952,678,93;2;F
95865;811,883,1648,734,952,1634,1513,1215,1390,514,503,1130,1174,703,637;32;F
95931;14;43;F
95938;26,1365,1648,698,315,309,1031,1417,970,1115,1641,999,990,1534,1455;39;M
95942;1390,514,833,637,353,1634,883,1031,1365,123,1534,1417,503,1641,703;26;M
95970;1513,883,1190,1534,1001,353,26,1126,1455,840,514,1417,1137,503,1641;46;F
95982;518,823,1031,883,26,309,1348,1455,840,1417,503,797,637;40;F
95986;785,123,990,840,1417,1130,503,1137,56,823,1126,1348,514,1641,637;29;M
95993;56,309,1634,823,518,785,1348,1001,514,997,1394,503,1641;36;F
95998;93;95;F
96000;999,1115;37;M
96007;1215,1458,1634,823,123,990,1534,1648,1126,1455,1417,1130,1641,1115,970;46;M
96021;1390,1641,1417,1634,1513,1648;29;F
96028;710,833,883,1634,1174;40;F
96030;970,26,999,1390,678,797,637,1534,1365,785,1417,1634,1458,1121,883;5;M
96043;678,309,883,1031,1215,990,1648,1001,1137,503,1130,734,952,637;31;F
96070;1190,1103,503,1130,797,353;29;F
96072;698,314,637,1390,1126,990,123,1215,14,785,1190,1031,883,1634,26;49;F
96075;312,315,309,1031,1648,1126,1417,797,1458,1641,1115;39;F
96093;1348,56,314,1094,637,1130,636,678,883,14,1097,1103,1390,1137,503;41;F
96096;710,734,1174,811,1534,1417,1137,703;32;F
96097;1634,703;33;F
96099;883,14,990,503,970;74;M
96109;840,1648,1534,703,997,1137,962,1641,314,970,1115,811,1365,1390,1215;45;F
96115;123,1126,1390,710,1634,1513,1137,503,1174,1641;36;M
96123;1634,823,518,1190,785,14,123,1390,1455,840,797,1641,962,353,26;42;M
96138;315,999,1634,883,1031,123,990,1534,1648,1455,514,1137,503,1641;44;F
96153;315,14,990,1648,1126,1390,1455,514,1417,1130,962,703,314,970,1115;77;F
96212;1094;30;F
96221;1634,883,14,1215,990,1534,1001,514,1137,734,1641,703,952,698,314;39;F
96229;26,1634,1513,823,1190,14,123,1215,1126,1390,1348,840,1137,56,1458;42;F
96232;1121,518,1648,990,1103,1001,1417,503,1130,1641,698,314,1094,637,1115;14;F
96233;1634,1513,1031,823,1534,734,1641,1130,1390,785,312,970;30;M
96250;999,1031,1390,678,797,637,1534,1641,785,1365,1417,1634,1458,1121,883;8;M
96260;883,1121,678,823,518,14,1126,1348,514,1137,56,314,93,353,636;38;F
96310;1513,518,785,1534,1417,997,812,1094,1115,1390,14,833,811,514,503;47;F
96326;990,1390,1455,1001,514,997,503,1130,797,734,1174,637,1641,1115,952;21;M
96329;1634;42;M
96334;1390,1513;49;M
96355;1417,1455,1390,1534,990,814,1215,1031,1513,315,1121,883,811,514,503;23;F
96357;785,1534,1648,1634,315,1031,1455,997,1641;34;M
96361;315,999,309,1634,1031,518,1365,1534,1126,1648,1455,840,1417,1641,1115;32;F
96375;1513,1031,1534,1648,1390,1455,1641,1634,785,1365,990,1417,970,353,1115;54;F
96395;1031,514,1513,1390,93,636,883,123,1534,1126,1348,1417,797,1641,678;36;F
96411;1648,997,1417,1137,26,883,1215,123,1513,1534,1390,840,514,503,1641;46;M
96414;514,1001,1126,1190,518,26,312,678,1634,1031,785,1534,1417,703;31;M
96441;1634,1031,123,1534,1648,1126,1641,353;32;F
96469;26,315,1190,999,1634,1031,990,1534,1648,1126,1390,1455,1417,56,1641;47;M
96488;93,1121,883,14,1097,1215,123,1648,1348,1137,503,1130,797,1458,812;38;F
96508;309,785,1001,514,1417,56,503,734,1641,952;25;F
96517;312,1121,14,1097,1215,1103,990,1137,56,503,1130,1458;13;F
96542;678,518,56,503,1458,703,636,353,1634,1513,883,314,93;71;F
96545;26,1634,1190,990,811,1390,1455,514,56,1394,1130,314,970,1115,353;30;F
96567;1390,1190,811,1455,703,1137,56,1130,797,999,1031,1534,1648,93,1115;36;F
96569;14,1365,1130,1641,1115;23;F
96586;840,1534,123,1365,1641,1513,93,1634,883,514,785,1031,990,1390,1417;40;F
96600;823,797,1031,1417,1641,1215,309,990,1126,997,962,970,637;63;F
96649;823,785,1031,315,309,26,1121,1103,1115,14,1097,997,1417,503,1130;23;M
96670;353,970,1641,503,1417,1455,123,1097,785,1190,1031,1634;48;M
96687;1634,1513,14,1390,1001,514,503,1130,962,952,1094;27;F
96691;315,309,26,999,1031,785,1534,1648,1126,1455,840,1417,797,1641,353;31;F
96726;309,999,1634,1648,1126,1390,514,1417,997,503,1130,1641,1115,1031,785;23;M
96753;503,1417,1031,1121,1634,309,26,812,93,703,1641,1126,990,814,123;13;M
96754;1365,309,315,14,1455,997,1130,1458,1641,962;26;M
96757;1641,734,1001,1390,814,1513,312,315,1634,883,1031,1215,1534,514,1137;34;F
96766;678,315,1634,1121,14,1137,1130,698,314,1094;39;M
96772;840,1190,883,309,312,678,1097,1126,1130,698;56;F
96777;26,1121,1031,518,1190,1534,1648,1126,56,1130,962,1641,797;55;M
96805;309,999,678,26,1031,1190,785,1365,990,1137,1641,698,314,970,1115;37;F
96839;999,26,123,1365,990,1648,1534,1126,1417,1641,970,1634,1031,785,353;39;M
96856;503,1641,123,823,1031,1634,26,353;13;F
96869;952,1137,1215,1513,26,678,315,1534,1126,1641,970,353,1648,1130,93;29;F
96876;999,26,315,1031,518,1190,785,1365,1534,1648,1126,1455,1417,1641,1115;22;M
96912;1455,999,309,1365,1215,1390,997,503,1641,636,883,1534,514,1417,812;22;M
96982;1190,1130,785,1031,883,26,1641,1455,1126,14,1634,1513,518,1390,353;28;F
96995;1031,14,1126,1390,1174;77;M
96998;1458,1417,883,1634,315,1126,1348,1094,637,56,503,1130,1641,1121,1137;43;F
96999;14,1115;53;M
97015;1137,997,1348,1390,518,1031,883,1513,315,999,678,309,1648,1126,314;34;M
97019;1648,997,710,797,1641,1031,1126,1390,637,1634,883,785,990,1534,970;34;F
97062;26,999,990,1534,1648,1126,1390,1455,1417,997,56,1458,1174,1641,970;17;M
97083;1115,970,1641,315,1417,990,1365,312,14;39;M
97110;123,814,1534,1648,1126,1455,514,1137,1641,703,314,93,812,353,1115;43;F
97114;1634,518,14,1365;44;M
97129;811,840,56;50;F
97133;999,26,1634,1513,123,1534,1648,1455,1417,1641,353,636,1115;36;F
97144;1648,1390,1190,970,1534,990,962,1031,1513,309,123,353,1417,1365,1634;58;F
97189;1455,1390,309,785,56,1641;45;M
97212;123,678,1634,1121,883,14,1390,1455,1137,503,1130,698,812,637,636;31;F
97217;698;8;M
97227;1390,1648,811,1215,1513,1121,678,883,14,514,56,1130,503,1115;39;F
97236;1634,1031,1534,1417,710,1130,1174,1641,703,952;35;M
97277;353,703,1417,1126,990,123,14,785,26,823,1634,1641;46;F
97311;1031,1534,1648,1417,1130,1641,970;40;M
97342;514,1001,1390,1648,1534,811,823,1513;46;M
97344;636,93,678,1634,518,14,990,1126,1348,1137,56,503,1130,797,1641;38;M
97346;56,678,1513,883,14,1215,811,514,1137,734,952,698,93,637,636;28;F
97356;93,1634,1190,785,123,1534,1126,1390,840,1001,514,1417,503,1174,1641;36;M
97361;353,1115,999,1031,823,785,14,1365,1390,1417;24;M
97371;883,26,309,1634,518,1190,1534,1126,1417,1130,797,1641,970,637;50;M
97372;1121,883,14,1097,990,1137,56,503,1130,1458,734,1174,636,353,1115;28;F
97445;999,1513,1190,1390,997,710,970;17;F
97449;1103,1455,840,1001,1417,710,56,797,1115,999,883,990,997,1174,1641;13;F
97463;503,997,1534,785,1513,678,814,1126,1390,1348,514,1137,1394,1458,698;45;F
97468;1365,1534,1648,1126,1455,1641,353,999,26,1031,785,990,1417,698,970;30;M
97487;1634,1031,518,14,1137,1641;39;M
97499;1365,26,999,309,315,1031,785,990,1534,1648,1126,1417,1115,997,1641;35;F
97500;123,840,514,1458,970,1634,1031,990,1534,1126,1455,1417,997,56,1641;51;F
97550;503,1417,1455,1126,1348,990,814,1215,1365,785,823,1634,26,1641,353;10;M
97556;518,990,999,309,1634,1031,1648,1126,503,997,1641,962,314,970,353;66;F
97557;514,1641,970,1115,999,309,315,1031,785,123,1648,1126,840,1417,997;51;F
97565;1634,26,312,678,1031,833,990,1648,797,698,314,636,1215,514,637;36;F
97585;1031,814,703,883,823,1190,14,990,1390,997,1137,1458,734,698,637;70;F
97599;785,1097,1455,56,1130,970,1641,952,314,93;33;F
97644;312,309,518,14,1097,1103,811,1126,1348,1455,1417,503,1130,1641,703;24;F
97648;518,1001,353,26,315,309,1097,1634,514,503,1130,1641;52;F
97672;1534,990,1365,1031,1513,309,1641,1634,811,1390,1001,503,1174;37;F
97682;1634,518,123,797,1641,93;21;M
97714;1641,503,997,514,1534;31;M
97718;14,1097,1103,1534,1390,1001,514,997,1137,1130,1641,703,952,1094,970;37;F
97772;990;75;F
97774;1534,1455,1001,785,1097,1126,1348,514,503,1641,962,703,314,1417,1130;43;F
97778;14,1126,1348,1641,93,678;43;M
97784;1031,1121,1641,678;48;F
97839;970,698,1001,1455,883,1513,1031,814,811,1534,1648,1126,678,309,1634;33;M
97845;636,93,1634,309,678,1513,14,123,1390,840,514,503,1130,962,637;39;F
97854;1121,514,1130;36;F
97855;1094,812,514,883,678,14,814,1126,1348,1390,997,1137,503,314,637;6;M
97868;1031,1634,309,315,1121,1513,1097,1103,1390,1348,503,1130,1641,703,314;23;F
97879;678,1121,734,952,1094;27;F
97884;1190,1365,1097,811,1534,1648,1390,1455,997,56,797,734,1641,962,703;31;F
97943;1641,970,999,309,315,883,990,1534,1648,1417,1365,823,1031,785,1390;79;F
97951;1190,14,1534,1455,1174,1641,678,26,309,315,1031,1648,1126,1417,797;52;F
97967;1097,1215,811,1390,1001,514,503,1130,1458,734,952,314,812,637,353;26;F
98037;970,1115,785,883,678,1513,14,814,1126,1390,1348,514,997,1137,1641;85;M
98040;1634,315,309,1126,1137,1458;40;F
98047;678,1394,314,1094,1130,1097;37;F
98093;14,123,990,1534,1648,1126,1455,840,514,1417,997,1174,1641,1115,1634;30;M
98099;840,1130,1641,703;30;M
98117;1031,785,1097,1103,1648,1348,56,1130,1458,1641,703,314,93,1094,353;46;F
98129;514,1126,1634,1121,823,518,811,997,703,93,970,1097,56,1130;44;F
98175;990,811,1534,1126,1390,1348,1001,1417,1641,309,26,1121,1513,1190,514;45;F
98187;309,518,1634,1031,785,990,1648,1126,1417,997,503,1130,1641,962,353;64;M
98200;990,1215,883,1513,315,970;23;F
98244;315,1365,1097,1634,518,785,14,990,710,56,1130,1174,962,970,353;39;F
98255;1634,811,514,710,503,734,1174,703,1115;30;F
98280;970,56,503,999,883,309,315,1031,785,14,990,811,1534,1641,1115;66;M
98291;1115,970,812,1641,1137,997,1455,1348,1390,678,1513,883,14,503,637;72;F
98330;309,315,1121,883,1031,1097,1103,811,1348,1390,1001,514,503,1458,703;67;F
98336;883,1001,514,56,503,1130,1641,970,353;43;F
98339;1641,1390,1534,990,1513,1121,883,785,353,970,123,1215,1190,1634,26;42;M
98346;883,1534,1126,1394,1121,14,1097,1215,1348,1137,56,503,1130,1641,962;47;M
98358;678,514,503,1115,353,1130,1103,1097,1365,14,1190,823,1513,1121,1634;50;F
98364;1534;45;M
98378;353,1115,1126,1534,1365,785,1190,518,1031,1513,1634,315,309,26,999;52;M
98384;1365,990,811,1534,1648,1348,514,1137,1130,1641,703,952,812,970,1115;26;F
98415;997,56,1365,785,26,999,309,315,1031,14,1534,1648,1455,1641,1115;21;M
98418;1634,26,1031,785,123,1534,1648,1126,1455,840,1417,997,56,503,1641;18;M
98428;309,1634,518,1190,785,123,1455,840,1417,997,797,970,26;63;F
98436;26,1634,990,1390,514,503,970;22;F
98438;315,678,1121,1031,14,1215,990,1534,1126,514,1001,1417,56,1458,1641;47;F
98480;312,1031,518,1365,833,1097,1641,314,1634,14,1534,1648,1126,1348,703;46;F
98510;883,990,678;35;F
98535;883,503,309,26,1634,823,518,1190,785,123,1126,1455,997,56,1130;52;F
98547;1031,990,811,797,1641,812,1115,26,123,1534,1648,1634,1365,1126,93;47;F
98553;503,840,1455,1390,1126,1648,1534,990,1215,1365,785,1190,1513,1634,26;33;F
98628;1641;38;M
98656;812,1115,678,1513,315,309,26,999,1215,811,1534,1126,1641,952,637;47;F
98685;1190,833,811,1001,514,1417,997,710,56,503,1130,797,1174,703,1115;31;F
98709;1390,1137,962,703,314,1094,811,1103,833,1097,1348,56,503,1130,636;46;F
98720;14,1031,1634,1097,990,1648,840,1417,56,503,1130,797,1641,962,703;59;F
98787;309,315,1513,518,785,14,1365,990,1534,1455,503,1641,314,970,1115;44;F
98807;678;40;F
98840;785,1097,1103,990,1534,1648,1455,514,1417,1137,503,1130,1641,703,1094;67;F
98854;26,1634,1031,1126,1455,1417,1137,797,1641,314,1115,637;50;M
98855;1634;39;M
98859;1137,1641,1031,1634,785,1097,1648,1348,56,1130,1458,703,93,1094,353;39;M
98878;26,678,315,1121,1031,785,14,1215,990,1534,1001,1417,56,1458,1641;10;F
98900;1031,518,785,1648,503,1130,1458,734,1641,93;31;F
98913;678,1348,1137,503,314,636;29;F
98917;678,1634,883,1215,1390,1001,1137,503,1458,637,353,636;48;F
98940;999,309,315,883,1031,785,14,990,811,1534,56,503,1641,970,1115;49;F
98943;1455,1417,1137,1130,797,1458,1094,1115,503,997,1648,678,1641,314,93;36;F
98956;678,315,1031,785,990,1648,1126,1417,797,1458,1174,1641,962;71;F
98961;309,315,1634,990,1534,997,1641;70;F
98962;678,1513,503,636,93,970;69;F
99011;785,1534,1390,1137,93,1115,309,315,1031,990,1126,1417,503,1641,970;31;F
99035;14,1348,1137,56,1130,883,1097;46;M
99116;1174,999,309,315,1031,785,1365,990,1534,1648,1455,1417,1641,970,1115;29;M
99121;309,785,514,56,1137,1348,1390,14,1121,883,1097,503,1130,353,703;56;F
99143;1634,1513,883,1031,518,1190,785,1534,1390,56,1130,962,314,93,636;47;F
99159;503,883,1137,1094,636,678,1130,637,14;36;F
99163;93;38;F
99166;1094,990,312,14,1348,1394,56,1130,1458;44;M
99198;811,678,1634,883,1390,1513,1031,952,93,1215,1648,1126,1641,1455,734;40;F
99215;1634,785,1365,1215,990,1534,1648,1455,840,514,1417,710,1641,970,1174;31;F
99232;1634,1031,14,1097,1130,1458,734,678;36;F
99254;514,1417,1137,503,1130,703,1094,970,309,315,1031,1534,1455,997,1641;51;F
99263;314,309,315,1634,1031,518,1190,785,123,56,797,812,970,353,1115;42;F
99278;1190,883,1121,1634,309,312,999,1031,14,1097,814,1641,952,314,93;45;F
99290;1094,636,1641,785,1513,678,1031,1348,1458;10;M
99297;315,309,26,785,123,990,1390,1455,1417,797,962,1634,840,1130,93;26;M
99312;1137,503,1534,785,1031,315,999,312,309,1215,514,1417,997,1641,703;29;F
99313;1348,56,1458,962,314,309,1634,1534,1390;30;M
99326;678,1121,1634,1031,14,1097,1137,1130,1458,734,1641;11;F
99335;312,14,811,1390,1513,1394;57;F
99336;1634,1031,518,1215,811,1648,1126,1348,1455,840,514,1417,1137,503,1641;73;F
99348;1137,1115,883,814,514,1634,1001,997,990,840,797,703,503,123,14;57;M
99382;1634,315,309,999,26,1031,518,785,990,1534,1126,1455,840,1641;73;M
99394;1121,1390,1348,1137,962,698,314,1094,312,309,1365,56,1130;38;M
99416;309,315,1634,1031,785,1365,833,123,990,1534,1455,1417,797,1174,1641;47;M
99419;93;4;F
99425;1458,1641,962,970,637,93,797,1001,1126,990,1215,1190,1634,309,1031;16;F
99444;518,1190,14,1534,1648,1126,1455,840,514,1417,1641,698,314,93,1115;72;F
99469;1641,962,952,314,93,970,636,1513,1390,514,997,710,1137,503,1174;37;F
99484;1365,883,315,518,990,1534,840,1174,1641,970,1115,26,1513,1031,1190;38;F
99494;703,503,990,14,1190,518;70;F
99527;315,1031,785,1365,1097,1103,990,1534,1126,1001,514,1417,997,1130,1641;47;F
99530;1190,1648,1641,1634,1031,123,814,1417,1137,797,1174,93,970,637,14;36;M
99540;1190,1097,1348,999,1031,1534,1455,797,678,970,1641,1648,990,123,1634;43;M
99563;1130,314,312,883,1031,814,56,1458,678,14,1534,1126,1417,1137,1094;46;F
99572;1455,990,1641,678,999,883,518;31;M
99585;315,1513,518,1190,785,1534,514,1417,503,314,883,1365,1390,637,970;34;F
99586;123,990,1534,1126,1455,1001,514,997,1137,503,1641,703,314,1094,970;86;M
99611;734,636,312,678,823,1348,503,314,703,812,1094,353,962,93,814;22;M
99616;26,309,1634,1513,883,823,1190,14,1097,833,1390,56,93,637;49;F
99635;1634,503,1130,1641,962,56,1137,309,1097,1190,518;43;F
99638;1001,1031,1365,1417,1130,1190,1534,1648,1126,797,1115,1641,1174,1455,1634;24;M
99663;1417,710,1394,1641,962,703,952,698,314,1094,970,637,353,636,1115;52;F
99717;315,309,26,999,1634,883,518,1190,785,1215,123,990,1417,503,970;73;F
99730;1190,14,833,811,1126,1137,503,1130,734,1174,1641,703,314,93,1094;62;F
99733;678,883,1031,1390,1348,1458,1641,970,353,636;7;M
99736;710,734;21;F
99738;999,1031,1126,997,1115,1641;42;M
99741;883,811,1390,1137,734,1641,703,1115;43;F
99747;518,785,1215,1534,1648,1126,1348,840,1417,56,1130,1641,314,93,970;43;F
99760;1215,785,1513,315,309,1031,1365,1648,1534,1455,1417,997,970,1115,1641;42;F
99784;883,123,678;60;F
99808;997,1534,990,123,26,315,1031,1390,1455,514,503,1641,962,703,970;44;F
99810;1190,990,1534,1455,840,514,1417,997,503,1130,1641,962,703,1094,970;70;F
99829;883,1215,514,710;35;F
99841;1634,1031,518,14,123,990,1648,1126,1455,1417,503,1641;40;F
99875;1365,1455,315,1534,1417,1137,1174,1641,952;38;M
99911;1215,123,1534,1455,1001,1417,56,503,962,93,637;43;F
99912;1648,1455,1417,962,1115,1634,1190,1534,1126,1390,840,503,734,1641,952;30;F
99933;698,1130,503,56,1390,1126,1534,14,1190,1031,1513,1121,1634,309,703;44;F
99938;1458,1348;44;M
99952;990,1031,1513,1634,14,123,703,93;40;F
99971;1634,1174;46;F
99982;1634,518,1455,514,1137,56,1641,962,703,1115;34;F
99987;1126,1648,1534,1365,785,1031,26,309,999,315,1455,514,1641;27;F
99994;312,309,315,1031,990,1534,1648,1126,1455,1417,997,1641,962,970,1130;74;F
100002;1001,1365,797,309,315,823,1634,1031,518,1455,997,990,503,698,93;9;M
100058;1031,785,1365,990,1534,1648,1390,1455,514,1417,797,1174,1641,703,970;56;F
100072;1031,1394,698,309,1097,990,1137,1130,1641;40;F
100150;1031,123,990,1126,1348,1455,997,1137,503,1130,703,93,812,970,353;46;F
100161;309,1031,1365,1001,514,997,1137,1115,1634,1121,14,56,503,1130,812;44;F
100168;1121,56;17;F
100170;1455,1534,1215,1634;22;M
100176;1634,1190,1534,1126,1390,1455,840,797,1641,1174,93,970;41;F
100189;997,1458,503,1130,962,315,1001,514,883,1031,1455,1641,1634,785,1126;20;F
100206;1390,1641,1215,514,1534,734,710,1174;37;F
100215;1137,1031,883,315,999,1634,1390,1417,514,56,1130,503,1641,962,353;18;M
100226;1190,785,1365,1215,1534,1648,1455,840,1417,997,1137,797,1174,1641,970;51;M
100253;1634,1126,1641,734,1174,710;33;M
100319;1130,503,1137,514,1215,1513,14;74;M
100333;703,698,1094,636,353,962,1130,56,1137,1126,1534,1097,518,1634,678;41;M
100394;883,1097,503,678,1513,814,1390,1137,703,1094,637,636;37;F
100412;883,1031,990,1534,1455,1094,785,1097,1126,514,56,503,1130,1641,703;34;F
100442;123,990,1534,1648,1126,1455,797,734,1641,952,698,1094,970,637,1115;25;F
100458;315,833,990,1455,514,1130,1641,314,970;46;F
100565;678,309,883,997,1417,734,314,812,636;37;F
100568;1190,14,123,1534,1648,1126,1390,1455,1417,997,503,797,1641;45;F
100591;883,309,1634,14,1534,1126,1455,840,514,1130,797,1174,1641,93,636;32;M
100610;1031,518,1190,785,1365,990,1534,1648,1390,1417,56,1641,970,1115,1130;47;F
100625;14,1215,123,1648,1390,1455,514,1417,503,797,1174,1641,703,1115;30;F
100638;26,1513,1031,785,1365,123,990,1534,1648,1455,1390,1417,797,1641,1115;20;M
100640;1634,1190,785,990,1534,1648,1390,1455,840,514,1417,997,797,1641,1115;31;M
100650;883,1031,1417,1130,1641;46;F
100682;93;30;M
100696;14,1348,1455,1417,1137,1130,1641;44;M
100698;1094,703,997,514,1648,1534,990,518,999,1031,1390,1455,1641,1513,1634;53;F
100711;785,1365,123,1455,1417,1137,1641,999,1634,1031,990,1648,1390,1348,997;35;M
100730;678;43;F
100789;1634,14,123,990,1534,1455,797,26,309,1190,1126,1390,840,1417,1641;50;F
100790;14,840,93,637,678,883,1031,123,1648,1126,1390,1137,1641,962,636;43;M
100795;1031,1126,1417,1458,1174,1348,1648,1513,999,1115,1641,1455,1534,1365,1634;30;F
100801;315,883,1190,14,123,1648,1417,997,1137,797,734,1174,1641,678,503;39;F
100829;637,309,1634,1031,785,1648,1126,1390,1348,1417,997,503,797,1641,1115;23;M
100876;314,997,1348,1390,999,309,315,1634,785,990,1534,1455,1417,962,970;38;F
100959;1417,503,962,970,309,315,1513,1031,1648,1126,1390,1137,1458,1641,636;47;F
101013;93;38;M
101014;1534,123,1365,518,1031,1513,309,1641,1634,315,1648,840,503,797,353;20;F
101018;26,315,1190,990,56;49;F
101026;1648,1534,1365,883,315,26,999,1390,514,703,952,93,812,970;28;F
101085;93,1115,997,1648,1215,1190,1634,1513,883,1031,1365,990,1534,1455,970;27;M
101131;840,514,1417,1137,56,1394,503,1130,1641,703,952,93,812,637,636;37;F
101144;1417,1634,309,678;12;M
101149;312,678,1634,883,1031,1097,833,814,1348,1455,1137,503,314;48;F
101174;970,1031,1513,315,26,990,1534,1001,514,1417,1130,1458,1174,1641,703;22;M
101203;990,309,315,1115,999,26,1031,785,1365,1534,1648,1455,1417,1641,970;40;M
101236;1137,1455,1390,1648,811,123,1513,678,883,1215,1126,1001,514,1641,952;25;F
101237;1031,518,990,1534,1455,1417,56,797,703,353,785,1641,970,999,1634;32;F
101293;1121,883,823,1190,1097,1103,811,1648,1390,56,503,1130,1641,703,314;31;F
101298;785,14,1365,1097,1534,1648,1126,1390,1455,840,1417,997,56,353,503;28;M
101301;1648,1348,1137,503,1130,1641,1115,970,314,703,990,1097,1121,785,14;51;F
101383;1534,1097,1365,1031,309,1634,785,1190,1348,503,353;29;F
101395;883,1513,315,1634,811,1648,1390,1348,514,503,1130,1641,962,703,970;27;F
101403;93,637;43;M
101406;1417,678,1115;16;F
101412;678,315,1634,1121,990,1534,1126,1417,1455,1137,797,1641,314,970,14;43;F
101413;990,1126,1455,1001,1417,797,1641,353,315,1634,1513,785,123,514,1394;23;M
101428;814,1126,1390,1001,514,710,1137,1174;26;F
101436;518,1190,785,823,315,1365,1348,1417,503,797,1641,314,93,1115,1174;30;M
101469;1417,710,1130,1174,970,785,1031,315;45;F
101478;703,1641,56,1137,1417,1648,1534,990,814,833,518,883,1634,678,970;36;F
101480;1455,1126,1534,990,785,1031,315,309,26,999,1634,123,1417,1641,970;41;M
101499;999,309,315,1031,990,1648,1390,1455,514,1417,503,1641;62;F
101506;999,312,1115,309,315,1634,1534,1126,1390,1348,1458;49;M
101547;518,309,315,1634,1513,1648,1126,1390,1417,797,1458,1641,962,314,970;40;M
101556;1534,1648,1634,1513,883,1215,1126,514,1417,1137,1458,1641,703,1455,1130;47;F
101563;636,1121,883,1215,811,1137,703,812;67;M
101568;312,678,1634,883,1031,1097,833,814,1348,1455,1137,503,314;11;F
101569;1115,1190,518,823,883,1634,999,785,1534,1648,1126,1348,1455,970,353;37;M
101585;785,1348,1137,503,1094;40;F
101615;1390,1348,997,56,1641,314,309,883,785,14,1126,514,1137,503,1094;35;F
101623;883,1031,14,814,990,1534,1648,1126,1455,1137,503,1174,1641,93,970;59;M
101637;93,637;74;F
101655;14,970,1126,1417,1458,312,309,1513,785,1365,990,1534,997,710,1174;36;M
101659;1031,1190,785,14,1365,1126,1455,514,1137,503,703,952,93,812,970;46;F
101662;990,698,970,1031,785,1648,1455,1641;36;F
101666;1634,1121,883,1031,823,1190,785,1215,1348,1455,514,503,1130,1641,962;19;F
101674;514,1417,997,1130,698,314,315,518,1215,990,1126,1455,1137,503,1641;36;F
101678;1121,26,678,309,883,1097,1215,811,514,1417,56,503,1130,703,952;26;F
101684;309,315,1634,1365,990,1534,1348,1417,710,56,1174,1641,962,970,1115;30;F
101685;14,785,1417,1031,1365,1534,1130,1641,1455,1648,990,970,353,1115;25;M
101692;637,997,1455,1001,1190,315,678,883,840,514,503,1130,1641;30;F
101702;56,514,999,26,1031,1137,1130,703,1094,1634,1648,734,1641,314,970;30;F
101716;1094,1137,811;68;F
101717;1634,823,1190,1097,1348,1130;29;F
101722;797,1648,1534,123,785,1190,518,823,1031,26,1634,1126,1455,1641,970;33;M
101737;312,823,1648,840,797,93,636,1634,14,1348;44;F
101753;637,93,1641,1137,997,1190,518,823,1031,1634,990,1126,514,56,970;25;F
101754;309,1031,999,26,1513,785,1365,990,1534,1648,1390,1455,1417,1641,1115;51;M
101758;26,1634,1031,518,1190,785,1648,1126,1455,514,1417,56,503,1641,703;32;F
101782;678,309,315,1031,785,1365,1534,1648,1126,1455,1417,997,503,797,1641;42;F
101788;309,997,518,312,315,1190,1126,797,970;49;F
101803;1390,1001,1417,1130,797,1641,637,353,952,703,811,1534,514,734,503;29;F
101815;1031,990,1534,1648,1417,997,970,309,14,514,710,503,1130,1174,1641;33;F
101836;1513,315,678,1634,833,811,1648,1390,1455,514,1417,503,1130,1641,703;22;F
101842;678,309,1634,1121,1031,518,1097,1215,710,503,734,1174,952,93,353;39;F
101851;315,1190,785,14,1365,123,1534,1648,1455,1417,797,1634,1031,1126,1115;33;F
101888;312,678,1634,883,1031,1097,833,814,1455,1348,1137,503,314;11;M
101896;1648,1534,1031,315,309,1641,703,1348,785,14,811,1126,1137,503,797;37;F
101906;1115,312,1513,823,14,123,1648,1390,1348,840,797,1641;10;M
101927;309,1634,883,1031,785,1365,970,1115,1455,1417,1648,1641;37;F
101929;518,1126,840,997,93,315,1513,785,1534,1455,1390,1641,637,503,970;21;M
101961;970,56,1130,1174,1641,962;32;M
101962;1097,1121,1130,1190,999,1513,811,1390,1137,797,678,883,514,56,970;29;F
101965;678,1513,14,990;22;F
101974;1641,56,1190,1513,309,1534,1365,1634,1031,785,14,1097,123,1648,1126;76;F
101989;678,883,1534,1390,503,703,812;38;F
102006;636;45;M
102012;1390,1534,1634,1513,14,1365,990,970;55;M
102018;309,315,1634,1031,785,1534,1648,1126,1455,840,1417,797,1174,1641,970;38;F
102031;315,309,26,1031,1190,14,1097,1534,1648,1390,1455,840,503,1130,797;53;F
102063;883,26,1634,1365,1417,970,999,309,315,1031,785,990,1648,1455,1641;46;F
102077;970,678,1121,1513,1126,1390,56,797,952,314;29;M
102109;1634,1190,1390,840,1455,503,797,1641,703,970;37;F
102110;1417,56,503,1130,1641,703,970,353;29;F
102143;785,1103,1641,518,1097,990,1648,1001,514,997,56,1130,703,1094,970;66;F
102144;1348,503,698,637,636,1137,1458,314,93,970,309,883,14,1648,1130;52;F
102173;1455,514,56,503,1130,1641,962,703,952,93,970,637,353,636,1115;58;M
102175;970,93,1641,1130,503,1137,1126,315,1634,1648,997;36;F
102188;1417,1137,797,1458,1641,309,1190,14,811,1534,514,503,1130;17;F
102209;1190,883,26,678,1634,1513,1365,1648,1126,1390,514,1417,1641,970,1115;40;M
102311;990,970,637,353,1115,883,1031,14,811,514,1137,56,503,703,314;45;F
102338;1641,312,1513,823,14,1648,1455,840,797,93;8;F
102339;990,840,952,1634,883,1417,1641,703;32;F
102428;1634,1390,514,503,1130,1174;30;F
102433;970,312,1031,785,1648,1455,1641;42;M
102445;1031,1634,785,814,1126,14,1348,1455,840,997,1641,93,970,1115;14;M
102449;999,883,1031,1190,1534,1641,1455,309,1634,990,1126,1390,1115;56;M
102453;999,14,1097,56,314,315,883,1455,1031,990,1534,1126,1641,698,970;47;F
102458;309,1031,785,1365,990,811,1534,1648,1455,1001,514,1417,1641,970;40;F
102462;309,315,1031,833,811,997,1641,1634,785,123,1648,56,503,1130,703;39;F
102465;1001,514,56,1641,962,703,811,123,833,1097,785,1190,1031,315,1634;40;F
102470;315,1634,1031,785,1365,1534,1648,1126,1348,1417,997,1137,1458,1641,314;41;F
102483;1031,315,309,999,1417,997,1137,503,1130,703,1634,883,1126,1458,1641;35;M
102487;1031,785,1648,26,1190,1455,1641,970;33;M
102536;970,93,1648,1455,1417,1534,14,785,1190,1634,312,678,1641;41;F
102611;1634,1648,1417,1641;29;M
102612;999,315,1031,785,1365,990,1534,1648,1455,1417,710,1174,1641,970,1115;41;F
102615;785,990,811,1648,1126,840,1455,514,1417,997,56,503,797,1641,703;69;F
102622;1094,970,1513,14,814,1648,1390,1348,997,56,1641,703;42;M
102632;1137,1394,1458,703,1094,999,1513,1031,1365,1648,1348,1417,1641,1115,1634;34;F
102641;1455,1417,503,970,315,309,1001,514,997,56,1130,1641;60;F
102645;999,309,1031,1097,1348,1394,1641,698,970;4;M
102651;1126,1648,1513,1634,1031,1190,785,1365,123,1534,1390,840,1417,997,797;31;M
102679;1031,1215,1137,678,1513,883,1390,1001,514,503,952,314,812,637,636;38;F
102699;1097,1190,883,1121,1634,811,1001,1137,503,1130,703,698,314,812,1115;42;F
102713;703,315,785,1534,1390,1001,1417,734,1641,1634,14,514,952,1137,883;36;F
102740;812,703,1190,514,797,962,970,1513,1031,1417,1137,1126,1390,1130,1641;31;F
102751;1031,315,26,785,1455,840,1417,997,797,1641;82;M
102752;678,315,1031,1534,1455,1417,1641;45;F
102781;309,999,1634,1121,1031,785,14,1097,1103,1126,1390,514,703,314,503;22;F
102818;990,812,970,637,1634,1031,785,14,1365,833,1215,811,503,703,93;53;F
102849;785,123,1390,1455,1130,1115,999,315,1634,883,1031,1648,1126,503,1641;28;F
102858;1115,1390,1126,123,1648,970,503,1417,1031,883,1513,315,999,1634,1641;26;F
102870;1365,997,710,703,970,1115,999,1097,833,1103,990,1001,514,56,1130;54;F
102878;785,1390,514,1137,503,703,952;27;F
102879;14,1103,1417,1534,1648,883,1513,1121,1455,797,970,1634,1190,123,1641;46;F
102912;1130,703,814,785,883,1121,315,833,1648,1348,314,637,514,1137,503;20;M
102914;698,678,797,636,314,1365,883,1348,1534,1215,1648,1634,123,14,970;35;F
102931;1634,518,1190,785,1455,840,1001,503,1641,1115;30;F
102980;1634,1641,93,812,26,823,1190,814,1390,1348,840,514,997,503;13;M
102989;1174;37;F
102996;315,1031,1534,1455,1417;29;F
103009;1215,678;42;M
103010;503,636,1641,990,1215,883,678;38;F
103035;823,518,1190,785,14,1215,1126,1455,514,1137,503,1130,1641;21;M
103056;678,883,14,1097,1126,1394,1130,314,812;42;F
103066;1130,1121,1634,678,309,883,1031,785,14,1365,1097,1215,1648,514,503;45;F
103095;1417,1348,1215,785,823,1634,315,26;46;F
103123;999,309,1031,1365,990,785,1648,1126,1417,997,797,1641,962,703,970;37;F
103125;1634,797,1641,962,1094,353,1115;36;M
103140;678,1215;40;F
103167;636;76;M
103199;1121,1031,518,785,14,811,1534,514,1417,997,56,503,1130,1641,970;32;F
103216;56,514,503,1641,1130,1126,1103,1097,1094,999,353,811,785,703,123;64;F
103217;514,14,1634,1641,1031,1126,1390,1348,1458,1174;51;M
103242;678,1215;10;F
103244;999,315,1121,1190,14,1534,1126,1001,514,997,503,1130,703,962,1115;46;F
103300;823,1190,785,123,990,1534,1126,1455,840,997,503,1130,1641,703,970;22;M
103302;990,14,315,26,1634,1031,1190,785,123,1534,1648,1126,1455,840,1641;46;F
103309;1641,1126,990,999,1634,1121,1097,833,811,1137,56,503,1130,703,1094;49;F
103327;1641,1174,734,1137,1390,1534,1648,811,1215,823,1513,1634,678,797,93;55;F
103331;990,1215,1031,1190,883,678,1513,514,1137,56,1130,1458,698,314,636;31;F
103346;26,1455,1648,1534,1190,315,999,309,1513,1031,785,990,1390,1641,1094;47;F
103350;1634,93,1348,710;36;M
103368;678,26,1634,1031,1190,785,123,1648,1534,1126,1348,1455,840,1417,1641;36;M
103369;1634,14,1534,1137,1130;36;F
103391;1513,315,1634,14,1534,1390,1348,503,1130,970,636,678,56,314,93;39;M
103407;1130,1458,703,315,1031,1001,997,503,883,990,514,970;73;F
103428;503,314,1634,678,14;44;F
103430;312,678,315,1634,785,14,123,1534,1648,1455,1417,1641,93,970;10;F
103481;1417,514,840,1455,1390,1534,811,26,315,1634,785,1365,1097,1126,1641;36;F
103488;309,1634,883,833,811,1126,1348,1001,56,1394,503,1130,703,314,970;48;F
103503;1534,1115,1455,1365,785,1190,518,1031,1634,315,309,1641,514,1417,997;33;M
103524;1174,1641,962,710,1215,1634,952,970,734,1417,14,1365,123,1103,990;30;F
103558;811,1097,309,999,990,1534,1648,1417,503,314,1094,1115;36;F
103572;1513,1126,1130,999,1097,1348,1417,1390,1534,1648,1031,1634,309,678,1641;44;M
103612;785,1215,990,1126,840,1417,1174,1641,970;69;F
103617;1190,518,1634,123,1115,785,999,1534,883,1031,1365,503,1641,710,1174;32;M
103640;518,1190,785,14,1365,1648,1126,997,1417,1137,797,1130,1641,703,698;68;F
103644;1115,1634,123,1534,1455,1417,1130,1641,962,970;34;M
103647;1097,999,785,123,1103,811,1126,514,1130,56,503,1641,703,1094,353;67;M
103664;990,1534,514,1130,1641,970,353,1121,14,1126,710,1137,503,1174,1115;38;F
103683;785,1097,1390,1455,997,56,1641,1130,1103,1634,514,353,1001,1648,123;46;F
103686;1365,123,1417,353,785,315,999,1634,1031,990,1534,1648,1126,1641,970;24;F
103696;999,1365,1115,734,710,1174;35;M
103715;309,518,14,1365,1534,1126,1390,1417,797,1641,698,970,503,997,785;25;F
103721;1534,997,1641,14,785,1513,1634,309,312,353,678,123,1348,1458,93;45;F
103730;1455,56,1094,1115,698,1641,1130,1137,1126,1648,1534,123,1031,1634,14;46;F
103752;1348,1031,1513,1634,315,811,1534,1648,1455,997,1417,1137,56,503,1641;44;F
103785;353,734,1458,698,312,678,1513,1390,1348,1137,503,1641,636;43;M
103794;678,518,990,970;24;M
103807;999,1031,1648,1126,1417,1641;24;F
103831;1634,1648,1126,1455,1641;67;M
103860;26,315,990,1001,840,1455,1417,997,1137,56,503,797,812,14,1641;51;M
103866;883,315,1031,785,990,1534,678,309,1634,1513,1126,1348,503,1130,962;41;M
103880;1534,1455,1417,997,1130,1641,703,698,999,309,315,1031,785,1648,56;47;F
103931;1115,1641,1130,997,1534,990,1634;33;M
103935;1031,518,1190,990,1534,1126,1455,840,56,797,1641,314,93,1094,970;53;M
103973;678,315,1121,883,518,1097,1103,997,56,503,1130,962,1634,1190,1390;51;F
103981;637,1130,1137,1001,1215,785,883,1513,1097,1390,514,56,503,952,703;30;F
104012;1634,678,1513,883,1190,1215,1390,1001,514,1137,503,703,637,970,1641;25;F
104026;970,1115,315,990,1126,1641,1417,840,1348,1534,1190,1031,1634,26,678;39;F
104028;1534;43;F
104046;678,1215,734,1174,952;33;F
104072;678,315,1031,785,990,1648,1126,1417,797,1458,1174,1641,962;78;M
104088;997,710,56,503,797,1174,970,1634,14,1390,1417,1130,1641,962,353;32;M
104090;1115,990,1513,1634,309,315,785,1390,514,1417,997,1641,962,970,637;29;F
104103;312,678,883,14,1215,123,1348,1130,314,970,1634,636;34;M
104171;840,997,703,636,309,710,1513,883,518,1126,1390,1417,970,962,1641;73;F
104197;1031,14,1126,1390,1348,1458,1174,1534,1417,962;47;M
104198;1103,1648,1455,503,1130,1641,1634,1121,14,1097,514,56,703,1094,1115;31;F
104215;26,1634,1190,123,1455,840,797,1641,970;68;M
104233;314,315,678,1417,518,990,1534,997,1137,503,1458,1641,812,970,636;70;F
104246;26,1190,990,1455,840,1641;30;M
104299;1513,1121,1137,56,503,1130,734,1174,637;48;F
104311;314,1031,823,518,1365,123,1648,1348,1455,1417,1137,503,1458,1641,93;41;F
104356;1641,962,636,999,26,1513,518,1190,785,1390,1455,1137,56,970;51;M
104368;1534,1097,785,518,823,883,26,999,315,1215,1001,514,503,952,1094;26;F
104415;518,1348,997,353,970,1641,840,123,1190,26,962,797,1455,1126,1634;51;M
104428;1534,999,1365,1455,56,1130,1634,26,1031,785,990,1417,1641,970,1115;40;F
104447;26,309,1031,1126,1455,1641,1115;29;F
104458;93;13;M
104470;785,518,999,309,315,1190,811,1648,1390,514,56,503,797,734,952;31;F
104471;636,1641,1417,1648,123,785,1031,309,315,1455,1137,1130,314,678;35;F
104505;315,1513,1031,785,1648,1390,514,1641,962;42;F
104510;1513,840,503,1130,997,1215,14,1031,999,309,1634,123,1455,56,1641;71;M
104523;309,1634,1121,1513,1126,1001,514,997,1137,1394,503,1130,636,1648,1215;43;M
104556;312,678,1634,1031,518,123,990,1648,1126,1417,997,797,1641,314;37;M
104558;1121,678,1634,14,514,997,1137,503,1130,1458,734,1641,703,952,812;42;F
104563;678,1513,883,1215,990,1121,1137,1130,312,14,814,1348,503,962,93;41;M
104582;315,1513,883,1031,518,785,1365,1390,840,56,734,1174,1641,703,1115;32;F
104583;315,833,1455,997,312,1174,797,503,1137,1348,678,1190,14;29;F
104587;514,1417,503,1641,636,1458,314,14,1348,1137,1130,962,952;20;F
104591;1455,26,883,1641,353,123,1458,1390,1348,1126,1031,1634;51;M
104602;315,1634,1031,123,1455,1417,56,1121,785,990,1648,1126,997,1137,1130;44;F
104607;703,962,56,999,1103,315,1190,1097,1215,1001,514,1130;36;F
104620;678,883,823,814,1534,514,1417,1137,797,1458,734,1641,952,314,637;32;F
104629;823,518,1190,14,1348,1455,514,503,1130,1458,1641,698,314,93,812;18;F
104632;123,1365,1031,1634,1534,1130,1641;28;F
104649;1126,990,518,823,315,26,309,1634,1031,1190,123,1648,1455,1417,1641;21;F
104652;56;74;F
104662;785,990,811,1534,1648,1126,1348,997,1634,1121,56,503,1130,1641,703;49;F
104674;636;42;F
104683;678,883,785,1137,1394,503,797,1458,1641,703,952,698,970,636,353;40;F
104699;312,26,1634,1031,123,1534,1648,1417;19;M
104707;1390,990,785,1190,312,999,309,1634,1031,123,1534,1648,1126,1455,1641;43;M
104780;637,315,1634,1137,1130,1031,990,970,814,1215,812,309,1641,883,636;19;F
104787;14,814,56,93;46;F
104837;1634,1031,1648,56,1641,703;48;F
104894;1031,14,1534,1126,1390,1348,1417,1458,1174,962;46;F
104903;1641,93,1534,990,14,1190,823,1031,883,1513,1634,309,26,678,636;60;M
104904;1534,990,814,1365,883,518,1190,14,1126,840,1455,503,703,970,637;60;F
104924;1001,1103,1097,315,26,952,962,703,1130,503,1137,1215,785,883,1634;25;F
104926;812,1455,990,1365,1121,883,1634,1103,503,1130,1641,703;17;F
104987;883,1365,1137,1130,1641,14;74;M
104990;797,56,1455,1648,1534,990,814,315,26,1634,1031,123,1417,1174,1641;41;M
105012;26,1534,1641,93,970,353,1417,1455,1126,1634,990;39;M
105021;1031,14,1534,1126,1390,1348,1417,1458,1174,962;45;F
105067;999,26,1648,970,710,1458,1031,1417,1641,1174,1115,315,785,1365,1534;57;F
105098;26,999,1031,1634,353,1115,123,814,1534,1648,514,970,1417,503,1641;29;M
105105;315,309,1634,1031,785,1534,1648,1126,1455,1417,997,503,1641,970,353;29;F
105116;123,833,14,785,883,1513,1634,309,26,814,997,1137,503,1641,353;38;F
105118;990,1455,1417,710,1115,26,1634,1031,518,123,1641,698,93,970,637;24;M
105136;1634,315,309,999,312,1513,990,1348,997,797,1641;22;M
105141;1634,1031,518,1190,1648,1126,1455,840,1417,997,503,1130,797,734,1641;26;F
105160;678,1513,1031,785,14,814,1534,1390,514,1417,56,797,962,93,636;68;M
105163;637,1648,1126,314,962,353,1513,1121,1417,1137,1394,1130,1458,1641,698;38;F
105179;1634,1097,1215,811,1390,514,1137,503,1130,962,703,970;44;F
105213;999,1455,26,309,315,1031,1190,785,1365,990,1534,1648,1641,970,1115;22;F
105214;514,1634,1513,14,1097,1103,811,1390,503,1130,734,952;29;F
105217;518,1190,785,1365,883,1031,123,1534,1648,1126,1417,1137,1641,999,1115;43;F
105226;999,1031,785,1365,1534,1648,1455,1417,997,797,1641,962,93,970,637;31;M
105230;1634,1190,123,990,840,93;50;M
105232;990,1534,1648,1390,1417,1641,970;57;F
105256;1455,997,1130,1634,1031,785,1103,990,1534,1648,1126,1417,56,1641,970;65;F
105280;315,1513,1190,785,1097,1215,990,1534,1390,1348,514,1417,1641,962,970;46;F
105292;678,1634,883,1031,518,14,1365,1534,1648,1130,952;36;F
105310;309,999,1634,1534,962,1417,952;31;M
105326;1031,14,1534,1126,1390,1348,1417,1458,1174,962;13;F
105358;26,1215,1455,797,1641,1126,1648,1634,785,1365,123,990,1534,1417,970;43;F
105383;1634,990,1534,1648,1417,970;37;M
105389;678,26,315,1634,883,1031,1097,123,1534,797,1641;49;F
105413;678,309,315,1634,883,1031,518,785,814,1534,1648,1455,514,1174,1641;37;F
105447;883,1031,14,1215,123,814,1390,1348,1137,1130,797,952,1634,678,812;35;F
105455;1031,14,1534,1126,1390,1348,1417,1458,1174,962;80;F
105488;1634,1513,1031,14,1365,1215,990,1534,1390,514,503,1130,797,1641,970;52;F
105495;309,315,1634,1031,1190,785,1365,1534,1648,1126,1455,1417,997,1137,1641;28;F
105502;1126,93,1094,315,1365,1390,1634,514,1137;30;F
105503;14,518,1121,353,1031,1534,1648,1455,797,1174,1641,962,1634,990,1417;25;M
105509;353,812,952,797,1137,840,514,1130,1115,1390,1641,637,1634,883,1215;31;M
105533;1455,315,26,999,1031,990,1534,1648,1126,840,1417,1641,1115,309;43;M
105567;1031,14,1534,1126,1390,1348,1417,1458,1174,962;85;M
105647;823,1121,1634,309,999,312,14,1215,1390,514,56,503,962,812,1094;29;F
105699;26,1634,1648,1137,962,1190,1534,1390,840,56,1641,970;65;M
105706;1648,962,353,503,1390,14,1513,56,698,1641,785,1534,1394,1130,636;49;M
105724;970,1641,997,1390,990,785,1031,883,1634,1174;41;F
105733;14;72;M
105736;1634;48;M
105763;1130,1126,1103,14,1031,678,1634,1641,1115;29;F
105793;636,514,93,1390,1126,1648,1534,990,123,1215,1031,1513,883,1121,999;43;M
105802;1534,990,883,312,999,26,1634,518,123,1126,997,1137,797,1641,970;32;M
105815;26,309,1634,1031,1190,785,1365,1534,1648;26;F
105818;14,93;36;M
105829;1455,1390,999,312,1634,1513,990,1534,1648,514,883,785,823,315,309;43;F
105831;1534,1126,1417,997,1130,970,1115,315,1513,14,1390,1455,514,56,1641;29;F
105845;637,1115;52;F
105849;26,315,1634,1031,518,14,1365,990,1534,1126,1455,840,1417,797,1641;32;M
105871;1513,1648,1455,1458,93,314,797,503,56,123,14,883,1121,315,312;50;F
105872;1417,710,1137,1641,962,970,353,1115,14;32;M
105898;1390,123,785,1031,315,990,514,999,1634,1534,1455,1417,1130,1641,970;23;M
105940;315,1634,1031,823,518,123,990,1348,1417,56,1130,353;38;M
105945;883,518,1190,785,1365,1097,1103,56,503,1130,734,1641,703,1115,353;31;F
105953;785,1215,814,1458,952,1001,1513,883,833,811,1390,1348,1137,734,703;43;F
106012;1126,990,123,1121,883,1534,1390,1348,797,1641,1137;44;F
106021;1648,1365,1190,1031,678,990,14,1513,315,883,785,1348,997,503,93;30;M
106034;703,999,1634,1513,883,1097,123,990,1534,1648,514,1417,1641,970,1390;29;F
106046;314,503,1137,514,1001,1390,814,1103,1215,1097,14,883,1513,1121,315;29;F
106071;1365,1534,1126,1455,314,1115,315,883,1097,990,1648,1417,1641,703,970;63;F
106094;970,636,353,1130,503,56,1390,814,1103,123,1121,315,26,678,1634;29;F
106111;1634;48;F
106132;309,1634,785,14,1365,1417,710;39;F
106135;1121,678,56,1215,315,1190,123,1648,514,1137,503,797,1641,962,636;37;F
106184;1455,1215,518,1190;41;M
106233;309,315,1634,1031,785,1365,990,1534,1648,1126,1455,1417,56,1130,1641;41;F
106248;1097,1215,1390,514,56,503,734,1641,703,952,314,812,1094,970,637;28;F
106265;678,1031,14,1534,1455,797,1641,309,785,123,1390,997,970,353;61;M
106276;309,678,1634,883,1031,785,1365,123,1534,1126,1455,1417,997,1641,636;40;F
106303;883,315,1634,1513,1031,1215,123,990,1534,1390,514,997,1137,503,797;11;M
106336;315,14,1648,1455,56,1130,1641;38;M
106362;785,678,883,1097,1215,811,1390,1001,514,1417,1458,734,1641,698,637;51;F
106379;315,514,999,309,1634,1121,1031,1534,1648,1348,1455,997,56,1641,962;46;M
106452;1097,1648,1390,1455,1001,514,1417,997,503,1130,1641,703,952,314,353;28;F
106463;1534,1390,1641,970,785,1031,1513,1634,883,14,1365,123,1648,1417,962;47;F
106474;952,314,637,353,636,970,1094,812,1641,503,514,1390,1215,518,1513;13;M
106493;1190,309,315,1634,26,1031,1365,785,990,1534,1648,1455,1417,797,1641;42;F
106503;990,56,93,1001,710,637,883,1215,514,1190,797,1174,1115,1534,1634;37;M
106557;1115,1534,990,1215,1365,785,883,1634,315,1390,514,1137,1641,962,703;24;F
106588;637;41;F
106625;514,785,823,1031,883,1513,1121,1634,315,309,26,678,797,1174,636;28;M
106626;309,26,315,1634,1513,1031,1534,1390,1455,514,997,56,503,1641,353;52;F
106629;814,811,503,14,997,1215,703;45;F
106696;883,518,14,814,1390,1348,56,797,93,1115;48;F
106718;1634,1513,1190,1097,123,1648,1390,1455,514,56,503,1130,703,970,353;36;F
106725;1648,1348,1455,1001,514,1417,997,1137,503,1174,1641,962,314,93,353;8;M
106738;811,1348,514,1641;48;M
106745;637;3;F
106757;93,970,353,636,1634,814,990,514,1137,503,812,14,710,734,1174;34;F
106800;811,814,1365,785,1031,1634,999,678,990,514,1417,710,1137,1641,970;36;F
106816;636,990,123,1513,1634,1215,814,1390,1348,514,797,952,93,812,1094;19;M
106820;314,1137,678,883,1031,1215,990,1648,1348,514,1641,970;36;F
106837;1390,840,997,503,93,636,1115,678,26,883,1190,1534,1126;42;M
106874;637;9;F
106896;1126,1513,1634,1190,811,1390,840,1001,514,503,1130,26,703,970,353;32;F
106902;353,314,1174,503,710,840,1348,1126,823,1634;25;M
106917;1634,636;49;M
106920;14,990,1641;80;M
106962;637;15;M
106973;309,883,1031,518,785,990,1534,1648,1126,1390,1001,514,1417,1641,970;64;F
106979;1634,785,1534,1648,1126,840,503,1641;33;M
106987;14,636;62;M
107043;1513,1634,678,14,1126,514,1137,1130,503,797,1458,1641,1094,637,636;40;F
107061;1634,14,814,1137,56,1130,1641,353,636;41;F
107068;999,1001,1031,990,1174,1534,710;32;F
107071;26,999,312,309,123,1348,962,1641,1394,514,1190,1031,1513,1634,1390;28;M
107109;811,1215,785,678,1634,883,833,1534,1348,1455,1458,1641,962,698,314;11;F
107117;637;16;M
107124;26,315,1634,1031,1190,518,785,14,123,1126,840,997,1641,703,970;32;F
107125;312,883,1634,1031,990,1648,1126,514,997,1137,503,734,703,952,812;70;M
107194;514,1126,1534,678,1215,1130,1641,970,637;29;F
107224;309,1513,1031,14,1103,990,1534,1648,1126,1390,1417,1137,1130,1641,314;38;F
107232;56,314,1137,812,703,514,1121,1031,14,1215,814,1126,1390,1348,1458;44;F
107233;1365,309,315,785,1190,14,990,1648,1417,797,1641,1115,26,1634,123;62;M
107245;678,14,833,123,814,811,1126,514,503,1130,797,703,93,1094,636;58;F
107251;56,353,1390,14,970,1031,1174;32;M
107269;1634,814,811,1126,503;35;F
107277;1534,1648,1348,1455,710,797,1174,1641,636;32;M
107314;514,710,678,833,1215,734,952,314,353;34;M
107323;785,1455,1641,1115;22;M
107362;1417,997,1641,93,1513,883,952,1634,14,1215,1001,514,56,503,1130;25;F
107416;1115,1365,56,1648,1455,1417,883,636,1137,1641,970,1031,26,990,785;44;F
107481;1513,883,997,1390,309,26,1634,518,785,990,1455,1417,797,1641,962;41;M
107487;93,636,637,678,883,1215,56,503,1130;51;F
107489;309,315,1031;70;F
107492;93,999,315,1634,1031,1190,785,990,1534,1648,1455,1417,797,1641,123;43;M
107533;1348,1390,814,1103,123,883,1513,1634,703,314,93,812,637,353,636;22;M
107541;1634,1031,14,1390,1174;29;F
107687;93;41;F
107692;999,1634,309,315,1031,785,990,1534,1126,1455,1417,1137,1130,1641,970;52;F
107703;1455,1126,1634,1031,123,990,1390,997,797,970;68;F
107706;26,1534,785,970;48;M
107743;703,503,1137,1001,1126,1215,833,785,1513,678,123,1390,1458,797;40;F
107750;1031,1513,26,999,1390,1417,1130,1458,698,309,1634,1648,734,1641,962;33;F
107752;1648,1115,970,26,309,315,1634,785,1031,990,1534,1126,1455,1417,1641;48;F
107761;1001,1634,678,1031,1534,811,503,1130,1458,1094,1115;27;F
107798;1137,997,514,1648,1534,833,1215,14,785,1031,883,1513,1634,315,26;64;F
107802;636,353,1094,703,1458,678,1121,1097,1103,814,1348,840,812,314,698;28;M
107867;14,814,811,1648,1126,1455,1417,1137,503,734,1641,703,698,637,1115;9;F
107869;785,1365,1534,314,1094,353,1174,503,710,1348,123,14,518,1634;38;M
107872;1130,970,1417,1455,1634,309,999,883,1031,1126,990,997,1137,56,1641;40;M
107897;999,678,312,1634,1121,1513,883,518,14,1365,1390,56,503,1130,1641;42;M
107906;1641,1634;46;F
107915;1641,353,636,999,315,1121,883,1031,123,1534,823,518,1648,93,812;43;M
107927;1634,518,14,1097,811,1126,1417,1137,797,734,1130,503,952,678;29;F
107963;315,26,1031,518,1190,1126,1455,840,1417,56,503,1130,1641,703,970;65;M
107976;970,1115,999,315,1634,883,1513,1031,785,1365,1534,1648,1390,1417,1641;22;F
108031;1534,123,785,823,309,1031,814,1648,997,1115,840,503,1458,1641,93;14;M
108044;1634,315,309,999,312,1121,1031,811,1534,1648,1126,514,56,1641,812;40;F
108047;823,1365,1534,1455,503,797,1174,1641,703,698,314,93,1094,970,1115;10;M
108048;56,1130,962,93,970,1115,1094,883,1534,1126,514,997,503,1641,703;58;M
108053;999,26,1031,123,1534,1126,1348,1455,1641,1634,1190;43;M
108060;678,1634,14,811,1126,1137,56,503,1130,1458,1641,698,314,1094;43;F
108064;312,999,883,1534,1390,997,990,1634,1031,1215,1126,1137,56,1458,1641;42;M
108074;315,785,353,970,703,1641,1130,503,514,1001,840,1390,1190,1634,26;40;M
108082;1634,1534,1126,1455,840,997,503,797,1458,1641,962,703,314,812,1094;39;M
108089;1097,14,785,518,1031,1634,678,309,315,1648,1455,1417,1641,93,970;40;F
108090;1031,26,997,1097,990,1455,710,1417,56,1641,1121,1648,1534,840,1130;62;M
108092;1634,14,1513,883,785,833,1215,814,811,1126,1390,1001,514,1137,703;40;F
108097;1126,1648,999,309,315,1634,1534,1455,970,1031,785,1365,990,1417,1641;35;M
108105;1215,1190,1513,1634,883,14,1097,1455,514,1417,503,123,678;40;M
108107;1641,514,1634,26,1513,1190,1390;46;F
108119;1634,1534,1455,1417,1641;34;M
108127;1455,997,1641;24;F
108128;309,1634,1513,518,1215,814,1390,514,997,1137,1115,503,734,1641,952;30;F
108135;315,1031,518,785,990,1534,1648,1390,1455,1417,997,734,1641,962,970;34;M
108148;999,309,1513,1365,1390,1455,997,1137,503,970,1115,1641;34;M
108175;1417,1348,1365,14,678,309,315,1031,785,1534,1648,1126,1455,1641,636;59;F
108176;1137,1390,503,1130,314,1094,1634,1513,883,1031,1215,123,814,1126,93;36;M
108204;637,503,1130,962,703,353,840,1455,1126,1648,1031,1634,514,797,1641;36;F
108223;1126,840,997,797,1641,970,636,1634,883,1031,14,1365,990,1534,1455;36;F
108230;1031,785,1365,1648,1534,1455,1417,997,797,1641,962,93,1115,710,1174;35;M
108253;1634,883,123,1648,1126,1390,1348,997,314;41;M
108259;1031,309,678,1634,1513,883,14,1215,123,990,1126,1390,797,1641,93;54;F
108281;678,315,785,1126,1417,710,1137,56,503,797,1458,734,1641,952;31;F
108296;1455;79;M
108329;678,14,1215,814,1137,56,503,1130,314,93,812,637,636;55;M
108390;678,883,1031,785,1365,1215,990,1648,1348,1455,1130,710,1634,999,1174;35;M
108414;14,1641,797,678;36;F
108442;990,883,1365,1126,1417,698,1115,999,315,1031,785,997,970,1641,309;52;M
108460;814,26,678,883,14,811,1137,503,734,1641,703,952,314,812;34;F
108486;990,123,14,1190,518,1031,678,1634,883,1215,814,514,1137,503,734;31;F
108495;1634,1513,1390,1174;29;F
108505;990,1031,353,1115,309,1634,518,1648,1126,1348,1455,514,503,1641,703;32;F
108520;309,14,1390,1348,1417,1137,56,503,1458,1641,703,698,812,1094,970;42;M
108535;990,1390,1634,883,1031,1190,785,1365,1648,1001,514,503,1641,703,637;31;F
108580;1634,883,811,990,1126,1455,1001,797,1641,703,970,637,353,1115,636;37;F
108644;952,840,1215,1190,883,1513,1634,1390,1001,514,710,1130,1174,637,353;21;M
108647;823,999,309,315,1031,518,1097,1648,1348,997,56,797,1641,703,970;41;F
108655;353,312;33;M
108681;1115,970,1121,309,785,990,1126,1390,514,1417,997,56,1130,1641,962;17;F
108684;1031,309,312,1634,1121,1190,1215,1648,1390,997,56,503,1130,1641,952;15;F
108695;1031,315,1121,518,785,1097,1215,1001,514,710,503,1641,314;46;F
108703;1121,962,812,1634,990,1126,1390,840,1455,1417,797,1641,636,970,93;41;F
108711;883,1130,703,93;61;F
108729;999,26,315,1031,785,1365,1648,1348,1455,1417,1641;16;M
108746;678,518,14,1097,123,990,93;32;M
108760;1190,990,1455,840,514,997,1137,797,1641,703,970;42;F
108809;1103,1348,1455,1417,997,503,1130,1094;33;M
108829;1513,14,1365,1097,1103,990,1390,1001,514,503,1458,1641,703,314,1094;40;F
108839;1031,26,309,1634,518,123,1390,840,1455,514,503,797,1641,703,1115;52;F
108848;1634,1031,1648,1126,1390,1455,1417,997,678,1513,1365,990,1534,1174,1641;23;F
108874;1215,883,1513,315,309,999,26,1634,1031,518,1190,785,14,123,1126;39;F
108914;1634,1121,518,14,811,1137,56,703;61;F
108956;93;47;M
108986;1031,1634,309,315,785,1390,514,503,797,962,703;59;F
109013;678,823,518,1348,797,636;12;M
109020;315,1634,990,970,637,734,797,309,1097,123,1126,710,1130,1641,353;47;F
109067;1097,56,1130;74;F
109090;1534,14,1513,811,698,1641,314,678,883,1031,1365,1215,990,1348,1137;39;F
109102;1634,883,1534,1115,1648,1365,1031,315,999,785,1348,1126,503,1641,1417;17;M
109135;710,1174,997,1417,1455,1648,1534,990,1365,785,1031,883,315,26,970;42;F
109145;1031,1513,999,1634,883,518,785,1097,811,1390,514,710,503,1174,703;36;F
109152;1215,1390,514,503,1130,314,636,1513,1121,14,1348,56,1458,734,962;25;F
109160;678,823,518,1348,797,636;9;M
109170;678,14,1097,1534,1648,1126,1390,1455,840,1001,514,1417,1137,503,1130;35;F
109203;970,1115,312,999,309,315,1634,823,990,1534,1126,1455,1417,1641,93;42;M
109205;1215,990,1126,1455,1417,883,785,123,1534,840,514,503,1130,1641,970;35;F
109263;1513,503;49;F
109269;678,309,990,503,1641,314,636,1634,14,518;52;M
109281;797,962,999,309,315,1031,785,1097,811,1648,1641,970,353,1115,1534;34;F
109298;1190,990,1126,1390,1348,1417,997,503,1641,970,1634,518,785;28;F
109301;678,823,518,1348,797,636;7;M
109313;26,883,1031,1190,1390,1455,840,514,1417,1137,56,503,1641,703,970;66;F
109378;812,309,1634,1097,1215,990,811,514,1137,1641,970,1130,797,14,503;42;F
109406;1115,1174,678,1634,785,1097,1390,1137,636;32;F
109407;26,1634,1190,14,833,1126,1455,840,1417,997,1137,503,1130,1641,637;45;F
109416;678,823,518,1348,797,636;;F
109439;1534,1126,840,1417,1641,1115;55;F
109448;637,636,678,1190,1097,811,1001,514,1137,56,1130,962,314,1121,93;40;F
109456;1634,14,1103,1348,503;35;F
109474;26,785,1365,970,999,315,1634,1031,1215,990,1534,1648,1455,1417,1641;43;F
109495;353,703,503,1137,1031,123,1534,1348,970,1641,1634,883,1648;39;F
109501;312,883,518,14,1097,1215,123,1348,1390,840,1001,514,353,1634;35;F
109503;1126,1001,514,1137,56,503,1130,703,698,314,812,1634,883,1097,811;38;F
109507;999,26,309,315,1634,883,1031,123,1648,1126,1455,797,1641,93,970;41;M
109513;1513,315,312,678,1634,883,833,811,1390,1455,514,1137,503,1130,703;40;F
109531;26,1455,840,1641,970;47;M
109548;883,14,1648,503,703,970,93;9;F
109581;678,883;47;F
109592;309,883,1031,1215,1648,1126,1455,1417,514,1130,1641,314,970,637,636;55;F
109627;1513,312,93,812,636,353,678,1634,883,1190,514,1137,503,952,637;38;F
109638;1121,312,309,883,1215,990,1455,1001,514,1137,503,970;49;M
109665;1390,814,1031,1513,1115,970,1641,797,840,1417,1648,1534,990,315,26;34;M
109745;1137,1394,990,1458,1641,1348,840,1534,1031,1634,315,1215,962;45;F
109763;1031,1455,997,962,1641,1130;39;M
109775;1365,1215,1641,990,1534,1126,514,1634,883,785,1455,1417,710,734,1174;30;F
109777;999,1513,1031,785,1365,990,1534,1126,1390,1455,840,1417,797,1641,970;30;F
109778;1648,1126,1390,1455,1174,999,1634,1121,1534,1417,93,1458,1641,970,636;13;F
109785;353,309,785,990,1115,1365,1031,1126,999,1534,1641,1634,518,1648,123;43;M
109793;883,1215,814,1390,514,1137,1458,1641,93,312,823,14,1348,503,1115;43;F
109818;883,1126,1390,997,1634,1121,1513,823,123,514,56,1130,797,1094,970;46;F
109843;1634,1097,1190,518;63;M
109857;698,1115,315,883,1031,785,990,1534,997,1417,710,1174,1641,93,970;39;F
109867;1215,1001,999,883,797,785,637,636,514,503,14;36;M
109868;999,315,1031,1190,990,1534,1648,1390,1455,1417,1137,1130,1174,1641,1513;21;F
109879;14,503,812;17;M
109890;14,503,514,636,637,785,797,883,999,1001,1215;35;F
109920;309,1097,1215,514,678,315,883,785,1648,1417,353,1634,1031,1534;37;F
109964;56,1130,1174,503,93,1634,14,1648,514,1417,1137,797,1641,636,637;39;M
109975;1031,1190,785,1417,1137,636,93,1634,823,518,123,1126,1348,1458,1641;37;F
110005;514,1126,1365,1634,315,1513,1215,990,970,1534,1648,1390,1417,1641,636;56;M
110009;1126,990,883,1031,1190,785,1215,123,1534,840,514,503,1130,1641,970;38;M
110029;1215,14,312,1513,883,1097,814,1390,514,710,1137,56,503,314,637;34;F
110077;503,1130,734,962,970,1190,1534,1634,785,123,811,1648,1348,1641,703;39;F
110091;309,999,1513,1365,1097,1534,990,1126,1390,1137,56,503,1458,703,970;30;M
110169;1534,1390,1455,840,1641,999,990,1126,514,997,797,970,1115,785,1365;35;M
110185;637,1513,1390,514,1137,1130,315,883,1365,1648,1115,999,309,1634,970;41;M
110196;814,1001,514,1137,1394,503,797,1458,734,952,314,93,637,353,636;4;M
110204;990,1641,970,637,312,678,315,1634,123,1126,1348,1137,503,797,314;38;F
110230;678,1634,14,1648,1126,1001,1137,1394,1641,698,637;41;F
110232;999,1031,785,1365,1126,1455,1417,1641,970,1115;67;M
110267;1634,518,1190,1097,1534;27;M
110276;1103,1137,698,93;37;F
110287;999,312,990,1455,514,970,1390,883,1513,1634;40;M
110289;1137,703,952,93,970,637,636,883,518,1215,811,1001,514,503,734;37;F
110320;518,1031,883,1634,315,1121,1513,1190,1097,1103,811,1390,514,503,1130;19;F
110331;1190,1641,1137,1126,1534,1031,883,1634;33;F
110339;1634,785,1115,999,309,1031,811,1534,1648,1455,503,1130,1641,703,314;29;F
110349;1190,14,123,1648,1455,840,1417,1137,56,503,797,1641,93,636,1115;38;F
110358;1348,1417,997,812,999,315,1634,1031,823,1190,123,990,1126,797,1641;47;M
110377;678,1215,962,703,883,14,811,1126,1001,514,1137,503,698,314,637;36;F
110391;315,1031,123,1534,1126,1417,1137,1458,698,823,56,1394,503,1641,314;40;M
110409;1130,970;33;F
110421;315,999,26,309,1190,1390,1648,1455,962,514,1417,503,1130,797,1641;49;M
110431;1455,1417,997,1641,962,703;32;M
110434;312,678,309,1121,518,1190,123,990,1534,1348,1455,997,56,1458,93;13;M
110443;970,1031,990,1534,1126;60;F
110456;56;45;M
110525;93;32;F
110532;678,1634,1031,1190,123,1534,514,797,1174,93;28;M
110538;999,315,1634,1031,785,990,1534,1648,1126,1348,1455,1417,997,1115,1641;45;M
110548;883,309,785,1534,637,1115,26,1634,1031,990,514,1648,503,1641,970;39;M
110554;1121,1513,14,1097,814,1390,1348,1137,56,503,1130,314,812,637,636;41;M
110581;309,1634,1031,518,1190,990,1648,1534,1455,840,1417,1641,123,797,353;19;M
110582;26,315,1634,1094;30;F
110595;56;44;F
110605;1031,309,26,315,785,1365,990,1534,1648,1455,840,1417,1641,970,1115;39;F
110612;1126,840,1001,514,997,503,962,314,970,1115,1103,1215,14,1390,56;32;F
110624;309,315,1031,1126,990,1648,1455,970,1115,1190,785,1634,123,1534,1641;49;F
110626;1634,840,797,1641,353,1115;35;F
110636;999,309,1534,315,1031,1348,1126,1455,503,1634,1190,785,1417;17;F
110657;999,1031,785,1365,1126,1455,1417,1641,970,1115;68;F
110669;1634,315,999,309,785,811,1348,1455,514,503,1130,1641,962,970,353;23;F
110692;93;88;F
110708;1534,811,1097,785,1513,315,999,1031,1215,1641,1634,990,1648,1455,1001;46;F
110710;1115,1641,1417,1648,1365,785,1190,990,26,1634,518,123,312;40;M
110712;56;12;F
110723;703,997,1390,1648,1365,309,1634,785,990,1455,1001,1417,503,1137,970;48;F
110750;309,678,1634,883,1031,1097,1215,814,1534,514,1417,503,1641,703,952;43;F
110786;999,315,1031,990,1534,514,1417,997,56,1641,970;45;F
110815;999,315,1513,1103,1390,1115,970,1641,1458,1130,123,785,1031,883,1634;32;F
110872;823,1634,14,990,1534,1126,1390,997,1137,710,1394,1641,314,93,970;15;M
110879;999,26,518,785,1648,1417,1137,1130,703,990,1031,1641,315,1534,1455;33;F
110895;999,309,315,1031,990,1534,1417,1174,1641,970,1115;51;M
110913;678,1648,1534,637,636,970,1137,514,990,785,883,1513,309,26,93;37;F
110923;814,734,1130,1137,1417,514,1001,1215,1634,833,14,811,710,503,1174;29;F
110932;1031,637,315,999,309,1513,883,990,1390,514,1417,1137,56,970,353;44;F
110954;785,1365,1641,1126,1648,309,1634,1121,1031,990,1130,314,970;47;F
110964;883,1190,990,1648,56,962,1417,997,503,1130,93;11;M
110992;1634,1190,1097,1103,1648,1126,1455,1001,503,1394,1130,1641;20;M
110994;1634,1031,1190,785,14,1365,123,1648,1455,1390,56,1130,797,1174,1641;26;M
111005;1031,785,1365,990,1534,1648,1126,1348,1455,1417,1137,1130,734,1641,952;27;M
111011;1634,503,990,883,14,1097,1137;53;F
111013;503,93,970;66;F
111025;1031,1190,1648,1455,1417,997,503,734,1174,1641,952;25;F
111028;1121,315,999,312,309,1634,883,823,14,1641,314;40;M
111038;990,1455,1641;66;F
111085;997,315,678,1097,811,1390,1348,503,514,56,1130,1458,703,637,636;48;F
111086;785,1001,1513,883,833,1215,814,811,1390,1348,1137,1458,734,952,703;4;M
111121;1534;35;M
111174;678,1126,1130,1641,636;40;M
111175;1390,353,1648,1534,315,1634,785,990,1126,1417,1641,970;68;M
111187;970,997,1417,1455,1126,1648,1534,990,123,309,999,1634,1031,1641;42;M
111189;999,26,1634,1031,785,1365,990,1534,1455,1417,56,1130,1641,970,1115;39;M
111190;312,785,1348,1458,1641,962,314,636;42;F
111193;833,315,999,26,1634,1031,1648,514,1137,1130,734,1641,703,970,1094;34;M
111227;93;31;M
111240;1137,812,990,309,1365,1215,1534,1455,503,1641;38;F
111261;1634,1455,1641,1513,1648,703;47;F
111265;353,1648,990,123,678,1634;53;M
111280;785,1534,1648,883,1031,518,811,990,1126,1001,514,56,503,703;42;F
111289;1121,14,814,1126,1390,1348;22;M
111290;514,1417,1130,1031,883,1513,518,990,1534,1648,1390,1137,1641,970,1115;73;F
111296;1513,1634,315,309,26,999,883,990,1648,1390,1417,797,1641,970,637;29;F
111322;1634,883,1190,785,1648,514,997,797,698,1348,353;11;M
111333;1455,1126,1648,1534,990,123,785,1190,1031,1634,315,309,999,1641;41;M
111339;1031,1634,1215,990,1534,1126,1390,1455,840,1001,997,1130,1641,703,970;27;M
111346;1458,636,314,93,1126,123,823,1031,309,1634,14,1648,1137,1641,353;45;F
111380;1634,1513,1190,1365,970,883,1390,840,1001,514,797,1641;29;F
111409;990,811,1130,1458,734;44;M
111428;1455,952,883,1641,970,353;40;F
111463;999,26,315,1031,785,14,1365,1534,1648,1126,1455,1417,1641,970,1115;32;M
111476;999,883,1031,1190,1365,1215,1534,1390,1455,1417,997,1641,970,637,1115;43;M
111488;514,1513,883,785,833,1215,811,1390,1348,1001,1137,1458,734,703,952;7;M
111493;990,1648,1455,514,1417,353,1115,1634,1215,1001,710,503,1174,1641,970;25;F
111499;309,1634,883,1031,823,785,14,1097,1348,1001,514,56,1130,1641,703;53;F
111511;678,14,997,56,1130,734,962,703,952,1115;31;M
111539;1634,1513,883,1031,785,1190,14,1365,123,1534,1390,1115,1417,797,93;41;M
111546;797,703,698,314,93,970,353,26,315,1634,1031,785,1534,1455,1641;45;F
111567;678,999,1648,1130,970,93,1641,990,1215,1190,1031,883,1513,1634,315;38;M
111581;637,514,1390,678,309,1513,883,785,1215,990,1534,1137,93,970,636;41;M
111612;1417,1126,883,1215,990,1455,514,503,1641,970,1634,1513,1534,1648,93;36;F
111613;1634,1513,1215,797,314;40;M
111616;309,970,999,990,14,93;38;F
111623;56,962,970,678,309,1634,1126,1130,1641,703,314,1094,1115;38;F
111650;999,315,1190,1215,990,1126,1390,1417,970,785,1648;33;F
111665;1513,990,1348,1215,123,1534,1648,1390,1417,1174,1641,678,1634,883,1031;30;F
111687;1634,883,1190,785,833,123,990,514,503,1130,797,962,703,314,970;45;F
111701;678,1121,1513,14,1215,1390,1001,514,503,1130,353;38;F
111702;1641,1115,312,678,1121,785,14,1097,811,1348,1137,56,503,1130,1458;39;F
111711;309,883,1097,785,1103,1390,1001,514,503,1641,962,703,698,314,353;37;F
111724;1121,997,1130,703,970,314,698,962,797,503,56,1417,1348,823,678;11;M
111727;883,14,1103,514,1137,1394,503,637;51;F
111738;999,1513,1031,1097,1103,990,1534,1648,1348,1417,1641,314,93,636,1115;9;M
111752;1641,990,1215,312,1121,1097,14,1348,1137,56,503,1130,1458;47;M
111771;1031,883,1417,353,1115,636,312,518,785,1455,997,56,503,1641,314;10;M
111790;1348,1126,1634,678,312,990,814,1190,503,962,703,952,698,314,93;37;M
111802;703;56;M
111806;315,1634,1031,518,1190,785,123,990,1648,1126,1455,840,1417,1641,970;67;M
111811;309,785,1215,1534,353,1137;48;F
111827;734,503,56,1137,514,1001,1390,814,1215,14,1634,883,518,1365;37;F
111830;785,990,1455,840,710,1648,1031,1001,1534,999,26,1417,1126,1641,1115;28;F
111840;785,1365,990,1534,1648,1126,1390,1455,514,710,1417,997,1458,1641,1115;26;F
111844;309,999,26,315,1634,1513,1031,1190,990,1534,1390,1455,1417,1130,797;34;M
111859;1534,1348,1390,1513,1121,1634,1094,1641,1130,1137,1001,1126,990,1215,883;21;F
111872;14,1215,814,1648,1126,1390,1348,1001,514,1137,56,1458,314,812,1094;11;M
111874;1648,1031,1001,1534,999,1115,26,1126,1641;27;M
111903;1634,1031,14,1126,1348,1455,514,1417,997,1137,503,1641,703,314,353;49;F
111912;990,514,1458,309,1031,1137,503,1130,797,703,315,56,1641,962,970;40;F
111921;970,1097,315,1634,518,811,1648,514,1417,997,1137,503,1130,1641,703;49;F
111939;814,309,315,999,26,1031,785,1365,1534,1648,970,1641,1634;14;M
111942;1215,990,1534,1348,1455,514,1417,997,1137,56,503,1130,1458,1641,703;49;F
111945;1115,1031,1215,999,1634,814,1534,1126,514,56,503,1130,1641,698;40;F
111949;883,1365,1215,990,1534,1648,1126,1348,1455,1001,514,1137,503,1458,1641;33;F
111950;1641,734,703,952,314,970,883,1031,990,1534,1137,503,1097,1126,1390;44;F
111964;26,309,315,14,990,811,1534,1648,1137,503,1458,1641,703,698,314;37;F
111965;1390,1031,1365,1534,1648,1215,1455,1417,514,710,1137,1641,698,1115,970;28;M
111973;315,1031,990,1534,1648,1126,1001,1417,997,1641,970,514,503,1115,353;45;F
111976;1121,1513,14,990,1390,1348,1001,514,1417,503,797,1174,1641,962;49;F
112000;999,26,309,315,1634,1031,990,1648,1126,1417,1641;47;M
112024;833,1130,1641,970,883,1365,962,1648,990,514,503,785,1534,1390,1455;55;F
112040;93,636,678,999,26,883,1031,1097,990,1648,1126,503,1641,812,1094;34;M
112062;678,1513,883,1031,1190,990,1126,1390,840,1417,1137,503,797,1641,970;37;F
112070;518,1534,1648,840,997,26,1634,1031,1190,785,123,1126,1455,1417,1641;40;M
112084;1348,962,314,636;11;M
112112;970,883,14,503,353,1390;64;F
112130;1190,309,1417,315,1634,1031,14,990,1534,1126,1137,1641,703,970,637;73;M
112131;1190,1513,26,1130,962,970,883,518,785,14,1215,990,1390,1417,734;68;F
112159;1513,1031,1126,840,1458,1634,883,1390,1190,785,797,93;45;M
112231;514,1130,637,1190,1634,1641,1513,1001,990,883,814,703,1121,1348;28;F
112245;315,1031,785,1534,1455,710,734,1174,1001,1215,883,1634,990,1648,1641;23;F
112254;312,1348,962,314,636;8;M
112255;999,1513,1031,26,1634,1121,1390,514,997,503,1130,797,1174,1641,703;40;M
112260;1513,309,315,1634,823,14,811,1126,1455,997,1137,1130,703,1094,970;49;F
112262;883,636,1634,1648,1641,315,785,1097,309,1031,123,990,503,1130,970;45;F
112293;990,811,514,1513,123,1390,1455,785,1634,26,309,1641,1031,1648,1130;36;F
112298;56,1190,123,1126,1455,797,1641,970,999,309,315,1634,1121,990,1534;55;M
112319;312,1634,1031,823,1641,678,1126,1348,797,703,314;40;F
112350;1417,698,1126,999,1513,1031,990,1534,1648,1390,1115,1455,1641,970,636;11;F
112367;823,1513,312,797,703,1097,1031,833,1390,997,1137,503,962,970,637;55;M
112368;797,315,999,1634,1513,970,26,1031,990,1534,1648,1390,1455,1417,1641;73;F
112377;1513,14,1126,1390,797;32;F
112402;734,1455,1215,678;33;M
112407;1634,823,785,1390,1348,503,1641;15;M
112411;678,1634,883,734;27;F
112429;999,1634,1534,309,785,990,1648,1126,1390,1417,1641,353;64;F
112466;1130,56,1126,811,14,785,1031,1121,1634,315;24;F
112491;315,1634,1365,785,990,1534,1458,970,678,1031,1455,1115,1648,1641,636;39;F
112522;315,1031,990,1001,514,970,637,1137,1648,1215,785,518,883,1634,1115;48;F
112529;1190,14;15;F
112530;883,1115,1417,1513,1031,1215,990,1534,1126,1390,1455,1001,1130,1641,970;27;F
112542;678,1634,315,1513,883,14,811,1390,1417,1137,503,1130,970,314;43;F
112559;309,999,14,990,93,970;8;F
112596;997,503,93,970,637,1534,999,315,1031,785,990,1648,514,1634,636;36;M
112603;309,1513,1641,26,1097;65;M
112641;1126,1348,1455,840,710,1641,1115,309,833,1534,1417,997,1174,970,353;40;M
112643;1390,1348,1001,514,797,1115,970,1641,1137,1417,1455,1534,990,1215,883;32;M
112663;1641,1634;46;F
112675;1513,1031,785,1365,1215,1648,1126,1390,514,1417,997,503,1641,962,1115;36;M
112676;636;30;M
112685;14,26,1121,823,518,990,1390,1348,1137,1130,970;48;F
112720;999,312,678,1121,1031,1215,1390,26,309,883,997,1417,1137,1130,1641;33;F
112724;309,315,1031,518,1365,990,1534,1648,1417,997,56,1130,1641,962,970;34;M
112748;1365,1648,840,353,970,1641,503,997,1417,1455,1348,990,785,1031,1634;10;M
112754;952,970,1094,812,1115,353,1641,93,503,1130,698,314,636,999,678;7;M
112769;309,315,1634,823,990,1534,1390,1455,1417,997,1130,1458,1641,962,970;49;M
112776;1137,883,962,1130,56,1121;46;F
112783;1634,811,1534,514,1417,710,503,1174,1641,703,970,353;25;F
112802;309,999,14,990,93,970;6;M
112858;1641,1031,710,503,14,518,1634,315,678;70;F
112870;123,1534,1648,1126,1390,997,1137,503,1130,797;10;M
112891;315,1634,1513,1190,1215,1534,1455,514,962,703,314;71;F
112900;678,990,1534,1126,1641,93,309,1634,883,1031,518,785,123,1390,703;38;F
112942;14,518,833,811,1001,514,56,1394,503,1130,734,962,703,1094,970;19;F
112959;999,309,315,1634,1513,1031,1190,990,1534,1390,1455,1417,797,1641,970;36;F
112965;93;10;M
112971;14,1634;50;F
112991;93;11;M
113003;1103,123,1121,1634,1097,1648,1137,797,1458,962,703,314,93,678,636;53;F
113008;999,1513,1031,1097,1103,990,1534,1648,1348,1417,1641,314,93,636,1115;45;M
113011;1126,1001,56,703,812,1348,514,1137,1394,503,1130,1458,1641,314,353;34;M
113040;999,14,1365,990,1534,1648,1348,1417,997,56,503,1130,1458,1641,1115;48;F
113045;1455,840,503;49;F
113048;503,1641,314,970,1348,1458;40;M
113052;1390,1458,1641,1534,1126,1417,56;42;F
113076;309,999,14,990,93,970;40;M
113089;1417,1455,1534,123,14,785,518,1031,1634,315,309,26,999,678,312;40;M
113112;785,1031,999,1634,1190,1365,1648,1455,514,1417,997,503,1458,1641,1115;17;F
113113;1513,883,1031,518,785,990,1534,1001,514,1417,710,1641,1115,309,1174;36;F
113145;1534,1348,514,1417,503,1641,1115,1634,1513,1390,1455,997,1458,962,353;44;M
113149;315,1190,1097,123,1455,1417,56,797,1130,785,990,1126,1390,514,997;21;F
113163;999,1534,1417,1137,56,503,812,1365,814,1648,1348,997,1458,1641,1115;12;M
113190;1634,1031,1190,123,1534,1648,1390,1174,1641,1115;39;M
113213;315,1634,1097,1215,1534,1417,1641,962,703,314,636;44;M
113222;1130,518,823,1215,123,990,1455,840,703,970,503,1390,1190,1513,1634;44;M
113247;1648,1534,990,1365,1031,315,309,999,785;25;F
113270;1648,1417,797,678,309,315,1031,785,990,1126,1390,1455,1641,698,970;64;F
113286;990,315,999,1417,1001,1455,123,785,1190,309,1031,811,1534,1126,1641;44;M
113287;1130,1121,1031,1215,1103,1137,56,503,314,812,637;46;F
113290;785,990,999,1031,14,1365,1534,1648,1126,1390,1417,1137,1641,970,1115;80;F
113292;678,1634,785,14,811,1126,1390,514,56,503,1130,734,1641,703,952;33;F
113301;1634,1513,123,503,812;43;F
113309;1031,785,1097,1534,1648,1455,1417,997,797;36;F
113334;1634,1190,1215,814,1001,514,1417,1137,56,1394,1130,1641,698,970,637;47;M
113335;785,1417,503,1641,1130;19;F
113342;123,990,997,1137,1458,503,1641,970,1634,14,1126,1348,1417,1130,353;50;M
113352;123,1348,997,1137,1115,26,785,14,1126,514,503,1634,1130,353,636;36;M
113356;1641,1115;78;F
113357;1126,514,698,353,734,1390,1634,637,678,785,1137,503,952,314,636;31;F
113365;312,315,1634,518,14,1455,1001,514,997,1137,56,503,703,952,970;56;M
113381;990,811,56,1130,1031,1115,999,1365,1001,514,710,734,1174;31;F
113398;309,1031,518,14,811,1648,1126,1348,1455,56,503,1130,1641,962,93;26;M
113418;990,314,1348,970,999,1031,1513,1097,1534,1648,1417,1641,93,636,1115;45;F
113423;26,309,315,1634,1190,785,14,1365,123,990,1648,1417,797,1641,1115;56;F
113424;1031,1190,785,990,811,1534,1648,1126,1455,840,997,503,1641,1130,1115;26;F
113466;1174,797,1417,1455,1390,1534,123,1365,785,1190,1634,840,1641,353;67;M
113483;678,312,1513,883,14,814,1126,1390,514,1137,503,1130,93,812,637;50;M
113489;14,678,309,883,811,1390,514,503,1458,962,1641,703,698,812,637;22;F
113544;1031,309,315,1174,93,314,312,1513,883,1390,997,710,698,970,636;13;M
113564;1115,93,698,1641,1458,990,1365,1031,678,883,785,1215,1126,503,636;34;F
113610;990,678,1390,1534,1001,503,1641,703,26,1513,883,1215,514,1137,637;48;F
113626;1634,678,1126,1348,1001,514,1417,1130,970,637;36;M
113636;1031,785,1534,1648,1417,503,1115,1130,1641,970;26;F
113644;1634,123,1534,1126,1348,840,1137,503,1174;26;M
113646;785,1031,1634,678,883,1190,990,1534,1455,1417,797,1641,970,636;33;F
113671;1634,883,1097,811,1390,1137,93;43;M
113684;1648,1365,785,1190,1634,312,315,309,1031,1534,1417,56,1130,1641,1115;41;M
113696;811,812,312,883,833,990,1648,797,1641,970;77;F
113760;636,883,1137;31;M
113766;678,883,93,503,1634,1115;40;M
113775;1130,14;52;M
113809;1634,1513,883,1031,14,814,990,1348,514,1137,1130,797,93,353;36;F
113812;1130,1031,999,26,1634,518,1365,1534,1648,1455,1417,997,797,1641,970;35;M
113816;999,1634,1031,785,1365,990,1648,1126,1455,1417,997,1641,1115;44;M
113817;999,309,1513,883,1031,785,1365,990,1126,1534,1390,1417,1641,970,1115;30;M
113825;1641,315,1634,1190,785,1097,123,990,1126,1390,1455,997,56,1130,703;62;M
113846;1365,315,999,678,1634,1031,1215,990,1126,970,636,883,785,514,637;40;F
113856;26,1634,1121,823,518,785,990,840,1417,797,1137,56,962,93,970;12;M
113859;26,1031,1534,309,999,785,990,1126,997,1641;45;M
113881;785,1097,811,514,797;29;F
113907;503,637,93,962,678,1634,1513,883,1097,1390,514,1137,1130,1641,1094;35;F
113911;678,1634,883,14,123,1348,56,962,636;43;M
113917;514,1001,312,678,1121,883,1097,1103,1348,56,1130,952,314,637,636;29;F
113940;1634,518,785,14,1534,840,1215,1001,514,1417,1137,503,797,1641,637;23;M
113966;811,703,637;56;F
113980;883,1097,1534,1001,514,1417,703,814,1390,1137,56,1130;36;F
113987;1031,312,1634,823,1001,514,1137,503,703,314,93,812,1094;50;F
114014;1121,1031,1097,1215,1103,1126,1137,56,503,1130,1458,703,314,812,353;9;F
114025;26,1390,1031,1115;41;F
114033;1031,1215,814,1534,1126,514,56,503,1130,1641,962,698,1115,1634,999;42;M
114036;1634,1513,1648,1126,840,93;36;M
114038;678,1634,1513,1031,785,14,1097,1215,1534,1648,1126,1390,1455,1641,1115;9;F
114048;678,309,1634,883,1031,518,785,123,990,1534,1126,1390,1641,703,93;35;M
114057;1634,14,123,812,353;13;M
114062;1455,1126,1648,990,1365,1190,883,1513,999,1031,785,1534,1417,1641,1115;29;F
114069;1648,1641,883,309,315,1634,1031,785,1097,123,990,503,1130,970,636;74;F
114098;999,26;42;M
114115;678,312,26,315,1121,1031,518,1534,1348,1455,1417,56,1130,1641,970;12;M
114128;26,1031,823,518,1365,123,1648,1348,1455,1417,1137,503,1458,1641,93;48;M
114174;14,1126,1137,970,999,1031,785,1365,990,1534,1648,1455,1417,1641,1115;38;M
114177;123,1534,840,785,1190,1634,26,315,1031,518,14,1126,1455,1417,997;31;M
114181;1513,990,811,1390,1455,1001,514,503,734,962,703,952,698,970,637;21;M
114193;1031,785,1365,990,1534,1648,1126,1455,1417,710,1130,1174,1641,970,1115;34;F
114220;1513,678,1634,518,1097,1534,1648,1126,1390,997,1130,797,1641,970,353;57;M
114228;1097,833,1103,814,1648,1126,997,1137,1641,962,703,636,123,678,797;59;M
114247;309,883,1215,503,952,314,637;25;F
114248;678,1121,883,14,833,814,811,1137,56,503,1130;42;F
114259;1513,123,1648,997,1215,840,514,797,1641,1031,1126,1390,970,1634,637;31;M
114271;678,312,309,1634,1513,823,1648,1455,698,93,314;44;M
114283;1390,1130,797,1641,703,952,812,970,1115;26;F
114293;312,1634,883,1031,823,14,990,1126,1348,1455,1417,1130,962,703,1094;12;M
114295;14,1215,814,1126,1001,514,1137,503,1458,1641,703,314,93,812,637;9;F
114313;698,970,1031,1215,734,315,1634,785,1534,1126,1641,14,1648,1417;51;M
114355;1031,785,1365,990,1534,1648,1126,1390,1455,1417,1130,797,1641,703,970;25;F
114356;785,1365,833,962,636,1634,990,997,1641,1115,1417,1534,1126,999,970;47;M
114357;990,1534,1648,1126,1455,840,797,970,1634,1513,1031,1390,1417,1137,1641;45;F
114373;1390,1115,970,1174,840,309,1634,823,518,1190,1648,1126,797,1641,93;34;M
114389;353,797,503,514,840,990,123,1190,1031,1634;44;M
114404;698,1641,1031,26,785,1365,990,1534,1417,970;30;M
114448;1458,698,1094,812,1348,1126,814,1097,14,309,678,1137,314,636,1115;40;F
114458;1458,1641,1137,1648,1031,309,1634,823,14,123,1126,314,93,636,353;8;F
114462;797,997,1001,1348,1390,990,123,14,1190,1513,1634,312,93;20;M
114475;1634,883,710,503,1174,1641;39;M
114490;1641,814,1215,833,1031,1121,1097,1103,1137,56,503,1130,1458,314,812;13;F
114515;999,309,315,883,1031,785,14,990,811,1534,56,503,1641,970,1115;15;F
114516;1001,503,797,1458,970,315,1634,1513,883,14,1390,514,1137,1130,703;23;F
114517;999,309,315,1031,518,1648,962;66;F
114525;1121,1348,1130,1634,678,637,14,811,1001,514,1137,56,503,703,314;44;F
114531;678,315,14,1534,1648,1137,503,1115;40;F
114543;26,1190,970;58;M
114571;1641,812,637,1031,1174,123,1215,1634,1130,734,952,14,814,811,710;23;M
114575;1215,1001,514,503;40;M
114584;1634,1513,1390,1190,1126,997,883,840,823,814,812,797,785,637,14;54;M
114586;1394,93,678,1121,1097,1103,1348,1137,56,503,1130,1458,703,698,1094;33;F
114602;1634,1031,1365,1648,970,1215,123,990,1534,1126,514,1417,997,1641,315;41;F
114606;812;52;M
114610;883,1634,315,309,1513,1031,833,990,1126,1417,514,1137,503,1130,703;24;F
114620;997,883,309,970,1641,1031,678,1634,1215,990,514,1137,503,93,636;36;F
114630;1648,1126,1390,1458,314,1094,970,315,518,1097,1348,1455,503,1641,703;66;F
114635;1348,1137,1130,1458,312,518,811,503,962,703,698,314;42;F
114643;1634,14,1126,1137,503,797,970;69;M
114645;814,1215,1365,1190,823,1031,1121,1634,309,999,678,785,1513,883,1115;31;F
114676;312,1031,1126,840,970,93,797,1137,997,1634,1513,883,785,123,1390;33;M
114678;93;33;M
114684;123,1103,990,1534,1648,1126,1001,514,1417,1641,970,637,353,883,1115;39;M
114691;1641,1115,1130,1455,1648,1126,1534,990,785,1031,315,309,26,999,312;75;F
114695;514,997,1031,1001,883,785,1126,637;43;F
114725;1121,518,1137,1394,503,1130,1641,962;39;F
114726;1031,309,26,315,1634,1513,883,1190,1534,1126,1455,840,1417,797,1641;38;M
114742;1115,970,1641,1137,1417,1390,1126,1648,1534,1365,14,1031,999,990,785;82;M
114747;1190,518,823,1121,1097,811,1001,514,503,1130,1641,962,703,1094,970;28;F
114750;312,518,1097,56,637;58;M
114766;710,1130,1174;28;F
114770;678,1031,785,1126,1417,1641;21;M
114781;999,1031,823,1365,123,1648,1348,1455,1417,1137,503,1458,1641,314,93;12;M
114810;14,811,1126,1137,503,734,93,1115;30;F
114856;26,997,309,1534,518,999,1641,797,1417,1455,1126,1648,123,1031,1634;34;M
114862;1513,14,990,1390,811,1137,503,637;43;F
114874;312,970,999,1031,1534,1126,1137,1130,734,1641,703,952;31;F
114883;678,814,785,636,823,1348,1137,503,93;43;F
114910;1513,785,997,123,56,1130,1641,970,1634,883,990,1126,1390,514,797;33;F
114929;1137,678,1031,785,1365,123,814,990,1130,1641,883,1097,1103,811,1348;35;F
114933;1215,1126,997,970,1634,1513,1031,1390,1001,514,503,1130,1641,962,703;29;M
114946;1126,1137,309,1634,1031,823,14,123,1648,1458,1641,314,93,353,636;13;F
114954;1190,785,14,1365,990,1534,1648,1455,840,997,56,1130,1641,93,970;25;M
114972;1634,14,990,1001,503,1130,1641,962,698,970;47;F
114973;1634,883,1348,56,1130,353,1115;37;F
114989;678,309,1634,1513,883,785,14,1097,1390,1641,997,1534,1348,1458,93;43;M
115004;1094;53;F
115018;883,823,1190,1215,1348,840,314,1513,1634,503;43;M
115046;1390,1001,1641,315,312,678,883,1097,811,56,1130,952,314,1094,636;1;F
115072;990,1513,1365,1031,315,999,26,309,785,1534,1455,1417,997,1641,636;40;M
115086;26,1031,823,518,1365,123,1648,1348,1455,1417,1137,503,1458,1641,93;9;F
115093;309,1513,1031,823,518,1190,785,14,1390,514,503,1130,797,962,703;21;M
115104;883,1031,315,309,1634,785,1097,123,990,1648,503,1130,1641,970,636;75;M
115157;814,999,26,1215,990,1534,1648,1455,514,1417,710,1137,503,1641,1115;21;F
115186;314,26,1634,823,1190,1097,123,811,1126,840,56,1130,1641,703,353;70;F
115188;1031,14,1390,1174;38;F
115191;1634,1348,1394,1458,93,970;44;M
115207;14,1097,833,811,1648,1390,1348,1001,56,503,1130,797,703,698,1094;65;F
115210;312,1097,1390,503,1130,1641,962,703;41;F
115224;999,1634,315,309,1031,1534,1648,1126,1455,514,1417,1641,970,1115;26;M
115276;312,518,811,814,1348,1137,503,1458,1130,962,703,698,314;11;M
115297;678,883,1097,1215,990,1390,1001,514,997,1137,503,1458,812,970,637;25;F
115309;315,1634,833,811,1348,1001,514,997,1130;47;F
115310;14,1390,1215,514,997,1417,93,962,315,797,999,26,309,1126,840;25;M
115311;1031,823,518,1365,123,1648,1348,1455,1417,1137,503,1458,1641,314,93;6;M
115313;56,1130,1641,314,970,1115,312,785,518,823,1031,1121,1634,315,26;43;M
115358;26,1121,823,518,14,990,1390,1348,1137,1130,93,970;51;M
115362;999,1634,1031,1365,123,990,1534,1648,1455,1417,997,1130,1641,1115;32;M
115406;999,309,1641,1458,840,1455,1126,1648,1534,990,123,785,1031,883,1634;31;M
115430;1417,1634,518,785,1348,503,970;45;F
115434;312,518,814,811,1348,1137,503,1130,1458,962,703,698,314,1115;14;F
115440;1390,123,1634;46;M
115446;1513,315,1190,785,1097,123,990,1126,1390,1455,1417,997,56,1130,797;57;F
115460;26,1634,883,1031,518,785,14,990,1390,1348,1001,514,1417,797,1641;19;F
115474;1634,1190,797,970,315,999,312,309,1513,1648,1417,1641,314;28;F
115505;1121,312,678,315,1634,883,14,123,990,1390,1348,514,797,703,93;66;F
115549;990,811,1534,1390,1348,997,1137,1394,1130,1458,1641,962,314,93,812;13;M
115571;999,26,1031,990,1137,503,1634,883,14,123,1648,1130,1641,93,353;36;F
115573;883,785,123,990,1648,1390,1348,1455,514,1417,997,1130,1641,353,503;30;M
115607;312,315,14,1365,990,1417,1641,970,1115;44;F
115633;1031,14,1390,1174;66;F
115653;26,1634,518,1190,785,1534,1648,1126,1348,1455,1417,997,797,1458,1641;62;F
115655;1215,123,990,1534,1648,1390,514,797,1174,1641,970,678;25;M
115669;1121,814,1348,1137,1130,970,1115,1417,1390,823,678,1634,1641,710,1174;35;M
115674;698,962,734,503,1394,710,1097,1121,1103,56,1130,1115;28;F
115706;678,315,823,123,990,1534,1137,1394,952,1513,1390,1348,514,1641,970;31;F
115730;1031,1513,26,785,1390,1648,990,514,1417,997,503,1130,797,962,1641;31;M
115737;999,1634,1126,1534,315,1031,1648,1348,1455,1417,997,503,1130,1641,314;30;F
115738;312,678,315,883,1097,811,1001,1137,56,1130,1641,952,314,636;39;M
115777;123,1365,1417,514,56,1130,678,1634,1513,883,1031,785,1215,990,970;41;M
115800;1634,1121,1513,1031,14,1126,1390,1348,1455,1001,1137,56,1130,1641;48;F
115821;1458,703,952,636,1094,812,734,1534,1103,1348,1137,56,1130,1641,1097;38;M
115829;1115,315,1121,1031,823,518,1190,1365,990,811,1534,1648,1455,514,703;22;M
115830;999,1137,1534,1365,14,883,1513,1634,315,1648,1390,1417,710,1458,1174;32;F
115842;1634,785,1365,123,990,1534,1648,1455,840,1417,710,1641,1115,1394,1513;70;F
115844;833,703,1641,797,1130,503,1394,1137,1001,514,1390,811,123,883,678;6;F
115858;312,518,1215,811,1137,314;36;F
115868;503,1641,1130,514,1001,1390,1103,518,999,962,997,1417,1126,1648,1031;35;M
115881;1348,1458;44;F
115882;1031,14,1126,1390,1174;69;M
115888;970,952,1641,734,1455,1126,1534,1215,1031,785,883,1634,315,309,26;36;F
115889;999,309,315,1365,1126,1648,1455,970,1641,1417,1534,785,1031,1634,26;37;M
115898;833,93,1115;9;M
115927;710,1174;31;M
115976;999,1634,518,833,123,811,710,1458,1174,734,1641,962,703,812,970;36;M
115980;999,26,309,1215,814,1534,1648,1455,514,1417,1137,503,1641,1115;21;M
115997;1348,1458;14;M
116038;1215,678;51;F
116042;93;31;M
116043;1348,1458;8;F
116143;1215,1190,1137,883,503,797,312,93,1634,14;71;F
116144;970,1534,518,1641,503,1031,315,1417;73;F
116146;1648,1390,1190,1126,997,883,990,1641,797,1031,1174,1513,678,785,14;77;F
116149;1648,1190,1126,997,883,840,833,1534,518,797,56,1417,1365,1634,14;60;F
116156;1648,1455,1126,1097,999,1094,1534,1641,1031,309,315,353,1417,1634,14;63;M
116161;1648,1390,1130,1534,503,1513,678,14;64;F
116167;1648,1126,997,970,703,1534,990,1641,503,1031,309,315,678,1417,14;76;F
116171;1137,1103,1097,1458,997,970,811,703,990,514,1513,309,315,93,785;74;F
116178;1215,1130,1126,1097,1458,883,814,703,990,503,1031,1513,1348,309,314;71;M
116182;1455,1390,1097,1001,997,1094,703,1534,1641,1031,1348,315,1417,785,14;74;M
116187;970,1534,518,1641,503,1031,315,1417;48;F
116190;1126,1097,970,883,990,518,1031,1417,1634;47;F
116193;1648,1126,997,970,883,710,990,518,503,797,962,315,678,785,26;81;F
116208;1390,1097,1001,883,637,1513,123,315,1634;31;F
116218;1130,1126,1097,883,812,1394,314,678,14;17;M
116226;1130,1126,1097,883,812,1394,314,678,14;72;M
116231;1458;21;M
99999965624;710,56,503,1174;40;F